/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageBudgetRecs
extends APINode {
    @SerializedName(value="amount_offset")
    private Long mAmountOffset = null;
    @SerializedName(value="budget_delta")
    private Long mBudgetDelta = null;
    @SerializedName(value="campaign_length")
    private Long mCampaignLength = null;
    @SerializedName(value="currency")
    private String mCurrency = null;
    @SerializedName(value="display_amount")
    private String mDisplayAmount = null;
    @SerializedName(value="reach")
    private Long mReach = null;
    @SerializedName(value="reach_interval")
    private Object mReachInterval = null;
    @SerializedName(value="value")
    private Long mValue = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    PageBudgetRecs() {
    }

    public PageBudgetRecs(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public PageBudgetRecs(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public PageBudgetRecs fetch() throws APIException {
        PageBudgetRecs newInstance = PageBudgetRecs.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static PageBudgetRecs fetchById(Long id, APIContext context) throws APIException {
        return PageBudgetRecs.fetchById(id.toString(), context);
    }

    public static ListenableFuture<PageBudgetRecs> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return PageBudgetRecs.fetchByIdAsync(id.toString(), context);
    }

    public static PageBudgetRecs fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<PageBudgetRecs> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<PageBudgetRecs> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<PageBudgetRecs>(context, "", "/", "GET", PageBudgetRecs.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<PageBudgetRecs>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<PageBudgetRecs>(context, "", "/", "GET", PageBudgetRecs.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static PageBudgetRecs loadJSON(String json, APIContext context) {
        PageBudgetRecs pageBudgetRecs = (PageBudgetRecs)PageBudgetRecs.getGson().fromJson(json, PageBudgetRecs.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(pageBudgetRecs.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        pageBudgetRecs.context = context;
        pageBudgetRecs.rawValue = json;
        return pageBudgetRecs;
    }

    public static APINodeList<PageBudgetRecs> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<PageBudgetRecs> pageBudgetRecss = new APINodeList<PageBudgetRecs>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        pageBudgetRecss.add(PageBudgetRecs.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return pageBudgetRecss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            pageBudgetRecss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        pageBudgetRecss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            pageBudgetRecss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            pageBudgetRecss.add(PageBudgetRecs.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                pageBudgetRecss.add(PageBudgetRecs.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            pageBudgetRecss.add(PageBudgetRecs.loadJSON(obj.toString(), context));
                        }
                    }
                    return pageBudgetRecss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        pageBudgetRecss.add(PageBudgetRecs.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return pageBudgetRecss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        pageBudgetRecss.add(PageBudgetRecs.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return pageBudgetRecss;
                }
                pageBudgetRecss.clear();
                pageBudgetRecss.add(PageBudgetRecs.loadJSON(json, context));
                return pageBudgetRecss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PageBudgetRecs.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Long getFieldAmountOffset() {
        return this.mAmountOffset;
    }

    public Long getFieldBudgetDelta() {
        return this.mBudgetDelta;
    }

    public Long getFieldCampaignLength() {
        return this.mCampaignLength;
    }

    public String getFieldCurrency() {
        return this.mCurrency;
    }

    public String getFieldDisplayAmount() {
        return this.mDisplayAmount;
    }

    public Long getFieldReach() {
        return this.mReach;
    }

    public Object getFieldReachInterval() {
        return this.mReachInterval;
    }

    public Long getFieldValue() {
        return this.mValue;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PageBudgetRecs copyFrom(PageBudgetRecs instance) {
        this.mAmountOffset = instance.mAmountOffset;
        this.mBudgetDelta = instance.mBudgetDelta;
        this.mCampaignLength = instance.mCampaignLength;
        this.mCurrency = instance.mCurrency;
        this.mDisplayAmount = instance.mDisplayAmount;
        this.mReach = instance.mReach;
        this.mReachInterval = instance.mReachInterval;
        this.mValue = instance.mValue;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PageBudgetRecs> getParser() {
        return new APIRequest.ResponseParser<PageBudgetRecs>(){

            @Override
            public APINodeList<PageBudgetRecs> parseResponse(String response, APIContext context, APIRequest<PageBudgetRecs> request) throws APIException.MalformedResponseException {
                return PageBudgetRecs.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<PageBudgetRecs> {
        PageBudgetRecs lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"amount_offset", "budget_delta", "campaign_length", "currency", "display_amount", "reach", "reach_interval", "value", "id"};

        @Override
        public PageBudgetRecs getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public PageBudgetRecs parseResponse(String response) throws APIException {
            return PageBudgetRecs.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public PageBudgetRecs execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public PageBudgetRecs execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<PageBudgetRecs> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<PageBudgetRecs> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, PageBudgetRecs>(){

                public PageBudgetRecs apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAmountOffsetField() {
            return this.requestAmountOffsetField(true);
        }

        public APIRequestGet requestAmountOffsetField(boolean value) {
            this.requestField("amount_offset", value);
            return this;
        }

        public APIRequestGet requestBudgetDeltaField() {
            return this.requestBudgetDeltaField(true);
        }

        public APIRequestGet requestBudgetDeltaField(boolean value) {
            this.requestField("budget_delta", value);
            return this;
        }

        public APIRequestGet requestCampaignLengthField() {
            return this.requestCampaignLengthField(true);
        }

        public APIRequestGet requestCampaignLengthField(boolean value) {
            this.requestField("campaign_length", value);
            return this;
        }

        public APIRequestGet requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGet requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGet requestDisplayAmountField() {
            return this.requestDisplayAmountField(true);
        }

        public APIRequestGet requestDisplayAmountField(boolean value) {
            this.requestField("display_amount", value);
            return this;
        }

        public APIRequestGet requestReachField() {
            return this.requestReachField(true);
        }

        public APIRequestGet requestReachField(boolean value) {
            this.requestField("reach", value);
            return this;
        }

        public APIRequestGet requestReachIntervalField() {
            return this.requestReachIntervalField(true);
        }

        public APIRequestGet requestReachIntervalField(boolean value) {
            this.requestField("reach_interval", value);
            return this;
        }

        public APIRequestGet requestValueField() {
            return this.requestValueField(true);
        }

        public APIRequestGet requestValueField(boolean value) {
            this.requestField("value", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

