/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Location
extends APINode {
    @SerializedName(value="city")
    private String mCity = null;
    @SerializedName(value="city_id")
    private Long mCityId = null;
    @SerializedName(value="country")
    private String mCountry = null;
    @SerializedName(value="country_code")
    private String mCountryCode = null;
    @SerializedName(value="latitude")
    private Double mLatitude = null;
    @SerializedName(value="located_in")
    private String mLocatedIn = null;
    @SerializedName(value="longitude")
    private Double mLongitude = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="region")
    private String mRegion = null;
    @SerializedName(value="region_id")
    private Long mRegionId = null;
    @SerializedName(value="state")
    private String mState = null;
    @SerializedName(value="street")
    private String mStreet = null;
    @SerializedName(value="zip")
    private String mZip = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    Location() {
    }

    public Location(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public Location(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public Location fetch() throws APIException {
        Location newInstance = Location.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static Location fetchById(Long id, APIContext context) throws APIException {
        return Location.fetchById(id.toString(), context);
    }

    public static ListenableFuture<Location> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return Location.fetchByIdAsync(id.toString(), context);
    }

    public static Location fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<Location> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<Location> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<Location>(context, "", "/", "GET", Location.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<Location>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<Location>(context, "", "/", "GET", Location.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static Location loadJSON(String json, APIContext context) {
        Location location = (Location)Location.getGson().fromJson(json, Location.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(location.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        location.context = context;
        location.rawValue = json;
        return location;
    }

    public static APINodeList<Location> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<Location> locations = new APINodeList<Location>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        locations.add(Location.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return locations;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            locations.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        locations.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            locations.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            locations.add(Location.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                locations.add(Location.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            locations.add(Location.loadJSON(obj.toString(), context));
                        }
                    }
                    return locations;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        locations.add(Location.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return locations;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        locations.add(Location.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return locations;
                }
                locations.clear();
                locations.add(Location.loadJSON(json, context));
                return locations;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return Location.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldCity() {
        return this.mCity;
    }

    public Long getFieldCityId() {
        return this.mCityId;
    }

    public String getFieldCountry() {
        return this.mCountry;
    }

    public String getFieldCountryCode() {
        return this.mCountryCode;
    }

    public Double getFieldLatitude() {
        return this.mLatitude;
    }

    public String getFieldLocatedIn() {
        return this.mLocatedIn;
    }

    public Double getFieldLongitude() {
        return this.mLongitude;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldRegion() {
        return this.mRegion;
    }

    public Long getFieldRegionId() {
        return this.mRegionId;
    }

    public String getFieldState() {
        return this.mState;
    }

    public String getFieldStreet() {
        return this.mStreet;
    }

    public String getFieldZip() {
        return this.mZip;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public Location copyFrom(Location instance) {
        this.mCity = instance.mCity;
        this.mCityId = instance.mCityId;
        this.mCountry = instance.mCountry;
        this.mCountryCode = instance.mCountryCode;
        this.mLatitude = instance.mLatitude;
        this.mLocatedIn = instance.mLocatedIn;
        this.mLongitude = instance.mLongitude;
        this.mName = instance.mName;
        this.mRegion = instance.mRegion;
        this.mRegionId = instance.mRegionId;
        this.mState = instance.mState;
        this.mStreet = instance.mStreet;
        this.mZip = instance.mZip;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<Location> getParser() {
        return new APIRequest.ResponseParser<Location>(){

            @Override
            public APINodeList<Location> parseResponse(String response, APIContext context, APIRequest<Location> request) throws APIException.MalformedResponseException {
                return Location.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<Location> {
        Location lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"city", "city_id", "country", "country_code", "latitude", "located_in", "longitude", "name", "region", "region_id", "state", "street", "zip", "id"};

        @Override
        public Location getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Location parseResponse(String response) throws APIException {
            return Location.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public Location execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Location execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<Location> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Location> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, Location>(){

                public Location apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCityField() {
            return this.requestCityField(true);
        }

        public APIRequestGet requestCityField(boolean value) {
            this.requestField("city", value);
            return this;
        }

        public APIRequestGet requestCityIdField() {
            return this.requestCityIdField(true);
        }

        public APIRequestGet requestCityIdField(boolean value) {
            this.requestField("city_id", value);
            return this;
        }

        public APIRequestGet requestCountryField() {
            return this.requestCountryField(true);
        }

        public APIRequestGet requestCountryField(boolean value) {
            this.requestField("country", value);
            return this;
        }

        public APIRequestGet requestCountryCodeField() {
            return this.requestCountryCodeField(true);
        }

        public APIRequestGet requestCountryCodeField(boolean value) {
            this.requestField("country_code", value);
            return this;
        }

        public APIRequestGet requestLatitudeField() {
            return this.requestLatitudeField(true);
        }

        public APIRequestGet requestLatitudeField(boolean value) {
            this.requestField("latitude", value);
            return this;
        }

        public APIRequestGet requestLocatedInField() {
            return this.requestLocatedInField(true);
        }

        public APIRequestGet requestLocatedInField(boolean value) {
            this.requestField("located_in", value);
            return this;
        }

        public APIRequestGet requestLongitudeField() {
            return this.requestLongitudeField(true);
        }

        public APIRequestGet requestLongitudeField(boolean value) {
            this.requestField("longitude", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestRegionField() {
            return this.requestRegionField(true);
        }

        public APIRequestGet requestRegionField(boolean value) {
            this.requestField("region", value);
            return this;
        }

        public APIRequestGet requestRegionIdField() {
            return this.requestRegionIdField(true);
        }

        public APIRequestGet requestRegionIdField(boolean value) {
            this.requestField("region_id", value);
            return this;
        }

        public APIRequestGet requestStateField() {
            return this.requestStateField(true);
        }

        public APIRequestGet requestStateField(boolean value) {
            this.requestField("state", value);
            return this;
        }

        public APIRequestGet requestStreetField() {
            return this.requestStreetField(true);
        }

        public APIRequestGet requestStreetField(boolean value) {
            this.requestField("street", value);
            return this;
        }

        public APIRequestGet requestZipField() {
            return this.requestZipField(true);
        }

        public APIRequestGet requestZipField(boolean value) {
            this.requestField("zip", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

