/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CanvasAdSettings
extends APINode {
    @SerializedName(value="is_canvas_collection_eligible")
    private Boolean mIsCanvasCollectionEligible = null;
    @SerializedName(value="lead_form_created_time")
    private Object mLeadFormCreatedTime = null;
    @SerializedName(value="lead_form_name")
    private String mLeadFormName = null;
    @SerializedName(value="lead_gen_form_id")
    private String mLeadGenFormId = null;
    @SerializedName(value="leads_count")
    private Long mLeadsCount = null;
    @SerializedName(value="product_set_id")
    private String mProductSetId = null;
    @SerializedName(value="use_retailer_item_ids")
    private Boolean mUseRetailerItemIds = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    CanvasAdSettings() {
    }

    public CanvasAdSettings(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public CanvasAdSettings(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public CanvasAdSettings fetch() throws APIException {
        CanvasAdSettings newInstance = CanvasAdSettings.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static CanvasAdSettings fetchById(Long id, APIContext context) throws APIException {
        return CanvasAdSettings.fetchById(id.toString(), context);
    }

    public static ListenableFuture<CanvasAdSettings> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return CanvasAdSettings.fetchByIdAsync(id.toString(), context);
    }

    public static CanvasAdSettings fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<CanvasAdSettings> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<CanvasAdSettings> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<CanvasAdSettings>(context, "", "/", "GET", CanvasAdSettings.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<CanvasAdSettings>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<CanvasAdSettings>(context, "", "/", "GET", CanvasAdSettings.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static CanvasAdSettings loadJSON(String json, APIContext context) {
        CanvasAdSettings canvasAdSettings = (CanvasAdSettings)CanvasAdSettings.getGson().fromJson(json, CanvasAdSettings.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(canvasAdSettings.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        canvasAdSettings.context = context;
        canvasAdSettings.rawValue = json;
        return canvasAdSettings;
    }

    public static APINodeList<CanvasAdSettings> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<CanvasAdSettings> canvasAdSettingss = new APINodeList<CanvasAdSettings>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        canvasAdSettingss.add(CanvasAdSettings.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return canvasAdSettingss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            canvasAdSettingss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        canvasAdSettingss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            canvasAdSettingss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            canvasAdSettingss.add(CanvasAdSettings.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                canvasAdSettingss.add(CanvasAdSettings.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            canvasAdSettingss.add(CanvasAdSettings.loadJSON(obj.toString(), context));
                        }
                    }
                    return canvasAdSettingss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        canvasAdSettingss.add(CanvasAdSettings.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return canvasAdSettingss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        canvasAdSettingss.add(CanvasAdSettings.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return canvasAdSettingss;
                }
                canvasAdSettingss.clear();
                canvasAdSettingss.add(CanvasAdSettings.loadJSON(json, context));
                return canvasAdSettingss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CanvasAdSettings.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Boolean getFieldIsCanvasCollectionEligible() {
        return this.mIsCanvasCollectionEligible;
    }

    public Object getFieldLeadFormCreatedTime() {
        return this.mLeadFormCreatedTime;
    }

    public String getFieldLeadFormName() {
        return this.mLeadFormName;
    }

    public String getFieldLeadGenFormId() {
        return this.mLeadGenFormId;
    }

    public Long getFieldLeadsCount() {
        return this.mLeadsCount;
    }

    public String getFieldProductSetId() {
        return this.mProductSetId;
    }

    public Boolean getFieldUseRetailerItemIds() {
        return this.mUseRetailerItemIds;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CanvasAdSettings copyFrom(CanvasAdSettings instance) {
        this.mIsCanvasCollectionEligible = instance.mIsCanvasCollectionEligible;
        this.mLeadFormCreatedTime = instance.mLeadFormCreatedTime;
        this.mLeadFormName = instance.mLeadFormName;
        this.mLeadGenFormId = instance.mLeadGenFormId;
        this.mLeadsCount = instance.mLeadsCount;
        this.mProductSetId = instance.mProductSetId;
        this.mUseRetailerItemIds = instance.mUseRetailerItemIds;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CanvasAdSettings> getParser() {
        return new APIRequest.ResponseParser<CanvasAdSettings>(){

            @Override
            public APINodeList<CanvasAdSettings> parseResponse(String response, APIContext context, APIRequest<CanvasAdSettings> request) throws APIException.MalformedResponseException {
                return CanvasAdSettings.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<CanvasAdSettings> {
        CanvasAdSettings lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"is_canvas_collection_eligible", "lead_form_created_time", "lead_form_name", "lead_gen_form_id", "leads_count", "product_set_id", "use_retailer_item_ids", "id"};

        @Override
        public CanvasAdSettings getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CanvasAdSettings parseResponse(String response) throws APIException {
            return CanvasAdSettings.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public CanvasAdSettings execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CanvasAdSettings execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<CanvasAdSettings> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CanvasAdSettings> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, CanvasAdSettings>(){

                public CanvasAdSettings apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestIsCanvasCollectionEligibleField() {
            return this.requestIsCanvasCollectionEligibleField(true);
        }

        public APIRequestGet requestIsCanvasCollectionEligibleField(boolean value) {
            this.requestField("is_canvas_collection_eligible", value);
            return this;
        }

        public APIRequestGet requestLeadFormCreatedTimeField() {
            return this.requestLeadFormCreatedTimeField(true);
        }

        public APIRequestGet requestLeadFormCreatedTimeField(boolean value) {
            this.requestField("lead_form_created_time", value);
            return this;
        }

        public APIRequestGet requestLeadFormNameField() {
            return this.requestLeadFormNameField(true);
        }

        public APIRequestGet requestLeadFormNameField(boolean value) {
            this.requestField("lead_form_name", value);
            return this;
        }

        public APIRequestGet requestLeadGenFormIdField() {
            return this.requestLeadGenFormIdField(true);
        }

        public APIRequestGet requestLeadGenFormIdField(boolean value) {
            this.requestField("lead_gen_form_id", value);
            return this;
        }

        public APIRequestGet requestLeadsCountField() {
            return this.requestLeadsCountField(true);
        }

        public APIRequestGet requestLeadsCountField(boolean value) {
            this.requestField("leads_count", value);
            return this;
        }

        public APIRequestGet requestProductSetIdField() {
            return this.requestProductSetIdField(true);
        }

        public APIRequestGet requestProductSetIdField(boolean value) {
            this.requestField("product_set_id", value);
            return this;
        }

        public APIRequestGet requestUseRetailerItemIdsField() {
            return this.requestUseRetailerItemIdsField(true);
        }

        public APIRequestGet requestUseRetailerItemIdsField(boolean value) {
            this.requestField("use_retailer_item_ids", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

