/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudiencePermissionForActions
extends APINode {
    @SerializedName(value="can_edit")
    private Boolean mCanEdit = null;
    @SerializedName(value="can_see_insight")
    private Boolean mCanSeeInsight = null;
    @SerializedName(value="can_share")
    private Boolean mCanShare = null;
    @SerializedName(value="subtype_supports_lookalike")
    private Boolean mSubtypeSupportsLookalike = null;
    @SerializedName(value="supports_recipient_lookalike")
    private Boolean mSupportsRecipientLookalike = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AudiencePermissionForActions() {
    }

    public AudiencePermissionForActions(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AudiencePermissionForActions(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AudiencePermissionForActions fetch() throws APIException {
        AudiencePermissionForActions newInstance = AudiencePermissionForActions.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AudiencePermissionForActions fetchById(Long id, APIContext context) throws APIException {
        return AudiencePermissionForActions.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AudiencePermissionForActions> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AudiencePermissionForActions.fetchByIdAsync(id.toString(), context);
    }

    public static AudiencePermissionForActions fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AudiencePermissionForActions> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AudiencePermissionForActions> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AudiencePermissionForActions>(context, "", "/", "GET", AudiencePermissionForActions.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AudiencePermissionForActions>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AudiencePermissionForActions>(context, "", "/", "GET", AudiencePermissionForActions.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AudiencePermissionForActions loadJSON(String json, APIContext context) {
        AudiencePermissionForActions audiencePermissionForActions = (AudiencePermissionForActions)AudiencePermissionForActions.getGson().fromJson(json, AudiencePermissionForActions.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(audiencePermissionForActions.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        audiencePermissionForActions.context = context;
        audiencePermissionForActions.rawValue = json;
        return audiencePermissionForActions;
    }

    public static APINodeList<AudiencePermissionForActions> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AudiencePermissionForActions> audiencePermissionForActionss = new APINodeList<AudiencePermissionForActions>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        audiencePermissionForActionss.add(AudiencePermissionForActions.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return audiencePermissionForActionss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            audiencePermissionForActionss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        audiencePermissionForActionss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            audiencePermissionForActionss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            audiencePermissionForActionss.add(AudiencePermissionForActions.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                audiencePermissionForActionss.add(AudiencePermissionForActions.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            audiencePermissionForActionss.add(AudiencePermissionForActions.loadJSON(obj.toString(), context));
                        }
                    }
                    return audiencePermissionForActionss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        audiencePermissionForActionss.add(AudiencePermissionForActions.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return audiencePermissionForActionss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        audiencePermissionForActionss.add(AudiencePermissionForActions.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return audiencePermissionForActionss;
                }
                audiencePermissionForActionss.clear();
                audiencePermissionForActionss.add(AudiencePermissionForActions.loadJSON(json, context));
                return audiencePermissionForActionss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AudiencePermissionForActions.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Boolean getFieldCanEdit() {
        return this.mCanEdit;
    }

    public Boolean getFieldCanSeeInsight() {
        return this.mCanSeeInsight;
    }

    public Boolean getFieldCanShare() {
        return this.mCanShare;
    }

    public Boolean getFieldSubtypeSupportsLookalike() {
        return this.mSubtypeSupportsLookalike;
    }

    public Boolean getFieldSupportsRecipientLookalike() {
        return this.mSupportsRecipientLookalike;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AudiencePermissionForActions copyFrom(AudiencePermissionForActions instance) {
        this.mCanEdit = instance.mCanEdit;
        this.mCanSeeInsight = instance.mCanSeeInsight;
        this.mCanShare = instance.mCanShare;
        this.mSubtypeSupportsLookalike = instance.mSubtypeSupportsLookalike;
        this.mSupportsRecipientLookalike = instance.mSupportsRecipientLookalike;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AudiencePermissionForActions> getParser() {
        return new APIRequest.ResponseParser<AudiencePermissionForActions>(){

            @Override
            public APINodeList<AudiencePermissionForActions> parseResponse(String response, APIContext context, APIRequest<AudiencePermissionForActions> request) throws APIException.MalformedResponseException {
                return AudiencePermissionForActions.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AudiencePermissionForActions> {
        AudiencePermissionForActions lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"can_edit", "can_see_insight", "can_share", "subtype_supports_lookalike", "supports_recipient_lookalike", "id"};

        @Override
        public AudiencePermissionForActions getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AudiencePermissionForActions parseResponse(String response) throws APIException {
            return AudiencePermissionForActions.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AudiencePermissionForActions execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AudiencePermissionForActions execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AudiencePermissionForActions> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AudiencePermissionForActions> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AudiencePermissionForActions>(){

                public AudiencePermissionForActions apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCanEditField() {
            return this.requestCanEditField(true);
        }

        public APIRequestGet requestCanEditField(boolean value) {
            this.requestField("can_edit", value);
            return this;
        }

        public APIRequestGet requestCanSeeInsightField() {
            return this.requestCanSeeInsightField(true);
        }

        public APIRequestGet requestCanSeeInsightField(boolean value) {
            this.requestField("can_see_insight", value);
            return this;
        }

        public APIRequestGet requestCanShareField() {
            return this.requestCanShareField(true);
        }

        public APIRequestGet requestCanShareField(boolean value) {
            this.requestField("can_share", value);
            return this;
        }

        public APIRequestGet requestSubtypeSupportsLookalikeField() {
            return this.requestSubtypeSupportsLookalikeField(true);
        }

        public APIRequestGet requestSubtypeSupportsLookalikeField(boolean value) {
            this.requestField("subtype_supports_lookalike", value);
            return this;
        }

        public APIRequestGet requestSupportsRecipientLookalikeField() {
            return this.requestSupportsRecipientLookalikeField(true);
        }

        public APIRequestGet requestSupportsRecipientLookalikeField(boolean value) {
            this.requestField("supports_recipient_lookalike", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

