/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdRuleExecutionOptions
extends APINode {
    @SerializedName(value="field")
    private String mField = null;
    @SerializedName(value="operator")
    private EnumOperator mOperator = null;
    @SerializedName(value="value")
    private Object mValue = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdRuleExecutionOptions() {
    }

    public AdRuleExecutionOptions(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdRuleExecutionOptions(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdRuleExecutionOptions fetch() throws APIException {
        AdRuleExecutionOptions newInstance = AdRuleExecutionOptions.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdRuleExecutionOptions fetchById(Long id, APIContext context) throws APIException {
        return AdRuleExecutionOptions.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdRuleExecutionOptions> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdRuleExecutionOptions.fetchByIdAsync(id.toString(), context);
    }

    public static AdRuleExecutionOptions fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdRuleExecutionOptions> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdRuleExecutionOptions> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdRuleExecutionOptions>(context, "", "/", "GET", AdRuleExecutionOptions.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdRuleExecutionOptions>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdRuleExecutionOptions>(context, "", "/", "GET", AdRuleExecutionOptions.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdRuleExecutionOptions loadJSON(String json, APIContext context) {
        AdRuleExecutionOptions adRuleExecutionOptions = (AdRuleExecutionOptions)AdRuleExecutionOptions.getGson().fromJson(json, AdRuleExecutionOptions.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adRuleExecutionOptions.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adRuleExecutionOptions.context = context;
        adRuleExecutionOptions.rawValue = json;
        return adRuleExecutionOptions;
    }

    public static APINodeList<AdRuleExecutionOptions> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdRuleExecutionOptions> adRuleExecutionOptionss = new APINodeList<AdRuleExecutionOptions>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adRuleExecutionOptionss.add(AdRuleExecutionOptions.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adRuleExecutionOptionss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adRuleExecutionOptionss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adRuleExecutionOptionss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adRuleExecutionOptionss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adRuleExecutionOptionss.add(AdRuleExecutionOptions.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adRuleExecutionOptionss.add(AdRuleExecutionOptions.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adRuleExecutionOptionss.add(AdRuleExecutionOptions.loadJSON(obj.toString(), context));
                        }
                    }
                    return adRuleExecutionOptionss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adRuleExecutionOptionss.add(AdRuleExecutionOptions.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adRuleExecutionOptionss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adRuleExecutionOptionss.add(AdRuleExecutionOptions.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adRuleExecutionOptionss;
                }
                adRuleExecutionOptionss.clear();
                adRuleExecutionOptionss.add(AdRuleExecutionOptions.loadJSON(json, context));
                return adRuleExecutionOptionss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdRuleExecutionOptions.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldField() {
        return this.mField;
    }

    public EnumOperator getFieldOperator() {
        return this.mOperator;
    }

    public Object getFieldValue() {
        return this.mValue;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdRuleExecutionOptions copyFrom(AdRuleExecutionOptions instance) {
        this.mField = instance.mField;
        this.mOperator = instance.mOperator;
        this.mValue = instance.mValue;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdRuleExecutionOptions> getParser() {
        return new APIRequest.ResponseParser<AdRuleExecutionOptions>(){

            @Override
            public APINodeList<AdRuleExecutionOptions> parseResponse(String response, APIContext context, APIRequest<AdRuleExecutionOptions> request) throws APIException.MalformedResponseException {
                return AdRuleExecutionOptions.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumOperator {
        VALUE_EQUAL("EQUAL"),
        VALUE_IN("IN"),
        NULL(null);

        private String value;

        private EnumOperator(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdRuleExecutionOptions> {
        AdRuleExecutionOptions lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"field", "operator", "value", "id"};

        @Override
        public AdRuleExecutionOptions getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdRuleExecutionOptions parseResponse(String response) throws APIException {
            return AdRuleExecutionOptions.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdRuleExecutionOptions execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdRuleExecutionOptions execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdRuleExecutionOptions> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdRuleExecutionOptions> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdRuleExecutionOptions>(){

                public AdRuleExecutionOptions apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestFieldField() {
            return this.requestFieldField(true);
        }

        public APIRequestGet requestFieldField(boolean value) {
            this.requestField("field", value);
            return this;
        }

        public APIRequestGet requestOperatorField() {
            return this.requestOperatorField(true);
        }

        public APIRequestGet requestOperatorField(boolean value) {
            this.requestField("operator", value);
            return this;
        }

        public APIRequestGet requestValueField() {
            return this.requestValueField(true);
        }

        public APIRequestGet requestValueField(boolean value) {
            this.requestField("value", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

