/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdCreativeLinkDataTemplateVideoSpec
extends APINode {
    @SerializedName(value="categorization_criteria")
    private String mCategorizationCriteria = null;
    @SerializedName(value="customization")
    private List<Object> mCustomization = null;
    @SerializedName(value="template_id")
    private String mTemplateId = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdCreativeLinkDataTemplateVideoSpec() {
    }

    public AdCreativeLinkDataTemplateVideoSpec(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdCreativeLinkDataTemplateVideoSpec(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdCreativeLinkDataTemplateVideoSpec fetch() throws APIException {
        AdCreativeLinkDataTemplateVideoSpec newInstance = AdCreativeLinkDataTemplateVideoSpec.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdCreativeLinkDataTemplateVideoSpec fetchById(Long id, APIContext context) throws APIException {
        return AdCreativeLinkDataTemplateVideoSpec.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdCreativeLinkDataTemplateVideoSpec> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdCreativeLinkDataTemplateVideoSpec.fetchByIdAsync(id.toString(), context);
    }

    public static AdCreativeLinkDataTemplateVideoSpec fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdCreativeLinkDataTemplateVideoSpec> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdCreativeLinkDataTemplateVideoSpec> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdCreativeLinkDataTemplateVideoSpec>(context, "", "/", "GET", AdCreativeLinkDataTemplateVideoSpec.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdCreativeLinkDataTemplateVideoSpec>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdCreativeLinkDataTemplateVideoSpec>(context, "", "/", "GET", AdCreativeLinkDataTemplateVideoSpec.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdCreativeLinkDataTemplateVideoSpec loadJSON(String json, APIContext context) {
        AdCreativeLinkDataTemplateVideoSpec adCreativeLinkDataTemplateVideoSpec = (AdCreativeLinkDataTemplateVideoSpec)AdCreativeLinkDataTemplateVideoSpec.getGson().fromJson(json, AdCreativeLinkDataTemplateVideoSpec.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCreativeLinkDataTemplateVideoSpec.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCreativeLinkDataTemplateVideoSpec.context = context;
        adCreativeLinkDataTemplateVideoSpec.rawValue = json;
        return adCreativeLinkDataTemplateVideoSpec;
    }

    public static APINodeList<AdCreativeLinkDataTemplateVideoSpec> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdCreativeLinkDataTemplateVideoSpec> adCreativeLinkDataTemplateVideoSpecs = new APINodeList<AdCreativeLinkDataTemplateVideoSpec>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCreativeLinkDataTemplateVideoSpecs.add(AdCreativeLinkDataTemplateVideoSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adCreativeLinkDataTemplateVideoSpecs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adCreativeLinkDataTemplateVideoSpecs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adCreativeLinkDataTemplateVideoSpecs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adCreativeLinkDataTemplateVideoSpecs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCreativeLinkDataTemplateVideoSpecs.add(AdCreativeLinkDataTemplateVideoSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCreativeLinkDataTemplateVideoSpecs.add(AdCreativeLinkDataTemplateVideoSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCreativeLinkDataTemplateVideoSpecs.add(AdCreativeLinkDataTemplateVideoSpec.loadJSON(obj.toString(), context));
                        }
                    }
                    return adCreativeLinkDataTemplateVideoSpecs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCreativeLinkDataTemplateVideoSpecs.add(AdCreativeLinkDataTemplateVideoSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adCreativeLinkDataTemplateVideoSpecs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCreativeLinkDataTemplateVideoSpecs.add(AdCreativeLinkDataTemplateVideoSpec.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCreativeLinkDataTemplateVideoSpecs;
                }
                adCreativeLinkDataTemplateVideoSpecs.clear();
                adCreativeLinkDataTemplateVideoSpecs.add(AdCreativeLinkDataTemplateVideoSpec.loadJSON(json, context));
                return adCreativeLinkDataTemplateVideoSpecs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCreativeLinkDataTemplateVideoSpec.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldCategorizationCriteria() {
        return this.mCategorizationCriteria;
    }

    public List<Object> getFieldCustomization() {
        return this.mCustomization;
    }

    public String getFieldTemplateId() {
        return this.mTemplateId;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCreativeLinkDataTemplateVideoSpec copyFrom(AdCreativeLinkDataTemplateVideoSpec instance) {
        this.mCategorizationCriteria = instance.mCategorizationCriteria;
        this.mCustomization = instance.mCustomization;
        this.mTemplateId = instance.mTemplateId;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCreativeLinkDataTemplateVideoSpec> getParser() {
        return new APIRequest.ResponseParser<AdCreativeLinkDataTemplateVideoSpec>(){

            @Override
            public APINodeList<AdCreativeLinkDataTemplateVideoSpec> parseResponse(String response, APIContext context, APIRequest<AdCreativeLinkDataTemplateVideoSpec> request) throws APIException.MalformedResponseException {
                return AdCreativeLinkDataTemplateVideoSpec.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdCreativeLinkDataTemplateVideoSpec> {
        AdCreativeLinkDataTemplateVideoSpec lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"categorization_criteria", "customization", "template_id", "id"};

        @Override
        public AdCreativeLinkDataTemplateVideoSpec getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdCreativeLinkDataTemplateVideoSpec parseResponse(String response) throws APIException {
            return AdCreativeLinkDataTemplateVideoSpec.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdCreativeLinkDataTemplateVideoSpec execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdCreativeLinkDataTemplateVideoSpec execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdCreativeLinkDataTemplateVideoSpec> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdCreativeLinkDataTemplateVideoSpec> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdCreativeLinkDataTemplateVideoSpec>(){

                public AdCreativeLinkDataTemplateVideoSpec apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCategorizationCriteriaField() {
            return this.requestCategorizationCriteriaField(true);
        }

        public APIRequestGet requestCategorizationCriteriaField(boolean value) {
            this.requestField("categorization_criteria", value);
            return this;
        }

        public APIRequestGet requestCustomizationField() {
            return this.requestCustomizationField(true);
        }

        public APIRequestGet requestCustomizationField(boolean value) {
            this.requestField("customization", value);
            return this;
        }

        public APIRequestGet requestTemplateIdField() {
            return this.requestTemplateIdField(true);
        }

        public APIRequestGet requestTemplateIdField(boolean value) {
            this.requestField("template_id", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

