/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdCreativeCollectionThumbnailInfo;
import com.facebook.ads.sdk.AdCreativeLinkDataAppLinkSpec;
import com.facebook.ads.sdk.AdCreativeLinkDataCallToAction;
import com.facebook.ads.sdk.AdCreativeLinkDataChildAttachment;
import com.facebook.ads.sdk.AdCreativeLinkDataCustomOverlaySpec;
import com.facebook.ads.sdk.AdCreativeLinkDataImageOverlaySpec;
import com.facebook.ads.sdk.AdCreativeLinkDataSponsorshipInfoSpec;
import com.facebook.ads.sdk.AdCreativePostClickConfiguration;
import com.facebook.ads.sdk.AdCreativeStaticFallbackSpec;
import com.facebook.ads.sdk.AdCustomizationRuleSpec;
import com.facebook.ads.sdk.AdsImageCrops;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdCreativeLinkData
extends APINode {
    @SerializedName(value="additional_image_index")
    private Long mAdditionalImageIndex = null;
    @SerializedName(value="app_link_spec")
    private AdCreativeLinkDataAppLinkSpec mAppLinkSpec = null;
    @SerializedName(value="attachment_style")
    private EnumAttachmentStyle mAttachmentStyle = null;
    @SerializedName(value="branded_content_shared_to_sponsor_status")
    private String mBrandedContentSharedToSponsorStatus = null;
    @SerializedName(value="branded_content_sponsor_page_id")
    private String mBrandedContentSponsorPageId = null;
    @SerializedName(value="branded_content_sponsor_relationship")
    private String mBrandedContentSponsorRelationship = null;
    @SerializedName(value="call_to_action")
    private AdCreativeLinkDataCallToAction mCallToAction = null;
    @SerializedName(value="caption")
    private String mCaption = null;
    @SerializedName(value="child_attachments")
    private List<AdCreativeLinkDataChildAttachment> mChildAttachments = null;
    @SerializedName(value="collection_thumbnails")
    private List<AdCreativeCollectionThumbnailInfo> mCollectionThumbnails = null;
    @SerializedName(value="custom_overlay_spec")
    private AdCreativeLinkDataCustomOverlaySpec mCustomOverlaySpec = null;
    @SerializedName(value="customization_rules_spec")
    private List<AdCustomizationRuleSpec> mCustomizationRulesSpec = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="event_id")
    private String mEventId = null;
    @SerializedName(value="force_single_link")
    private Boolean mForceSingleLink = null;
    @SerializedName(value="format_option")
    private EnumFormatOption mFormatOption = null;
    @SerializedName(value="image_crops")
    private AdsImageCrops mImageCrops = null;
    @SerializedName(value="image_hash")
    private String mImageHash = null;
    @SerializedName(value="image_overlay_spec")
    private AdCreativeLinkDataImageOverlaySpec mImageOverlaySpec = null;
    @SerializedName(value="link")
    private String mLink = null;
    @SerializedName(value="message")
    private String mMessage = null;
    @SerializedName(value="multi_share_end_card")
    private Boolean mMultiShareEndCard = null;
    @SerializedName(value="multi_share_optimized")
    private Boolean mMultiShareOptimized = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="offer_id")
    private String mOfferId = null;
    @SerializedName(value="page_welcome_message")
    private String mPageWelcomeMessage = null;
    @SerializedName(value="picture")
    private String mPicture = null;
    @SerializedName(value="post_click_configuration")
    private AdCreativePostClickConfiguration mPostClickConfiguration = null;
    @SerializedName(value="preferred_image_tags")
    private List<String> mPreferredImageTags = null;
    @SerializedName(value="retailer_item_ids")
    private List<String> mRetailerItemIds = null;
    @SerializedName(value="show_multiple_images")
    private Boolean mShowMultipleImages = null;
    @SerializedName(value="sponsorship_info")
    private AdCreativeLinkDataSponsorshipInfoSpec mSponsorshipInfo = null;
    @SerializedName(value="static_fallback_spec")
    private AdCreativeStaticFallbackSpec mStaticFallbackSpec = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    AdCreativeLinkData() {
    }

    public AdCreativeLinkData(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdCreativeLinkData(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdCreativeLinkData fetch() throws APIException {
        AdCreativeLinkData newInstance = AdCreativeLinkData.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdCreativeLinkData fetchById(Long id, APIContext context) throws APIException {
        return AdCreativeLinkData.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdCreativeLinkData> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdCreativeLinkData.fetchByIdAsync(id.toString(), context);
    }

    public static AdCreativeLinkData fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdCreativeLinkData> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdCreativeLinkData> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdCreativeLinkData>(context, "", "/", "GET", AdCreativeLinkData.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdCreativeLinkData>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdCreativeLinkData>(context, "", "/", "GET", AdCreativeLinkData.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdCreativeLinkData loadJSON(String json, APIContext context) {
        AdCreativeLinkData adCreativeLinkData = (AdCreativeLinkData)AdCreativeLinkData.getGson().fromJson(json, AdCreativeLinkData.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCreativeLinkData.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCreativeLinkData.context = context;
        adCreativeLinkData.rawValue = json;
        return adCreativeLinkData;
    }

    public static APINodeList<AdCreativeLinkData> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdCreativeLinkData> adCreativeLinkDatas = new APINodeList<AdCreativeLinkData>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCreativeLinkDatas.add(AdCreativeLinkData.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adCreativeLinkDatas;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adCreativeLinkDatas.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adCreativeLinkDatas.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adCreativeLinkDatas.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCreativeLinkDatas.add(AdCreativeLinkData.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCreativeLinkDatas.add(AdCreativeLinkData.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCreativeLinkDatas.add(AdCreativeLinkData.loadJSON(obj.toString(), context));
                        }
                    }
                    return adCreativeLinkDatas;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCreativeLinkDatas.add(AdCreativeLinkData.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adCreativeLinkDatas;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCreativeLinkDatas.add(AdCreativeLinkData.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCreativeLinkDatas;
                }
                adCreativeLinkDatas.clear();
                adCreativeLinkDatas.add(AdCreativeLinkData.loadJSON(json, context));
                return adCreativeLinkDatas;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCreativeLinkData.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Long getFieldAdditionalImageIndex() {
        return this.mAdditionalImageIndex;
    }

    public AdCreativeLinkDataAppLinkSpec getFieldAppLinkSpec() {
        if (this.mAppLinkSpec != null) {
            this.mAppLinkSpec.context = this.getContext();
        }
        return this.mAppLinkSpec;
    }

    public EnumAttachmentStyle getFieldAttachmentStyle() {
        return this.mAttachmentStyle;
    }

    public String getFieldBrandedContentSharedToSponsorStatus() {
        return this.mBrandedContentSharedToSponsorStatus;
    }

    public String getFieldBrandedContentSponsorPageId() {
        return this.mBrandedContentSponsorPageId;
    }

    public String getFieldBrandedContentSponsorRelationship() {
        return this.mBrandedContentSponsorRelationship;
    }

    public AdCreativeLinkDataCallToAction getFieldCallToAction() {
        if (this.mCallToAction != null) {
            this.mCallToAction.context = this.getContext();
        }
        return this.mCallToAction;
    }

    public String getFieldCaption() {
        return this.mCaption;
    }

    public List<AdCreativeLinkDataChildAttachment> getFieldChildAttachments() {
        return this.mChildAttachments;
    }

    public List<AdCreativeCollectionThumbnailInfo> getFieldCollectionThumbnails() {
        return this.mCollectionThumbnails;
    }

    public AdCreativeLinkDataCustomOverlaySpec getFieldCustomOverlaySpec() {
        if (this.mCustomOverlaySpec != null) {
            this.mCustomOverlaySpec.context = this.getContext();
        }
        return this.mCustomOverlaySpec;
    }

    public List<AdCustomizationRuleSpec> getFieldCustomizationRulesSpec() {
        return this.mCustomizationRulesSpec;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldEventId() {
        return this.mEventId;
    }

    public Boolean getFieldForceSingleLink() {
        return this.mForceSingleLink;
    }

    public EnumFormatOption getFieldFormatOption() {
        return this.mFormatOption;
    }

    public AdsImageCrops getFieldImageCrops() {
        if (this.mImageCrops != null) {
            this.mImageCrops.context = this.getContext();
        }
        return this.mImageCrops;
    }

    public String getFieldImageHash() {
        return this.mImageHash;
    }

    public AdCreativeLinkDataImageOverlaySpec getFieldImageOverlaySpec() {
        if (this.mImageOverlaySpec != null) {
            this.mImageOverlaySpec.context = this.getContext();
        }
        return this.mImageOverlaySpec;
    }

    public String getFieldLink() {
        return this.mLink;
    }

    public String getFieldMessage() {
        return this.mMessage;
    }

    public Boolean getFieldMultiShareEndCard() {
        return this.mMultiShareEndCard;
    }

    public Boolean getFieldMultiShareOptimized() {
        return this.mMultiShareOptimized;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldOfferId() {
        return this.mOfferId;
    }

    public String getFieldPageWelcomeMessage() {
        return this.mPageWelcomeMessage;
    }

    public String getFieldPicture() {
        return this.mPicture;
    }

    public AdCreativePostClickConfiguration getFieldPostClickConfiguration() {
        if (this.mPostClickConfiguration != null) {
            this.mPostClickConfiguration.context = this.getContext();
        }
        return this.mPostClickConfiguration;
    }

    public List<String> getFieldPreferredImageTags() {
        return this.mPreferredImageTags;
    }

    public List<String> getFieldRetailerItemIds() {
        return this.mRetailerItemIds;
    }

    public Boolean getFieldShowMultipleImages() {
        return this.mShowMultipleImages;
    }

    public AdCreativeLinkDataSponsorshipInfoSpec getFieldSponsorshipInfo() {
        if (this.mSponsorshipInfo != null) {
            this.mSponsorshipInfo.context = this.getContext();
        }
        return this.mSponsorshipInfo;
    }

    public AdCreativeStaticFallbackSpec getFieldStaticFallbackSpec() {
        if (this.mStaticFallbackSpec != null) {
            this.mStaticFallbackSpec.context = this.getContext();
        }
        return this.mStaticFallbackSpec;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCreativeLinkData copyFrom(AdCreativeLinkData instance) {
        this.mAdditionalImageIndex = instance.mAdditionalImageIndex;
        this.mAppLinkSpec = instance.mAppLinkSpec;
        this.mAttachmentStyle = instance.mAttachmentStyle;
        this.mBrandedContentSharedToSponsorStatus = instance.mBrandedContentSharedToSponsorStatus;
        this.mBrandedContentSponsorPageId = instance.mBrandedContentSponsorPageId;
        this.mBrandedContentSponsorRelationship = instance.mBrandedContentSponsorRelationship;
        this.mCallToAction = instance.mCallToAction;
        this.mCaption = instance.mCaption;
        this.mChildAttachments = instance.mChildAttachments;
        this.mCollectionThumbnails = instance.mCollectionThumbnails;
        this.mCustomOverlaySpec = instance.mCustomOverlaySpec;
        this.mCustomizationRulesSpec = instance.mCustomizationRulesSpec;
        this.mDescription = instance.mDescription;
        this.mEventId = instance.mEventId;
        this.mForceSingleLink = instance.mForceSingleLink;
        this.mFormatOption = instance.mFormatOption;
        this.mImageCrops = instance.mImageCrops;
        this.mImageHash = instance.mImageHash;
        this.mImageOverlaySpec = instance.mImageOverlaySpec;
        this.mLink = instance.mLink;
        this.mMessage = instance.mMessage;
        this.mMultiShareEndCard = instance.mMultiShareEndCard;
        this.mMultiShareOptimized = instance.mMultiShareOptimized;
        this.mName = instance.mName;
        this.mOfferId = instance.mOfferId;
        this.mPageWelcomeMessage = instance.mPageWelcomeMessage;
        this.mPicture = instance.mPicture;
        this.mPostClickConfiguration = instance.mPostClickConfiguration;
        this.mPreferredImageTags = instance.mPreferredImageTags;
        this.mRetailerItemIds = instance.mRetailerItemIds;
        this.mShowMultipleImages = instance.mShowMultipleImages;
        this.mSponsorshipInfo = instance.mSponsorshipInfo;
        this.mStaticFallbackSpec = instance.mStaticFallbackSpec;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCreativeLinkData> getParser() {
        return new APIRequest.ResponseParser<AdCreativeLinkData>(){

            @Override
            public APINodeList<AdCreativeLinkData> parseResponse(String response, APIContext context, APIRequest<AdCreativeLinkData> request) throws APIException.MalformedResponseException {
                return AdCreativeLinkData.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumFormatOption {
        VALUE_CAROUSEL_IMAGES_MULTI_ITEMS("carousel_images_multi_items"),
        VALUE_CAROUSEL_IMAGES_SINGLE_ITEM("carousel_images_single_item"),
        VALUE_CAROUSEL_SLIDESHOWS("carousel_slideshows"),
        VALUE_SINGLE_IMAGE("single_image"),
        NULL(null);

        private String value;

        private EnumFormatOption(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumAttachmentStyle {
        VALUE_LINK("link"),
        VALUE_DEFAULT("default"),
        NULL(null);

        private String value;

        private EnumAttachmentStyle(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdCreativeLinkData> {
        AdCreativeLinkData lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"additional_image_index", "app_link_spec", "attachment_style", "branded_content_shared_to_sponsor_status", "branded_content_sponsor_page_id", "branded_content_sponsor_relationship", "call_to_action", "caption", "child_attachments", "collection_thumbnails", "custom_overlay_spec", "customization_rules_spec", "description", "event_id", "force_single_link", "format_option", "image_crops", "image_hash", "image_overlay_spec", "link", "message", "multi_share_end_card", "multi_share_optimized", "name", "offer_id", "page_welcome_message", "picture", "post_click_configuration", "preferred_image_tags", "retailer_item_ids", "show_multiple_images", "sponsorship_info", "static_fallback_spec", "id"};

        @Override
        public AdCreativeLinkData getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdCreativeLinkData parseResponse(String response) throws APIException {
            return AdCreativeLinkData.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public AdCreativeLinkData execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdCreativeLinkData execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public ListenableFuture<AdCreativeLinkData> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdCreativeLinkData> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<String, AdCreativeLinkData>(){

                public AdCreativeLinkData apply(String result) {
                    try {
                        return APIRequestGet.this.parseResponse(result);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAdditionalImageIndexField() {
            return this.requestAdditionalImageIndexField(true);
        }

        public APIRequestGet requestAdditionalImageIndexField(boolean value) {
            this.requestField("additional_image_index", value);
            return this;
        }

        public APIRequestGet requestAppLinkSpecField() {
            return this.requestAppLinkSpecField(true);
        }

        public APIRequestGet requestAppLinkSpecField(boolean value) {
            this.requestField("app_link_spec", value);
            return this;
        }

        public APIRequestGet requestAttachmentStyleField() {
            return this.requestAttachmentStyleField(true);
        }

        public APIRequestGet requestAttachmentStyleField(boolean value) {
            this.requestField("attachment_style", value);
            return this;
        }

        public APIRequestGet requestBrandedContentSharedToSponsorStatusField() {
            return this.requestBrandedContentSharedToSponsorStatusField(true);
        }

        public APIRequestGet requestBrandedContentSharedToSponsorStatusField(boolean value) {
            this.requestField("branded_content_shared_to_sponsor_status", value);
            return this;
        }

        public APIRequestGet requestBrandedContentSponsorPageIdField() {
            return this.requestBrandedContentSponsorPageIdField(true);
        }

        public APIRequestGet requestBrandedContentSponsorPageIdField(boolean value) {
            this.requestField("branded_content_sponsor_page_id", value);
            return this;
        }

        public APIRequestGet requestBrandedContentSponsorRelationshipField() {
            return this.requestBrandedContentSponsorRelationshipField(true);
        }

        public APIRequestGet requestBrandedContentSponsorRelationshipField(boolean value) {
            this.requestField("branded_content_sponsor_relationship", value);
            return this;
        }

        public APIRequestGet requestCallToActionField() {
            return this.requestCallToActionField(true);
        }

        public APIRequestGet requestCallToActionField(boolean value) {
            this.requestField("call_to_action", value);
            return this;
        }

        public APIRequestGet requestCaptionField() {
            return this.requestCaptionField(true);
        }

        public APIRequestGet requestCaptionField(boolean value) {
            this.requestField("caption", value);
            return this;
        }

        public APIRequestGet requestChildAttachmentsField() {
            return this.requestChildAttachmentsField(true);
        }

        public APIRequestGet requestChildAttachmentsField(boolean value) {
            this.requestField("child_attachments", value);
            return this;
        }

        public APIRequestGet requestCollectionThumbnailsField() {
            return this.requestCollectionThumbnailsField(true);
        }

        public APIRequestGet requestCollectionThumbnailsField(boolean value) {
            this.requestField("collection_thumbnails", value);
            return this;
        }

        public APIRequestGet requestCustomOverlaySpecField() {
            return this.requestCustomOverlaySpecField(true);
        }

        public APIRequestGet requestCustomOverlaySpecField(boolean value) {
            this.requestField("custom_overlay_spec", value);
            return this;
        }

        public APIRequestGet requestCustomizationRulesSpecField() {
            return this.requestCustomizationRulesSpecField(true);
        }

        public APIRequestGet requestCustomizationRulesSpecField(boolean value) {
            this.requestField("customization_rules_spec", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestEventIdField() {
            return this.requestEventIdField(true);
        }

        public APIRequestGet requestEventIdField(boolean value) {
            this.requestField("event_id", value);
            return this;
        }

        public APIRequestGet requestForceSingleLinkField() {
            return this.requestForceSingleLinkField(true);
        }

        public APIRequestGet requestForceSingleLinkField(boolean value) {
            this.requestField("force_single_link", value);
            return this;
        }

        public APIRequestGet requestFormatOptionField() {
            return this.requestFormatOptionField(true);
        }

        public APIRequestGet requestFormatOptionField(boolean value) {
            this.requestField("format_option", value);
            return this;
        }

        public APIRequestGet requestImageCropsField() {
            return this.requestImageCropsField(true);
        }

        public APIRequestGet requestImageCropsField(boolean value) {
            this.requestField("image_crops", value);
            return this;
        }

        public APIRequestGet requestImageHashField() {
            return this.requestImageHashField(true);
        }

        public APIRequestGet requestImageHashField(boolean value) {
            this.requestField("image_hash", value);
            return this;
        }

        public APIRequestGet requestImageOverlaySpecField() {
            return this.requestImageOverlaySpecField(true);
        }

        public APIRequestGet requestImageOverlaySpecField(boolean value) {
            this.requestField("image_overlay_spec", value);
            return this;
        }

        public APIRequestGet requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGet requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGet requestMessageField() {
            return this.requestMessageField(true);
        }

        public APIRequestGet requestMessageField(boolean value) {
            this.requestField("message", value);
            return this;
        }

        public APIRequestGet requestMultiShareEndCardField() {
            return this.requestMultiShareEndCardField(true);
        }

        public APIRequestGet requestMultiShareEndCardField(boolean value) {
            this.requestField("multi_share_end_card", value);
            return this;
        }

        public APIRequestGet requestMultiShareOptimizedField() {
            return this.requestMultiShareOptimizedField(true);
        }

        public APIRequestGet requestMultiShareOptimizedField(boolean value) {
            this.requestField("multi_share_optimized", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestOfferIdField() {
            return this.requestOfferIdField(true);
        }

        public APIRequestGet requestOfferIdField(boolean value) {
            this.requestField("offer_id", value);
            return this;
        }

        public APIRequestGet requestPageWelcomeMessageField() {
            return this.requestPageWelcomeMessageField(true);
        }

        public APIRequestGet requestPageWelcomeMessageField(boolean value) {
            this.requestField("page_welcome_message", value);
            return this;
        }

        public APIRequestGet requestPictureField() {
            return this.requestPictureField(true);
        }

        public APIRequestGet requestPictureField(boolean value) {
            this.requestField("picture", value);
            return this;
        }

        public APIRequestGet requestPostClickConfigurationField() {
            return this.requestPostClickConfigurationField(true);
        }

        public APIRequestGet requestPostClickConfigurationField(boolean value) {
            this.requestField("post_click_configuration", value);
            return this;
        }

        public APIRequestGet requestPreferredImageTagsField() {
            return this.requestPreferredImageTagsField(true);
        }

        public APIRequestGet requestPreferredImageTagsField(boolean value) {
            this.requestField("preferred_image_tags", value);
            return this;
        }

        public APIRequestGet requestRetailerItemIdsField() {
            return this.requestRetailerItemIdsField(true);
        }

        public APIRequestGet requestRetailerItemIdsField(boolean value) {
            this.requestField("retailer_item_ids", value);
            return this;
        }

        public APIRequestGet requestShowMultipleImagesField() {
            return this.requestShowMultipleImagesField(true);
        }

        public APIRequestGet requestShowMultipleImagesField(boolean value) {
            this.requestField("show_multiple_images", value);
            return this;
        }

        public APIRequestGet requestSponsorshipInfoField() {
            return this.requestSponsorshipInfoField(true);
        }

        public APIRequestGet requestSponsorshipInfoField(boolean value) {
            this.requestField("sponsorship_info", value);
            return this;
        }

        public APIRequestGet requestStaticFallbackSpecField() {
            return this.requestStaticFallbackSpecField(true);
        }

        public APIRequestGet requestStaticFallbackSpecField(boolean value) {
            this.requestField("static_fallback_spec", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }
}

