/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.ProductItem;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductsQualityIssue
extends APINode {
    @SerializedName(value="count")
    private Long mCount = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="issue_type")
    private String mIssueType = null;
    @SerializedName(value="property_names")
    private List<String> mPropertyNames = null;
    @SerializedName(value="samples")
    private List<ProductItem> mSamples = null;
    @SerializedName(value="summary")
    private String mSummary = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static ProductsQualityIssue loadJSON(String json, APIContext context) {
        ProductsQualityIssue productsQualityIssue = (ProductsQualityIssue)ProductsQualityIssue.getGson().fromJson(json, ProductsQualityIssue.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(productsQualityIssue.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        productsQualityIssue.context = context;
        productsQualityIssue.rawValue = json;
        return productsQualityIssue;
    }

    public static APINodeList<ProductsQualityIssue> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ProductsQualityIssue> productsQualityIssues = new APINodeList<ProductsQualityIssue>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        productsQualityIssues.add(ProductsQualityIssue.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return productsQualityIssues;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            productsQualityIssues.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        productsQualityIssues.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            productsQualityIssues.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            productsQualityIssues.add(ProductsQualityIssue.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                productsQualityIssues.add(ProductsQualityIssue.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            productsQualityIssues.add(ProductsQualityIssue.loadJSON(obj.toString(), context));
                        }
                    }
                    return productsQualityIssues;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        productsQualityIssues.add(ProductsQualityIssue.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return productsQualityIssues;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        productsQualityIssues.add(ProductsQualityIssue.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return productsQualityIssues;
                }
                productsQualityIssues.clear();
                productsQualityIssues.add(ProductsQualityIssue.loadJSON(json, context));
                return productsQualityIssues;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ProductsQualityIssue.getGson().toJson((Object)this);
    }

    public Long getFieldCount() {
        return this.mCount;
    }

    public ProductsQualityIssue setFieldCount(Long value) {
        this.mCount = value;
        return this;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public ProductsQualityIssue setFieldDescription(String value) {
        this.mDescription = value;
        return this;
    }

    public String getFieldIssueType() {
        return this.mIssueType;
    }

    public ProductsQualityIssue setFieldIssueType(String value) {
        this.mIssueType = value;
        return this;
    }

    public List<String> getFieldPropertyNames() {
        return this.mPropertyNames;
    }

    public ProductsQualityIssue setFieldPropertyNames(List<String> value) {
        this.mPropertyNames = value;
        return this;
    }

    public List<ProductItem> getFieldSamples() {
        return this.mSamples;
    }

    public ProductsQualityIssue setFieldSamples(List<ProductItem> value) {
        this.mSamples = value;
        return this;
    }

    public ProductsQualityIssue setFieldSamples(String value) {
        Type type = new TypeToken<List<ProductItem>>(){}.getType();
        this.mSamples = (List)ProductItem.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldSummary() {
        return this.mSummary;
    }

    public ProductsQualityIssue setFieldSummary(String value) {
        this.mSummary = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ProductsQualityIssue copyFrom(ProductsQualityIssue instance) {
        this.mCount = instance.mCount;
        this.mDescription = instance.mDescription;
        this.mIssueType = instance.mIssueType;
        this.mPropertyNames = instance.mPropertyNames;
        this.mSamples = instance.mSamples;
        this.mSummary = instance.mSummary;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ProductsQualityIssue> getParser() {
        return new APIRequest.ResponseParser<ProductsQualityIssue>(){

            @Override
            public APINodeList<ProductsQualityIssue> parseResponse(String response, APIContext context, APIRequest<ProductsQualityIssue> request) throws APIException.MalformedResponseException {
                return ProductsQualityIssue.parseResponse(response, context, request);
            }
        };
    }
}

