/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverPhoto
extends APINode {
    @SerializedName(value="cover_id")
    private String mCoverId = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="offset_x")
    private Double mOffsetX = null;
    @SerializedName(value="offset_y")
    private Double mOffsetY = null;
    @SerializedName(value="source")
    private String mSource = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static CoverPhoto loadJSON(String json, APIContext context) {
        CoverPhoto coverPhoto = (CoverPhoto)CoverPhoto.getGson().fromJson(json, CoverPhoto.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(coverPhoto.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        coverPhoto.context = context;
        coverPhoto.rawValue = json;
        return coverPhoto;
    }

    public static APINodeList<CoverPhoto> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<CoverPhoto> coverPhotos = new APINodeList<CoverPhoto>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        coverPhotos.add(CoverPhoto.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return coverPhotos;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            coverPhotos.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        coverPhotos.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            coverPhotos.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            coverPhotos.add(CoverPhoto.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                coverPhotos.add(CoverPhoto.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            coverPhotos.add(CoverPhoto.loadJSON(obj.toString(), context));
                        }
                    }
                    return coverPhotos;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        coverPhotos.add(CoverPhoto.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return coverPhotos;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        coverPhotos.add(CoverPhoto.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return coverPhotos;
                }
                coverPhotos.clear();
                coverPhotos.add(CoverPhoto.loadJSON(json, context));
                return coverPhotos;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CoverPhoto.getGson().toJson((Object)this);
    }

    public String getFieldCoverId() {
        return this.mCoverId;
    }

    public CoverPhoto setFieldCoverId(String value) {
        this.mCoverId = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public CoverPhoto setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public Double getFieldOffsetX() {
        return this.mOffsetX;
    }

    public CoverPhoto setFieldOffsetX(Double value) {
        this.mOffsetX = value;
        return this;
    }

    public Double getFieldOffsetY() {
        return this.mOffsetY;
    }

    public CoverPhoto setFieldOffsetY(Double value) {
        this.mOffsetY = value;
        return this;
    }

    public String getFieldSource() {
        return this.mSource;
    }

    public CoverPhoto setFieldSource(String value) {
        this.mSource = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CoverPhoto copyFrom(CoverPhoto instance) {
        this.mCoverId = instance.mCoverId;
        this.mId = instance.mId;
        this.mOffsetX = instance.mOffsetX;
        this.mOffsetY = instance.mOffsetY;
        this.mSource = instance.mSource;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CoverPhoto> getParser() {
        return new APIRequest.ResponseParser<CoverPhoto>(){

            @Override
            public APINodeList<CoverPhoto> parseResponse(String response, APIContext context, APIRequest<CoverPhoto> request) throws APIException.MalformedResponseException {
                return CoverPhoto.parseResponse(response, context, request);
            }
        };
    }
}

