/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdsPixelStats
extends APINode {
    @SerializedName(value="count")
    private Long mCount = null;
    @SerializedName(value="diagnostics_hourly_last_timestamp")
    private String mDiagnosticsHourlyLastTimestamp = null;
    @SerializedName(value="event")
    private String mEvent = null;
    @SerializedName(value="value")
    private String mValue = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdsPixelStats loadJSON(String json, APIContext context) {
        AdsPixelStats adsPixelStats = (AdsPixelStats)AdsPixelStats.getGson().fromJson(json, AdsPixelStats.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adsPixelStats.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adsPixelStats.context = context;
        adsPixelStats.rawValue = json;
        return adsPixelStats;
    }

    public static APINodeList<AdsPixelStats> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdsPixelStats> adsPixelStatss = new APINodeList<AdsPixelStats>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adsPixelStatss.add(AdsPixelStats.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adsPixelStatss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adsPixelStatss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adsPixelStatss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adsPixelStatss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adsPixelStatss.add(AdsPixelStats.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adsPixelStatss.add(AdsPixelStats.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adsPixelStatss.add(AdsPixelStats.loadJSON(obj.toString(), context));
                        }
                    }
                    return adsPixelStatss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adsPixelStatss.add(AdsPixelStats.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adsPixelStatss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adsPixelStatss.add(AdsPixelStats.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adsPixelStatss;
                }
                adsPixelStatss.clear();
                adsPixelStatss.add(AdsPixelStats.loadJSON(json, context));
                return adsPixelStatss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdsPixelStats.getGson().toJson((Object)this);
    }

    public Long getFieldCount() {
        return this.mCount;
    }

    public AdsPixelStats setFieldCount(Long value) {
        this.mCount = value;
        return this;
    }

    public String getFieldDiagnosticsHourlyLastTimestamp() {
        return this.mDiagnosticsHourlyLastTimestamp;
    }

    public AdsPixelStats setFieldDiagnosticsHourlyLastTimestamp(String value) {
        this.mDiagnosticsHourlyLastTimestamp = value;
        return this;
    }

    public String getFieldEvent() {
        return this.mEvent;
    }

    public AdsPixelStats setFieldEvent(String value) {
        this.mEvent = value;
        return this;
    }

    public String getFieldValue() {
        return this.mValue;
    }

    public AdsPixelStats setFieldValue(String value) {
        this.mValue = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdsPixelStats copyFrom(AdsPixelStats instance) {
        this.mCount = instance.mCount;
        this.mDiagnosticsHourlyLastTimestamp = instance.mDiagnosticsHourlyLastTimestamp;
        this.mEvent = instance.mEvent;
        this.mValue = instance.mValue;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdsPixelStats> getParser() {
        return new APIRequest.ResponseParser<AdsPixelStats>(){

            @Override
            public APINodeList<AdsPixelStats> parseResponse(String response, APIContext context, APIRequest<AdsPixelStats> request) throws APIException.MalformedResponseException {
                return AdsPixelStats.parseResponse(response, context, request);
            }
        };
    }
}

