/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdgroupRelevanceScore;
import com.facebook.ads.sdk.AdsActionStats;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdsInsights
extends APINode {
    @SerializedName(value="account_currency")
    private String mAccountCurrency = null;
    @SerializedName(value="account_id")
    private String mAccountId = null;
    @SerializedName(value="account_name")
    private String mAccountName = null;
    @SerializedName(value="action_values")
    private List<AdsActionStats> mActionValues = null;
    @SerializedName(value="actions")
    private List<AdsActionStats> mActions = null;
    @SerializedName(value="ad_id")
    private String mAdId = null;
    @SerializedName(value="ad_name")
    private String mAdName = null;
    @SerializedName(value="adset_id")
    private String mAdsetId = null;
    @SerializedName(value="adset_name")
    private String mAdsetName = null;
    @SerializedName(value="buying_type")
    private String mBuyingType = null;
    @SerializedName(value="campaign_id")
    private String mCampaignId = null;
    @SerializedName(value="campaign_name")
    private String mCampaignName = null;
    @SerializedName(value="canvas_avg_view_percent")
    private String mCanvasAvgViewPercent = null;
    @SerializedName(value="canvas_avg_view_time")
    private String mCanvasAvgViewTime = null;
    @SerializedName(value="clicks")
    private String mClicks = null;
    @SerializedName(value="cost_per_10_sec_video_view")
    private List<AdsActionStats> mCostPer10SecVideoView = null;
    @SerializedName(value="cost_per_action_type")
    private List<AdsActionStats> mCostPerActionType = null;
    @SerializedName(value="cost_per_estimated_ad_recallers")
    private String mCostPerEstimatedAdRecallers = null;
    @SerializedName(value="cost_per_inline_link_click")
    private String mCostPerInlineLinkClick = null;
    @SerializedName(value="cost_per_inline_post_engagement")
    private String mCostPerInlinePostEngagement = null;
    @SerializedName(value="cost_per_outbound_click")
    private List<AdsActionStats> mCostPerOutboundClick = null;
    @SerializedName(value="cost_per_unique_action_type")
    private List<AdsActionStats> mCostPerUniqueActionType = null;
    @SerializedName(value="cost_per_unique_click")
    private String mCostPerUniqueClick = null;
    @SerializedName(value="cost_per_unique_inline_link_click")
    private String mCostPerUniqueInlineLinkClick = null;
    @SerializedName(value="cost_per_unique_outbound_click")
    private List<AdsActionStats> mCostPerUniqueOutboundClick = null;
    @SerializedName(value="cpc")
    private String mCpc = null;
    @SerializedName(value="cpm")
    private String mCpm = null;
    @SerializedName(value="cpp")
    private String mCpp = null;
    @SerializedName(value="ctr")
    private String mCtr = null;
    @SerializedName(value="date_start")
    private String mDateStart = null;
    @SerializedName(value="date_stop")
    private String mDateStop = null;
    @SerializedName(value="estimated_ad_recall_rate")
    private String mEstimatedAdRecallRate = null;
    @SerializedName(value="estimated_ad_recallers")
    private String mEstimatedAdRecallers = null;
    @SerializedName(value="frequency")
    private String mFrequency = null;
    @SerializedName(value="impressions")
    private String mImpressions = null;
    @SerializedName(value="inline_link_click_ctr")
    private String mInlineLinkClickCtr = null;
    @SerializedName(value="inline_link_clicks")
    private String mInlineLinkClicks = null;
    @SerializedName(value="inline_post_engagement")
    private String mInlinePostEngagement = null;
    @SerializedName(value="mobile_app_purchase_roas")
    private List<AdsActionStats> mMobileAppPurchaseRoas = null;
    @SerializedName(value="objective")
    private String mObjective = null;
    @SerializedName(value="outbound_clicks")
    private List<AdsActionStats> mOutboundClicks = null;
    @SerializedName(value="outbound_clicks_ctr")
    private List<AdsActionStats> mOutboundClicksCtr = null;
    @SerializedName(value="place_page_name")
    private String mPlacePageName = null;
    @SerializedName(value="reach")
    private String mReach = null;
    @SerializedName(value="relevance_score")
    private AdgroupRelevanceScore mRelevanceScore = null;
    @SerializedName(value="social_impressions")
    private String mSocialImpressions = null;
    @SerializedName(value="social_spend")
    private String mSocialSpend = null;
    @SerializedName(value="spend")
    private String mSpend = null;
    @SerializedName(value="total_action_value")
    private String mTotalActionValue = null;
    @SerializedName(value="unique_actions")
    private List<AdsActionStats> mUniqueActions = null;
    @SerializedName(value="unique_clicks")
    private String mUniqueClicks = null;
    @SerializedName(value="unique_ctr")
    private String mUniqueCtr = null;
    @SerializedName(value="unique_inline_link_click_ctr")
    private String mUniqueInlineLinkClickCtr = null;
    @SerializedName(value="unique_inline_link_clicks")
    private String mUniqueInlineLinkClicks = null;
    @SerializedName(value="unique_link_clicks_ctr")
    private String mUniqueLinkClicksCtr = null;
    @SerializedName(value="unique_outbound_clicks")
    private List<AdsActionStats> mUniqueOutboundClicks = null;
    @SerializedName(value="unique_outbound_clicks_ctr")
    private List<AdsActionStats> mUniqueOutboundClicksCtr = null;
    @SerializedName(value="video_10_sec_watched_actions")
    private List<AdsActionStats> mVideo10SecWatchedActions = null;
    @SerializedName(value="video_30_sec_watched_actions")
    private List<AdsActionStats> mVideo30SecWatchedActions = null;
    @SerializedName(value="video_avg_percent_watched_actions")
    private List<AdsActionStats> mVideoAvgPercentWatchedActions = null;
    @SerializedName(value="video_avg_time_watched_actions")
    private List<AdsActionStats> mVideoAvgTimeWatchedActions = null;
    @SerializedName(value="video_p100_watched_actions")
    private List<AdsActionStats> mVideoP100WatchedActions = null;
    @SerializedName(value="video_p25_watched_actions")
    private List<AdsActionStats> mVideoP25WatchedActions = null;
    @SerializedName(value="video_p50_watched_actions")
    private List<AdsActionStats> mVideoP50WatchedActions = null;
    @SerializedName(value="video_p75_watched_actions")
    private List<AdsActionStats> mVideoP75WatchedActions = null;
    @SerializedName(value="video_p95_watched_actions")
    private List<AdsActionStats> mVideoP95WatchedActions = null;
    @SerializedName(value="website_ctr")
    private List<AdsActionStats> mWebsiteCtr = null;
    @SerializedName(value="website_purchase_roas")
    private List<AdsActionStats> mWebsitePurchaseRoas = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdsInsights loadJSON(String json, APIContext context) {
        AdsInsights adsInsights = (AdsInsights)AdsInsights.getGson().fromJson(json, AdsInsights.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adsInsights.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adsInsights.context = context;
        adsInsights.rawValue = json;
        return adsInsights;
    }

    public static APINodeList<AdsInsights> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdsInsights> adsInsightss = new APINodeList<AdsInsights>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adsInsightss.add(AdsInsights.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adsInsightss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adsInsightss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adsInsightss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adsInsightss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adsInsightss.add(AdsInsights.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adsInsightss.add(AdsInsights.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adsInsightss.add(AdsInsights.loadJSON(obj.toString(), context));
                        }
                    }
                    return adsInsightss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adsInsightss.add(AdsInsights.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adsInsightss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adsInsightss.add(AdsInsights.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adsInsightss;
                }
                adsInsightss.clear();
                adsInsightss.add(AdsInsights.loadJSON(json, context));
                return adsInsightss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdsInsights.getGson().toJson((Object)this);
    }

    public String getFieldAccountCurrency() {
        return this.mAccountCurrency;
    }

    public AdsInsights setFieldAccountCurrency(String value) {
        this.mAccountCurrency = value;
        return this;
    }

    public String getFieldAccountId() {
        return this.mAccountId;
    }

    public AdsInsights setFieldAccountId(String value) {
        this.mAccountId = value;
        return this;
    }

    public String getFieldAccountName() {
        return this.mAccountName;
    }

    public AdsInsights setFieldAccountName(String value) {
        this.mAccountName = value;
        return this;
    }

    public List<AdsActionStats> getFieldActionValues() {
        return this.mActionValues;
    }

    public AdsInsights setFieldActionValues(List<AdsActionStats> value) {
        this.mActionValues = value;
        return this;
    }

    public AdsInsights setFieldActionValues(String value) {
        Type type = new TypeToken<List<AdsActionStats>>(){}.getType();
        this.mActionValues = (List)AdsActionStats.getGson().fromJson(value, type);
        return this;
    }

    public List<AdsActionStats> getFieldActions() {
        return this.mActions;
    }

    public AdsInsights setFieldActions(List<AdsActionStats> value) {
        this.mActions = value;
        return this;
    }

    public AdsInsights setFieldActions(String value) {
        Type type = new TypeToken<List<AdsActionStats>>(){}.getType();
        this.mActions = (List)AdsActionStats.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldAdId() {
        return this.mAdId;
    }

    public AdsInsights setFieldAdId(String value) {
        this.mAdId = value;
        return this;
    }

    public String getFieldAdName() {
        return this.mAdName;
    }

    public AdsInsights setFieldAdName(String value) {
        this.mAdName = value;
        return this;
    }

    public String getFieldAdsetId() {
        return this.mAdsetId;
    }

    public AdsInsights setFieldAdsetId(String value) {
        this.mAdsetId = value;
        return this;
    }

    public String getFieldAdsetName() {
        return this.mAdsetName;
    }

    public AdsInsights setFieldAdsetName(String value) {
        this.mAdsetName = value;
        return this;
    }

    public String getFieldBuyingType() {
        return this.mBuyingType;
    }

    public AdsInsights setFieldBuyingType(String value) {
        this.mBuyingType = value;
        return this;
    }

    public String getFieldCampaignId() {
        return this.mCampaignId;
    }

    public AdsInsights setFieldCampaignId(String value) {
        this.mCampaignId = value;
        return this;
    }

    public String getFieldCampaignName() {
        return this.mCampaignName;
    }

    public AdsInsights setFieldCampaignName(String value) {
        this.mCampaignName = value;
        return this;
    }

    public String getFieldCanvasAvgViewPercent() {
        return this.mCanvasAvgViewPercent;
    }

    public AdsInsights setFieldCanvasAvgViewPercent(String value) {
        this.mCanvasAvgViewPercent = value;
        return this;
    }

    public String getFieldCanvasAvgViewTime() {
        return this.mCanvasAvgViewTime;
    }

    public AdsInsights setFieldCanvasAvgViewTime(String value) {
        this.mCanvasAvgViewTime = value;
        return this;
    }

    public String getFieldClicks() {
        return this.mClicks;
    }

    public AdsInsights setFieldClicks(String value) {
        this.mClicks = value;
        return this;
    }

    public List<AdsActionStats> getFieldCostPer10SecVideoView() {
        return this.mCostPer10SecVideoView;
    }

    public AdsInsights setFieldCostPer10SecVideoView(List<AdsActionStats> value) {
        this.mCostPer10SecVideoView = value;
        return this;
    }

    public AdsInsights setFieldCostPer10SecVideoView(String value) {
        Type type = new TypeToken<List<AdsActionStats>>(){}.getType();
        this.mCostPer10SecVideoView = (List)AdsActionStats.getGson().fromJson(value, type);
        return this;
    }

    public List<AdsActionStats> getFieldCostPerActionType() {
        return this.mCostPerActionType;
    }

    public AdsInsights setFieldCostPerActionType(List<AdsActionStats> value) {
        this.mCostPerActionType = value;
        return this;
    }

    public AdsInsights setFieldCostPerActionType(String value) {
        Type type = new TypeToken<List<AdsActionStats>>(){}.getType();
        this.mCostPerActionType = (List)AdsActionStats.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldCostPerEstimatedAdRecallers() {
        return this.mCostPerEstimatedAdRecallers;
    }

    public AdsInsights setFieldCostPerEstimatedAdRecallers(String value) {
        this.mCostPerEstimatedAdRecallers = value;
        return this;
    }

    public String getFieldCostPerInlineLinkClick() {
        return this.mCostPerInlineLinkClick;
    }

    public AdsInsights setFieldCostPerInlineLinkClick(String value) {
        this.mCostPerInlineLinkClick = value;
        return this;
    }

    public String getFieldCostPerInlinePostEngagement() {
        return this.mCostPerInlinePostEngagement;
    }

    public AdsInsights setFieldCostPerInlinePostEngagement(String value) {
        this.mCostPerInlinePostEngagement = value;
        return this;
    }

    public List<AdsActionStats> getFieldCostPerOutboundClick() {
        return this.mCostPerOutboundClick;
    }

    public AdsInsights setFieldCostPerOutboundClick(List<AdsActionStats> value) {
        this.mCostPerOutboundClick = value;
        return this;
    }

    public AdsInsights setFieldCostPerOutboundClick(String value) {
        Type type = new TypeToken<List<AdsActionStats>>(){}.getType();
        this.mCostPerOutboundClick = (List)AdsActionStats.getGson().fromJson(value, type);
        return this;
    }

    public List<AdsActionStats> getFieldCostPerUniqueActionType() {
        return this.mCostPerUniqueActionType;
    }

    public AdsInsights setFieldCostPerUniqueActionType(List<AdsActionStats> value) {
        this.mCostPerUniqueActionType = value;
        return this;
    }

    public AdsInsights setFieldCostPerUniqueActionType(String value) {
        Type type = new TypeToken<List<AdsActionStats>>(){}.getType();
        this.mCostPerUniqueActionType = (List)AdsActionStats.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldCostPerUniqueClick() {
        return this.mCostPerUniqueClick;
    }

    public AdsInsights setFieldCostPerUniqueClick(String value) {
        this.mCostPerUniqueClick = value;
        return this;
    }

    public String getFieldCostPerUniqueInlineLinkClick() {
        return this.mCostPerUniqueInlineLinkClick;
    }

    public AdsInsights setFieldCostPerUniqueInlineLinkClick(String value) {
        this.mCostPerUniqueInlineLinkClick = value;
        return this;
    }

    public List<AdsActionStats> getFieldCostPerUniqueOutboundClick() {
        return this.mCostPerUniqueOutboundClick;
    }

    public AdsInsights setFieldCostPerUniqueOutboundClick(List<AdsActionStats> value) {
        this.mCostPerUniqueOutboundClick = value;
        return this;
    }

    public AdsInsights setFieldCostPerUniqueOutboundClick(String value) {
        Type type = new TypeToken<List<AdsActionStats>>(){}.getType();
        this.mCostPerUniqueOutboundClick = (List)AdsActionStats.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldCpc() {
        return this.mCpc;
    }

    public AdsInsights setFieldCpc(String value) {
        this.mCpc = value;
        return this;
    }

    public String getFieldCpm() {
        return this.mCpm;
    }

    public AdsInsights setFieldCpm(String value) {
        this.mCpm = value;
        return this;
    }

    public String getFieldCpp() {
        return this.mCpp;
    }

    public AdsInsights setFieldCpp(String value) {
        this.mCpp = value;
        return this;
    }

    public String getFieldCtr() {
        return this.mCtr;
    }

    public AdsInsights setFieldCtr(String value) {
        this.mCtr = value;
        return this;
    }

    public String getFieldDateStart() {
        return this.mDateStart;
    }

    public AdsInsights setFieldDateStart(String value) {
        this.mDateStart = value;
        return this;
    }

    public String getFieldDateStop() {
        return this.mDateStop;
    }

    public AdsInsights setFieldDateStop(String value) {
        this.mDateStop = value;
        return this;
    }

    public String getFieldEstimatedAdRecallRate() {
        return this.mEstimatedAdRecallRate;
    }

    public AdsInsights setFieldEstimatedAdRecallRate(String value) {
        this.mEstimatedAdRecallRate = value;
        return this;
    }

    public String getFieldEstimatedAdRecallers() {
        return this.mEstimatedAdRecallers;
    }

    public AdsInsights setFieldEstimatedAdRecallers(String value) {
        this.mEstimatedAdRecallers = value;
        return this;
    }

    public String getFieldFrequency() {
        return this.mFrequency;
    }

    public AdsInsights setFieldFrequency(String value) {
        this.mFrequency = value;
        return this;
    }

    public String getFieldImpressions() {
        return this.mImpressions;
    }

    public AdsInsights setFieldImpressions(String value) {
        this.mImpressions = value;
        return this;
    }

    public String getFieldInlineLinkClickCtr() {
        return this.mInlineLinkClickCtr;
    }

    public AdsInsights setFieldInlineLinkClickCtr(String value) {
        this.mInlineLinkClickCtr = value;
        return this;
    }

    public String getFieldInlineLinkClicks() {
        return this.mInlineLinkClicks;
    }

    public AdsInsights setFieldInlineLinkClicks(String value) {
        this.mInlineLinkClicks = value;
        return this;
    }

    public String getFieldInlinePostEngagement() {
        return this.mInlinePostEngagement;
    }

    public AdsInsights setFieldInlinePostEngagement(String value) {
        this.mInlinePostEngagement = value;
        return this;
    }

    public List<AdsActionStats> getFieldMobileAppPurchaseRoas() {
        return this.mMobileAppPurchaseRoas;
    }

    public AdsInsights setFieldMobileAppPurchaseRoas(List<AdsActionStats> value) {
        this.mMobileAppPurchaseRoas = value;
        return this;
    }

    public AdsInsights setFieldMobileAppPurchaseRoas(String value) {
        Type type = new TypeToken<List<AdsActionStats>>(){}.getType();
        this.mMobileAppPurchaseRoas = (List)AdsActionStats.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldObjective() {
        return this.mObjective;
    }

    public AdsInsights setFieldObjective(String value) {
        this.mObjective = value;
        return this;
    }

    public List<AdsActionStats> getFieldOutboundClicks() {
        return this.mOutboundClicks;
    }

    public AdsInsights setFieldOutboundClicks(List<AdsActionStats> value) {
        this.mOutboundClicks = value;
        return this;
    }

    public AdsInsights setFieldOutboundClicks(String value) {
        Type type = new TypeToken<List<AdsActionStats>>(){}.getType();
        this.mOutboundClicks = (List)AdsActionStats.getGson().fromJson(value, type);
        return this;
    }

    public List<AdsActionStats> getFieldOutboundClicksCtr() {
        return this.mOutboundClicksCtr;
    }

    public AdsInsights setFieldOutboundClicksCtr(List<AdsActionStats> value) {
        this.mOutboundClicksCtr = value;
        return this;
    }

    public AdsInsights setFieldOutboundClicksCtr(String value) {
        Type type = new TypeToken<List<AdsActionStats>>(){}.getType();
        this.mOutboundClicksCtr = (List)AdsActionStats.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldPlacePageName() {
        return this.mPlacePageName;
    }

    public AdsInsights setFieldPlacePageName(String value) {
        this.mPlacePageName = value;
        return this;
    }

    public String getFieldReach() {
        return this.mReach;
    }

    public AdsInsights setFieldReach(String value) {
        this.mReach = value;
        return this;
    }

    public AdgroupRelevanceScore getFieldRelevanceScore() {
        return this.mRelevanceScore;
    }

    public AdsInsights setFieldRelevanceScore(AdgroupRelevanceScore value) {
        this.mRelevanceScore = value;
        return this;
    }

    public AdsInsights setFieldRelevanceScore(String value) {
        Type type = new TypeToken<AdgroupRelevanceScore>(){}.getType();
        this.mRelevanceScore = (AdgroupRelevanceScore)AdgroupRelevanceScore.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldSocialImpressions() {
        return this.mSocialImpressions;
    }

    public AdsInsights setFieldSocialImpressions(String value) {
        this.mSocialImpressions = value;
        return this;
    }

    public String getFieldSocialSpend() {
        return this.mSocialSpend;
    }

    public AdsInsights setFieldSocialSpend(String value) {
        this.mSocialSpend = value;
        return this;
    }

    public String getFieldSpend() {
        return this.mSpend;
    }

    public AdsInsights setFieldSpend(String value) {
        this.mSpend = value;
        return this;
    }

    public String getFieldTotalActionValue() {
        return this.mTotalActionValue;
    }

    public AdsInsights setFieldTotalActionValue(String value) {
        this.mTotalActionValue = value;
        return this;
    }

    public List<AdsActionStats> getFieldUniqueActions() {
        return this.mUniqueActions;
    }

    public AdsInsights setFieldUniqueActions(List<AdsActionStats> value) {
        this.mUniqueActions = value;
        return this;
    }

    public AdsInsights setFieldUniqueActions(String value) {
        Type type = new TypeToken<List<AdsActionStats>>(){}.getType();
        this.mUniqueActions = (List)AdsActionStats.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldUniqueClicks() {
        return this.mUniqueClicks;
    }

    public AdsInsights setFieldUniqueClicks(String value) {
        this.mUniqueClicks = value;
        return this;
    }

    public String getFieldUniqueCtr() {
        return this.mUniqueCtr;
    }

    public AdsInsights setFieldUniqueCtr(String value) {
        this.mUniqueCtr = value;
        return this;
    }

    public String getFieldUniqueInlineLinkClickCtr() {
        return this.mUniqueInlineLinkClickCtr;
    }

    public AdsInsights setFieldUniqueInlineLinkClickCtr(String value) {
        this.mUniqueInlineLinkClickCtr = value;
        return this;
    }

    public String getFieldUniqueInlineLinkClicks() {
        return this.mUniqueInlineLinkClicks;
    }

    public AdsInsights setFieldUniqueInlineLinkClicks(String value) {
        this.mUniqueInlineLinkClicks = value;
        return this;
    }

    public String getFieldUniqueLinkClicksCtr() {
        return this.mUniqueLinkClicksCtr;
    }

    public AdsInsights setFieldUniqueLinkClicksCtr(String value) {
        this.mUniqueLinkClicksCtr = value;
        return this;
    }

    public List<AdsActionStats> getFieldUniqueOutboundClicks() {
        return this.mUniqueOutboundClicks;
    }

    public AdsInsights setFieldUniqueOutboundClicks(List<AdsActionStats> value) {
        this.mUniqueOutboundClicks = value;
        return this;
    }

    public AdsInsights setFieldUniqueOutboundClicks(String value) {
        Type type = new TypeToken<List<AdsActionStats>>(){}.getType();
        this.mUniqueOutboundClicks = (List)AdsActionStats.getGson().fromJson(value, type);
        return this;
    }

    public List<AdsActionStats> getFieldUniqueOutboundClicksCtr() {
        return this.mUniqueOutboundClicksCtr;
    }

    public AdsInsights setFieldUniqueOutboundClicksCtr(List<AdsActionStats> value) {
        this.mUniqueOutboundClicksCtr = value;
        return this;
    }

    public AdsInsights setFieldUniqueOutboundClicksCtr(String value) {
        Type type = new TypeToken<List<AdsActionStats>>(){}.getType();
        this.mUniqueOutboundClicksCtr = (List)AdsActionStats.getGson().fromJson(value, type);
        return this;
    }

    public List<AdsActionStats> getFieldVideo10SecWatchedActions() {
        return this.mVideo10SecWatchedActions;
    }

    public AdsInsights setFieldVideo10SecWatchedActions(List<AdsActionStats> value) {
        this.mVideo10SecWatchedActions = value;
        return this;
    }

    public AdsInsights setFieldVideo10SecWatchedActions(String value) {
        Type type = new TypeToken<List<AdsActionStats>>(){}.getType();
        this.mVideo10SecWatchedActions = (List)AdsActionStats.getGson().fromJson(value, type);
        return this;
    }

    public List<AdsActionStats> getFieldVideo30SecWatchedActions() {
        return this.mVideo30SecWatchedActions;
    }

    public AdsInsights setFieldVideo30SecWatchedActions(List<AdsActionStats> value) {
        this.mVideo30SecWatchedActions = value;
        return this;
    }

    public AdsInsights setFieldVideo30SecWatchedActions(String value) {
        Type type = new TypeToken<List<AdsActionStats>>(){}.getType();
        this.mVideo30SecWatchedActions = (List)AdsActionStats.getGson().fromJson(value, type);
        return this;
    }

    public List<AdsActionStats> getFieldVideoAvgPercentWatchedActions() {
        return this.mVideoAvgPercentWatchedActions;
    }

    public AdsInsights setFieldVideoAvgPercentWatchedActions(List<AdsActionStats> value) {
        this.mVideoAvgPercentWatchedActions = value;
        return this;
    }

    public AdsInsights setFieldVideoAvgPercentWatchedActions(String value) {
        Type type = new TypeToken<List<AdsActionStats>>(){}.getType();
        this.mVideoAvgPercentWatchedActions = (List)AdsActionStats.getGson().fromJson(value, type);
        return this;
    }

    public List<AdsActionStats> getFieldVideoAvgTimeWatchedActions() {
        return this.mVideoAvgTimeWatchedActions;
    }

    public AdsInsights setFieldVideoAvgTimeWatchedActions(List<AdsActionStats> value) {
        this.mVideoAvgTimeWatchedActions = value;
        return this;
    }

    public AdsInsights setFieldVideoAvgTimeWatchedActions(String value) {
        Type type = new TypeToken<List<AdsActionStats>>(){}.getType();
        this.mVideoAvgTimeWatchedActions = (List)AdsActionStats.getGson().fromJson(value, type);
        return this;
    }

    public List<AdsActionStats> getFieldVideoP100WatchedActions() {
        return this.mVideoP100WatchedActions;
    }

    public AdsInsights setFieldVideoP100WatchedActions(List<AdsActionStats> value) {
        this.mVideoP100WatchedActions = value;
        return this;
    }

    public AdsInsights setFieldVideoP100WatchedActions(String value) {
        Type type = new TypeToken<List<AdsActionStats>>(){}.getType();
        this.mVideoP100WatchedActions = (List)AdsActionStats.getGson().fromJson(value, type);
        return this;
    }

    public List<AdsActionStats> getFieldVideoP25WatchedActions() {
        return this.mVideoP25WatchedActions;
    }

    public AdsInsights setFieldVideoP25WatchedActions(List<AdsActionStats> value) {
        this.mVideoP25WatchedActions = value;
        return this;
    }

    public AdsInsights setFieldVideoP25WatchedActions(String value) {
        Type type = new TypeToken<List<AdsActionStats>>(){}.getType();
        this.mVideoP25WatchedActions = (List)AdsActionStats.getGson().fromJson(value, type);
        return this;
    }

    public List<AdsActionStats> getFieldVideoP50WatchedActions() {
        return this.mVideoP50WatchedActions;
    }

    public AdsInsights setFieldVideoP50WatchedActions(List<AdsActionStats> value) {
        this.mVideoP50WatchedActions = value;
        return this;
    }

    public AdsInsights setFieldVideoP50WatchedActions(String value) {
        Type type = new TypeToken<List<AdsActionStats>>(){}.getType();
        this.mVideoP50WatchedActions = (List)AdsActionStats.getGson().fromJson(value, type);
        return this;
    }

    public List<AdsActionStats> getFieldVideoP75WatchedActions() {
        return this.mVideoP75WatchedActions;
    }

    public AdsInsights setFieldVideoP75WatchedActions(List<AdsActionStats> value) {
        this.mVideoP75WatchedActions = value;
        return this;
    }

    public AdsInsights setFieldVideoP75WatchedActions(String value) {
        Type type = new TypeToken<List<AdsActionStats>>(){}.getType();
        this.mVideoP75WatchedActions = (List)AdsActionStats.getGson().fromJson(value, type);
        return this;
    }

    public List<AdsActionStats> getFieldVideoP95WatchedActions() {
        return this.mVideoP95WatchedActions;
    }

    public AdsInsights setFieldVideoP95WatchedActions(List<AdsActionStats> value) {
        this.mVideoP95WatchedActions = value;
        return this;
    }

    public AdsInsights setFieldVideoP95WatchedActions(String value) {
        Type type = new TypeToken<List<AdsActionStats>>(){}.getType();
        this.mVideoP95WatchedActions = (List)AdsActionStats.getGson().fromJson(value, type);
        return this;
    }

    public List<AdsActionStats> getFieldWebsiteCtr() {
        return this.mWebsiteCtr;
    }

    public AdsInsights setFieldWebsiteCtr(List<AdsActionStats> value) {
        this.mWebsiteCtr = value;
        return this;
    }

    public AdsInsights setFieldWebsiteCtr(String value) {
        Type type = new TypeToken<List<AdsActionStats>>(){}.getType();
        this.mWebsiteCtr = (List)AdsActionStats.getGson().fromJson(value, type);
        return this;
    }

    public List<AdsActionStats> getFieldWebsitePurchaseRoas() {
        return this.mWebsitePurchaseRoas;
    }

    public AdsInsights setFieldWebsitePurchaseRoas(List<AdsActionStats> value) {
        this.mWebsitePurchaseRoas = value;
        return this;
    }

    public AdsInsights setFieldWebsitePurchaseRoas(String value) {
        Type type = new TypeToken<List<AdsActionStats>>(){}.getType();
        this.mWebsitePurchaseRoas = (List)AdsActionStats.getGson().fromJson(value, type);
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdsInsights copyFrom(AdsInsights instance) {
        this.mAccountCurrency = instance.mAccountCurrency;
        this.mAccountId = instance.mAccountId;
        this.mAccountName = instance.mAccountName;
        this.mActionValues = instance.mActionValues;
        this.mActions = instance.mActions;
        this.mAdId = instance.mAdId;
        this.mAdName = instance.mAdName;
        this.mAdsetId = instance.mAdsetId;
        this.mAdsetName = instance.mAdsetName;
        this.mBuyingType = instance.mBuyingType;
        this.mCampaignId = instance.mCampaignId;
        this.mCampaignName = instance.mCampaignName;
        this.mCanvasAvgViewPercent = instance.mCanvasAvgViewPercent;
        this.mCanvasAvgViewTime = instance.mCanvasAvgViewTime;
        this.mClicks = instance.mClicks;
        this.mCostPer10SecVideoView = instance.mCostPer10SecVideoView;
        this.mCostPerActionType = instance.mCostPerActionType;
        this.mCostPerEstimatedAdRecallers = instance.mCostPerEstimatedAdRecallers;
        this.mCostPerInlineLinkClick = instance.mCostPerInlineLinkClick;
        this.mCostPerInlinePostEngagement = instance.mCostPerInlinePostEngagement;
        this.mCostPerOutboundClick = instance.mCostPerOutboundClick;
        this.mCostPerUniqueActionType = instance.mCostPerUniqueActionType;
        this.mCostPerUniqueClick = instance.mCostPerUniqueClick;
        this.mCostPerUniqueInlineLinkClick = instance.mCostPerUniqueInlineLinkClick;
        this.mCostPerUniqueOutboundClick = instance.mCostPerUniqueOutboundClick;
        this.mCpc = instance.mCpc;
        this.mCpm = instance.mCpm;
        this.mCpp = instance.mCpp;
        this.mCtr = instance.mCtr;
        this.mDateStart = instance.mDateStart;
        this.mDateStop = instance.mDateStop;
        this.mEstimatedAdRecallRate = instance.mEstimatedAdRecallRate;
        this.mEstimatedAdRecallers = instance.mEstimatedAdRecallers;
        this.mFrequency = instance.mFrequency;
        this.mImpressions = instance.mImpressions;
        this.mInlineLinkClickCtr = instance.mInlineLinkClickCtr;
        this.mInlineLinkClicks = instance.mInlineLinkClicks;
        this.mInlinePostEngagement = instance.mInlinePostEngagement;
        this.mMobileAppPurchaseRoas = instance.mMobileAppPurchaseRoas;
        this.mObjective = instance.mObjective;
        this.mOutboundClicks = instance.mOutboundClicks;
        this.mOutboundClicksCtr = instance.mOutboundClicksCtr;
        this.mPlacePageName = instance.mPlacePageName;
        this.mReach = instance.mReach;
        this.mRelevanceScore = instance.mRelevanceScore;
        this.mSocialImpressions = instance.mSocialImpressions;
        this.mSocialSpend = instance.mSocialSpend;
        this.mSpend = instance.mSpend;
        this.mTotalActionValue = instance.mTotalActionValue;
        this.mUniqueActions = instance.mUniqueActions;
        this.mUniqueClicks = instance.mUniqueClicks;
        this.mUniqueCtr = instance.mUniqueCtr;
        this.mUniqueInlineLinkClickCtr = instance.mUniqueInlineLinkClickCtr;
        this.mUniqueInlineLinkClicks = instance.mUniqueInlineLinkClicks;
        this.mUniqueLinkClicksCtr = instance.mUniqueLinkClicksCtr;
        this.mUniqueOutboundClicks = instance.mUniqueOutboundClicks;
        this.mUniqueOutboundClicksCtr = instance.mUniqueOutboundClicksCtr;
        this.mVideo10SecWatchedActions = instance.mVideo10SecWatchedActions;
        this.mVideo30SecWatchedActions = instance.mVideo30SecWatchedActions;
        this.mVideoAvgPercentWatchedActions = instance.mVideoAvgPercentWatchedActions;
        this.mVideoAvgTimeWatchedActions = instance.mVideoAvgTimeWatchedActions;
        this.mVideoP100WatchedActions = instance.mVideoP100WatchedActions;
        this.mVideoP25WatchedActions = instance.mVideoP25WatchedActions;
        this.mVideoP50WatchedActions = instance.mVideoP50WatchedActions;
        this.mVideoP75WatchedActions = instance.mVideoP75WatchedActions;
        this.mVideoP95WatchedActions = instance.mVideoP95WatchedActions;
        this.mWebsiteCtr = instance.mWebsiteCtr;
        this.mWebsitePurchaseRoas = instance.mWebsitePurchaseRoas;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdsInsights> getParser() {
        return new APIRequest.ResponseParser<AdsInsights>(){

            @Override
            public APINodeList<AdsInsights> parseResponse(String response, APIContext context, APIRequest<AdsInsights> request) throws APIException.MalformedResponseException {
                return AdsInsights.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumSummary {
        VALUE_ID("id"),
        VALUE_ACCOUNT_ID("account_id"),
        VALUE_ASYNC_PERCENT_COMPLETION("async_percent_completion"),
        VALUE_ASYNC_STATUS("async_status"),
        VALUE_DATE_START("date_start"),
        VALUE_DATE_STOP("date_stop"),
        VALUE_EMAILS("emails"),
        VALUE_FRIENDLY_NAME("friendly_name"),
        VALUE_IS_BOOKMARKED("is_bookmarked"),
        VALUE_IS_RUNNING("is_running"),
        VALUE_SCHEDULE_ID("schedule_id"),
        VALUE_TIME_COMPLETED("time_completed"),
        VALUE_TIME_REF("time_ref"),
        NULL(null);

        private String value;

        private EnumSummary(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumSummaryActionBreakdowns {
        VALUE_ACTION_CANVAS_COMPONENT_NAME("action_canvas_component_name"),
        VALUE_ACTION_CAROUSEL_CARD_ID("action_carousel_card_id"),
        VALUE_ACTION_CAROUSEL_CARD_NAME("action_carousel_card_name"),
        VALUE_ACTION_DESTINATION("action_destination"),
        VALUE_ACTION_DEVICE("action_device"),
        VALUE_ACTION_LINK_CLICK_DESTINATION("action_link_click_destination"),
        VALUE_ACTION_REACTION("action_reaction"),
        VALUE_ACTION_TARGET_ID("action_target_id"),
        VALUE_ACTION_TYPE("action_type"),
        VALUE_ACTION_VIDEO_SOUND("action_video_sound"),
        VALUE_ACTION_VIDEO_TYPE("action_video_type"),
        NULL(null);

        private String value;

        private EnumSummaryActionBreakdowns(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumLevel {
        VALUE_AD("ad"),
        VALUE_ADSET("adset"),
        VALUE_CAMPAIGN("campaign"),
        VALUE_ACCOUNT("account"),
        NULL(null);

        private String value;

        private EnumLevel(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumDatePreset {
        VALUE_TODAY("today"),
        VALUE_YESTERDAY("yesterday"),
        VALUE_THIS_MONTH("this_month"),
        VALUE_LAST_MONTH("last_month"),
        VALUE_THIS_QUARTER("this_quarter"),
        VALUE_LIFETIME("lifetime"),
        VALUE_LAST_3D("last_3d"),
        VALUE_LAST_7D("last_7d"),
        VALUE_LAST_14D("last_14d"),
        VALUE_LAST_28D("last_28d"),
        VALUE_LAST_30D("last_30d"),
        VALUE_LAST_90D("last_90d"),
        VALUE_LAST_WEEK_MON_SUN("last_week_mon_sun"),
        VALUE_LAST_WEEK_SUN_SAT("last_week_sun_sat"),
        VALUE_LAST_QUARTER("last_quarter"),
        VALUE_LAST_YEAR("last_year"),
        VALUE_THIS_WEEK_MON_TODAY("this_week_mon_today"),
        VALUE_THIS_WEEK_SUN_TODAY("this_week_sun_today"),
        VALUE_THIS_YEAR("this_year"),
        NULL(null);

        private String value;

        private EnumDatePreset(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumBreakdowns {
        VALUE_AGE("age"),
        VALUE_COUNTRY("country"),
        VALUE_DMA("dma"),
        VALUE_GENDER("gender"),
        VALUE_FREQUENCY_VALUE("frequency_value"),
        VALUE_HOURLY_STATS_AGGREGATED_BY_ADVERTISER_TIME_ZONE("hourly_stats_aggregated_by_advertiser_time_zone"),
        VALUE_HOURLY_STATS_AGGREGATED_BY_AUDIENCE_TIME_ZONE("hourly_stats_aggregated_by_audience_time_zone"),
        VALUE_IMPRESSION_DEVICE("impression_device"),
        VALUE_PLACE_PAGE_ID("place_page_id"),
        VALUE_PUBLISHER_PLATFORM("publisher_platform"),
        VALUE_PLATFORM_POSITION("platform_position"),
        VALUE_DEVICE_PLATFORM("device_platform"),
        VALUE_PRODUCT_ID("product_id"),
        VALUE_REGION("region"),
        VALUE_AD_FORMAT_ASSET("ad_format_asset"),
        VALUE_BODY_ASSET("body_asset"),
        VALUE_CALL_TO_ACTION_ASSET("call_to_action_asset"),
        VALUE_DESCRIPTION_ASSET("description_asset"),
        VALUE_IMAGE_ASSET("image_asset"),
        VALUE_LINK_URL_ASSET("link_url_asset"),
        VALUE_TITLE_ASSET("title_asset"),
        VALUE_VIDEO_ASSET("video_asset"),
        NULL(null);

        private String value;

        private EnumBreakdowns(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumActionReportTime {
        VALUE_IMPRESSION("impression"),
        VALUE_CONVERSION("conversion"),
        NULL(null);

        private String value;

        private EnumActionReportTime(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumActionBreakdowns {
        VALUE_ACTION_CANVAS_COMPONENT_NAME("action_canvas_component_name"),
        VALUE_ACTION_CAROUSEL_CARD_ID("action_carousel_card_id"),
        VALUE_ACTION_CAROUSEL_CARD_NAME("action_carousel_card_name"),
        VALUE_ACTION_DESTINATION("action_destination"),
        VALUE_ACTION_DEVICE("action_device"),
        VALUE_ACTION_LINK_CLICK_DESTINATION("action_link_click_destination"),
        VALUE_ACTION_REACTION("action_reaction"),
        VALUE_ACTION_TARGET_ID("action_target_id"),
        VALUE_ACTION_TYPE("action_type"),
        VALUE_ACTION_VIDEO_SOUND("action_video_sound"),
        VALUE_ACTION_VIDEO_TYPE("action_video_type"),
        NULL(null);

        private String value;

        private EnumActionBreakdowns(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumActionAttributionWindows {
        VALUE_1D_VIEW("1d_view"),
        VALUE_7D_VIEW("7d_view"),
        VALUE_28D_VIEW("28d_view"),
        VALUE_1D_CLICK("1d_click"),
        VALUE_7D_CLICK("7d_click"),
        VALUE_28D_CLICK("28d_click"),
        VALUE_DEFAULT("default"),
        NULL(null);

        private String value;

        private EnumActionAttributionWindows(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

