/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetingGeoLocationMarket
extends APINode {
    @SerializedName(value="country")
    private String mCountry = null;
    @SerializedName(value="key")
    private String mKey = null;
    @SerializedName(value="market_type")
    private String mMarketType = null;
    @SerializedName(value="name")
    private String mName = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static TargetingGeoLocationMarket loadJSON(String json, APIContext context) {
        TargetingGeoLocationMarket targetingGeoLocationMarket = (TargetingGeoLocationMarket)TargetingGeoLocationMarket.getGson().fromJson(json, TargetingGeoLocationMarket.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(targetingGeoLocationMarket.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        targetingGeoLocationMarket.context = context;
        targetingGeoLocationMarket.rawValue = json;
        return targetingGeoLocationMarket;
    }

    public static APINodeList<TargetingGeoLocationMarket> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block19: {
            APINodeList<TargetingGeoLocationMarket> targetingGeoLocationMarkets = new APINodeList<TargetingGeoLocationMarket>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        targetingGeoLocationMarkets.add(TargetingGeoLocationMarket.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return targetingGeoLocationMarkets;
                }
                if (!result.isJsonObject()) break block19;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            targetingGeoLocationMarkets.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        targetingGeoLocationMarkets.setPaging((String)previous, next);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            targetingGeoLocationMarkets.add(TargetingGeoLocationMarket.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                targetingGeoLocationMarkets.add(TargetingGeoLocationMarket.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            targetingGeoLocationMarkets.add(TargetingGeoLocationMarket.loadJSON(obj.toString(), context));
                        }
                    }
                    return targetingGeoLocationMarkets;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        targetingGeoLocationMarkets.add(TargetingGeoLocationMarket.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return targetingGeoLocationMarkets;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        targetingGeoLocationMarkets.add(TargetingGeoLocationMarket.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return targetingGeoLocationMarkets;
                }
                targetingGeoLocationMarkets.clear();
                targetingGeoLocationMarkets.add(TargetingGeoLocationMarket.loadJSON(json, context));
                return targetingGeoLocationMarkets;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return TargetingGeoLocationMarket.getGson().toJson((Object)this);
    }

    public String getFieldCountry() {
        return this.mCountry;
    }

    public TargetingGeoLocationMarket setFieldCountry(String value) {
        this.mCountry = value;
        return this;
    }

    public String getFieldKey() {
        return this.mKey;
    }

    public TargetingGeoLocationMarket setFieldKey(String value) {
        this.mKey = value;
        return this;
    }

    public String getFieldMarketType() {
        return this.mMarketType;
    }

    public TargetingGeoLocationMarket setFieldMarketType(String value) {
        this.mMarketType = value;
        return this;
    }

    public String getFieldName() {
        return this.mName;
    }

    public TargetingGeoLocationMarket setFieldName(String value) {
        this.mName = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public TargetingGeoLocationMarket copyFrom(TargetingGeoLocationMarket instance) {
        this.mCountry = instance.mCountry;
        this.mKey = instance.mKey;
        this.mMarketType = instance.mMarketType;
        this.mName = instance.mName;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<TargetingGeoLocationMarket> getParser() {
        return new APIRequest.ResponseParser<TargetingGeoLocationMarket>(){

            @Override
            public APINodeList<TargetingGeoLocationMarket> parseResponse(String response, APIContext context, APIRequest<TargetingGeoLocationMarket> request) throws APIException.MalformedResponseException {
                return TargetingGeoLocationMarket.parseResponse(response, context, request);
            }
        };
    }
}

