/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageCategory
extends APINode {
    @SerializedName(value="api_enum")
    private String mApiEnum = null;
    @SerializedName(value="fb_page_categories")
    private List<PageCategory> mFbPageCategories = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="name")
    private String mName = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static PageCategory loadJSON(String json, APIContext context) {
        PageCategory pageCategory = (PageCategory)PageCategory.getGson().fromJson(json, PageCategory.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(pageCategory.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        pageCategory.context = context;
        pageCategory.rawValue = json;
        return pageCategory;
    }

    public static APINodeList<PageCategory> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block19: {
            APINodeList<PageCategory> pageCategorys = new APINodeList<PageCategory>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        pageCategorys.add(PageCategory.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return pageCategorys;
                }
                if (!result.isJsonObject()) break block19;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            pageCategorys.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        pageCategorys.setPaging((String)previous, next);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            pageCategorys.add(PageCategory.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                pageCategorys.add(PageCategory.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            pageCategorys.add(PageCategory.loadJSON(obj.toString(), context));
                        }
                    }
                    return pageCategorys;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        pageCategorys.add(PageCategory.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return pageCategorys;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        pageCategorys.add(PageCategory.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return pageCategorys;
                }
                pageCategorys.clear();
                pageCategorys.add(PageCategory.loadJSON(json, context));
                return pageCategorys;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PageCategory.getGson().toJson((Object)this);
    }

    public String getFieldApiEnum() {
        return this.mApiEnum;
    }

    public PageCategory setFieldApiEnum(String value) {
        this.mApiEnum = value;
        return this;
    }

    public List<PageCategory> getFieldFbPageCategories() {
        return this.mFbPageCategories;
    }

    public PageCategory setFieldFbPageCategories(List<PageCategory> value) {
        this.mFbPageCategories = value;
        return this;
    }

    public PageCategory setFieldFbPageCategories(String value) {
        Type type = new TypeToken<List<PageCategory>>(){}.getType();
        this.mFbPageCategories = (List)PageCategory.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public PageCategory setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public String getFieldName() {
        return this.mName;
    }

    public PageCategory setFieldName(String value) {
        this.mName = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PageCategory copyFrom(PageCategory instance) {
        this.mApiEnum = instance.mApiEnum;
        this.mFbPageCategories = instance.mFbPageCategories;
        this.mId = instance.mId;
        this.mName = instance.mName;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PageCategory> getParser() {
        return new APIRequest.ResponseParser<PageCategory>(){

            @Override
            public APINodeList<PageCategory> parseResponse(String response, APIContext context, APIRequest<PageCategory> request) throws APIException.MalformedResponseException {
                return PageCategory.parseResponse(response, context, request);
            }
        };
    }
}

