/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstantArticleInsightsQueryResult
extends APINode {
    @SerializedName(value="breakdowns")
    private Map<String, String> mBreakdowns = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="time")
    private String mTime = null;
    @SerializedName(value="value")
    private String mValue = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static InstantArticleInsightsQueryResult loadJSON(String json, APIContext context) {
        InstantArticleInsightsQueryResult instantArticleInsightsQueryResult = (InstantArticleInsightsQueryResult)InstantArticleInsightsQueryResult.getGson().fromJson(json, InstantArticleInsightsQueryResult.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(instantArticleInsightsQueryResult.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        instantArticleInsightsQueryResult.context = context;
        instantArticleInsightsQueryResult.rawValue = json;
        return instantArticleInsightsQueryResult;
    }

    public static APINodeList<InstantArticleInsightsQueryResult> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block19: {
            APINodeList<InstantArticleInsightsQueryResult> instantArticleInsightsQueryResults = new APINodeList<InstantArticleInsightsQueryResult>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        instantArticleInsightsQueryResults.add(InstantArticleInsightsQueryResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return instantArticleInsightsQueryResults;
                }
                if (!result.isJsonObject()) break block19;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            instantArticleInsightsQueryResults.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        instantArticleInsightsQueryResults.setPaging((String)previous, next);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            instantArticleInsightsQueryResults.add(InstantArticleInsightsQueryResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                instantArticleInsightsQueryResults.add(InstantArticleInsightsQueryResult.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            instantArticleInsightsQueryResults.add(InstantArticleInsightsQueryResult.loadJSON(obj.toString(), context));
                        }
                    }
                    return instantArticleInsightsQueryResults;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        instantArticleInsightsQueryResults.add(InstantArticleInsightsQueryResult.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return instantArticleInsightsQueryResults;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        instantArticleInsightsQueryResults.add(InstantArticleInsightsQueryResult.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return instantArticleInsightsQueryResults;
                }
                instantArticleInsightsQueryResults.clear();
                instantArticleInsightsQueryResults.add(InstantArticleInsightsQueryResult.loadJSON(json, context));
                return instantArticleInsightsQueryResults;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return InstantArticleInsightsQueryResult.getGson().toJson((Object)this);
    }

    public Map<String, String> getFieldBreakdowns() {
        return this.mBreakdowns;
    }

    public InstantArticleInsightsQueryResult setFieldBreakdowns(Map<String, String> value) {
        this.mBreakdowns = value;
        return this;
    }

    public String getFieldName() {
        return this.mName;
    }

    public InstantArticleInsightsQueryResult setFieldName(String value) {
        this.mName = value;
        return this;
    }

    public String getFieldTime() {
        return this.mTime;
    }

    public InstantArticleInsightsQueryResult setFieldTime(String value) {
        this.mTime = value;
        return this;
    }

    public String getFieldValue() {
        return this.mValue;
    }

    public InstantArticleInsightsQueryResult setFieldValue(String value) {
        this.mValue = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public InstantArticleInsightsQueryResult copyFrom(InstantArticleInsightsQueryResult instance) {
        this.mBreakdowns = instance.mBreakdowns;
        this.mName = instance.mName;
        this.mTime = instance.mTime;
        this.mValue = instance.mValue;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<InstantArticleInsightsQueryResult> getParser() {
        return new APIRequest.ResponseParser<InstantArticleInsightsQueryResult>(){

            @Override
            public APINodeList<InstantArticleInsightsQueryResult> parseResponse(String response, APIContext context, APIRequest<InstantArticleInsightsQueryResult> request) throws APIException.MalformedResponseException {
                return InstantArticleInsightsQueryResult.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumPeriod {
        VALUE_DAY("day"),
        VALUE_WEEK("week"),
        VALUE_DAYS_28("days_28"),
        VALUE_MONTH("month"),
        VALUE_LIFETIME("lifetime"),
        VALUE_TOTAL_OVER_RANGE("total_over_range"),
        NULL(null);

        private String value;

        private EnumPeriod(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumBreakdown {
        VALUE_NO_BREAKDOWN("no_breakdown"),
        VALUE_PLATFORM("platform"),
        VALUE_AGE("age"),
        VALUE_REGION("region"),
        VALUE_COUNTRY("country"),
        VALUE_IS_SHARED_BY_IA_OWNER("is_shared_by_ia_owner"),
        VALUE_GENDER("gender"),
        VALUE_GENDER_AND_AGE("gender_and_age"),
        VALUE_IS_ORGANIC("is_organic"),
        NULL(null);

        private String value;

        private EnumBreakdown(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

