/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.InstagramInsightsValue;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstagramInsightsResult
extends APINode {
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="period")
    private String mPeriod = null;
    @SerializedName(value="title")
    private String mTitle = null;
    @SerializedName(value="values")
    private List<InstagramInsightsValue> mValues = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static InstagramInsightsResult loadJSON(String json, APIContext context) {
        InstagramInsightsResult instagramInsightsResult = (InstagramInsightsResult)InstagramInsightsResult.getGson().fromJson(json, InstagramInsightsResult.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(instagramInsightsResult.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        instagramInsightsResult.context = context;
        instagramInsightsResult.rawValue = json;
        return instagramInsightsResult;
    }

    public static APINodeList<InstagramInsightsResult> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block19: {
            APINodeList<InstagramInsightsResult> instagramInsightsResults = new APINodeList<InstagramInsightsResult>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        instagramInsightsResults.add(InstagramInsightsResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return instagramInsightsResults;
                }
                if (!result.isJsonObject()) break block19;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            instagramInsightsResults.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        instagramInsightsResults.setPaging((String)previous, next);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            instagramInsightsResults.add(InstagramInsightsResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                instagramInsightsResults.add(InstagramInsightsResult.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            instagramInsightsResults.add(InstagramInsightsResult.loadJSON(obj.toString(), context));
                        }
                    }
                    return instagramInsightsResults;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        instagramInsightsResults.add(InstagramInsightsResult.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return instagramInsightsResults;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        instagramInsightsResults.add(InstagramInsightsResult.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return instagramInsightsResults;
                }
                instagramInsightsResults.clear();
                instagramInsightsResults.add(InstagramInsightsResult.loadJSON(json, context));
                return instagramInsightsResults;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return InstagramInsightsResult.getGson().toJson((Object)this);
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public InstagramInsightsResult setFieldDescription(String value) {
        this.mDescription = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public InstagramInsightsResult setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public String getFieldName() {
        return this.mName;
    }

    public InstagramInsightsResult setFieldName(String value) {
        this.mName = value;
        return this;
    }

    public String getFieldPeriod() {
        return this.mPeriod;
    }

    public InstagramInsightsResult setFieldPeriod(String value) {
        this.mPeriod = value;
        return this;
    }

    public String getFieldTitle() {
        return this.mTitle;
    }

    public InstagramInsightsResult setFieldTitle(String value) {
        this.mTitle = value;
        return this;
    }

    public List<InstagramInsightsValue> getFieldValues() {
        return this.mValues;
    }

    public InstagramInsightsResult setFieldValues(List<InstagramInsightsValue> value) {
        this.mValues = value;
        return this;
    }

    public InstagramInsightsResult setFieldValues(String value) {
        Type type = new TypeToken<List<InstagramInsightsValue>>(){}.getType();
        this.mValues = (List)InstagramInsightsValue.getGson().fromJson(value, type);
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public InstagramInsightsResult copyFrom(InstagramInsightsResult instance) {
        this.mDescription = instance.mDescription;
        this.mId = instance.mId;
        this.mName = instance.mName;
        this.mPeriod = instance.mPeriod;
        this.mTitle = instance.mTitle;
        this.mValues = instance.mValues;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<InstagramInsightsResult> getParser() {
        return new APIRequest.ResponseParser<InstagramInsightsResult>(){

            @Override
            public APINodeList<InstagramInsightsResult> parseResponse(String response, APIContext context, APIRequest<InstagramInsightsResult> request) throws APIException.MalformedResponseException {
                return InstagramInsightsResult.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumPeriod {
        VALUE_DAY("day"),
        VALUE_WEEK("week"),
        VALUE_DAYS_28("days_28"),
        VALUE_MONTH("month"),
        VALUE_LIFETIME("lifetime"),
        VALUE_TOTAL_OVER_RANGE("total_over_range"),
        NULL(null);

        private String value;

        private EnumPeriod(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumMetric {
        VALUE_IMPRESSIONS("impressions"),
        VALUE_REACH("reach"),
        VALUE_CAROUSEL_ALBUM_IMPRESSIONS("carousel_album_impressions"),
        VALUE_CAROUSEL_ALBUM_REACH("carousel_album_reach"),
        VALUE_CAROUSEL_ALBUM_ENGAGEMENT("carousel_album_engagement"),
        VALUE_CAROUSEL_ALBUM_SAVED("carousel_album_saved"),
        VALUE_CAROUSEL_ALBUM_VIDEO_VIEWS("carousel_album_video_views"),
        VALUE_TAPS_FORWARD("taps_forward"),
        VALUE_TAPS_BACK("taps_back"),
        VALUE_EXITS("exits"),
        VALUE_REPLIES("replies"),
        VALUE_ENGAGEMENT("engagement"),
        VALUE_SAVED("saved"),
        VALUE_VIDEO_VIEWS("video_views"),
        NULL(null);

        private String value;

        private EnumMetric(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

