/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Engagement
extends APINode {
    @SerializedName(value="count")
    private Long mCount = null;
    @SerializedName(value="count_string")
    private String mCountString = null;
    @SerializedName(value="count_string_with_like")
    private String mCountStringWithLike = null;
    @SerializedName(value="count_string_without_like")
    private String mCountStringWithoutLike = null;
    @SerializedName(value="social_sentence")
    private String mSocialSentence = null;
    @SerializedName(value="social_sentence_with_like")
    private String mSocialSentenceWithLike = null;
    @SerializedName(value="social_sentence_without_like")
    private String mSocialSentenceWithoutLike = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static Engagement loadJSON(String json, APIContext context) {
        Engagement engagement = (Engagement)Engagement.getGson().fromJson(json, Engagement.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(engagement.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        engagement.context = context;
        engagement.rawValue = json;
        return engagement;
    }

    public static APINodeList<Engagement> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block19: {
            APINodeList<Engagement> engagements = new APINodeList<Engagement>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        engagements.add(Engagement.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return engagements;
                }
                if (!result.isJsonObject()) break block19;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            engagements.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        engagements.setPaging((String)previous, next);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            engagements.add(Engagement.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                engagements.add(Engagement.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            engagements.add(Engagement.loadJSON(obj.toString(), context));
                        }
                    }
                    return engagements;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        engagements.add(Engagement.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return engagements;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        engagements.add(Engagement.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return engagements;
                }
                engagements.clear();
                engagements.add(Engagement.loadJSON(json, context));
                return engagements;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return Engagement.getGson().toJson((Object)this);
    }

    public Long getFieldCount() {
        return this.mCount;
    }

    public Engagement setFieldCount(Long value) {
        this.mCount = value;
        return this;
    }

    public String getFieldCountString() {
        return this.mCountString;
    }

    public Engagement setFieldCountString(String value) {
        this.mCountString = value;
        return this;
    }

    public String getFieldCountStringWithLike() {
        return this.mCountStringWithLike;
    }

    public Engagement setFieldCountStringWithLike(String value) {
        this.mCountStringWithLike = value;
        return this;
    }

    public String getFieldCountStringWithoutLike() {
        return this.mCountStringWithoutLike;
    }

    public Engagement setFieldCountStringWithoutLike(String value) {
        this.mCountStringWithoutLike = value;
        return this;
    }

    public String getFieldSocialSentence() {
        return this.mSocialSentence;
    }

    public Engagement setFieldSocialSentence(String value) {
        this.mSocialSentence = value;
        return this;
    }

    public String getFieldSocialSentenceWithLike() {
        return this.mSocialSentenceWithLike;
    }

    public Engagement setFieldSocialSentenceWithLike(String value) {
        this.mSocialSentenceWithLike = value;
        return this;
    }

    public String getFieldSocialSentenceWithoutLike() {
        return this.mSocialSentenceWithoutLike;
    }

    public Engagement setFieldSocialSentenceWithoutLike(String value) {
        this.mSocialSentenceWithoutLike = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public Engagement copyFrom(Engagement instance) {
        this.mCount = instance.mCount;
        this.mCountString = instance.mCountString;
        this.mCountStringWithLike = instance.mCountStringWithLike;
        this.mCountStringWithoutLike = instance.mCountStringWithoutLike;
        this.mSocialSentence = instance.mSocialSentence;
        this.mSocialSentenceWithLike = instance.mSocialSentenceWithLike;
        this.mSocialSentenceWithoutLike = instance.mSocialSentenceWithoutLike;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<Engagement> getParser() {
        return new APIRequest.ResponseParser<Engagement>(){

            @Override
            public APINodeList<Engagement> parseResponse(String response, APIContext context, APIRequest<Engagement> request) throws APIException.MalformedResponseException {
                return Engagement.parseResponse(response, context, request);
            }
        };
    }
}

