/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectDebit
extends APINode {
    @SerializedName(value="bank_account_last_4")
    private String mBankAccountLast4 = null;
    @SerializedName(value="bank_code_last_4")
    private String mBankCodeLast4 = null;
    @SerializedName(value="bank_name")
    private String mBankName = null;
    @SerializedName(value="default_receiving_method_products")
    private List<String> mDefaultReceivingMethodProducts = null;
    @SerializedName(value="display_string")
    private String mDisplayString = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="last_four_digits")
    private String mLastFourDigits = null;
    @SerializedName(value="onboarding_url")
    private String mOnboardingUrl = null;
    @SerializedName(value="owner_name")
    private String mOwnerName = null;
    @SerializedName(value="status")
    private Long mStatus = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static DirectDebit loadJSON(String json, APIContext context) {
        DirectDebit directDebit = (DirectDebit)DirectDebit.getGson().fromJson(json, DirectDebit.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(directDebit.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        directDebit.context = context;
        directDebit.rawValue = json;
        return directDebit;
    }

    public static APINodeList<DirectDebit> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block19: {
            APINodeList<DirectDebit> directDebits = new APINodeList<DirectDebit>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        directDebits.add(DirectDebit.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return directDebits;
                }
                if (!result.isJsonObject()) break block19;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            directDebits.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        directDebits.setPaging((String)previous, next);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            directDebits.add(DirectDebit.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                directDebits.add(DirectDebit.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            directDebits.add(DirectDebit.loadJSON(obj.toString(), context));
                        }
                    }
                    return directDebits;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        directDebits.add(DirectDebit.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return directDebits;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        directDebits.add(DirectDebit.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return directDebits;
                }
                directDebits.clear();
                directDebits.add(DirectDebit.loadJSON(json, context));
                return directDebits;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return DirectDebit.getGson().toJson((Object)this);
    }

    public String getFieldBankAccountLast4() {
        return this.mBankAccountLast4;
    }

    public DirectDebit setFieldBankAccountLast4(String value) {
        this.mBankAccountLast4 = value;
        return this;
    }

    public String getFieldBankCodeLast4() {
        return this.mBankCodeLast4;
    }

    public DirectDebit setFieldBankCodeLast4(String value) {
        this.mBankCodeLast4 = value;
        return this;
    }

    public String getFieldBankName() {
        return this.mBankName;
    }

    public DirectDebit setFieldBankName(String value) {
        this.mBankName = value;
        return this;
    }

    public List<String> getFieldDefaultReceivingMethodProducts() {
        return this.mDefaultReceivingMethodProducts;
    }

    public DirectDebit setFieldDefaultReceivingMethodProducts(List<String> value) {
        this.mDefaultReceivingMethodProducts = value;
        return this;
    }

    public String getFieldDisplayString() {
        return this.mDisplayString;
    }

    public DirectDebit setFieldDisplayString(String value) {
        this.mDisplayString = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public DirectDebit setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public String getFieldLastFourDigits() {
        return this.mLastFourDigits;
    }

    public DirectDebit setFieldLastFourDigits(String value) {
        this.mLastFourDigits = value;
        return this;
    }

    public String getFieldOnboardingUrl() {
        return this.mOnboardingUrl;
    }

    public DirectDebit setFieldOnboardingUrl(String value) {
        this.mOnboardingUrl = value;
        return this;
    }

    public String getFieldOwnerName() {
        return this.mOwnerName;
    }

    public DirectDebit setFieldOwnerName(String value) {
        this.mOwnerName = value;
        return this;
    }

    public Long getFieldStatus() {
        return this.mStatus;
    }

    public DirectDebit setFieldStatus(Long value) {
        this.mStatus = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public DirectDebit copyFrom(DirectDebit instance) {
        this.mBankAccountLast4 = instance.mBankAccountLast4;
        this.mBankCodeLast4 = instance.mBankCodeLast4;
        this.mBankName = instance.mBankName;
        this.mDefaultReceivingMethodProducts = instance.mDefaultReceivingMethodProducts;
        this.mDisplayString = instance.mDisplayString;
        this.mId = instance.mId;
        this.mLastFourDigits = instance.mLastFourDigits;
        this.mOnboardingUrl = instance.mOnboardingUrl;
        this.mOwnerName = instance.mOwnerName;
        this.mStatus = instance.mStatus;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<DirectDebit> getParser() {
        return new APIRequest.ResponseParser<DirectDebit>(){

            @Override
            public APINodeList<DirectDebit> parseResponse(String response, APIContext context, APIRequest<DirectDebit> request) throws APIException.MalformedResponseException {
                return DirectDebit.parseResponse(response, context, request);
            }
        };
    }
}

