/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomAudienceStatus
extends APINode {
    @SerializedName(value="code")
    private Long mCode = null;
    @SerializedName(value="description")
    private String mDescription = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static CustomAudienceStatus loadJSON(String json, APIContext context) {
        CustomAudienceStatus customAudienceStatus = (CustomAudienceStatus)CustomAudienceStatus.getGson().fromJson(json, CustomAudienceStatus.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(customAudienceStatus.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        customAudienceStatus.context = context;
        customAudienceStatus.rawValue = json;
        return customAudienceStatus;
    }

    public static APINodeList<CustomAudienceStatus> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block19: {
            APINodeList<CustomAudienceStatus> customAudienceStatuss = new APINodeList<CustomAudienceStatus>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        customAudienceStatuss.add(CustomAudienceStatus.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return customAudienceStatuss;
                }
                if (!result.isJsonObject()) break block19;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            customAudienceStatuss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        customAudienceStatuss.setPaging((String)previous, next);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            customAudienceStatuss.add(CustomAudienceStatus.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                customAudienceStatuss.add(CustomAudienceStatus.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            customAudienceStatuss.add(CustomAudienceStatus.loadJSON(obj.toString(), context));
                        }
                    }
                    return customAudienceStatuss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        customAudienceStatuss.add(CustomAudienceStatus.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return customAudienceStatuss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        customAudienceStatuss.add(CustomAudienceStatus.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return customAudienceStatuss;
                }
                customAudienceStatuss.clear();
                customAudienceStatuss.add(CustomAudienceStatus.loadJSON(json, context));
                return customAudienceStatuss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CustomAudienceStatus.getGson().toJson((Object)this);
    }

    public Long getFieldCode() {
        return this.mCode;
    }

    public CustomAudienceStatus setFieldCode(Long value) {
        this.mCode = value;
        return this;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public CustomAudienceStatus setFieldDescription(String value) {
        this.mDescription = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CustomAudienceStatus copyFrom(CustomAudienceStatus instance) {
        this.mCode = instance.mCode;
        this.mDescription = instance.mDescription;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CustomAudienceStatus> getParser() {
        return new APIRequest.ResponseParser<CustomAudienceStatus>(){

            @Override
            public APINodeList<CustomAudienceStatus> parseResponse(String response, APIContext context, APIRequest<CustomAudienceStatus> request) throws APIException.MalformedResponseException {
                return CustomAudienceStatus.parseResponse(response, context, request);
            }
        };
    }
}

