/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.User;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class MediaCopyrightUpdateRecord
extends APINode {
    @SerializedName(value="action_types")
    private List<String> mActionTypes = null;
    @SerializedName(value="actor")
    private User mActor = null;
    @SerializedName(value="actor_type")
    private String mActorType = null;
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="ownership_countries")
    private List<Object> mOwnershipCountries = null;
    @SerializedName(value="whitelisted_accounts")
    private List<Object> mWhitelistedAccounts = null;
    protected static Gson gson = null;

    MediaCopyrightUpdateRecord() {
    }

    public MediaCopyrightUpdateRecord(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public MediaCopyrightUpdateRecord(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public MediaCopyrightUpdateRecord fetch() throws APIException {
        MediaCopyrightUpdateRecord newInstance = MediaCopyrightUpdateRecord.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static MediaCopyrightUpdateRecord fetchById(Long id, APIContext context) throws APIException {
        return MediaCopyrightUpdateRecord.fetchById(id.toString(), context);
    }

    public static ListenableFuture<MediaCopyrightUpdateRecord> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return MediaCopyrightUpdateRecord.fetchByIdAsync(id.toString(), context);
    }

    public static MediaCopyrightUpdateRecord fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<MediaCopyrightUpdateRecord> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<MediaCopyrightUpdateRecord> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<MediaCopyrightUpdateRecord>(context, "", "/", "GET", MediaCopyrightUpdateRecord.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<MediaCopyrightUpdateRecord>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<MediaCopyrightUpdateRecord>(context, "", "/", "GET", MediaCopyrightUpdateRecord.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static MediaCopyrightUpdateRecord loadJSON(String json, APIContext context, String header) {
        MediaCopyrightUpdateRecord mediaCopyrightUpdateRecord = (MediaCopyrightUpdateRecord)MediaCopyrightUpdateRecord.getGson().fromJson(json, MediaCopyrightUpdateRecord.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(mediaCopyrightUpdateRecord.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        mediaCopyrightUpdateRecord.context = context;
        mediaCopyrightUpdateRecord.rawValue = json;
        mediaCopyrightUpdateRecord.header = header;
        return mediaCopyrightUpdateRecord;
    }

    public static APINodeList<MediaCopyrightUpdateRecord> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<MediaCopyrightUpdateRecord> mediaCopyrightUpdateRecords = new APINodeList<MediaCopyrightUpdateRecord>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        mediaCopyrightUpdateRecords.add(MediaCopyrightUpdateRecord.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return mediaCopyrightUpdateRecords;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            mediaCopyrightUpdateRecords.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        mediaCopyrightUpdateRecords.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            mediaCopyrightUpdateRecords.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            mediaCopyrightUpdateRecords.add(MediaCopyrightUpdateRecord.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                mediaCopyrightUpdateRecords.add(MediaCopyrightUpdateRecord.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            mediaCopyrightUpdateRecords.add(MediaCopyrightUpdateRecord.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return mediaCopyrightUpdateRecords;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        mediaCopyrightUpdateRecords.add(MediaCopyrightUpdateRecord.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return mediaCopyrightUpdateRecords;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        mediaCopyrightUpdateRecords.add(MediaCopyrightUpdateRecord.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return mediaCopyrightUpdateRecords;
                }
                mediaCopyrightUpdateRecords.clear();
                mediaCopyrightUpdateRecords.add(MediaCopyrightUpdateRecord.loadJSON(json, context, header));
                return mediaCopyrightUpdateRecords;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return MediaCopyrightUpdateRecord.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public List<String> getFieldActionTypes() {
        return this.mActionTypes;
    }

    public User getFieldActor() {
        if (this.mActor != null) {
            this.mActor.context = this.getContext();
        }
        return this.mActor;
    }

    public String getFieldActorType() {
        return this.mActorType;
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public String getFieldId() {
        return this.mId;
    }

    public List<Object> getFieldOwnershipCountries() {
        return this.mOwnershipCountries;
    }

    public List<Object> getFieldWhitelistedAccounts() {
        return this.mWhitelistedAccounts;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public MediaCopyrightUpdateRecord copyFrom(MediaCopyrightUpdateRecord instance) {
        this.mActionTypes = instance.mActionTypes;
        this.mActor = instance.mActor;
        this.mActorType = instance.mActorType;
        this.mCreationTime = instance.mCreationTime;
        this.mId = instance.mId;
        this.mOwnershipCountries = instance.mOwnershipCountries;
        this.mWhitelistedAccounts = instance.mWhitelistedAccounts;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<MediaCopyrightUpdateRecord> getParser() {
        return new APIRequest.ResponseParser<MediaCopyrightUpdateRecord>(){

            @Override
            public APINodeList<MediaCopyrightUpdateRecord> parseResponse(String response, APIContext context, APIRequest<MediaCopyrightUpdateRecord> request, String header) throws APIException.MalformedResponseException {
                return MediaCopyrightUpdateRecord.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<MediaCopyrightUpdateRecord> {
        MediaCopyrightUpdateRecord lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"action_types", "actor", "actor_type", "creation_time", "id", "ownership_countries", "whitelisted_accounts"};

        @Override
        public MediaCopyrightUpdateRecord getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public MediaCopyrightUpdateRecord parseResponse(String response, String header) throws APIException {
            return MediaCopyrightUpdateRecord.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public MediaCopyrightUpdateRecord execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public MediaCopyrightUpdateRecord execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<MediaCopyrightUpdateRecord> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<MediaCopyrightUpdateRecord> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, MediaCopyrightUpdateRecord>(){

                public MediaCopyrightUpdateRecord apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestActionTypesField() {
            return this.requestActionTypesField(true);
        }

        public APIRequestGet requestActionTypesField(boolean value) {
            this.requestField("action_types", value);
            return this;
        }

        public APIRequestGet requestActorField() {
            return this.requestActorField(true);
        }

        public APIRequestGet requestActorField(boolean value) {
            this.requestField("actor", value);
            return this;
        }

        public APIRequestGet requestActorTypeField() {
            return this.requestActorTypeField(true);
        }

        public APIRequestGet requestActorTypeField(boolean value) {
            this.requestField("actor_type", value);
            return this;
        }

        public APIRequestGet requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGet requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestOwnershipCountriesField() {
            return this.requestOwnershipCountriesField(true);
        }

        public APIRequestGet requestOwnershipCountriesField(boolean value) {
            this.requestField("ownership_countries", value);
            return this;
        }

        public APIRequestGet requestWhitelistedAccountsField() {
            return this.requestWhitelistedAccountsField(true);
        }

        public APIRequestGet requestWhitelistedAccountsField(boolean value) {
            this.requestField("whitelisted_accounts", value);
            return this;
        }
    }
}

