/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class CPASAdCreationTemplate
extends APINode {
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_unused_template")
    private Boolean mIsUnusedTemplate = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="optimization_goal")
    private String mOptimizationGoal = null;
    @SerializedName(value="targeting_type")
    private String mTargetingType = null;
    @SerializedName(value="template_type")
    private String mTemplateType = null;
    protected static Gson gson = null;

    CPASAdCreationTemplate() {
    }

    public CPASAdCreationTemplate(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public CPASAdCreationTemplate(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public CPASAdCreationTemplate fetch() throws APIException {
        CPASAdCreationTemplate newInstance = CPASAdCreationTemplate.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static CPASAdCreationTemplate fetchById(Long id, APIContext context) throws APIException {
        return CPASAdCreationTemplate.fetchById(id.toString(), context);
    }

    public static ListenableFuture<CPASAdCreationTemplate> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return CPASAdCreationTemplate.fetchByIdAsync(id.toString(), context);
    }

    public static CPASAdCreationTemplate fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<CPASAdCreationTemplate> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<CPASAdCreationTemplate> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<CPASAdCreationTemplate>(context, "", "/", "GET", CPASAdCreationTemplate.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<CPASAdCreationTemplate>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<CPASAdCreationTemplate>(context, "", "/", "GET", CPASAdCreationTemplate.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static CPASAdCreationTemplate loadJSON(String json, APIContext context, String header) {
        CPASAdCreationTemplate cpasAdCreationTemplate = (CPASAdCreationTemplate)CPASAdCreationTemplate.getGson().fromJson(json, CPASAdCreationTemplate.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(cpasAdCreationTemplate.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        cpasAdCreationTemplate.context = context;
        cpasAdCreationTemplate.rawValue = json;
        cpasAdCreationTemplate.header = header;
        return cpasAdCreationTemplate;
    }

    public static APINodeList<CPASAdCreationTemplate> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<CPASAdCreationTemplate> cpasAdCreationTemplates = new APINodeList<CPASAdCreationTemplate>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        cpasAdCreationTemplates.add(CPASAdCreationTemplate.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return cpasAdCreationTemplates;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            cpasAdCreationTemplates.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        cpasAdCreationTemplates.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            cpasAdCreationTemplates.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            cpasAdCreationTemplates.add(CPASAdCreationTemplate.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                cpasAdCreationTemplates.add(CPASAdCreationTemplate.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            cpasAdCreationTemplates.add(CPASAdCreationTemplate.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return cpasAdCreationTemplates;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        cpasAdCreationTemplates.add(CPASAdCreationTemplate.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return cpasAdCreationTemplates;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        cpasAdCreationTemplates.add(CPASAdCreationTemplate.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return cpasAdCreationTemplates;
                }
                cpasAdCreationTemplates.clear();
                cpasAdCreationTemplates.add(CPASAdCreationTemplate.loadJSON(json, context, header));
                return cpasAdCreationTemplates;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CPASAdCreationTemplate.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsUnusedTemplate() {
        return this.mIsUnusedTemplate;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldOptimizationGoal() {
        return this.mOptimizationGoal;
    }

    public String getFieldTargetingType() {
        return this.mTargetingType;
    }

    public String getFieldTemplateType() {
        return this.mTemplateType;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CPASAdCreationTemplate copyFrom(CPASAdCreationTemplate instance) {
        this.mDescription = instance.mDescription;
        this.mId = instance.mId;
        this.mIsUnusedTemplate = instance.mIsUnusedTemplate;
        this.mName = instance.mName;
        this.mOptimizationGoal = instance.mOptimizationGoal;
        this.mTargetingType = instance.mTargetingType;
        this.mTemplateType = instance.mTemplateType;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CPASAdCreationTemplate> getParser() {
        return new APIRequest.ResponseParser<CPASAdCreationTemplate>(){

            @Override
            public APINodeList<CPASAdCreationTemplate> parseResponse(String response, APIContext context, APIRequest<CPASAdCreationTemplate> request, String header) throws APIException.MalformedResponseException {
                return CPASAdCreationTemplate.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<CPASAdCreationTemplate> {
        CPASAdCreationTemplate lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"description", "id", "is_unused_template", "name", "optimization_goal", "targeting_type", "template_type"};

        @Override
        public CPASAdCreationTemplate getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CPASAdCreationTemplate parseResponse(String response, String header) throws APIException {
            return CPASAdCreationTemplate.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public CPASAdCreationTemplate execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CPASAdCreationTemplate execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<CPASAdCreationTemplate> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CPASAdCreationTemplate> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, CPASAdCreationTemplate>(){

                public CPASAdCreationTemplate apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsUnusedTemplateField() {
            return this.requestIsUnusedTemplateField(true);
        }

        public APIRequestGet requestIsUnusedTemplateField(boolean value) {
            this.requestField("is_unused_template", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestOptimizationGoalField() {
            return this.requestOptimizationGoalField(true);
        }

        public APIRequestGet requestOptimizationGoalField(boolean value) {
            this.requestField("optimization_goal", value);
            return this;
        }

        public APIRequestGet requestTargetingTypeField() {
            return this.requestTargetingTypeField(true);
        }

        public APIRequestGet requestTargetingTypeField(boolean value) {
            this.requestField("targeting_type", value);
            return this;
        }

        public APIRequestGet requestTemplateTypeField() {
            return this.requestTemplateTypeField(true);
        }

        public APIRequestGet requestTemplateTypeField(boolean value) {
            this.requestField("template_type", value);
            return this;
        }
    }
}

