/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

public class AdAssetVideo
extends APINode {
    @SerializedName(value="caption_ids")
    private List<String> mCaptionIds = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="source_image_url")
    private String mSourceImageUrl = null;
    @SerializedName(value="tag")
    private String mTag = null;
    @SerializedName(value="thumbnail_hash")
    private String mThumbnailHash = null;
    @SerializedName(value="thumbnail_source")
    private String mThumbnailSource = null;
    @SerializedName(value="thumbnail_url")
    private String mThumbnailUrl = null;
    @SerializedName(value="url")
    private String mUrl = null;
    @SerializedName(value="url_tags")
    private String mUrlTags = null;
    @SerializedName(value="video_id")
    private String mVideoId = null;
    @SerializedName(value="video_name")
    private String mVideoName = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdAssetVideo loadJSON(String json, APIContext context, String header) {
        AdAssetVideo adAssetVideo = (AdAssetVideo)AdAssetVideo.getGson().fromJson(json, AdAssetVideo.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adAssetVideo.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adAssetVideo.context = context;
        adAssetVideo.rawValue = json;
        adAssetVideo.header = header;
        return adAssetVideo;
    }

    public static APINodeList<AdAssetVideo> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdAssetVideo> adAssetVideos = new APINodeList<AdAssetVideo>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adAssetVideos.add(AdAssetVideo.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adAssetVideos;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adAssetVideos.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adAssetVideos.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adAssetVideos.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adAssetVideos.add(AdAssetVideo.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adAssetVideos.add(AdAssetVideo.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adAssetVideos.add(AdAssetVideo.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adAssetVideos;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adAssetVideos.add(AdAssetVideo.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adAssetVideos;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adAssetVideos.add(AdAssetVideo.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adAssetVideos;
                }
                adAssetVideos.clear();
                adAssetVideos.add(AdAssetVideo.loadJSON(json, context, header));
                return adAssetVideos;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdAssetVideo.getGson().toJson((Object)this);
    }

    public List<String> getFieldCaptionIds() {
        return this.mCaptionIds;
    }

    public AdAssetVideo setFieldCaptionIds(List<String> value) {
        this.mCaptionIds = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public AdAssetVideo setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public String getFieldSourceImageUrl() {
        return this.mSourceImageUrl;
    }

    public AdAssetVideo setFieldSourceImageUrl(String value) {
        this.mSourceImageUrl = value;
        return this;
    }

    public String getFieldTag() {
        return this.mTag;
    }

    public AdAssetVideo setFieldTag(String value) {
        this.mTag = value;
        return this;
    }

    public String getFieldThumbnailHash() {
        return this.mThumbnailHash;
    }

    public AdAssetVideo setFieldThumbnailHash(String value) {
        this.mThumbnailHash = value;
        return this;
    }

    public String getFieldThumbnailSource() {
        return this.mThumbnailSource;
    }

    public AdAssetVideo setFieldThumbnailSource(String value) {
        this.mThumbnailSource = value;
        return this;
    }

    public String getFieldThumbnailUrl() {
        return this.mThumbnailUrl;
    }

    public AdAssetVideo setFieldThumbnailUrl(String value) {
        this.mThumbnailUrl = value;
        return this;
    }

    public String getFieldUrl() {
        return this.mUrl;
    }

    public AdAssetVideo setFieldUrl(String value) {
        this.mUrl = value;
        return this;
    }

    public String getFieldUrlTags() {
        return this.mUrlTags;
    }

    public AdAssetVideo setFieldUrlTags(String value) {
        this.mUrlTags = value;
        return this;
    }

    public String getFieldVideoId() {
        return this.mVideoId;
    }

    public AdAssetVideo setFieldVideoId(String value) {
        this.mVideoId = value;
        return this;
    }

    public String getFieldVideoName() {
        return this.mVideoName;
    }

    public AdAssetVideo setFieldVideoName(String value) {
        this.mVideoName = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdAssetVideo copyFrom(AdAssetVideo instance) {
        this.mCaptionIds = instance.mCaptionIds;
        this.mId = instance.mId;
        this.mSourceImageUrl = instance.mSourceImageUrl;
        this.mTag = instance.mTag;
        this.mThumbnailHash = instance.mThumbnailHash;
        this.mThumbnailSource = instance.mThumbnailSource;
        this.mThumbnailUrl = instance.mThumbnailUrl;
        this.mUrl = instance.mUrl;
        this.mUrlTags = instance.mUrlTags;
        this.mVideoId = instance.mVideoId;
        this.mVideoName = instance.mVideoName;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdAssetVideo> getParser() {
        return new APIRequest.ResponseParser<AdAssetVideo>(){

            @Override
            public APINodeList<AdAssetVideo> parseResponse(String response, APIContext context, APIRequest<AdAssetVideo> request, String header) throws APIException.MalformedResponseException {
                return AdAssetVideo.parseResponse(response, context, request, header);
            }
        };
    }
}

