/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class GuidanceLiftEstimate
extends APINode {
    @SerializedName(value="actual_7d_cpr")
    private Double mActual7dCpr = null;
    @SerializedName(value="adoption_date")
    private String mAdoptionDate = null;
    @SerializedName(value="guidance_name")
    private String mGuidanceName = null;
    @SerializedName(value="lift_estimation")
    private Double mLiftEstimation = null;
    @SerializedName(value="predicted_7d_cpr")
    private Double mPredicted7dCpr = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static GuidanceLiftEstimate loadJSON(String json, APIContext context, String header) {
        GuidanceLiftEstimate guidanceLiftEstimate = (GuidanceLiftEstimate)GuidanceLiftEstimate.getGson().fromJson(json, GuidanceLiftEstimate.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(guidanceLiftEstimate.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        guidanceLiftEstimate.context = context;
        guidanceLiftEstimate.rawValue = json;
        guidanceLiftEstimate.header = header;
        return guidanceLiftEstimate;
    }

    public static APINodeList<GuidanceLiftEstimate> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<GuidanceLiftEstimate> guidanceLiftEstimates = new APINodeList<GuidanceLiftEstimate>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        guidanceLiftEstimates.add(GuidanceLiftEstimate.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return guidanceLiftEstimates;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            guidanceLiftEstimates.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        guidanceLiftEstimates.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            guidanceLiftEstimates.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            guidanceLiftEstimates.add(GuidanceLiftEstimate.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                guidanceLiftEstimates.add(GuidanceLiftEstimate.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            guidanceLiftEstimates.add(GuidanceLiftEstimate.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return guidanceLiftEstimates;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        guidanceLiftEstimates.add(GuidanceLiftEstimate.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return guidanceLiftEstimates;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        guidanceLiftEstimates.add(GuidanceLiftEstimate.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return guidanceLiftEstimates;
                }
                guidanceLiftEstimates.clear();
                guidanceLiftEstimates.add(GuidanceLiftEstimate.loadJSON(json, context, header));
                return guidanceLiftEstimates;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return GuidanceLiftEstimate.getGson().toJson((Object)this);
    }

    public Double getFieldActual7dCpr() {
        return this.mActual7dCpr;
    }

    public GuidanceLiftEstimate setFieldActual7dCpr(Double value) {
        this.mActual7dCpr = value;
        return this;
    }

    public String getFieldAdoptionDate() {
        return this.mAdoptionDate;
    }

    public GuidanceLiftEstimate setFieldAdoptionDate(String value) {
        this.mAdoptionDate = value;
        return this;
    }

    public String getFieldGuidanceName() {
        return this.mGuidanceName;
    }

    public GuidanceLiftEstimate setFieldGuidanceName(String value) {
        this.mGuidanceName = value;
        return this;
    }

    public Double getFieldLiftEstimation() {
        return this.mLiftEstimation;
    }

    public GuidanceLiftEstimate setFieldLiftEstimation(Double value) {
        this.mLiftEstimation = value;
        return this;
    }

    public Double getFieldPredicted7dCpr() {
        return this.mPredicted7dCpr;
    }

    public GuidanceLiftEstimate setFieldPredicted7dCpr(Double value) {
        this.mPredicted7dCpr = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public GuidanceLiftEstimate copyFrom(GuidanceLiftEstimate instance) {
        this.mActual7dCpr = instance.mActual7dCpr;
        this.mAdoptionDate = instance.mAdoptionDate;
        this.mGuidanceName = instance.mGuidanceName;
        this.mLiftEstimation = instance.mLiftEstimation;
        this.mPredicted7dCpr = instance.mPredicted7dCpr;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<GuidanceLiftEstimate> getParser() {
        return new APIRequest.ResponseParser<GuidanceLiftEstimate>(){

            @Override
            public APINodeList<GuidanceLiftEstimate> parseResponse(String response, APIContext context, APIRequest<GuidanceLiftEstimate> request, String header) throws APIException.MalformedResponseException {
                return GuidanceLiftEstimate.parseResponse(response, context, request, header);
            }
        };
    }
}

