/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AssignedUser;
import com.facebook.ads.sdk.Business;
import com.facebook.ads.sdk.CTXPartnerAppWelcomeMessageFlow;
import com.facebook.ads.sdk.CommerceMerchantSettings;
import com.facebook.ads.sdk.Dataset;
import com.facebook.ads.sdk.ProductCatalog;
import com.facebook.ads.sdk.WhatsAppBusinessHealthStatusForMessageSend;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class WhatsAppBusinessAccount
extends APINode {
    @SerializedName(value="account_review_status")
    private String mAccountReviewStatus = null;
    @SerializedName(value="analytics")
    private Object mAnalytics = null;
    @SerializedName(value="auth_international_rate_eligibility")
    private Object mAuthInternationalRateEligibility = null;
    @SerializedName(value="business_verification_status")
    private EnumBusinessVerificationStatus mBusinessVerificationStatus = null;
    @SerializedName(value="country")
    private String mCountry = null;
    @SerializedName(value="creation_time")
    private Long mCreationTime = null;
    @SerializedName(value="currency")
    private String mCurrency = null;
    @SerializedName(value="health_status")
    private WhatsAppBusinessHealthStatusForMessageSend mHealthStatus = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_enabled_for_insights")
    private Boolean mIsEnabledForInsights = null;
    @SerializedName(value="is_shared_with_partners")
    private Boolean mIsSharedWithPartners = null;
    @SerializedName(value="linked_commerce_account")
    private CommerceMerchantSettings mLinkedCommerceAccount = null;
    @SerializedName(value="marketing_messages_lite_api_status")
    private String mMarketingMessagesLiteApiStatus = null;
    @SerializedName(value="marketing_messages_onboarding_status")
    private String mMarketingMessagesOnboardingStatus = null;
    @SerializedName(value="message_template_namespace")
    private String mMessageTemplateNamespace = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="on_behalf_of_business_info")
    private Object mOnBehalfOfBusinessInfo = null;
    @SerializedName(value="owner_business")
    private Business mOwnerBusiness = null;
    @SerializedName(value="owner_business_info")
    private Object mOwnerBusinessInfo = null;
    @SerializedName(value="ownership_type")
    private String mOwnershipType = null;
    @SerializedName(value="primary_business_location")
    private String mPrimaryBusinessLocation = null;
    @SerializedName(value="primary_funding_id")
    private String mPrimaryFundingId = null;
    @SerializedName(value="purchase_order_number")
    private String mPurchaseOrderNumber = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="timezone_id")
    private String mTimezoneId = null;
    protected static Gson gson = null;

    WhatsAppBusinessAccount() {
    }

    public WhatsAppBusinessAccount(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public WhatsAppBusinessAccount(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public WhatsAppBusinessAccount fetch() throws APIException {
        WhatsAppBusinessAccount newInstance = WhatsAppBusinessAccount.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static WhatsAppBusinessAccount fetchById(Long id, APIContext context) throws APIException {
        return WhatsAppBusinessAccount.fetchById(id.toString(), context);
    }

    public static ListenableFuture<WhatsAppBusinessAccount> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return WhatsAppBusinessAccount.fetchByIdAsync(id.toString(), context);
    }

    public static WhatsAppBusinessAccount fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<WhatsAppBusinessAccount> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<WhatsAppBusinessAccount> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<WhatsAppBusinessAccount>(context, "", "/", "GET", WhatsAppBusinessAccount.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<WhatsAppBusinessAccount>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<WhatsAppBusinessAccount>(context, "", "/", "GET", WhatsAppBusinessAccount.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static WhatsAppBusinessAccount loadJSON(String json, APIContext context, String header) {
        WhatsAppBusinessAccount whatsAppBusinessAccount = (WhatsAppBusinessAccount)WhatsAppBusinessAccount.getGson().fromJson(json, WhatsAppBusinessAccount.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(whatsAppBusinessAccount.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        whatsAppBusinessAccount.context = context;
        whatsAppBusinessAccount.rawValue = json;
        whatsAppBusinessAccount.header = header;
        return whatsAppBusinessAccount;
    }

    public static APINodeList<WhatsAppBusinessAccount> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<WhatsAppBusinessAccount> whatsAppBusinessAccounts = new APINodeList<WhatsAppBusinessAccount>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        whatsAppBusinessAccounts.add(WhatsAppBusinessAccount.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return whatsAppBusinessAccounts;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            whatsAppBusinessAccounts.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        whatsAppBusinessAccounts.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            whatsAppBusinessAccounts.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            whatsAppBusinessAccounts.add(WhatsAppBusinessAccount.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                whatsAppBusinessAccounts.add(WhatsAppBusinessAccount.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            whatsAppBusinessAccounts.add(WhatsAppBusinessAccount.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return whatsAppBusinessAccounts;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        whatsAppBusinessAccounts.add(WhatsAppBusinessAccount.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return whatsAppBusinessAccounts;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        whatsAppBusinessAccounts.add(WhatsAppBusinessAccount.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return whatsAppBusinessAccounts;
                }
                whatsAppBusinessAccounts.clear();
                whatsAppBusinessAccounts.add(WhatsAppBusinessAccount.loadJSON(json, context, header));
                return whatsAppBusinessAccounts;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return WhatsAppBusinessAccount.getGson().toJson((Object)this);
    }

    public APIRequestGetActivities getActivities() {
        return new APIRequestGetActivities(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteAssignedUsers deleteAssignedUsers() {
        return new APIRequestDeleteAssignedUsers(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAssignedUsers getAssignedUsers() {
        return new APIRequestGetAssignedUsers(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateAssignedUser createAssignedUser() {
        return new APIRequestCreateAssignedUser(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetAudiences getAudiences() {
        return new APIRequestGetAudiences(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetCallAnalytics getCallAnalytics() {
        return new APIRequestGetCallAnalytics(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetConversationAnalytics getConversationAnalytics() {
        return new APIRequestGetConversationAnalytics(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetDataset getDataset() {
        return new APIRequestGetDataset(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateDataset createDataset() {
        return new APIRequestCreateDataset(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetFlows getFlows() {
        return new APIRequestGetFlows(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateFlow createFlow() {
        return new APIRequestCreateFlow(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateGeneratePaymentConfigurationOauthLink createGeneratePaymentConfigurationOauthLink() {
        return new APIRequestCreateGeneratePaymentConfigurationOauthLink(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetMessageCampaigns getMessageCampaigns() {
        return new APIRequestGetMessageCampaigns(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetMessageTemplatePreviews getMessageTemplatePreviews() {
        return new APIRequestGetMessageTemplatePreviews(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteMessageTemplates deleteMessageTemplates() {
        return new APIRequestDeleteMessageTemplates(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetMessageTemplates getMessageTemplates() {
        return new APIRequestGetMessageTemplates(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateMessageTemplate createMessageTemplate() {
        return new APIRequestCreateMessageTemplate(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateMigrateFlow createMigrateFlow() {
        return new APIRequestCreateMigrateFlow(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateMigrateMessageTemplate createMigrateMessageTemplate() {
        return new APIRequestCreateMigrateMessageTemplate(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeletePaymentConfiguration deletePaymentConfiguration() {
        return new APIRequestDeletePaymentConfiguration(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetPaymentConfiguration getPaymentConfiguration() {
        return new APIRequestGetPaymentConfiguration(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreatePaymentConfiguration createPaymentConfiguration() {
        return new APIRequestCreatePaymentConfiguration(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetPaymentConfigurations getPaymentConfigurations() {
        return new APIRequestGetPaymentConfigurations(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetPhoneNumbers getPhoneNumbers() {
        return new APIRequestGetPhoneNumbers(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreatePhoneNumber createPhoneNumber() {
        return new APIRequestCreatePhoneNumber(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetPricingAnalytics getPricingAnalytics() {
        return new APIRequestGetPricingAnalytics(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteProductCatalogs deleteProductCatalogs() {
        return new APIRequestDeleteProductCatalogs(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetProductCatalogs getProductCatalogs() {
        return new APIRequestGetProductCatalogs(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateProductCatalog createProductCatalog() {
        return new APIRequestCreateProductCatalog(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetSchedules getSchedules() {
        return new APIRequestGetSchedules(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateSetOboMobilityIntent createSetOboMobilityIntent() {
        return new APIRequestCreateSetOboMobilityIntent(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateSetSolutionMigrationIntent createSetSolutionMigrationIntent() {
        return new APIRequestCreateSetSolutionMigrationIntent(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetSolutions getSolutions() {
        return new APIRequestGetSolutions(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDeleteSubscribedApps deleteSubscribedApps() {
        return new APIRequestDeleteSubscribedApps(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetSubscribedApps getSubscribedApps() {
        return new APIRequestGetSubscribedApps(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateSubscribedApp createSubscribedApp() {
        return new APIRequestCreateSubscribedApp(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetTemplateAnalytics getTemplateAnalytics() {
        return new APIRequestGetTemplateAnalytics(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetTemplateGroupAnalytics getTemplateGroupAnalytics() {
        return new APIRequestGetTemplateGroupAnalytics(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetTemplateGroups getTemplateGroups() {
        return new APIRequestGetTemplateGroups(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateTemplateGroup createTemplateGroup() {
        return new APIRequestCreateTemplateGroup(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetTemplatePerformanceMetrics getTemplatePerformanceMetrics() {
        return new APIRequestGetTemplatePerformanceMetrics(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateUpsertMessageTemplate createUpsertMessageTemplate() {
        return new APIRequestCreateUpsertMessageTemplate(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetWelcomeMessageSequences getWelcomeMessageSequences() {
        return new APIRequestGetWelcomeMessageSequences(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAccountReviewStatus() {
        return this.mAccountReviewStatus;
    }

    public Object getFieldAnalytics() {
        return this.mAnalytics;
    }

    public Object getFieldAuthInternationalRateEligibility() {
        return this.mAuthInternationalRateEligibility;
    }

    public EnumBusinessVerificationStatus getFieldBusinessVerificationStatus() {
        return this.mBusinessVerificationStatus;
    }

    public String getFieldCountry() {
        return this.mCountry;
    }

    public Long getFieldCreationTime() {
        return this.mCreationTime;
    }

    public String getFieldCurrency() {
        return this.mCurrency;
    }

    public WhatsAppBusinessHealthStatusForMessageSend getFieldHealthStatus() {
        return this.mHealthStatus;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsEnabledForInsights() {
        return this.mIsEnabledForInsights;
    }

    public Boolean getFieldIsSharedWithPartners() {
        return this.mIsSharedWithPartners;
    }

    public CommerceMerchantSettings getFieldLinkedCommerceAccount() {
        if (this.mLinkedCommerceAccount != null) {
            this.mLinkedCommerceAccount.context = this.getContext();
        }
        return this.mLinkedCommerceAccount;
    }

    public String getFieldMarketingMessagesLiteApiStatus() {
        return this.mMarketingMessagesLiteApiStatus;
    }

    public String getFieldMarketingMessagesOnboardingStatus() {
        return this.mMarketingMessagesOnboardingStatus;
    }

    public String getFieldMessageTemplateNamespace() {
        return this.mMessageTemplateNamespace;
    }

    public String getFieldName() {
        return this.mName;
    }

    public Object getFieldOnBehalfOfBusinessInfo() {
        return this.mOnBehalfOfBusinessInfo;
    }

    public Business getFieldOwnerBusiness() {
        if (this.mOwnerBusiness != null) {
            this.mOwnerBusiness.context = this.getContext();
        }
        return this.mOwnerBusiness;
    }

    public Object getFieldOwnerBusinessInfo() {
        return this.mOwnerBusinessInfo;
    }

    public String getFieldOwnershipType() {
        return this.mOwnershipType;
    }

    public String getFieldPrimaryBusinessLocation() {
        return this.mPrimaryBusinessLocation;
    }

    public String getFieldPrimaryFundingId() {
        return this.mPrimaryFundingId;
    }

    public String getFieldPurchaseOrderNumber() {
        return this.mPurchaseOrderNumber;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public String getFieldTimezoneId() {
        return this.mTimezoneId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public WhatsAppBusinessAccount copyFrom(WhatsAppBusinessAccount instance) {
        this.mAccountReviewStatus = instance.mAccountReviewStatus;
        this.mAnalytics = instance.mAnalytics;
        this.mAuthInternationalRateEligibility = instance.mAuthInternationalRateEligibility;
        this.mBusinessVerificationStatus = instance.mBusinessVerificationStatus;
        this.mCountry = instance.mCountry;
        this.mCreationTime = instance.mCreationTime;
        this.mCurrency = instance.mCurrency;
        this.mHealthStatus = instance.mHealthStatus;
        this.mId = instance.mId;
        this.mIsEnabledForInsights = instance.mIsEnabledForInsights;
        this.mIsSharedWithPartners = instance.mIsSharedWithPartners;
        this.mLinkedCommerceAccount = instance.mLinkedCommerceAccount;
        this.mMarketingMessagesLiteApiStatus = instance.mMarketingMessagesLiteApiStatus;
        this.mMarketingMessagesOnboardingStatus = instance.mMarketingMessagesOnboardingStatus;
        this.mMessageTemplateNamespace = instance.mMessageTemplateNamespace;
        this.mName = instance.mName;
        this.mOnBehalfOfBusinessInfo = instance.mOnBehalfOfBusinessInfo;
        this.mOwnerBusiness = instance.mOwnerBusiness;
        this.mOwnerBusinessInfo = instance.mOwnerBusinessInfo;
        this.mOwnershipType = instance.mOwnershipType;
        this.mPrimaryBusinessLocation = instance.mPrimaryBusinessLocation;
        this.mPrimaryFundingId = instance.mPrimaryFundingId;
        this.mPurchaseOrderNumber = instance.mPurchaseOrderNumber;
        this.mStatus = instance.mStatus;
        this.mTimezoneId = instance.mTimezoneId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<WhatsAppBusinessAccount> getParser() {
        return new APIRequest.ResponseParser<WhatsAppBusinessAccount>(){

            @Override
            public APINodeList<WhatsAppBusinessAccount> parseResponse(String response, APIContext context, APIRequest<WhatsAppBusinessAccount> request, String header) throws APIException.MalformedResponseException {
                return WhatsAppBusinessAccount.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumProductType {
        VALUE_CLOUD_API("CLOUD_API"),
        VALUE_MARKETING_MESSAGES_LITE_API("MARKETING_MESSAGES_LITE_API");

        private String value;

        private EnumProductType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumPricingTypes {
        VALUE_FREE_CUSTOMER_SERVICE("FREE_CUSTOMER_SERVICE"),
        VALUE_FREE_ENTRY_POINT("FREE_ENTRY_POINT"),
        VALUE_FREE_GROUP_CUSTOMER_SERVICE("FREE_GROUP_CUSTOMER_SERVICE"),
        VALUE_REGULAR("REGULAR");

        private String value;

        private EnumPricingTypes(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumPricingCategories {
        VALUE_AUTHENTICATION("AUTHENTICATION"),
        VALUE_AUTHENTICATION_INTERNATIONAL("AUTHENTICATION_INTERNATIONAL"),
        VALUE_GROUP_MARKETING("GROUP_MARKETING"),
        VALUE_GROUP_SERVICE("GROUP_SERVICE"),
        VALUE_GROUP_UTILITY("GROUP_UTILITY"),
        VALUE_MARKETING("MARKETING"),
        VALUE_MARKETING_LITE("MARKETING_LITE"),
        VALUE_SERVICE("SERVICE"),
        VALUE_UTILITY("UTILITY");

        private String value;

        private EnumPricingCategories(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumStatus {
        VALUE_APPROVED("APPROVED"),
        VALUE_ARCHIVED("ARCHIVED"),
        VALUE_DELETED("DELETED"),
        VALUE_DISABLED("DISABLED"),
        VALUE_IN_APPEAL("IN_APPEAL"),
        VALUE_LIMIT_EXCEEDED("LIMIT_EXCEEDED"),
        VALUE_PAUSED("PAUSED"),
        VALUE_PENDING("PENDING"),
        VALUE_PENDING_DELETION("PENDING_DELETION"),
        VALUE_REJECTED("REJECTED");

        private String value;

        private EnumStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumQualityScore {
        VALUE_GREEN("GREEN"),
        VALUE_RED("RED"),
        VALUE_UNKNOWN("UNKNOWN"),
        VALUE_YELLOW("YELLOW");

        private String value;

        private EnumQualityScore(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumButtonTypes {
        VALUE_OTP("OTP");

        private String value;

        private EnumButtonTypes(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumCategories {
        VALUE_APPOINTMENT_BOOKING("APPOINTMENT_BOOKING"),
        VALUE_CONTACT_US("CONTACT_US"),
        VALUE_CUSTOMER_SUPPORT("CUSTOMER_SUPPORT"),
        VALUE_LEAD_GENERATION("LEAD_GENERATION"),
        VALUE_OTHER("OTHER"),
        VALUE_SHOPPING("SHOPPING"),
        VALUE_SIGN_IN("SIGN_IN"),
        VALUE_SIGN_UP("SIGN_UP"),
        VALUE_SURVEY("SURVEY");

        private String value;

        private EnumCategories(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumConversationTypes {
        VALUE_FREE_ENTRY_POINT("FREE_ENTRY_POINT"),
        VALUE_FREE_TIER("FREE_TIER"),
        VALUE_REGULAR("REGULAR"),
        VALUE_UNKNOWN("UNKNOWN");

        private String value;

        private EnumConversationTypes(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumConversationDirections {
        VALUE_BUSINESS_INITIATED("BUSINESS_INITIATED"),
        VALUE_UNKNOWN("UNKNOWN"),
        VALUE_USER_INITIATED("USER_INITIATED");

        private String value;

        private EnumConversationDirections(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumConversationCategories {
        VALUE_AUTHENTICATION("AUTHENTICATION"),
        VALUE_AUTHENTICATION_INTERNATIONAL("AUTHENTICATION_INTERNATIONAL"),
        VALUE_MARKETING("MARKETING"),
        VALUE_MARKETING_LITE("MARKETING_LITE"),
        VALUE_SERVICE("SERVICE"),
        VALUE_UTILITY("UTILITY");

        private String value;

        private EnumConversationCategories(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumMetricTypes {
        VALUE_AVERAGE_DURATION("AVERAGE_DURATION"),
        VALUE_COST("COST"),
        VALUE_COUNT("COUNT"),
        VALUE_UNKNOWN("UNKNOWN");

        private String value;

        private EnumMetricTypes(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumGranularity {
        VALUE_DAILY("DAILY"),
        VALUE_HALF_HOUR("HALF_HOUR"),
        VALUE_MONTHLY("MONTHLY");

        private String value;

        private EnumGranularity(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumDirections {
        VALUE_BUSINESS_INITIATED("BUSINESS_INITIATED"),
        VALUE_UNKNOWN("UNKNOWN"),
        VALUE_USER_INITIATED("USER_INITIATED");

        private String value;

        private EnumDirections(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumDimensions {
        VALUE_COUNTRY("COUNTRY"),
        VALUE_DIRECTION("DIRECTION"),
        VALUE_PHONE("PHONE"),
        VALUE_TIER("TIER"),
        VALUE_UNKNOWN("UNKNOWN");

        private String value;

        private EnumDimensions(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumProviderName {
        VALUE_BILLDESK("BILLDESK"),
        VALUE_PAYU("PAYU"),
        VALUE_RAZORPAY("RAZORPAY"),
        VALUE_UPI_VPA("UPI_VPA"),
        VALUE_ZAAKPAY("ZAAKPAY");

        private String value;

        private EnumProviderName(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumSubCategory {
        VALUE_ORDER_DETAILS("ORDER_DETAILS"),
        VALUE_ORDER_STATUS("ORDER_STATUS");

        private String value;

        private EnumSubCategory(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumParameterFormat {
        VALUE_NAMED("NAMED"),
        VALUE_POSITIONAL("POSITIONAL");

        private String value;

        private EnumParameterFormat(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumDisplayFormat {
        VALUE_ORDER_DETAILS("ORDER_DETAILS");

        private String value;

        private EnumDisplayFormat(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumCategory {
        VALUE_AUTHENTICATION("AUTHENTICATION"),
        VALUE_MARKETING("MARKETING"),
        VALUE_UTILITY("UTILITY");

        private String value;

        private EnumCategory(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumTasks {
        VALUE_DEVELOP("DEVELOP"),
        VALUE_MANAGE("MANAGE"),
        VALUE_MANAGE_EXTENSIONS("MANAGE_EXTENSIONS"),
        VALUE_MANAGE_PHONE("MANAGE_PHONE"),
        VALUE_MANAGE_PHONE_ASSETS("MANAGE_PHONE_ASSETS"),
        VALUE_MANAGE_TEMPLATES("MANAGE_TEMPLATES"),
        VALUE_MESSAGING("MESSAGING"),
        VALUE_VIEW_COST("VIEW_COST"),
        VALUE_VIEW_PHONE_ASSETS("VIEW_PHONE_ASSETS"),
        VALUE_VIEW_TEMPLATES("VIEW_TEMPLATES");

        private String value;

        private EnumTasks(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumBusinessVerificationStatus {
        VALUE_EXPIRED("expired"),
        VALUE_FAILED("failed"),
        VALUE_INELIGIBLE("ineligible"),
        VALUE_NOT_VERIFIED("not_verified"),
        VALUE_PENDING("pending"),
        VALUE_PENDING_NEED_MORE_INFO("pending_need_more_info"),
        VALUE_PENDING_SUBMISSION("pending_submission"),
        VALUE_REJECTED("rejected"),
        VALUE_REVOKED("revoked"),
        VALUE_VERIFIED("verified");

        private String value;

        private EnumBusinessVerificationStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestUpdate
    extends APIRequest<WhatsAppBusinessAccount> {
        WhatsAppBusinessAccount lastResponse = null;
        public static final String[] PARAMS = new String[]{"is_enabled_for_insights"};
        public static final String[] FIELDS = new String[0];

        @Override
        public WhatsAppBusinessAccount getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public WhatsAppBusinessAccount parseResponse(String response, String header) throws APIException {
            return WhatsAppBusinessAccount.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public WhatsAppBusinessAccount execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public WhatsAppBusinessAccount execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<WhatsAppBusinessAccount> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<WhatsAppBusinessAccount> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, WhatsAppBusinessAccount>(){

                public WhatsAppBusinessAccount apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setIsEnabledForInsights(Boolean isEnabledForInsights) {
            this.setParam("is_enabled_for_insights", isEnabledForInsights);
            return this;
        }

        public APIRequestUpdate setIsEnabledForInsights(String isEnabledForInsights) {
            this.setParam("is_enabled_for_insights", isEnabledForInsights);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGet
    extends APIRequest<WhatsAppBusinessAccount> {
        WhatsAppBusinessAccount lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"account_review_status", "analytics", "auth_international_rate_eligibility", "business_verification_status", "country", "creation_time", "currency", "health_status", "id", "is_enabled_for_insights", "is_shared_with_partners", "linked_commerce_account", "marketing_messages_lite_api_status", "marketing_messages_onboarding_status", "message_template_namespace", "name", "on_behalf_of_business_info", "owner_business", "owner_business_info", "ownership_type", "primary_business_location", "primary_funding_id", "purchase_order_number", "status", "timezone_id"};

        @Override
        public WhatsAppBusinessAccount getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public WhatsAppBusinessAccount parseResponse(String response, String header) throws APIException {
            return WhatsAppBusinessAccount.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public WhatsAppBusinessAccount execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public WhatsAppBusinessAccount execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<WhatsAppBusinessAccount> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<WhatsAppBusinessAccount> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, WhatsAppBusinessAccount>(){

                public WhatsAppBusinessAccount apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAccountReviewStatusField() {
            return this.requestAccountReviewStatusField(true);
        }

        public APIRequestGet requestAccountReviewStatusField(boolean value) {
            this.requestField("account_review_status", value);
            return this;
        }

        public APIRequestGet requestAnalyticsField() {
            return this.requestAnalyticsField(true);
        }

        public APIRequestGet requestAnalyticsField(boolean value) {
            this.requestField("analytics", value);
            return this;
        }

        public APIRequestGet requestAuthInternationalRateEligibilityField() {
            return this.requestAuthInternationalRateEligibilityField(true);
        }

        public APIRequestGet requestAuthInternationalRateEligibilityField(boolean value) {
            this.requestField("auth_international_rate_eligibility", value);
            return this;
        }

        public APIRequestGet requestBusinessVerificationStatusField() {
            return this.requestBusinessVerificationStatusField(true);
        }

        public APIRequestGet requestBusinessVerificationStatusField(boolean value) {
            this.requestField("business_verification_status", value);
            return this;
        }

        public APIRequestGet requestCountryField() {
            return this.requestCountryField(true);
        }

        public APIRequestGet requestCountryField(boolean value) {
            this.requestField("country", value);
            return this;
        }

        public APIRequestGet requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGet requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGet requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGet requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGet requestHealthStatusField() {
            return this.requestHealthStatusField(true);
        }

        public APIRequestGet requestHealthStatusField(boolean value) {
            this.requestField("health_status", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsEnabledForInsightsField() {
            return this.requestIsEnabledForInsightsField(true);
        }

        public APIRequestGet requestIsEnabledForInsightsField(boolean value) {
            this.requestField("is_enabled_for_insights", value);
            return this;
        }

        public APIRequestGet requestIsSharedWithPartnersField() {
            return this.requestIsSharedWithPartnersField(true);
        }

        public APIRequestGet requestIsSharedWithPartnersField(boolean value) {
            this.requestField("is_shared_with_partners", value);
            return this;
        }

        public APIRequestGet requestLinkedCommerceAccountField() {
            return this.requestLinkedCommerceAccountField(true);
        }

        public APIRequestGet requestLinkedCommerceAccountField(boolean value) {
            this.requestField("linked_commerce_account", value);
            return this;
        }

        public APIRequestGet requestMarketingMessagesLiteApiStatusField() {
            return this.requestMarketingMessagesLiteApiStatusField(true);
        }

        public APIRequestGet requestMarketingMessagesLiteApiStatusField(boolean value) {
            this.requestField("marketing_messages_lite_api_status", value);
            return this;
        }

        public APIRequestGet requestMarketingMessagesOnboardingStatusField() {
            return this.requestMarketingMessagesOnboardingStatusField(true);
        }

        public APIRequestGet requestMarketingMessagesOnboardingStatusField(boolean value) {
            this.requestField("marketing_messages_onboarding_status", value);
            return this;
        }

        public APIRequestGet requestMessageTemplateNamespaceField() {
            return this.requestMessageTemplateNamespaceField(true);
        }

        public APIRequestGet requestMessageTemplateNamespaceField(boolean value) {
            this.requestField("message_template_namespace", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestOnBehalfOfBusinessInfoField() {
            return this.requestOnBehalfOfBusinessInfoField(true);
        }

        public APIRequestGet requestOnBehalfOfBusinessInfoField(boolean value) {
            this.requestField("on_behalf_of_business_info", value);
            return this;
        }

        public APIRequestGet requestOwnerBusinessField() {
            return this.requestOwnerBusinessField(true);
        }

        public APIRequestGet requestOwnerBusinessField(boolean value) {
            this.requestField("owner_business", value);
            return this;
        }

        public APIRequestGet requestOwnerBusinessInfoField() {
            return this.requestOwnerBusinessInfoField(true);
        }

        public APIRequestGet requestOwnerBusinessInfoField(boolean value) {
            this.requestField("owner_business_info", value);
            return this;
        }

        public APIRequestGet requestOwnershipTypeField() {
            return this.requestOwnershipTypeField(true);
        }

        public APIRequestGet requestOwnershipTypeField(boolean value) {
            this.requestField("ownership_type", value);
            return this;
        }

        public APIRequestGet requestPrimaryBusinessLocationField() {
            return this.requestPrimaryBusinessLocationField(true);
        }

        public APIRequestGet requestPrimaryBusinessLocationField(boolean value) {
            this.requestField("primary_business_location", value);
            return this;
        }

        public APIRequestGet requestPrimaryFundingIdField() {
            return this.requestPrimaryFundingIdField(true);
        }

        public APIRequestGet requestPrimaryFundingIdField(boolean value) {
            this.requestField("primary_funding_id", value);
            return this;
        }

        public APIRequestGet requestPurchaseOrderNumberField() {
            return this.requestPurchaseOrderNumberField(true);
        }

        public APIRequestGet requestPurchaseOrderNumberField(boolean value) {
            this.requestField("purchase_order_number", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestTimezoneIdField() {
            return this.requestTimezoneIdField(true);
        }

        public APIRequestGet requestTimezoneIdField(boolean value) {
            this.requestField("timezone_id", value);
            return this;
        }
    }

    public static class APIRequestGetWelcomeMessageSequences
    extends APIRequest<CTXPartnerAppWelcomeMessageFlow> {
        APINodeList<CTXPartnerAppWelcomeMessageFlow> lastResponse = null;
        public static final String[] PARAMS = new String[]{"app_id", "sequence_id"};
        public static final String[] FIELDS = new String[]{"compatible_platforms", "eligible_platforms", "id", "is_ig_only_flow", "is_used_in_ad", "last_update_time", "name", "welcome_message_flow", "welcome_message_sequence"};

        @Override
        public APINodeList<CTXPartnerAppWelcomeMessageFlow> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<CTXPartnerAppWelcomeMessageFlow> parseResponse(String response, String header) throws APIException {
            return CTXPartnerAppWelcomeMessageFlow.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<CTXPartnerAppWelcomeMessageFlow> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<CTXPartnerAppWelcomeMessageFlow> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<CTXPartnerAppWelcomeMessageFlow>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<CTXPartnerAppWelcomeMessageFlow>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<CTXPartnerAppWelcomeMessageFlow>>(){

                public APINodeList<CTXPartnerAppWelcomeMessageFlow> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetWelcomeMessageSequences(String nodeId, APIContext context) {
            super(context, nodeId, "/welcome_message_sequences", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetWelcomeMessageSequences setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetWelcomeMessageSequences setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetWelcomeMessageSequences setAppId(String appId) {
            this.setParam("app_id", appId);
            return this;
        }

        public APIRequestGetWelcomeMessageSequences setSequenceId(String sequenceId) {
            this.setParam("sequence_id", sequenceId);
            return this;
        }

        public APIRequestGetWelcomeMessageSequences requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetWelcomeMessageSequences requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetWelcomeMessageSequences requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetWelcomeMessageSequences requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetWelcomeMessageSequences requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetWelcomeMessageSequences requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetWelcomeMessageSequences requestCompatiblePlatformsField() {
            return this.requestCompatiblePlatformsField(true);
        }

        public APIRequestGetWelcomeMessageSequences requestCompatiblePlatformsField(boolean value) {
            this.requestField("compatible_platforms", value);
            return this;
        }

        public APIRequestGetWelcomeMessageSequences requestEligiblePlatformsField() {
            return this.requestEligiblePlatformsField(true);
        }

        public APIRequestGetWelcomeMessageSequences requestEligiblePlatformsField(boolean value) {
            this.requestField("eligible_platforms", value);
            return this;
        }

        public APIRequestGetWelcomeMessageSequences requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetWelcomeMessageSequences requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetWelcomeMessageSequences requestIsIgOnlyFlowField() {
            return this.requestIsIgOnlyFlowField(true);
        }

        public APIRequestGetWelcomeMessageSequences requestIsIgOnlyFlowField(boolean value) {
            this.requestField("is_ig_only_flow", value);
            return this;
        }

        public APIRequestGetWelcomeMessageSequences requestIsUsedInAdField() {
            return this.requestIsUsedInAdField(true);
        }

        public APIRequestGetWelcomeMessageSequences requestIsUsedInAdField(boolean value) {
            this.requestField("is_used_in_ad", value);
            return this;
        }

        public APIRequestGetWelcomeMessageSequences requestLastUpdateTimeField() {
            return this.requestLastUpdateTimeField(true);
        }

        public APIRequestGetWelcomeMessageSequences requestLastUpdateTimeField(boolean value) {
            this.requestField("last_update_time", value);
            return this;
        }

        public APIRequestGetWelcomeMessageSequences requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetWelcomeMessageSequences requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetWelcomeMessageSequences requestWelcomeMessageFlowField() {
            return this.requestWelcomeMessageFlowField(true);
        }

        public APIRequestGetWelcomeMessageSequences requestWelcomeMessageFlowField(boolean value) {
            this.requestField("welcome_message_flow", value);
            return this;
        }

        public APIRequestGetWelcomeMessageSequences requestWelcomeMessageSequenceField() {
            return this.requestWelcomeMessageSequenceField(true);
        }

        public APIRequestGetWelcomeMessageSequences requestWelcomeMessageSequenceField(boolean value) {
            this.requestField("welcome_message_sequence", value);
            return this;
        }
    }

    public static class APIRequestCreateUpsertMessageTemplate
    extends APIRequest<WhatsAppBusinessAccount> {
        WhatsAppBusinessAccount lastResponse = null;
        public static final String[] PARAMS = new String[]{"category", "components", "languages", "message_send_ttl_seconds", "name"};
        public static final String[] FIELDS = new String[0];

        @Override
        public WhatsAppBusinessAccount getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public WhatsAppBusinessAccount parseResponse(String response, String header) throws APIException {
            return WhatsAppBusinessAccount.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public WhatsAppBusinessAccount execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public WhatsAppBusinessAccount execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<WhatsAppBusinessAccount> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<WhatsAppBusinessAccount> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, WhatsAppBusinessAccount>(){

                public WhatsAppBusinessAccount apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestCreateUpsertMessageTemplate(String nodeId, APIContext context) {
            super(context, nodeId, "/upsert_message_templates", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateUpsertMessageTemplate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateUpsertMessageTemplate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateUpsertMessageTemplate setCategory(EnumCategory category) {
            this.setParam("category", (Object)category);
            return this;
        }

        public APIRequestCreateUpsertMessageTemplate setCategory(String category) {
            this.setParam("category", category);
            return this;
        }

        public APIRequestCreateUpsertMessageTemplate setComponents(List<Map<String, String>> components) {
            this.setParam("components", components);
            return this;
        }

        public APIRequestCreateUpsertMessageTemplate setComponents(String components) {
            this.setParam("components", components);
            return this;
        }

        public APIRequestCreateUpsertMessageTemplate setLanguages(List<String> languages) {
            this.setParam("languages", languages);
            return this;
        }

        public APIRequestCreateUpsertMessageTemplate setLanguages(String languages) {
            this.setParam("languages", languages);
            return this;
        }

        public APIRequestCreateUpsertMessageTemplate setMessageSendTtlSeconds(Long messageSendTtlSeconds) {
            this.setParam("message_send_ttl_seconds", messageSendTtlSeconds);
            return this;
        }

        public APIRequestCreateUpsertMessageTemplate setMessageSendTtlSeconds(String messageSendTtlSeconds) {
            this.setParam("message_send_ttl_seconds", messageSendTtlSeconds);
            return this;
        }

        public APIRequestCreateUpsertMessageTemplate setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreateUpsertMessageTemplate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateUpsertMessageTemplate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateUpsertMessageTemplate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateUpsertMessageTemplate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateUpsertMessageTemplate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateUpsertMessageTemplate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetTemplatePerformanceMetrics
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"name", "template_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetTemplatePerformanceMetrics(String nodeId, APIContext context) {
            super(context, nodeId, "/template_performance_metrics", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetTemplatePerformanceMetrics setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetTemplatePerformanceMetrics setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetTemplatePerformanceMetrics setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestGetTemplatePerformanceMetrics setTemplateId(String templateId) {
            this.setParam("template_id", templateId);
            return this;
        }

        public APIRequestGetTemplatePerformanceMetrics requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetTemplatePerformanceMetrics requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTemplatePerformanceMetrics requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetTemplatePerformanceMetrics requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTemplatePerformanceMetrics requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetTemplatePerformanceMetrics requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestCreateTemplateGroup
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"description", "name", "whatsapp_business_templates"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestCreateTemplateGroup(String nodeId, APIContext context) {
            super(context, nodeId, "/template_groups", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateTemplateGroup setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateTemplateGroup setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateTemplateGroup setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestCreateTemplateGroup setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreateTemplateGroup setWhatsappBusinessTemplates(List<String> whatsappBusinessTemplates) {
            this.setParam("whatsapp_business_templates", whatsappBusinessTemplates);
            return this;
        }

        public APIRequestCreateTemplateGroup setWhatsappBusinessTemplates(String whatsappBusinessTemplates) {
            this.setParam("whatsapp_business_templates", whatsappBusinessTemplates);
            return this;
        }

        public APIRequestCreateTemplateGroup requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateTemplateGroup requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateTemplateGroup requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateTemplateGroup requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateTemplateGroup requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateTemplateGroup requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetTemplateGroups
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetTemplateGroups(String nodeId, APIContext context) {
            super(context, nodeId, "/template_groups", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetTemplateGroups setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetTemplateGroups setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetTemplateGroups requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetTemplateGroups requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTemplateGroups requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetTemplateGroups requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTemplateGroups requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetTemplateGroups requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetTemplateGroupAnalytics
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"end", "granularity", "metric_types", "start", "template_group_ids"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetTemplateGroupAnalytics(String nodeId, APIContext context) {
            super(context, nodeId, "/template_group_analytics", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetTemplateGroupAnalytics setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetTemplateGroupAnalytics setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetTemplateGroupAnalytics setEnd(String end) {
            this.setParam("end", end);
            return this;
        }

        public APIRequestGetTemplateGroupAnalytics setGranularity(EnumGranularity granularity) {
            this.setParam("granularity", (Object)granularity);
            return this;
        }

        public APIRequestGetTemplateGroupAnalytics setGranularity(String granularity) {
            this.setParam("granularity", granularity);
            return this;
        }

        public APIRequestGetTemplateGroupAnalytics setMetricTypes(List<EnumMetricTypes> metricTypes) {
            this.setParam("metric_types", metricTypes);
            return this;
        }

        public APIRequestGetTemplateGroupAnalytics setMetricTypes(String metricTypes) {
            this.setParam("metric_types", metricTypes);
            return this;
        }

        public APIRequestGetTemplateGroupAnalytics setStart(String start) {
            this.setParam("start", start);
            return this;
        }

        public APIRequestGetTemplateGroupAnalytics setTemplateGroupIds(List<String> templateGroupIds) {
            this.setParam("template_group_ids", templateGroupIds);
            return this;
        }

        public APIRequestGetTemplateGroupAnalytics setTemplateGroupIds(String templateGroupIds) {
            this.setParam("template_group_ids", templateGroupIds);
            return this;
        }

        public APIRequestGetTemplateGroupAnalytics requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetTemplateGroupAnalytics requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTemplateGroupAnalytics requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetTemplateGroupAnalytics requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTemplateGroupAnalytics requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetTemplateGroupAnalytics requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetTemplateAnalytics
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"end", "granularity", "metric_types", "product_type", "start", "template_ids"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetTemplateAnalytics(String nodeId, APIContext context) {
            super(context, nodeId, "/template_analytics", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetTemplateAnalytics setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetTemplateAnalytics setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetTemplateAnalytics setEnd(String end) {
            this.setParam("end", end);
            return this;
        }

        public APIRequestGetTemplateAnalytics setGranularity(EnumGranularity granularity) {
            this.setParam("granularity", (Object)granularity);
            return this;
        }

        public APIRequestGetTemplateAnalytics setGranularity(String granularity) {
            this.setParam("granularity", granularity);
            return this;
        }

        public APIRequestGetTemplateAnalytics setMetricTypes(List<EnumMetricTypes> metricTypes) {
            this.setParam("metric_types", metricTypes);
            return this;
        }

        public APIRequestGetTemplateAnalytics setMetricTypes(String metricTypes) {
            this.setParam("metric_types", metricTypes);
            return this;
        }

        public APIRequestGetTemplateAnalytics setProductType(EnumProductType productType) {
            this.setParam("product_type", (Object)productType);
            return this;
        }

        public APIRequestGetTemplateAnalytics setProductType(String productType) {
            this.setParam("product_type", productType);
            return this;
        }

        public APIRequestGetTemplateAnalytics setStart(String start) {
            this.setParam("start", start);
            return this;
        }

        public APIRequestGetTemplateAnalytics setTemplateIds(List<String> templateIds) {
            this.setParam("template_ids", templateIds);
            return this;
        }

        public APIRequestGetTemplateAnalytics setTemplateIds(String templateIds) {
            this.setParam("template_ids", templateIds);
            return this;
        }

        public APIRequestGetTemplateAnalytics requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetTemplateAnalytics requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTemplateAnalytics requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetTemplateAnalytics requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetTemplateAnalytics requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetTemplateAnalytics requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestCreateSubscribedApp
    extends APIRequest<WhatsAppBusinessAccount> {
        WhatsAppBusinessAccount lastResponse = null;
        public static final String[] PARAMS = new String[]{"override_callback_uri", "verify_token"};
        public static final String[] FIELDS = new String[0];

        @Override
        public WhatsAppBusinessAccount getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public WhatsAppBusinessAccount parseResponse(String response, String header) throws APIException {
            return WhatsAppBusinessAccount.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public WhatsAppBusinessAccount execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public WhatsAppBusinessAccount execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<WhatsAppBusinessAccount> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<WhatsAppBusinessAccount> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, WhatsAppBusinessAccount>(){

                public WhatsAppBusinessAccount apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestCreateSubscribedApp(String nodeId, APIContext context) {
            super(context, nodeId, "/subscribed_apps", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateSubscribedApp setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateSubscribedApp setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateSubscribedApp setOverrideCallbackUri(String overrideCallbackUri) {
            this.setParam("override_callback_uri", overrideCallbackUri);
            return this;
        }

        public APIRequestCreateSubscribedApp setVerifyToken(String verifyToken) {
            this.setParam("verify_token", verifyToken);
            return this;
        }

        public APIRequestCreateSubscribedApp requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateSubscribedApp requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateSubscribedApp requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateSubscribedApp requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateSubscribedApp requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateSubscribedApp requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetSubscribedApps
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetSubscribedApps(String nodeId, APIContext context) {
            super(context, nodeId, "/subscribed_apps", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetSubscribedApps setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetSubscribedApps setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetSubscribedApps requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetSubscribedApps requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetSubscribedApps requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetSubscribedApps requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetSubscribedApps requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetSubscribedApps requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestDeleteSubscribedApps
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestDeleteSubscribedApps(String nodeId, APIContext context) {
            super(context, nodeId, "/subscribed_apps", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteSubscribedApps setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteSubscribedApps setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteSubscribedApps requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteSubscribedApps requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteSubscribedApps requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteSubscribedApps requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteSubscribedApps requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteSubscribedApps requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetSolutions
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetSolutions(String nodeId, APIContext context) {
            super(context, nodeId, "/solutions", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetSolutions setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetSolutions setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetSolutions requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetSolutions requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetSolutions requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetSolutions requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetSolutions requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetSolutions requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestCreateSetSolutionMigrationIntent
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"app_id", "solution_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestCreateSetSolutionMigrationIntent(String nodeId, APIContext context) {
            super(context, nodeId, "/set_solution_migration_intent", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateSetSolutionMigrationIntent setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateSetSolutionMigrationIntent setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateSetSolutionMigrationIntent setAppId(String appId) {
            this.setParam("app_id", appId);
            return this;
        }

        public APIRequestCreateSetSolutionMigrationIntent setSolutionId(String solutionId) {
            this.setParam("solution_id", solutionId);
            return this;
        }

        public APIRequestCreateSetSolutionMigrationIntent requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateSetSolutionMigrationIntent requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateSetSolutionMigrationIntent requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateSetSolutionMigrationIntent requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateSetSolutionMigrationIntent requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateSetSolutionMigrationIntent requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestCreateSetOboMobilityIntent
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"solution_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestCreateSetOboMobilityIntent(String nodeId, APIContext context) {
            super(context, nodeId, "/set_obo_mobility_intent", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateSetOboMobilityIntent setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateSetOboMobilityIntent setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateSetOboMobilityIntent setSolutionId(String solutionId) {
            this.setParam("solution_id", solutionId);
            return this;
        }

        public APIRequestCreateSetOboMobilityIntent requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateSetOboMobilityIntent requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateSetOboMobilityIntent requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateSetOboMobilityIntent requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateSetOboMobilityIntent requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateSetOboMobilityIntent requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetSchedules
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetSchedules(String nodeId, APIContext context) {
            super(context, nodeId, "/schedules", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetSchedules setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetSchedules setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetSchedules requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetSchedules requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetSchedules requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetSchedules requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetSchedules requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetSchedules requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestCreateProductCatalog
    extends APIRequest<ProductCatalog> {
        ProductCatalog lastResponse = null;
        public static final String[] PARAMS = new String[]{"catalog_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public ProductCatalog getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ProductCatalog parseResponse(String response, String header) throws APIException {
            return ProductCatalog.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public ProductCatalog execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ProductCatalog execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<ProductCatalog> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ProductCatalog> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, ProductCatalog>(){

                public ProductCatalog apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestCreateProductCatalog(String nodeId, APIContext context) {
            super(context, nodeId, "/product_catalogs", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateProductCatalog setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateProductCatalog setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateProductCatalog setCatalogId(String catalogId) {
            this.setParam("catalog_id", catalogId);
            return this;
        }

        public APIRequestCreateProductCatalog requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateProductCatalog requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateProductCatalog requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateProductCatalog requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateProductCatalog requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateProductCatalog requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetProductCatalogs
    extends APIRequest<ProductCatalog> {
        APINodeList<ProductCatalog> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"ad_account_to_collaborative_ads_share_settings", "agency_collaborative_ads_share_settings", "business", "catalog_store", "commerce_merchant_settings", "creator_user", "da_display_settings", "default_image_url", "fallback_image_url", "feed_count", "id", "is_catalog_segment", "is_local_catalog", "name", "owner_business", "product_count", "store_catalog_settings", "user_access_expire_time", "vertical"};

        @Override
        public APINodeList<ProductCatalog> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<ProductCatalog> parseResponse(String response, String header) throws APIException {
            return ProductCatalog.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<ProductCatalog> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<ProductCatalog> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<ProductCatalog>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<ProductCatalog>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<ProductCatalog>>(){

                public APINodeList<ProductCatalog> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetProductCatalogs(String nodeId, APIContext context) {
            super(context, nodeId, "/product_catalogs", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetProductCatalogs setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetProductCatalogs setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetProductCatalogs requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetProductCatalogs requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetProductCatalogs requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetProductCatalogs requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetProductCatalogs requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetProductCatalogs requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetProductCatalogs requestAdAccountToCollaborativeAdsShareSettingsField() {
            return this.requestAdAccountToCollaborativeAdsShareSettingsField(true);
        }

        public APIRequestGetProductCatalogs requestAdAccountToCollaborativeAdsShareSettingsField(boolean value) {
            this.requestField("ad_account_to_collaborative_ads_share_settings", value);
            return this;
        }

        public APIRequestGetProductCatalogs requestAgencyCollaborativeAdsShareSettingsField() {
            return this.requestAgencyCollaborativeAdsShareSettingsField(true);
        }

        public APIRequestGetProductCatalogs requestAgencyCollaborativeAdsShareSettingsField(boolean value) {
            this.requestField("agency_collaborative_ads_share_settings", value);
            return this;
        }

        public APIRequestGetProductCatalogs requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetProductCatalogs requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetProductCatalogs requestCatalogStoreField() {
            return this.requestCatalogStoreField(true);
        }

        public APIRequestGetProductCatalogs requestCatalogStoreField(boolean value) {
            this.requestField("catalog_store", value);
            return this;
        }

        public APIRequestGetProductCatalogs requestCommerceMerchantSettingsField() {
            return this.requestCommerceMerchantSettingsField(true);
        }

        public APIRequestGetProductCatalogs requestCommerceMerchantSettingsField(boolean value) {
            this.requestField("commerce_merchant_settings", value);
            return this;
        }

        public APIRequestGetProductCatalogs requestCreatorUserField() {
            return this.requestCreatorUserField(true);
        }

        public APIRequestGetProductCatalogs requestCreatorUserField(boolean value) {
            this.requestField("creator_user", value);
            return this;
        }

        public APIRequestGetProductCatalogs requestDaDisplaySettingsField() {
            return this.requestDaDisplaySettingsField(true);
        }

        public APIRequestGetProductCatalogs requestDaDisplaySettingsField(boolean value) {
            this.requestField("da_display_settings", value);
            return this;
        }

        public APIRequestGetProductCatalogs requestDefaultImageUrlField() {
            return this.requestDefaultImageUrlField(true);
        }

        public APIRequestGetProductCatalogs requestDefaultImageUrlField(boolean value) {
            this.requestField("default_image_url", value);
            return this;
        }

        public APIRequestGetProductCatalogs requestFallbackImageUrlField() {
            return this.requestFallbackImageUrlField(true);
        }

        public APIRequestGetProductCatalogs requestFallbackImageUrlField(boolean value) {
            this.requestField("fallback_image_url", value);
            return this;
        }

        public APIRequestGetProductCatalogs requestFeedCountField() {
            return this.requestFeedCountField(true);
        }

        public APIRequestGetProductCatalogs requestFeedCountField(boolean value) {
            this.requestField("feed_count", value);
            return this;
        }

        public APIRequestGetProductCatalogs requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetProductCatalogs requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetProductCatalogs requestIsCatalogSegmentField() {
            return this.requestIsCatalogSegmentField(true);
        }

        public APIRequestGetProductCatalogs requestIsCatalogSegmentField(boolean value) {
            this.requestField("is_catalog_segment", value);
            return this;
        }

        public APIRequestGetProductCatalogs requestIsLocalCatalogField() {
            return this.requestIsLocalCatalogField(true);
        }

        public APIRequestGetProductCatalogs requestIsLocalCatalogField(boolean value) {
            this.requestField("is_local_catalog", value);
            return this;
        }

        public APIRequestGetProductCatalogs requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetProductCatalogs requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetProductCatalogs requestOwnerBusinessField() {
            return this.requestOwnerBusinessField(true);
        }

        public APIRequestGetProductCatalogs requestOwnerBusinessField(boolean value) {
            this.requestField("owner_business", value);
            return this;
        }

        public APIRequestGetProductCatalogs requestProductCountField() {
            return this.requestProductCountField(true);
        }

        public APIRequestGetProductCatalogs requestProductCountField(boolean value) {
            this.requestField("product_count", value);
            return this;
        }

        public APIRequestGetProductCatalogs requestStoreCatalogSettingsField() {
            return this.requestStoreCatalogSettingsField(true);
        }

        public APIRequestGetProductCatalogs requestStoreCatalogSettingsField(boolean value) {
            this.requestField("store_catalog_settings", value);
            return this;
        }

        public APIRequestGetProductCatalogs requestUserAccessExpireTimeField() {
            return this.requestUserAccessExpireTimeField(true);
        }

        public APIRequestGetProductCatalogs requestUserAccessExpireTimeField(boolean value) {
            this.requestField("user_access_expire_time", value);
            return this;
        }

        public APIRequestGetProductCatalogs requestVerticalField() {
            return this.requestVerticalField(true);
        }

        public APIRequestGetProductCatalogs requestVerticalField(boolean value) {
            this.requestField("vertical", value);
            return this;
        }
    }

    public static class APIRequestDeleteProductCatalogs
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"catalog_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestDeleteProductCatalogs(String nodeId, APIContext context) {
            super(context, nodeId, "/product_catalogs", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteProductCatalogs setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteProductCatalogs setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteProductCatalogs setCatalogId(String catalogId) {
            this.setParam("catalog_id", catalogId);
            return this;
        }

        public APIRequestDeleteProductCatalogs requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteProductCatalogs requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteProductCatalogs requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteProductCatalogs requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteProductCatalogs requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteProductCatalogs requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetPricingAnalytics
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"country_codes", "dimensions", "end", "granularity", "metric_types", "phone_numbers", "pricing_categories", "pricing_types", "start", "tiers"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetPricingAnalytics(String nodeId, APIContext context) {
            super(context, nodeId, "/pricing_analytics", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPricingAnalytics setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPricingAnalytics setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPricingAnalytics setCountryCodes(List<String> countryCodes) {
            this.setParam("country_codes", countryCodes);
            return this;
        }

        public APIRequestGetPricingAnalytics setCountryCodes(String countryCodes) {
            this.setParam("country_codes", countryCodes);
            return this;
        }

        public APIRequestGetPricingAnalytics setDimensions(List<EnumDimensions> dimensions) {
            this.setParam("dimensions", dimensions);
            return this;
        }

        public APIRequestGetPricingAnalytics setDimensions(String dimensions) {
            this.setParam("dimensions", dimensions);
            return this;
        }

        public APIRequestGetPricingAnalytics setEnd(Long end) {
            this.setParam("end", end);
            return this;
        }

        public APIRequestGetPricingAnalytics setEnd(String end) {
            this.setParam("end", end);
            return this;
        }

        public APIRequestGetPricingAnalytics setGranularity(EnumGranularity granularity) {
            this.setParam("granularity", (Object)granularity);
            return this;
        }

        public APIRequestGetPricingAnalytics setGranularity(String granularity) {
            this.setParam("granularity", granularity);
            return this;
        }

        public APIRequestGetPricingAnalytics setMetricTypes(List<EnumMetricTypes> metricTypes) {
            this.setParam("metric_types", metricTypes);
            return this;
        }

        public APIRequestGetPricingAnalytics setMetricTypes(String metricTypes) {
            this.setParam("metric_types", metricTypes);
            return this;
        }

        public APIRequestGetPricingAnalytics setPhoneNumbers(List<String> phoneNumbers) {
            this.setParam("phone_numbers", phoneNumbers);
            return this;
        }

        public APIRequestGetPricingAnalytics setPhoneNumbers(String phoneNumbers) {
            this.setParam("phone_numbers", phoneNumbers);
            return this;
        }

        public APIRequestGetPricingAnalytics setPricingCategories(List<EnumPricingCategories> pricingCategories) {
            this.setParam("pricing_categories", pricingCategories);
            return this;
        }

        public APIRequestGetPricingAnalytics setPricingCategories(String pricingCategories) {
            this.setParam("pricing_categories", pricingCategories);
            return this;
        }

        public APIRequestGetPricingAnalytics setPricingTypes(List<EnumPricingTypes> pricingTypes) {
            this.setParam("pricing_types", pricingTypes);
            return this;
        }

        public APIRequestGetPricingAnalytics setPricingTypes(String pricingTypes) {
            this.setParam("pricing_types", pricingTypes);
            return this;
        }

        public APIRequestGetPricingAnalytics setStart(Long start) {
            this.setParam("start", start);
            return this;
        }

        public APIRequestGetPricingAnalytics setStart(String start) {
            this.setParam("start", start);
            return this;
        }

        public APIRequestGetPricingAnalytics setTiers(List<String> tiers) {
            this.setParam("tiers", tiers);
            return this;
        }

        public APIRequestGetPricingAnalytics setTiers(String tiers) {
            this.setParam("tiers", tiers);
            return this;
        }

        public APIRequestGetPricingAnalytics requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPricingAnalytics requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPricingAnalytics requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPricingAnalytics requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPricingAnalytics requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPricingAnalytics requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestCreatePhoneNumber
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"cc", "migrate_phone_number", "phone_number", "preverified_id", "verified_name"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestCreatePhoneNumber(String nodeId, APIContext context) {
            super(context, nodeId, "/phone_numbers", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreatePhoneNumber setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreatePhoneNumber setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreatePhoneNumber setCc(String cc) {
            this.setParam("cc", cc);
            return this;
        }

        public APIRequestCreatePhoneNumber setMigratePhoneNumber(Boolean migratePhoneNumber) {
            this.setParam("migrate_phone_number", migratePhoneNumber);
            return this;
        }

        public APIRequestCreatePhoneNumber setMigratePhoneNumber(String migratePhoneNumber) {
            this.setParam("migrate_phone_number", migratePhoneNumber);
            return this;
        }

        public APIRequestCreatePhoneNumber setPhoneNumber(String phoneNumber) {
            this.setParam("phone_number", phoneNumber);
            return this;
        }

        public APIRequestCreatePhoneNumber setPreverifiedId(String preverifiedId) {
            this.setParam("preverified_id", preverifiedId);
            return this;
        }

        public APIRequestCreatePhoneNumber setVerifiedName(String verifiedName) {
            this.setParam("verified_name", verifiedName);
            return this;
        }

        public APIRequestCreatePhoneNumber requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreatePhoneNumber requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreatePhoneNumber requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreatePhoneNumber requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreatePhoneNumber requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreatePhoneNumber requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetPhoneNumbers
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetPhoneNumbers(String nodeId, APIContext context) {
            super(context, nodeId, "/phone_numbers", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPhoneNumbers setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPhoneNumbers setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPhoneNumbers requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPhoneNumbers requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPhoneNumbers requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPhoneNumbers requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPhoneNumbers requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPhoneNumbers requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetPaymentConfigurations
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetPaymentConfigurations(String nodeId, APIContext context) {
            super(context, nodeId, "/payment_configurations", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPaymentConfigurations setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPaymentConfigurations setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPaymentConfigurations requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPaymentConfigurations requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPaymentConfigurations requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPaymentConfigurations requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPaymentConfigurations requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPaymentConfigurations requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestCreatePaymentConfiguration
    extends APIRequest<WhatsAppBusinessAccount> {
        WhatsAppBusinessAccount lastResponse = null;
        public static final String[] PARAMS = new String[]{"configuration_name", "data_endpoint_url", "merchant_category_code", "merchant_vpa", "provider_name", "purpose_code", "redirect_url"};
        public static final String[] FIELDS = new String[0];

        @Override
        public WhatsAppBusinessAccount getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public WhatsAppBusinessAccount parseResponse(String response, String header) throws APIException {
            return WhatsAppBusinessAccount.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public WhatsAppBusinessAccount execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public WhatsAppBusinessAccount execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<WhatsAppBusinessAccount> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<WhatsAppBusinessAccount> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, WhatsAppBusinessAccount>(){

                public WhatsAppBusinessAccount apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestCreatePaymentConfiguration(String nodeId, APIContext context) {
            super(context, nodeId, "/payment_configuration", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreatePaymentConfiguration setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreatePaymentConfiguration setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreatePaymentConfiguration setConfigurationName(String configurationName) {
            this.setParam("configuration_name", configurationName);
            return this;
        }

        public APIRequestCreatePaymentConfiguration setDataEndpointUrl(String dataEndpointUrl) {
            this.setParam("data_endpoint_url", dataEndpointUrl);
            return this;
        }

        public APIRequestCreatePaymentConfiguration setMerchantCategoryCode(String merchantCategoryCode) {
            this.setParam("merchant_category_code", merchantCategoryCode);
            return this;
        }

        public APIRequestCreatePaymentConfiguration setMerchantVpa(String merchantVpa) {
            this.setParam("merchant_vpa", merchantVpa);
            return this;
        }

        public APIRequestCreatePaymentConfiguration setProviderName(EnumProviderName providerName) {
            this.setParam("provider_name", (Object)providerName);
            return this;
        }

        public APIRequestCreatePaymentConfiguration setProviderName(String providerName) {
            this.setParam("provider_name", providerName);
            return this;
        }

        public APIRequestCreatePaymentConfiguration setPurposeCode(String purposeCode) {
            this.setParam("purpose_code", purposeCode);
            return this;
        }

        public APIRequestCreatePaymentConfiguration setRedirectUrl(String redirectUrl) {
            this.setParam("redirect_url", redirectUrl);
            return this;
        }

        public APIRequestCreatePaymentConfiguration requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreatePaymentConfiguration requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreatePaymentConfiguration requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreatePaymentConfiguration requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreatePaymentConfiguration requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreatePaymentConfiguration requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetPaymentConfiguration
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"configuration_name"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetPaymentConfiguration(String nodeId, APIContext context) {
            super(context, nodeId, "/payment_configuration", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPaymentConfiguration setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPaymentConfiguration setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPaymentConfiguration setConfigurationName(String configurationName) {
            this.setParam("configuration_name", configurationName);
            return this;
        }

        public APIRequestGetPaymentConfiguration requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPaymentConfiguration requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPaymentConfiguration requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPaymentConfiguration requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPaymentConfiguration requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPaymentConfiguration requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestDeletePaymentConfiguration
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"configuration_name"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestDeletePaymentConfiguration(String nodeId, APIContext context) {
            super(context, nodeId, "/payment_configuration", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeletePaymentConfiguration setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeletePaymentConfiguration setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeletePaymentConfiguration setConfigurationName(String configurationName) {
            this.setParam("configuration_name", configurationName);
            return this;
        }

        public APIRequestDeletePaymentConfiguration requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeletePaymentConfiguration requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeletePaymentConfiguration requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeletePaymentConfiguration requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeletePaymentConfiguration requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeletePaymentConfiguration requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestCreateMigrateMessageTemplate
    extends APIRequest<WhatsAppBusinessAccount> {
        WhatsAppBusinessAccount lastResponse = null;
        public static final String[] PARAMS = new String[]{"page_number", "source_waba_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public WhatsAppBusinessAccount getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public WhatsAppBusinessAccount parseResponse(String response, String header) throws APIException {
            return WhatsAppBusinessAccount.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public WhatsAppBusinessAccount execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public WhatsAppBusinessAccount execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<WhatsAppBusinessAccount> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<WhatsAppBusinessAccount> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, WhatsAppBusinessAccount>(){

                public WhatsAppBusinessAccount apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestCreateMigrateMessageTemplate(String nodeId, APIContext context) {
            super(context, nodeId, "/migrate_message_templates", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateMigrateMessageTemplate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateMigrateMessageTemplate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateMigrateMessageTemplate setPageNumber(Long pageNumber) {
            this.setParam("page_number", pageNumber);
            return this;
        }

        public APIRequestCreateMigrateMessageTemplate setPageNumber(String pageNumber) {
            this.setParam("page_number", pageNumber);
            return this;
        }

        public APIRequestCreateMigrateMessageTemplate setSourceWabaId(String sourceWabaId) {
            this.setParam("source_waba_id", sourceWabaId);
            return this;
        }

        public APIRequestCreateMigrateMessageTemplate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateMigrateMessageTemplate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateMigrateMessageTemplate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateMigrateMessageTemplate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateMigrateMessageTemplate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateMigrateMessageTemplate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestCreateMigrateFlow
    extends APIRequest<WhatsAppBusinessAccount> {
        WhatsAppBusinessAccount lastResponse = null;
        public static final String[] PARAMS = new String[]{"source_flow_names", "source_waba_id"};
        public static final String[] FIELDS = new String[0];

        @Override
        public WhatsAppBusinessAccount getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public WhatsAppBusinessAccount parseResponse(String response, String header) throws APIException {
            return WhatsAppBusinessAccount.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public WhatsAppBusinessAccount execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public WhatsAppBusinessAccount execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<WhatsAppBusinessAccount> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<WhatsAppBusinessAccount> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, WhatsAppBusinessAccount>(){

                public WhatsAppBusinessAccount apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestCreateMigrateFlow(String nodeId, APIContext context) {
            super(context, nodeId, "/migrate_flows", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateMigrateFlow setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateMigrateFlow setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateMigrateFlow setSourceFlowNames(List<String> sourceFlowNames) {
            this.setParam("source_flow_names", sourceFlowNames);
            return this;
        }

        public APIRequestCreateMigrateFlow setSourceFlowNames(String sourceFlowNames) {
            this.setParam("source_flow_names", sourceFlowNames);
            return this;
        }

        public APIRequestCreateMigrateFlow setSourceWabaId(String sourceWabaId) {
            this.setParam("source_waba_id", sourceWabaId);
            return this;
        }

        public APIRequestCreateMigrateFlow requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateMigrateFlow requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateMigrateFlow requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateMigrateFlow requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateMigrateFlow requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateMigrateFlow requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestCreateMessageTemplate
    extends APIRequest<WhatsAppBusinessAccount> {
        WhatsAppBusinessAccount lastResponse = null;
        public static final String[] PARAMS = new String[]{"allow_category_change", "category", "components", "cta_url_link_tracking_opted_out", "degrees_of_freedom_spec", "display_format", "language", "library_template_body_inputs", "library_template_button_inputs", "library_template_name", "message_send_ttl_seconds", "name", "parameter_format", "sub_category"};
        public static final String[] FIELDS = new String[0];

        @Override
        public WhatsAppBusinessAccount getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public WhatsAppBusinessAccount parseResponse(String response, String header) throws APIException {
            return WhatsAppBusinessAccount.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public WhatsAppBusinessAccount execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public WhatsAppBusinessAccount execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<WhatsAppBusinessAccount> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<WhatsAppBusinessAccount> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, WhatsAppBusinessAccount>(){

                public WhatsAppBusinessAccount apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestCreateMessageTemplate(String nodeId, APIContext context) {
            super(context, nodeId, "/message_templates", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateMessageTemplate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateMessageTemplate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateMessageTemplate setAllowCategoryChange(Boolean allowCategoryChange) {
            this.setParam("allow_category_change", allowCategoryChange);
            return this;
        }

        public APIRequestCreateMessageTemplate setAllowCategoryChange(String allowCategoryChange) {
            this.setParam("allow_category_change", allowCategoryChange);
            return this;
        }

        public APIRequestCreateMessageTemplate setCategory(EnumCategory category) {
            this.setParam("category", (Object)category);
            return this;
        }

        public APIRequestCreateMessageTemplate setCategory(String category) {
            this.setParam("category", category);
            return this;
        }

        public APIRequestCreateMessageTemplate setComponents(List<Map<String, String>> components) {
            this.setParam("components", components);
            return this;
        }

        public APIRequestCreateMessageTemplate setComponents(String components) {
            this.setParam("components", components);
            return this;
        }

        public APIRequestCreateMessageTemplate setCtaUrlLinkTrackingOptedOut(Boolean ctaUrlLinkTrackingOptedOut) {
            this.setParam("cta_url_link_tracking_opted_out", ctaUrlLinkTrackingOptedOut);
            return this;
        }

        public APIRequestCreateMessageTemplate setCtaUrlLinkTrackingOptedOut(String ctaUrlLinkTrackingOptedOut) {
            this.setParam("cta_url_link_tracking_opted_out", ctaUrlLinkTrackingOptedOut);
            return this;
        }

        public APIRequestCreateMessageTemplate setDegreesOfFreedomSpec(Map<String, String> degreesOfFreedomSpec) {
            this.setParam("degrees_of_freedom_spec", degreesOfFreedomSpec);
            return this;
        }

        public APIRequestCreateMessageTemplate setDegreesOfFreedomSpec(String degreesOfFreedomSpec) {
            this.setParam("degrees_of_freedom_spec", degreesOfFreedomSpec);
            return this;
        }

        public APIRequestCreateMessageTemplate setDisplayFormat(EnumDisplayFormat displayFormat) {
            this.setParam("display_format", (Object)displayFormat);
            return this;
        }

        public APIRequestCreateMessageTemplate setDisplayFormat(String displayFormat) {
            this.setParam("display_format", displayFormat);
            return this;
        }

        public APIRequestCreateMessageTemplate setLanguage(String language) {
            this.setParam("language", language);
            return this;
        }

        public APIRequestCreateMessageTemplate setLibraryTemplateBodyInputs(Map<String, String> libraryTemplateBodyInputs) {
            this.setParam("library_template_body_inputs", libraryTemplateBodyInputs);
            return this;
        }

        public APIRequestCreateMessageTemplate setLibraryTemplateBodyInputs(String libraryTemplateBodyInputs) {
            this.setParam("library_template_body_inputs", libraryTemplateBodyInputs);
            return this;
        }

        public APIRequestCreateMessageTemplate setLibraryTemplateButtonInputs(List<Map<String, String>> libraryTemplateButtonInputs) {
            this.setParam("library_template_button_inputs", libraryTemplateButtonInputs);
            return this;
        }

        public APIRequestCreateMessageTemplate setLibraryTemplateButtonInputs(String libraryTemplateButtonInputs) {
            this.setParam("library_template_button_inputs", libraryTemplateButtonInputs);
            return this;
        }

        public APIRequestCreateMessageTemplate setLibraryTemplateName(String libraryTemplateName) {
            this.setParam("library_template_name", libraryTemplateName);
            return this;
        }

        public APIRequestCreateMessageTemplate setMessageSendTtlSeconds(Long messageSendTtlSeconds) {
            this.setParam("message_send_ttl_seconds", messageSendTtlSeconds);
            return this;
        }

        public APIRequestCreateMessageTemplate setMessageSendTtlSeconds(String messageSendTtlSeconds) {
            this.setParam("message_send_ttl_seconds", messageSendTtlSeconds);
            return this;
        }

        public APIRequestCreateMessageTemplate setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreateMessageTemplate setParameterFormat(EnumParameterFormat parameterFormat) {
            this.setParam("parameter_format", (Object)parameterFormat);
            return this;
        }

        public APIRequestCreateMessageTemplate setParameterFormat(String parameterFormat) {
            this.setParam("parameter_format", parameterFormat);
            return this;
        }

        public APIRequestCreateMessageTemplate setSubCategory(EnumSubCategory subCategory) {
            this.setParam("sub_category", (Object)subCategory);
            return this;
        }

        public APIRequestCreateMessageTemplate setSubCategory(String subCategory) {
            this.setParam("sub_category", subCategory);
            return this;
        }

        public APIRequestCreateMessageTemplate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateMessageTemplate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateMessageTemplate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateMessageTemplate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateMessageTemplate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateMessageTemplate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetMessageTemplates
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"category", "content", "language", "name", "name_or_content", "quality_score", "status"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetMessageTemplates(String nodeId, APIContext context) {
            super(context, nodeId, "/message_templates", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetMessageTemplates setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetMessageTemplates setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetMessageTemplates setCategory(List<EnumCategory> category) {
            this.setParam("category", category);
            return this;
        }

        public APIRequestGetMessageTemplates setCategory(String category) {
            this.setParam("category", category);
            return this;
        }

        public APIRequestGetMessageTemplates setContent(String content) {
            this.setParam("content", content);
            return this;
        }

        public APIRequestGetMessageTemplates setLanguage(List<String> language) {
            this.setParam("language", language);
            return this;
        }

        public APIRequestGetMessageTemplates setLanguage(String language) {
            this.setParam("language", language);
            return this;
        }

        public APIRequestGetMessageTemplates setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestGetMessageTemplates setNameOrContent(String nameOrContent) {
            this.setParam("name_or_content", nameOrContent);
            return this;
        }

        public APIRequestGetMessageTemplates setQualityScore(List<EnumQualityScore> qualityScore) {
            this.setParam("quality_score", qualityScore);
            return this;
        }

        public APIRequestGetMessageTemplates setQualityScore(String qualityScore) {
            this.setParam("quality_score", qualityScore);
            return this;
        }

        public APIRequestGetMessageTemplates setStatus(List<EnumStatus> status) {
            this.setParam("status", status);
            return this;
        }

        public APIRequestGetMessageTemplates setStatus(String status) {
            this.setParam("status", status);
            return this;
        }

        public APIRequestGetMessageTemplates requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetMessageTemplates requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetMessageTemplates requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetMessageTemplates requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetMessageTemplates requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetMessageTemplates requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestDeleteMessageTemplates
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"hsm_id", "name"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestDeleteMessageTemplates(String nodeId, APIContext context) {
            super(context, nodeId, "/message_templates", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteMessageTemplates setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteMessageTemplates setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteMessageTemplates setHsmId(String hsmId) {
            this.setParam("hsm_id", hsmId);
            return this;
        }

        public APIRequestDeleteMessageTemplates setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestDeleteMessageTemplates requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteMessageTemplates requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteMessageTemplates requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteMessageTemplates requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteMessageTemplates requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteMessageTemplates requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetMessageTemplatePreviews
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"add_security_recommendation", "button_types", "category", "code_expiration_minutes", "languages"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetMessageTemplatePreviews(String nodeId, APIContext context) {
            super(context, nodeId, "/message_template_previews", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetMessageTemplatePreviews setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetMessageTemplatePreviews setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetMessageTemplatePreviews setAddSecurityRecommendation(Boolean addSecurityRecommendation) {
            this.setParam("add_security_recommendation", addSecurityRecommendation);
            return this;
        }

        public APIRequestGetMessageTemplatePreviews setAddSecurityRecommendation(String addSecurityRecommendation) {
            this.setParam("add_security_recommendation", addSecurityRecommendation);
            return this;
        }

        public APIRequestGetMessageTemplatePreviews setButtonTypes(List<EnumButtonTypes> buttonTypes) {
            this.setParam("button_types", buttonTypes);
            return this;
        }

        public APIRequestGetMessageTemplatePreviews setButtonTypes(String buttonTypes) {
            this.setParam("button_types", buttonTypes);
            return this;
        }

        public APIRequestGetMessageTemplatePreviews setCategory(EnumCategory category) {
            this.setParam("category", (Object)category);
            return this;
        }

        public APIRequestGetMessageTemplatePreviews setCategory(String category) {
            this.setParam("category", category);
            return this;
        }

        public APIRequestGetMessageTemplatePreviews setCodeExpirationMinutes(Long codeExpirationMinutes) {
            this.setParam("code_expiration_minutes", codeExpirationMinutes);
            return this;
        }

        public APIRequestGetMessageTemplatePreviews setCodeExpirationMinutes(String codeExpirationMinutes) {
            this.setParam("code_expiration_minutes", codeExpirationMinutes);
            return this;
        }

        public APIRequestGetMessageTemplatePreviews setLanguages(List<String> languages) {
            this.setParam("languages", languages);
            return this;
        }

        public APIRequestGetMessageTemplatePreviews setLanguages(String languages) {
            this.setParam("languages", languages);
            return this;
        }

        public APIRequestGetMessageTemplatePreviews requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetMessageTemplatePreviews requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetMessageTemplatePreviews requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetMessageTemplatePreviews requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetMessageTemplatePreviews requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetMessageTemplatePreviews requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetMessageCampaigns
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetMessageCampaigns(String nodeId, APIContext context) {
            super(context, nodeId, "/message_campaigns", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetMessageCampaigns setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetMessageCampaigns setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetMessageCampaigns requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetMessageCampaigns requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetMessageCampaigns requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetMessageCampaigns requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetMessageCampaigns requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetMessageCampaigns requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestCreateGeneratePaymentConfigurationOauthLink
    extends APIRequest<WhatsAppBusinessAccount> {
        WhatsAppBusinessAccount lastResponse = null;
        public static final String[] PARAMS = new String[]{"configuration_name", "redirect_url"};
        public static final String[] FIELDS = new String[0];

        @Override
        public WhatsAppBusinessAccount getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public WhatsAppBusinessAccount parseResponse(String response, String header) throws APIException {
            return WhatsAppBusinessAccount.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public WhatsAppBusinessAccount execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public WhatsAppBusinessAccount execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<WhatsAppBusinessAccount> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<WhatsAppBusinessAccount> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, WhatsAppBusinessAccount>(){

                public WhatsAppBusinessAccount apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestCreateGeneratePaymentConfigurationOauthLink(String nodeId, APIContext context) {
            super(context, nodeId, "/generate_payment_configuration_oauth_link", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateGeneratePaymentConfigurationOauthLink setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateGeneratePaymentConfigurationOauthLink setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateGeneratePaymentConfigurationOauthLink setConfigurationName(String configurationName) {
            this.setParam("configuration_name", configurationName);
            return this;
        }

        public APIRequestCreateGeneratePaymentConfigurationOauthLink setRedirectUrl(String redirectUrl) {
            this.setParam("redirect_url", redirectUrl);
            return this;
        }

        public APIRequestCreateGeneratePaymentConfigurationOauthLink requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateGeneratePaymentConfigurationOauthLink requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateGeneratePaymentConfigurationOauthLink requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateGeneratePaymentConfigurationOauthLink requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateGeneratePaymentConfigurationOauthLink requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateGeneratePaymentConfigurationOauthLink requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestCreateFlow
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[]{"categories", "clone_flow_id", "endpoint_uri", "flow_json", "name", "publish"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestCreateFlow(String nodeId, APIContext context) {
            super(context, nodeId, "/flows", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateFlow setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateFlow setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateFlow setCategories(List<EnumCategories> categories) {
            this.setParam("categories", categories);
            return this;
        }

        public APIRequestCreateFlow setCategories(String categories) {
            this.setParam("categories", categories);
            return this;
        }

        public APIRequestCreateFlow setCloneFlowId(String cloneFlowId) {
            this.setParam("clone_flow_id", cloneFlowId);
            return this;
        }

        public APIRequestCreateFlow setEndpointUri(String endpointUri) {
            this.setParam("endpoint_uri", endpointUri);
            return this;
        }

        public APIRequestCreateFlow setFlowJson(String flowJson) {
            this.setParam("flow_json", flowJson);
            return this;
        }

        public APIRequestCreateFlow setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreateFlow setPublish(Boolean publish) {
            this.setParam("publish", publish);
            return this;
        }

        public APIRequestCreateFlow setPublish(String publish) {
            this.setParam("publish", publish);
            return this;
        }

        public APIRequestCreateFlow requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateFlow requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateFlow requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateFlow requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateFlow requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateFlow requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetFlows
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetFlows(String nodeId, APIContext context) {
            super(context, nodeId, "/flows", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetFlows setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetFlows setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetFlows requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetFlows requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetFlows requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetFlows requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetFlows requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetFlows requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestCreateDataset
    extends APIRequest<Dataset> {
        Dataset lastResponse = null;
        public static final String[] PARAMS = new String[]{"dataset_name"};
        public static final String[] FIELDS = new String[0];

        @Override
        public Dataset getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Dataset parseResponse(String response, String header) throws APIException {
            return Dataset.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public Dataset execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Dataset execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<Dataset> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Dataset> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, Dataset>(){

                public Dataset apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestCreateDataset(String nodeId, APIContext context) {
            super(context, nodeId, "/dataset", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateDataset setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateDataset setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateDataset setDatasetName(String datasetName) {
            this.setParam("dataset_name", datasetName);
            return this;
        }

        public APIRequestCreateDataset requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateDataset requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateDataset requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateDataset requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateDataset requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateDataset requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetDataset
    extends APIRequest<Dataset> {
        APINodeList<Dataset> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"id", "name"};

        @Override
        public APINodeList<Dataset> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Dataset> parseResponse(String response, String header) throws APIException {
            return Dataset.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Dataset> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Dataset> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Dataset>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Dataset>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Dataset>>(){

                public APINodeList<Dataset> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetDataset(String nodeId, APIContext context) {
            super(context, nodeId, "/dataset", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetDataset setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetDataset setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetDataset requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetDataset requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetDataset requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetDataset requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetDataset requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetDataset requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetDataset requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetDataset requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetDataset requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetDataset requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }
    }

    public static class APIRequestGetConversationAnalytics
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"conversation_categories", "conversation_directions", "conversation_types", "country_codes", "dimensions", "end", "granularity", "metric_types", "phone_numbers", "start"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetConversationAnalytics(String nodeId, APIContext context) {
            super(context, nodeId, "/conversation_analytics", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetConversationAnalytics setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetConversationAnalytics setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetConversationAnalytics setConversationCategories(List<EnumConversationCategories> conversationCategories) {
            this.setParam("conversation_categories", conversationCategories);
            return this;
        }

        public APIRequestGetConversationAnalytics setConversationCategories(String conversationCategories) {
            this.setParam("conversation_categories", conversationCategories);
            return this;
        }

        public APIRequestGetConversationAnalytics setConversationDirections(List<EnumConversationDirections> conversationDirections) {
            this.setParam("conversation_directions", conversationDirections);
            return this;
        }

        public APIRequestGetConversationAnalytics setConversationDirections(String conversationDirections) {
            this.setParam("conversation_directions", conversationDirections);
            return this;
        }

        public APIRequestGetConversationAnalytics setConversationTypes(List<EnumConversationTypes> conversationTypes) {
            this.setParam("conversation_types", conversationTypes);
            return this;
        }

        public APIRequestGetConversationAnalytics setConversationTypes(String conversationTypes) {
            this.setParam("conversation_types", conversationTypes);
            return this;
        }

        public APIRequestGetConversationAnalytics setCountryCodes(List<String> countryCodes) {
            this.setParam("country_codes", countryCodes);
            return this;
        }

        public APIRequestGetConversationAnalytics setCountryCodes(String countryCodes) {
            this.setParam("country_codes", countryCodes);
            return this;
        }

        public APIRequestGetConversationAnalytics setDimensions(List<EnumDimensions> dimensions) {
            this.setParam("dimensions", dimensions);
            return this;
        }

        public APIRequestGetConversationAnalytics setDimensions(String dimensions) {
            this.setParam("dimensions", dimensions);
            return this;
        }

        public APIRequestGetConversationAnalytics setEnd(Long end) {
            this.setParam("end", end);
            return this;
        }

        public APIRequestGetConversationAnalytics setEnd(String end) {
            this.setParam("end", end);
            return this;
        }

        public APIRequestGetConversationAnalytics setGranularity(EnumGranularity granularity) {
            this.setParam("granularity", (Object)granularity);
            return this;
        }

        public APIRequestGetConversationAnalytics setGranularity(String granularity) {
            this.setParam("granularity", granularity);
            return this;
        }

        public APIRequestGetConversationAnalytics setMetricTypes(List<EnumMetricTypes> metricTypes) {
            this.setParam("metric_types", metricTypes);
            return this;
        }

        public APIRequestGetConversationAnalytics setMetricTypes(String metricTypes) {
            this.setParam("metric_types", metricTypes);
            return this;
        }

        public APIRequestGetConversationAnalytics setPhoneNumbers(List<String> phoneNumbers) {
            this.setParam("phone_numbers", phoneNumbers);
            return this;
        }

        public APIRequestGetConversationAnalytics setPhoneNumbers(String phoneNumbers) {
            this.setParam("phone_numbers", phoneNumbers);
            return this;
        }

        public APIRequestGetConversationAnalytics setStart(Long start) {
            this.setParam("start", start);
            return this;
        }

        public APIRequestGetConversationAnalytics setStart(String start) {
            this.setParam("start", start);
            return this;
        }

        public APIRequestGetConversationAnalytics requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetConversationAnalytics requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetConversationAnalytics requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetConversationAnalytics requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetConversationAnalytics requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetConversationAnalytics requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetCallAnalytics
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"country_codes", "dimensions", "directions", "end", "granularity", "metric_types", "phone_numbers", "start"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetCallAnalytics(String nodeId, APIContext context) {
            super(context, nodeId, "/call_analytics", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetCallAnalytics setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetCallAnalytics setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetCallAnalytics setCountryCodes(List<String> countryCodes) {
            this.setParam("country_codes", countryCodes);
            return this;
        }

        public APIRequestGetCallAnalytics setCountryCodes(String countryCodes) {
            this.setParam("country_codes", countryCodes);
            return this;
        }

        public APIRequestGetCallAnalytics setDimensions(List<EnumDimensions> dimensions) {
            this.setParam("dimensions", dimensions);
            return this;
        }

        public APIRequestGetCallAnalytics setDimensions(String dimensions) {
            this.setParam("dimensions", dimensions);
            return this;
        }

        public APIRequestGetCallAnalytics setDirections(List<EnumDirections> directions) {
            this.setParam("directions", directions);
            return this;
        }

        public APIRequestGetCallAnalytics setDirections(String directions) {
            this.setParam("directions", directions);
            return this;
        }

        public APIRequestGetCallAnalytics setEnd(Long end) {
            this.setParam("end", end);
            return this;
        }

        public APIRequestGetCallAnalytics setEnd(String end) {
            this.setParam("end", end);
            return this;
        }

        public APIRequestGetCallAnalytics setGranularity(EnumGranularity granularity) {
            this.setParam("granularity", (Object)granularity);
            return this;
        }

        public APIRequestGetCallAnalytics setGranularity(String granularity) {
            this.setParam("granularity", granularity);
            return this;
        }

        public APIRequestGetCallAnalytics setMetricTypes(List<EnumMetricTypes> metricTypes) {
            this.setParam("metric_types", metricTypes);
            return this;
        }

        public APIRequestGetCallAnalytics setMetricTypes(String metricTypes) {
            this.setParam("metric_types", metricTypes);
            return this;
        }

        public APIRequestGetCallAnalytics setPhoneNumbers(List<String> phoneNumbers) {
            this.setParam("phone_numbers", phoneNumbers);
            return this;
        }

        public APIRequestGetCallAnalytics setPhoneNumbers(String phoneNumbers) {
            this.setParam("phone_numbers", phoneNumbers);
            return this;
        }

        public APIRequestGetCallAnalytics setStart(Long start) {
            this.setParam("start", start);
            return this;
        }

        public APIRequestGetCallAnalytics setStart(String start) {
            this.setParam("start", start);
            return this;
        }

        public APIRequestGetCallAnalytics requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetCallAnalytics requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCallAnalytics requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetCallAnalytics requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCallAnalytics requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetCallAnalytics requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetAudiences
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetAudiences(String nodeId, APIContext context) {
            super(context, nodeId, "/audiences", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAudiences setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAudiences setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAudiences requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAudiences requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAudiences requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAudiences requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAudiences requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAudiences requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestCreateAssignedUser
    extends APIRequest<WhatsAppBusinessAccount> {
        WhatsAppBusinessAccount lastResponse = null;
        public static final String[] PARAMS = new String[]{"tasks", "user"};
        public static final String[] FIELDS = new String[0];

        @Override
        public WhatsAppBusinessAccount getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public WhatsAppBusinessAccount parseResponse(String response, String header) throws APIException {
            return WhatsAppBusinessAccount.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public WhatsAppBusinessAccount execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public WhatsAppBusinessAccount execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<WhatsAppBusinessAccount> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<WhatsAppBusinessAccount> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, WhatsAppBusinessAccount>(){

                public WhatsAppBusinessAccount apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestCreateAssignedUser(String nodeId, APIContext context) {
            super(context, nodeId, "/assigned_users", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateAssignedUser setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateAssignedUser setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateAssignedUser setTasks(List<EnumTasks> tasks) {
            this.setParam("tasks", tasks);
            return this;
        }

        public APIRequestCreateAssignedUser setTasks(String tasks) {
            this.setParam("tasks", tasks);
            return this;
        }

        public APIRequestCreateAssignedUser setUser(Long user) {
            this.setParam("user", user);
            return this;
        }

        public APIRequestCreateAssignedUser setUser(String user) {
            this.setParam("user", user);
            return this;
        }

        public APIRequestCreateAssignedUser requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateAssignedUser requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAssignedUser requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateAssignedUser requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateAssignedUser requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateAssignedUser requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetAssignedUsers
    extends APIRequest<AssignedUser> {
        APINodeList<AssignedUser> lastResponse = null;
        public static final String[] PARAMS = new String[]{"business"};
        public static final String[] FIELDS = new String[]{"business", "id", "name", "user_type"};

        @Override
        public APINodeList<AssignedUser> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AssignedUser> parseResponse(String response, String header) throws APIException {
            return AssignedUser.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AssignedUser> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AssignedUser> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AssignedUser>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AssignedUser>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<AssignedUser>>(){

                public APINodeList<AssignedUser> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetAssignedUsers(String nodeId, APIContext context) {
            super(context, nodeId, "/assigned_users", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetAssignedUsers setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetAssignedUsers setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetAssignedUsers setBusiness(String business) {
            this.setParam("business", business);
            return this;
        }

        public APIRequestGetAssignedUsers requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetAssignedUsers requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAssignedUsers requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetAssignedUsers requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetAssignedUsers requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetAssignedUsers requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetAssignedUsers requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetAssignedUsers requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetAssignedUsers requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetAssignedUsers requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetAssignedUsers requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetAssignedUsers requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetAssignedUsers requestUserTypeField() {
            return this.requestUserTypeField(true);
        }

        public APIRequestGetAssignedUsers requestUserTypeField(boolean value) {
            this.requestField("user_type", value);
            return this;
        }
    }

    public static class APIRequestDeleteAssignedUsers
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[]{"user"};
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestDeleteAssignedUsers(String nodeId, APIContext context) {
            super(context, nodeId, "/assigned_users", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDeleteAssignedUsers setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDeleteAssignedUsers setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDeleteAssignedUsers setUser(Long user) {
            this.setParam("user", user);
            return this;
        }

        public APIRequestDeleteAssignedUsers setUser(String user) {
            this.setParam("user", user);
            return this;
        }

        public APIRequestDeleteAssignedUsers requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDeleteAssignedUsers requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteAssignedUsers requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDeleteAssignedUsers requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDeleteAssignedUsers requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDeleteAssignedUsers requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetActivities
    extends APIRequest<APINode> {
        APINodeList<APINode> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINodeList<APINode> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<APINode> parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header);
        }

        @Override
        public APINodeList<APINode> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<APINode> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<APINode>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<APINode>>(){

                public APINodeList<APINode> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetActivities(String nodeId, APIContext context) {
            super(context, nodeId, "/activities", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetActivities setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetActivities setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetActivities requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetActivities requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetActivities requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetActivities requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetActivities requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetActivities requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

