/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.InsightsResult;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class Stories
extends APINode {
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="media_id")
    private String mMediaId = null;
    @SerializedName(value="media_type")
    private String mMediaType = null;
    @SerializedName(value="post_id")
    private String mPostId = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="url")
    private String mUrl = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    Stories() {
    }

    public Stories(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public Stories(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public Stories fetch() throws APIException {
        Stories newInstance = Stories.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static Stories fetchById(Long id, APIContext context) throws APIException {
        return Stories.fetchById(id.toString(), context);
    }

    public static ListenableFuture<Stories> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return Stories.fetchByIdAsync(id.toString(), context);
    }

    public static Stories fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<Stories> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<Stories> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<Stories>(context, "", "/", "GET", Stories.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<Stories>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<Stories>(context, "", "/", "GET", Stories.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static Stories loadJSON(String json, APIContext context, String header) {
        Stories stories = (Stories)Stories.getGson().fromJson(json, Stories.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(stories.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        stories.context = context;
        stories.rawValue = json;
        stories.header = header;
        return stories;
    }

    public static APINodeList<Stories> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<Stories> storiess = new APINodeList<Stories>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        storiess.add(Stories.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return storiess;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            storiess.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        storiess.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            storiess.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            storiess.add(Stories.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                storiess.add(Stories.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            storiess.add(Stories.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return storiess;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        storiess.add(Stories.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return storiess;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        storiess.add(Stories.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return storiess;
                }
                storiess.clear();
                storiess.add(Stories.loadJSON(json, context, header));
                return storiess;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return Stories.getGson().toJson((Object)this);
    }

    public APIRequestGetInsights getInsights() {
        return new APIRequestGetInsights(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public String getFieldMediaId() {
        return this.mMediaId;
    }

    public String getFieldMediaType() {
        return this.mMediaType;
    }

    public String getFieldPostId() {
        return this.mPostId;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public String getFieldUrl() {
        return this.mUrl;
    }

    public String getFieldId() {
        return this.mId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public Stories copyFrom(Stories instance) {
        this.mCreationTime = instance.mCreationTime;
        this.mMediaId = instance.mMediaId;
        this.mMediaType = instance.mMediaType;
        this.mPostId = instance.mPostId;
        this.mStatus = instance.mStatus;
        this.mUrl = instance.mUrl;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<Stories> getParser() {
        return new APIRequest.ResponseParser<Stories>(){

            @Override
            public APINodeList<Stories> parseResponse(String response, APIContext context, APIRequest<Stories> request, String header) throws APIException.MalformedResponseException {
                return Stories.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumStatus {
        VALUE_ARCHIVED("ARCHIVED"),
        VALUE_PUBLISHED("PUBLISHED");

        private String value;

        private EnumStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestGet
    extends APIRequest<Stories> {
        Stories lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"creation_time", "media_id", "media_type", "post_id", "status", "url", "id"};

        @Override
        public Stories getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Stories parseResponse(String response, String header) throws APIException {
            return Stories.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public Stories execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Stories execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<Stories> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Stories> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, Stories>(){

                public Stories apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGet requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGet requestMediaIdField() {
            return this.requestMediaIdField(true);
        }

        public APIRequestGet requestMediaIdField(boolean value) {
            this.requestField("media_id", value);
            return this;
        }

        public APIRequestGet requestMediaTypeField() {
            return this.requestMediaTypeField(true);
        }

        public APIRequestGet requestMediaTypeField(boolean value) {
            this.requestField("media_type", value);
            return this;
        }

        public APIRequestGet requestPostIdField() {
            return this.requestPostIdField(true);
        }

        public APIRequestGet requestPostIdField(boolean value) {
            this.requestField("post_id", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestUrlField() {
            return this.requestUrlField(true);
        }

        public APIRequestGet requestUrlField(boolean value) {
            this.requestField("url", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }
    }

    public static class APIRequestGetInsights
    extends APIRequest<InsightsResult> {
        APINodeList<InsightsResult> lastResponse = null;
        public static final String[] PARAMS = new String[]{"metric"};
        public static final String[] FIELDS = new String[]{"description", "description_from_api_doc", "id", "name", "period", "title", "values"};

        @Override
        public APINodeList<InsightsResult> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<InsightsResult> parseResponse(String response, String header) throws APIException {
            return InsightsResult.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<InsightsResult> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<InsightsResult> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<InsightsResult>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<InsightsResult>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<InsightsResult>>(){

                public APINodeList<InsightsResult> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetInsights(String nodeId, APIContext context) {
            super(context, nodeId, "/insights", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetInsights setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetInsights setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetInsights setMetric(List<InsightsResult.EnumMetric> metric) {
            this.setParam("metric", metric);
            return this;
        }

        public APIRequestGetInsights setMetric(String metric) {
            this.setParam("metric", metric);
            return this;
        }

        public APIRequestGetInsights requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetInsights requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetInsights requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetInsights requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetInsights requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetInsights requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetInsights requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetInsights requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetInsights requestDescriptionFromApiDocField() {
            return this.requestDescriptionFromApiDocField(true);
        }

        public APIRequestGetInsights requestDescriptionFromApiDocField(boolean value) {
            this.requestField("description_from_api_doc", value);
            return this;
        }

        public APIRequestGetInsights requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetInsights requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetInsights requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetInsights requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetInsights requestPeriodField() {
            return this.requestPeriodField(true);
        }

        public APIRequestGetInsights requestPeriodField(boolean value) {
            this.requestField("period", value);
            return this;
        }

        public APIRequestGetInsights requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGetInsights requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }

        public APIRequestGetInsights requestValuesField() {
            return this.requestValuesField(true);
        }

        public APIRequestGetInsights requestValuesField(boolean value) {
            this.requestField("values", value);
            return this;
        }
    }
}

