/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class InstagramBusinessAsset
extends APINode {
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="ig_user_id")
    private String mIgUserId = null;
    @SerializedName(value="ig_username")
    private String mIgUsername = null;
    protected static Gson gson = null;

    InstagramBusinessAsset() {
    }

    public InstagramBusinessAsset(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public InstagramBusinessAsset(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public InstagramBusinessAsset fetch() throws APIException {
        InstagramBusinessAsset newInstance = InstagramBusinessAsset.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static InstagramBusinessAsset fetchById(Long id, APIContext context) throws APIException {
        return InstagramBusinessAsset.fetchById(id.toString(), context);
    }

    public static ListenableFuture<InstagramBusinessAsset> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return InstagramBusinessAsset.fetchByIdAsync(id.toString(), context);
    }

    public static InstagramBusinessAsset fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<InstagramBusinessAsset> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<InstagramBusinessAsset> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<InstagramBusinessAsset>(context, "", "/", "GET", InstagramBusinessAsset.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<InstagramBusinessAsset>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<InstagramBusinessAsset>(context, "", "/", "GET", InstagramBusinessAsset.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static InstagramBusinessAsset loadJSON(String json, APIContext context, String header) {
        InstagramBusinessAsset instagramBusinessAsset = (InstagramBusinessAsset)InstagramBusinessAsset.getGson().fromJson(json, InstagramBusinessAsset.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(instagramBusinessAsset.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        instagramBusinessAsset.context = context;
        instagramBusinessAsset.rawValue = json;
        instagramBusinessAsset.header = header;
        return instagramBusinessAsset;
    }

    public static APINodeList<InstagramBusinessAsset> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<InstagramBusinessAsset> instagramBusinessAssets = new APINodeList<InstagramBusinessAsset>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        instagramBusinessAssets.add(InstagramBusinessAsset.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return instagramBusinessAssets;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            instagramBusinessAssets.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        instagramBusinessAssets.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            instagramBusinessAssets.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            instagramBusinessAssets.add(InstagramBusinessAsset.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                instagramBusinessAssets.add(InstagramBusinessAsset.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            instagramBusinessAssets.add(InstagramBusinessAsset.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return instagramBusinessAssets;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        instagramBusinessAssets.add(InstagramBusinessAsset.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return instagramBusinessAssets;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        instagramBusinessAssets.add(InstagramBusinessAsset.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return instagramBusinessAssets;
                }
                instagramBusinessAssets.clear();
                instagramBusinessAssets.add(InstagramBusinessAsset.loadJSON(json, context, header));
                return instagramBusinessAssets;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return InstagramBusinessAsset.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldIgUserId() {
        return this.mIgUserId;
    }

    public String getFieldIgUsername() {
        return this.mIgUsername;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public InstagramBusinessAsset copyFrom(InstagramBusinessAsset instance) {
        this.mId = instance.mId;
        this.mIgUserId = instance.mIgUserId;
        this.mIgUsername = instance.mIgUsername;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<InstagramBusinessAsset> getParser() {
        return new APIRequest.ResponseParser<InstagramBusinessAsset>(){

            @Override
            public APINodeList<InstagramBusinessAsset> parseResponse(String response, APIContext context, APIRequest<InstagramBusinessAsset> request, String header) throws APIException.MalformedResponseException {
                return InstagramBusinessAsset.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<InstagramBusinessAsset> {
        InstagramBusinessAsset lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"id", "ig_user_id", "ig_username"};

        @Override
        public InstagramBusinessAsset getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public InstagramBusinessAsset parseResponse(String response, String header) throws APIException {
            return InstagramBusinessAsset.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public InstagramBusinessAsset execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public InstagramBusinessAsset execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<InstagramBusinessAsset> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<InstagramBusinessAsset> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, InstagramBusinessAsset>(){

                public InstagramBusinessAsset apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIgUserIdField() {
            return this.requestIgUserIdField(true);
        }

        public APIRequestGet requestIgUserIdField(boolean value) {
            this.requestField("ig_user_id", value);
            return this;
        }

        public APIRequestGet requestIgUsernameField() {
            return this.requestIgUsernameField(true);
        }

        public APIRequestGet requestIgUsernameField(boolean value) {
            this.requestField("ig_username", value);
            return this;
        }
    }
}

