/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.APIResponse;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;

public class APINodeList<T extends APINode>
extends ArrayList<T>
implements APIResponse {
    private String before;
    private String after;
    private String previous;
    private String next;
    private APIRequest<T> request;
    private String rawValue;
    private String header;
    private boolean autoPagination;
    private String appSecret;

    public APINodeList(APIRequest<T> request, String rawValue, String header) {
        this.request = request;
        this.rawValue = rawValue;
        this.header = header;
    }

    public APINodeList<T> withAutoPaginationIterator(boolean autoPagination) {
        this.autoPagination = autoPagination;
        return this;
    }

    public APINodeList<T> nextPage() throws APIException {
        return this.nextPage(0);
    }

    public APINodeList<T> nextPage(int limit) throws APIException {
        if (this.next != null) {
            if (this.appSecret == null) {
                this.request.setOverrideUrl(this.next);
            } else {
                try {
                    URL a = new URL(this.next);
                    String connector = a.getQuery() == null ? "?" : "&";
                    this.request.setOverrideUrl(this.next + connector + "appsecret_proof=" + this.appSecret);
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
            return (APINodeList)this.request.execute();
        }
        if (this.after == null) {
            return null;
        }
        this.request.setOverrideUrl(null);
        HashMap<String, Object> extraParams = new HashMap<String, Object>();
        if (limit > 0) {
            extraParams.put("limit", limit);
        }
        extraParams.put("after", this.after);
        return (APINodeList)this.request.execute(extraParams);
    }

    public void setCursors(String before, String after) {
        this.before = before;
        this.after = after;
    }

    public void setPaging(String previous, String next) {
        this.previous = previous;
        this.next = next;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    @Override
    public Iterator<T> iterator() {
        return this.autoPagination ? new APINodeListAutoPaginationIterator(this, this) : super.iterator();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        for (APINode t : this) {
            action.accept(t);
        }
    }

    @Override
    public String getRawResponse() {
        return this.rawValue;
    }

    @Override
    public JsonObject getRawResponseAsJsonObject() {
        JsonParser parser = new JsonParser();
        return parser.parse(this.rawValue).getAsJsonObject();
    }

    public T head() {
        return (T)(this.size() > 0 ? (APINode)this.get(0) : null);
    }

    @Override
    public String getHeader() {
        return this.header;
    }

    @Override
    public APIException getException() {
        return null;
    }

    protected Iterator<T> getCurrentListIterator() {
        return super.iterator();
    }

    @Override
    public int size() {
        if (this.autoPagination) {
            throw new RuntimeException("When auto pagination is enabled, size is not available. Use stream/parallelStream or forEach to iterate");
        }
        return super.size();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.autoPagination ? new APINodeListAutoPaginationSpliterator(this) : super.spliterator();
    }

    private class APINodeListAutoPaginationSpliterator
    implements Spliterator<T> {
        APINodeList<T> list;
        Iterator<T> it;
        boolean alreadySplit = false;

        APINodeListAutoPaginationSpliterator(APINodeList<T> list) {
            this.list = list.withAutoPaginationIterator(true);
            this.it = list.getCurrentListIterator();
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            if (this.it.hasNext()) {
                action.accept(this.it.next());
                return true;
            }
            if (this.alreadySplit) {
                return false;
            }
            try {
                this.list = this.list.nextPage();
                if (this.list == null) {
                    return false;
                }
                this.it = this.list.getCurrentListIterator();
            }
            catch (APIException e) {
                throw new RuntimeException(e);
            }
            if (this.it.hasNext()) {
                action.accept(this.it.next());
                return true;
            }
            return false;
        }

        @Override
        public Spliterator<T> trySplit() {
            if (this.alreadySplit) {
                return null;
            }
            this.alreadySplit = true;
            try {
                APINodeList nextList = this.list.nextPage();
                return nextList.getCurrentListIterator().hasNext() ? new APINodeListAutoPaginationSpliterator(nextList) : null;
            }
            catch (APIException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public long estimateSize() {
            return Integer.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 1024;
        }
    }

    private static class APINodeListAutoPaginationIterator<E extends APINodeList<T>>
    implements Iterator<T> {
        private APINodeList<T> list;
        private Iterator<T> it;
        final /* synthetic */ APINodeList this$0;

        APINodeListAutoPaginationIterator(E list) {
            this.this$0 = var1_1;
            this.list = list;
            this.it = ((APINodeList)list).getCurrentListIterator();
        }

        @Override
        public boolean hasNext() {
            if (this.it.hasNext()) {
                return true;
            }
            try {
                this.list = this.list.nextPage();
            }
            catch (APIException e) {
                throw new RuntimeException(e);
            }
            if (this.list == null) {
                return false;
            }
            this.it = this.list.getCurrentListIterator();
            return this.it.hasNext();
        }

        @Override
        public T next() {
            return this.hasNext() ? (APINode)this.it.next() : null;
        }
    }
}

