/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

public class AdVolume
extends APINode {
    @SerializedName(value="ad_volume_break_down")
    private List<Object> mAdVolumeBreakDown = null;
    @SerializedName(value="ads_running_or_in_review_count")
    private Long mAdsRunningOrInReviewCount = null;
    @SerializedName(value="future_limit_activation_date")
    private String mFutureLimitActivationDate = null;
    @SerializedName(value="future_limit_on_ads_running_or_in_review")
    private Long mFutureLimitOnAdsRunningOrInReview = null;
    @SerializedName(value="individual_accounts_ad_volume")
    private Long mIndividualAccountsAdVolume = null;
    @SerializedName(value="is_gpa_page")
    private Boolean mIsGpaPage = null;
    @SerializedName(value="limit_on_ads_running_or_in_review")
    private Long mLimitOnAdsRunningOrInReview = null;
    @SerializedName(value="owning_business_ad_volume")
    private Long mOwningBusinessAdVolume = null;
    @SerializedName(value="partner_business_ad_volume")
    private Long mPartnerBusinessAdVolume = null;
    @SerializedName(value="user_role")
    private String mUserRole = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdVolume loadJSON(String json, APIContext context, String header) {
        AdVolume adVolume = (AdVolume)AdVolume.getGson().fromJson(json, AdVolume.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adVolume.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adVolume.context = context;
        adVolume.rawValue = json;
        adVolume.header = header;
        return adVolume;
    }

    public static APINodeList<AdVolume> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdVolume> adVolumes = new APINodeList<AdVolume>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adVolumes.add(AdVolume.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adVolumes;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adVolumes.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adVolumes.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adVolumes.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adVolumes.add(AdVolume.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adVolumes.add(AdVolume.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adVolumes.add(AdVolume.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adVolumes;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adVolumes.add(AdVolume.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adVolumes;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adVolumes.add(AdVolume.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adVolumes;
                }
                adVolumes.clear();
                adVolumes.add(AdVolume.loadJSON(json, context, header));
                return adVolumes;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdVolume.getGson().toJson((Object)this);
    }

    public List<Object> getFieldAdVolumeBreakDown() {
        return this.mAdVolumeBreakDown;
    }

    public AdVolume setFieldAdVolumeBreakDown(List<Object> value) {
        this.mAdVolumeBreakDown = value;
        return this;
    }

    public Long getFieldAdsRunningOrInReviewCount() {
        return this.mAdsRunningOrInReviewCount;
    }

    public AdVolume setFieldAdsRunningOrInReviewCount(Long value) {
        this.mAdsRunningOrInReviewCount = value;
        return this;
    }

    public String getFieldFutureLimitActivationDate() {
        return this.mFutureLimitActivationDate;
    }

    public AdVolume setFieldFutureLimitActivationDate(String value) {
        this.mFutureLimitActivationDate = value;
        return this;
    }

    public Long getFieldFutureLimitOnAdsRunningOrInReview() {
        return this.mFutureLimitOnAdsRunningOrInReview;
    }

    public AdVolume setFieldFutureLimitOnAdsRunningOrInReview(Long value) {
        this.mFutureLimitOnAdsRunningOrInReview = value;
        return this;
    }

    public Long getFieldIndividualAccountsAdVolume() {
        return this.mIndividualAccountsAdVolume;
    }

    public AdVolume setFieldIndividualAccountsAdVolume(Long value) {
        this.mIndividualAccountsAdVolume = value;
        return this;
    }

    public Boolean getFieldIsGpaPage() {
        return this.mIsGpaPage;
    }

    public AdVolume setFieldIsGpaPage(Boolean value) {
        this.mIsGpaPage = value;
        return this;
    }

    public Long getFieldLimitOnAdsRunningOrInReview() {
        return this.mLimitOnAdsRunningOrInReview;
    }

    public AdVolume setFieldLimitOnAdsRunningOrInReview(Long value) {
        this.mLimitOnAdsRunningOrInReview = value;
        return this;
    }

    public Long getFieldOwningBusinessAdVolume() {
        return this.mOwningBusinessAdVolume;
    }

    public AdVolume setFieldOwningBusinessAdVolume(Long value) {
        this.mOwningBusinessAdVolume = value;
        return this;
    }

    public Long getFieldPartnerBusinessAdVolume() {
        return this.mPartnerBusinessAdVolume;
    }

    public AdVolume setFieldPartnerBusinessAdVolume(Long value) {
        this.mPartnerBusinessAdVolume = value;
        return this;
    }

    public String getFieldUserRole() {
        return this.mUserRole;
    }

    public AdVolume setFieldUserRole(String value) {
        this.mUserRole = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdVolume copyFrom(AdVolume instance) {
        this.mAdVolumeBreakDown = instance.mAdVolumeBreakDown;
        this.mAdsRunningOrInReviewCount = instance.mAdsRunningOrInReviewCount;
        this.mFutureLimitActivationDate = instance.mFutureLimitActivationDate;
        this.mFutureLimitOnAdsRunningOrInReview = instance.mFutureLimitOnAdsRunningOrInReview;
        this.mIndividualAccountsAdVolume = instance.mIndividualAccountsAdVolume;
        this.mIsGpaPage = instance.mIsGpaPage;
        this.mLimitOnAdsRunningOrInReview = instance.mLimitOnAdsRunningOrInReview;
        this.mOwningBusinessAdVolume = instance.mOwningBusinessAdVolume;
        this.mPartnerBusinessAdVolume = instance.mPartnerBusinessAdVolume;
        this.mUserRole = instance.mUserRole;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdVolume> getParser() {
        return new APIRequest.ResponseParser<AdVolume>(){

            @Override
            public APINodeList<AdVolume> parseResponse(String response, APIContext context, APIRequest<AdVolume> request, String header) throws APIException.MalformedResponseException {
                return AdVolume.parseResponse(response, context, request, header);
            }
        };
    }
}

