/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.RawCustomAudience;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class ReportingAudience
extends APINode {
    @SerializedName(value="custom_audiences")
    private List<RawCustomAudience> mCustomAudiences = null;
    @SerializedName(value="custom_audiences_url_param_name")
    private String mCustomAudiencesUrlParamName = null;
    @SerializedName(value="custom_audiences_url_param_type")
    private String mCustomAudiencesUrlParamType = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static ReportingAudience loadJSON(String json, APIContext context, String header) {
        ReportingAudience reportingAudience = (ReportingAudience)ReportingAudience.getGson().fromJson(json, ReportingAudience.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(reportingAudience.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        reportingAudience.context = context;
        reportingAudience.rawValue = json;
        reportingAudience.header = header;
        return reportingAudience;
    }

    public static APINodeList<ReportingAudience> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ReportingAudience> reportingAudiences = new APINodeList<ReportingAudience>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        reportingAudiences.add(ReportingAudience.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return reportingAudiences;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            reportingAudiences.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        reportingAudiences.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            reportingAudiences.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            reportingAudiences.add(ReportingAudience.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                reportingAudiences.add(ReportingAudience.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            reportingAudiences.add(ReportingAudience.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return reportingAudiences;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        reportingAudiences.add(ReportingAudience.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return reportingAudiences;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        reportingAudiences.add(ReportingAudience.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return reportingAudiences;
                }
                reportingAudiences.clear();
                reportingAudiences.add(ReportingAudience.loadJSON(json, context, header));
                return reportingAudiences;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ReportingAudience.getGson().toJson((Object)this);
    }

    public List<RawCustomAudience> getFieldCustomAudiences() {
        return this.mCustomAudiences;
    }

    public ReportingAudience setFieldCustomAudiences(List<RawCustomAudience> value) {
        this.mCustomAudiences = value;
        return this;
    }

    public ReportingAudience setFieldCustomAudiences(String value) {
        Type type = new TypeToken<List<RawCustomAudience>>(){}.getType();
        this.mCustomAudiences = (List)RawCustomAudience.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldCustomAudiencesUrlParamName() {
        return this.mCustomAudiencesUrlParamName;
    }

    public ReportingAudience setFieldCustomAudiencesUrlParamName(String value) {
        this.mCustomAudiencesUrlParamName = value;
        return this;
    }

    public String getFieldCustomAudiencesUrlParamType() {
        return this.mCustomAudiencesUrlParamType;
    }

    public ReportingAudience setFieldCustomAudiencesUrlParamType(String value) {
        this.mCustomAudiencesUrlParamType = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ReportingAudience copyFrom(ReportingAudience instance) {
        this.mCustomAudiences = instance.mCustomAudiences;
        this.mCustomAudiencesUrlParamName = instance.mCustomAudiencesUrlParamName;
        this.mCustomAudiencesUrlParamType = instance.mCustomAudiencesUrlParamType;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ReportingAudience> getParser() {
        return new APIRequest.ResponseParser<ReportingAudience>(){

            @Override
            public APINodeList<ReportingAudience> parseResponse(String response, APIContext context, APIRequest<ReportingAudience> request, String header) throws APIException.MalformedResponseException {
                return ReportingAudience.parseResponse(response, context, request, header);
            }
        };
    }
}

