/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class PublisherWhiteList
extends APINode {
    @SerializedName(value="business_owner_id")
    private String mBusinessOwnerId = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="last_updated_time")
    private String mLastUpdatedTime = null;
    @SerializedName(value="last_updated_user")
    private String mLastUpdatedUser = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="placement_type")
    private String mPlacementType = null;
    protected static Gson gson = null;

    PublisherWhiteList() {
    }

    public PublisherWhiteList(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public PublisherWhiteList(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public PublisherWhiteList fetch() throws APIException {
        PublisherWhiteList newInstance = PublisherWhiteList.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static PublisherWhiteList fetchById(Long id, APIContext context) throws APIException {
        return PublisherWhiteList.fetchById(id.toString(), context);
    }

    public static ListenableFuture<PublisherWhiteList> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return PublisherWhiteList.fetchByIdAsync(id.toString(), context);
    }

    public static PublisherWhiteList fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<PublisherWhiteList> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<PublisherWhiteList> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<PublisherWhiteList>(context, "", "/", "GET", PublisherWhiteList.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<PublisherWhiteList>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<PublisherWhiteList>(context, "", "/", "GET", PublisherWhiteList.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static PublisherWhiteList loadJSON(String json, APIContext context, String header) {
        PublisherWhiteList publisherWhiteList = (PublisherWhiteList)PublisherWhiteList.getGson().fromJson(json, PublisherWhiteList.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(publisherWhiteList.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        publisherWhiteList.context = context;
        publisherWhiteList.rawValue = json;
        publisherWhiteList.header = header;
        return publisherWhiteList;
    }

    public static APINodeList<PublisherWhiteList> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<PublisherWhiteList> publisherWhiteLists = new APINodeList<PublisherWhiteList>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        publisherWhiteLists.add(PublisherWhiteList.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return publisherWhiteLists;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            publisherWhiteLists.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        publisherWhiteLists.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            publisherWhiteLists.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            publisherWhiteLists.add(PublisherWhiteList.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                publisherWhiteLists.add(PublisherWhiteList.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            publisherWhiteLists.add(PublisherWhiteList.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return publisherWhiteLists;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        publisherWhiteLists.add(PublisherWhiteList.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return publisherWhiteLists;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        publisherWhiteLists.add(PublisherWhiteList.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return publisherWhiteLists;
                }
                publisherWhiteLists.clear();
                publisherWhiteLists.add(PublisherWhiteList.loadJSON(json, context, header));
                return publisherWhiteLists;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PublisherWhiteList.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldBusinessOwnerId() {
        return this.mBusinessOwnerId;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldLastUpdatedTime() {
        return this.mLastUpdatedTime;
    }

    public String getFieldLastUpdatedUser() {
        return this.mLastUpdatedUser;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldPlacementType() {
        return this.mPlacementType;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PublisherWhiteList copyFrom(PublisherWhiteList instance) {
        this.mBusinessOwnerId = instance.mBusinessOwnerId;
        this.mId = instance.mId;
        this.mLastUpdatedTime = instance.mLastUpdatedTime;
        this.mLastUpdatedUser = instance.mLastUpdatedUser;
        this.mName = instance.mName;
        this.mPlacementType = instance.mPlacementType;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PublisherWhiteList> getParser() {
        return new APIRequest.ResponseParser<PublisherWhiteList>(){

            @Override
            public APINodeList<PublisherWhiteList> parseResponse(String response, APIContext context, APIRequest<PublisherWhiteList> request, String header) throws APIException.MalformedResponseException {
                return PublisherWhiteList.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<PublisherWhiteList> {
        PublisherWhiteList lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"business_owner_id", "id", "last_updated_time", "last_updated_user", "name", "placement_type"};

        @Override
        public PublisherWhiteList getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public PublisherWhiteList parseResponse(String response, String header) throws APIException {
            return PublisherWhiteList.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public PublisherWhiteList execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public PublisherWhiteList execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<PublisherWhiteList> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<PublisherWhiteList> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, PublisherWhiteList>(){

                public PublisherWhiteList apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBusinessOwnerIdField() {
            return this.requestBusinessOwnerIdField(true);
        }

        public APIRequestGet requestBusinessOwnerIdField(boolean value) {
            this.requestField("business_owner_id", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestLastUpdatedTimeField() {
            return this.requestLastUpdatedTimeField(true);
        }

        public APIRequestGet requestLastUpdatedTimeField(boolean value) {
            this.requestField("last_updated_time", value);
            return this;
        }

        public APIRequestGet requestLastUpdatedUserField() {
            return this.requestLastUpdatedUserField(true);
        }

        public APIRequestGet requestLastUpdatedUserField(boolean value) {
            this.requestField("last_updated_user", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestPlacementTypeField() {
            return this.requestPlacementTypeField(true);
        }

        public APIRequestGet requestPlacementTypeField(boolean value) {
            this.requestField("placement_type", value);
            return this;
        }
    }
}

