/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class MessageDeliveryEstimate
extends APINode {
    @SerializedName(value="estimate_cost")
    private Double mEstimateCost = null;
    @SerializedName(value="estimate_cost_lower_bound")
    private Double mEstimateCostLowerBound = null;
    @SerializedName(value="estimate_cost_upper_bound")
    private Double mEstimateCostUpperBound = null;
    @SerializedName(value="estimate_coverage_lower_bound")
    private Long mEstimateCoverageLowerBound = null;
    @SerializedName(value="estimate_coverage_upper_bound")
    private Long mEstimateCoverageUpperBound = null;
    @SerializedName(value="estimate_delivery")
    private Long mEstimateDelivery = null;
    @SerializedName(value="estimate_delivery_lower_bound")
    private Long mEstimateDeliveryLowerBound = null;
    @SerializedName(value="estimate_delivery_upper_bound")
    private Long mEstimateDeliveryUpperBound = null;
    @SerializedName(value="estimate_status")
    private String mEstimateStatus = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static MessageDeliveryEstimate loadJSON(String json, APIContext context, String header) {
        MessageDeliveryEstimate messageDeliveryEstimate = (MessageDeliveryEstimate)MessageDeliveryEstimate.getGson().fromJson(json, MessageDeliveryEstimate.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(messageDeliveryEstimate.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        messageDeliveryEstimate.context = context;
        messageDeliveryEstimate.rawValue = json;
        messageDeliveryEstimate.header = header;
        return messageDeliveryEstimate;
    }

    public static APINodeList<MessageDeliveryEstimate> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<MessageDeliveryEstimate> messageDeliveryEstimates = new APINodeList<MessageDeliveryEstimate>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        messageDeliveryEstimates.add(MessageDeliveryEstimate.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return messageDeliveryEstimates;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            messageDeliveryEstimates.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        messageDeliveryEstimates.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            messageDeliveryEstimates.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            messageDeliveryEstimates.add(MessageDeliveryEstimate.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                messageDeliveryEstimates.add(MessageDeliveryEstimate.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            messageDeliveryEstimates.add(MessageDeliveryEstimate.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return messageDeliveryEstimates;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        messageDeliveryEstimates.add(MessageDeliveryEstimate.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return messageDeliveryEstimates;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        messageDeliveryEstimates.add(MessageDeliveryEstimate.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return messageDeliveryEstimates;
                }
                messageDeliveryEstimates.clear();
                messageDeliveryEstimates.add(MessageDeliveryEstimate.loadJSON(json, context, header));
                return messageDeliveryEstimates;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return MessageDeliveryEstimate.getGson().toJson((Object)this);
    }

    public Double getFieldEstimateCost() {
        return this.mEstimateCost;
    }

    public MessageDeliveryEstimate setFieldEstimateCost(Double value) {
        this.mEstimateCost = value;
        return this;
    }

    public Double getFieldEstimateCostLowerBound() {
        return this.mEstimateCostLowerBound;
    }

    public MessageDeliveryEstimate setFieldEstimateCostLowerBound(Double value) {
        this.mEstimateCostLowerBound = value;
        return this;
    }

    public Double getFieldEstimateCostUpperBound() {
        return this.mEstimateCostUpperBound;
    }

    public MessageDeliveryEstimate setFieldEstimateCostUpperBound(Double value) {
        this.mEstimateCostUpperBound = value;
        return this;
    }

    public Long getFieldEstimateCoverageLowerBound() {
        return this.mEstimateCoverageLowerBound;
    }

    public MessageDeliveryEstimate setFieldEstimateCoverageLowerBound(Long value) {
        this.mEstimateCoverageLowerBound = value;
        return this;
    }

    public Long getFieldEstimateCoverageUpperBound() {
        return this.mEstimateCoverageUpperBound;
    }

    public MessageDeliveryEstimate setFieldEstimateCoverageUpperBound(Long value) {
        this.mEstimateCoverageUpperBound = value;
        return this;
    }

    public Long getFieldEstimateDelivery() {
        return this.mEstimateDelivery;
    }

    public MessageDeliveryEstimate setFieldEstimateDelivery(Long value) {
        this.mEstimateDelivery = value;
        return this;
    }

    public Long getFieldEstimateDeliveryLowerBound() {
        return this.mEstimateDeliveryLowerBound;
    }

    public MessageDeliveryEstimate setFieldEstimateDeliveryLowerBound(Long value) {
        this.mEstimateDeliveryLowerBound = value;
        return this;
    }

    public Long getFieldEstimateDeliveryUpperBound() {
        return this.mEstimateDeliveryUpperBound;
    }

    public MessageDeliveryEstimate setFieldEstimateDeliveryUpperBound(Long value) {
        this.mEstimateDeliveryUpperBound = value;
        return this;
    }

    public String getFieldEstimateStatus() {
        return this.mEstimateStatus;
    }

    public MessageDeliveryEstimate setFieldEstimateStatus(String value) {
        this.mEstimateStatus = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public MessageDeliveryEstimate copyFrom(MessageDeliveryEstimate instance) {
        this.mEstimateCost = instance.mEstimateCost;
        this.mEstimateCostLowerBound = instance.mEstimateCostLowerBound;
        this.mEstimateCostUpperBound = instance.mEstimateCostUpperBound;
        this.mEstimateCoverageLowerBound = instance.mEstimateCoverageLowerBound;
        this.mEstimateCoverageUpperBound = instance.mEstimateCoverageUpperBound;
        this.mEstimateDelivery = instance.mEstimateDelivery;
        this.mEstimateDeliveryLowerBound = instance.mEstimateDeliveryLowerBound;
        this.mEstimateDeliveryUpperBound = instance.mEstimateDeliveryUpperBound;
        this.mEstimateStatus = instance.mEstimateStatus;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<MessageDeliveryEstimate> getParser() {
        return new APIRequest.ResponseParser<MessageDeliveryEstimate>(){

            @Override
            public APINodeList<MessageDeliveryEstimate> parseResponse(String response, APIContext context, APIRequest<MessageDeliveryEstimate> request, String header) throws APIException.MalformedResponseException {
                return MessageDeliveryEstimate.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumPacingType {
        VALUE_DAY_PARTING("DAY_PARTING"),
        VALUE_DISABLED("DISABLED"),
        VALUE_NO_PACING("NO_PACING"),
        VALUE_PROBABILISTIC_PACING("PROBABILISTIC_PACING"),
        VALUE_PROBABILISTIC_PACING_V2("PROBABILISTIC_PACING_V2"),
        VALUE_STANDARD("STANDARD");

        private String value;

        private EnumPacingType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumOptimizationGoal {
        VALUE_AD_RECALL_LIFT("AD_RECALL_LIFT"),
        VALUE_APP_INSTALLS("APP_INSTALLS"),
        VALUE_APP_INSTALLS_AND_OFFSITE_CONVERSIONS("APP_INSTALLS_AND_OFFSITE_CONVERSIONS"),
        VALUE_CONVERSATIONS("CONVERSATIONS"),
        VALUE_DERIVED_EVENTS("DERIVED_EVENTS"),
        VALUE_ENGAGED_USERS("ENGAGED_USERS"),
        VALUE_EVENT_RESPONSES("EVENT_RESPONSES"),
        VALUE_IMPRESSIONS("IMPRESSIONS"),
        VALUE_IN_APP_VALUE("IN_APP_VALUE"),
        VALUE_LANDING_PAGE_VIEWS("LANDING_PAGE_VIEWS"),
        VALUE_LEAD_GENERATION("LEAD_GENERATION"),
        VALUE_LINK_CLICKS("LINK_CLICKS"),
        VALUE_MEANINGFUL_CALL_ATTEMPT("MEANINGFUL_CALL_ATTEMPT"),
        VALUE_MESSAGING_APPOINTMENT_CONVERSION("MESSAGING_APPOINTMENT_CONVERSION"),
        VALUE_MESSAGING_PURCHASE_CONVERSION("MESSAGING_PURCHASE_CONVERSION"),
        VALUE_NONE("NONE"),
        VALUE_OFFSITE_CONVERSIONS("OFFSITE_CONVERSIONS"),
        VALUE_PAGE_LIKES("PAGE_LIKES"),
        VALUE_POST_ENGAGEMENT("POST_ENGAGEMENT"),
        VALUE_PROFILE_VISIT("PROFILE_VISIT"),
        VALUE_QUALITY_CALL("QUALITY_CALL"),
        VALUE_QUALITY_LEAD("QUALITY_LEAD"),
        VALUE_REACH("REACH"),
        VALUE_REMINDERS_SET("REMINDERS_SET"),
        VALUE_SUBSCRIBERS("SUBSCRIBERS"),
        VALUE_THRUPLAY("THRUPLAY"),
        VALUE_VALUE("VALUE"),
        VALUE_VISIT_INSTAGRAM_PROFILE("VISIT_INSTAGRAM_PROFILE");

        private String value;

        private EnumOptimizationGoal(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

