/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.InstagramUser;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class InstagramCarousel
extends APINode {
    @SerializedName(value="caption_text")
    private String mCaptionText = null;
    @SerializedName(value="comment_count")
    private Long mCommentCount = null;
    @SerializedName(value="content_type")
    private Long mContentType = null;
    @SerializedName(value="display_url")
    private String mDisplayUrl = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="ig_media_id")
    private String mIgMediaId = null;
    @SerializedName(value="like_count")
    private Long mLikeCount = null;
    @SerializedName(value="owner_instagram_user")
    private InstagramUser mOwnerInstagramUser = null;
    @SerializedName(value="permalink")
    private String mPermalink = null;
    @SerializedName(value="taken_at")
    private String mTakenAt = null;
    @SerializedName(value="video_url")
    private String mVideoUrl = null;
    protected static Gson gson = null;

    InstagramCarousel() {
    }

    public InstagramCarousel(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public InstagramCarousel(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public InstagramCarousel fetch() throws APIException {
        InstagramCarousel newInstance = InstagramCarousel.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static InstagramCarousel fetchById(Long id, APIContext context) throws APIException {
        return InstagramCarousel.fetchById(id.toString(), context);
    }

    public static ListenableFuture<InstagramCarousel> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return InstagramCarousel.fetchByIdAsync(id.toString(), context);
    }

    public static InstagramCarousel fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<InstagramCarousel> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<InstagramCarousel> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<InstagramCarousel>(context, "", "/", "GET", InstagramCarousel.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<InstagramCarousel>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<InstagramCarousel>(context, "", "/", "GET", InstagramCarousel.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static InstagramCarousel loadJSON(String json, APIContext context, String header) {
        InstagramCarousel instagramCarousel = (InstagramCarousel)InstagramCarousel.getGson().fromJson(json, InstagramCarousel.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(instagramCarousel.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        instagramCarousel.context = context;
        instagramCarousel.rawValue = json;
        instagramCarousel.header = header;
        return instagramCarousel;
    }

    public static APINodeList<InstagramCarousel> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<InstagramCarousel> instagramCarousels = new APINodeList<InstagramCarousel>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        instagramCarousels.add(InstagramCarousel.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return instagramCarousels;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            instagramCarousels.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        instagramCarousels.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            instagramCarousels.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            instagramCarousels.add(InstagramCarousel.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                instagramCarousels.add(InstagramCarousel.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            instagramCarousels.add(InstagramCarousel.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return instagramCarousels;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        instagramCarousels.add(InstagramCarousel.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return instagramCarousels;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        instagramCarousels.add(InstagramCarousel.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return instagramCarousels;
                }
                instagramCarousels.clear();
                instagramCarousels.add(InstagramCarousel.loadJSON(json, context, header));
                return instagramCarousels;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return InstagramCarousel.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldCaptionText() {
        return this.mCaptionText;
    }

    public Long getFieldCommentCount() {
        return this.mCommentCount;
    }

    public Long getFieldContentType() {
        return this.mContentType;
    }

    public String getFieldDisplayUrl() {
        return this.mDisplayUrl;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldIgMediaId() {
        return this.mIgMediaId;
    }

    public Long getFieldLikeCount() {
        return this.mLikeCount;
    }

    public InstagramUser getFieldOwnerInstagramUser() {
        if (this.mOwnerInstagramUser != null) {
            this.mOwnerInstagramUser.context = this.getContext();
        }
        return this.mOwnerInstagramUser;
    }

    public String getFieldPermalink() {
        return this.mPermalink;
    }

    public String getFieldTakenAt() {
        return this.mTakenAt;
    }

    public String getFieldVideoUrl() {
        return this.mVideoUrl;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public InstagramCarousel copyFrom(InstagramCarousel instance) {
        this.mCaptionText = instance.mCaptionText;
        this.mCommentCount = instance.mCommentCount;
        this.mContentType = instance.mContentType;
        this.mDisplayUrl = instance.mDisplayUrl;
        this.mId = instance.mId;
        this.mIgMediaId = instance.mIgMediaId;
        this.mLikeCount = instance.mLikeCount;
        this.mOwnerInstagramUser = instance.mOwnerInstagramUser;
        this.mPermalink = instance.mPermalink;
        this.mTakenAt = instance.mTakenAt;
        this.mVideoUrl = instance.mVideoUrl;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<InstagramCarousel> getParser() {
        return new APIRequest.ResponseParser<InstagramCarousel>(){

            @Override
            public APINodeList<InstagramCarousel> parseResponse(String response, APIContext context, APIRequest<InstagramCarousel> request, String header) throws APIException.MalformedResponseException {
                return InstagramCarousel.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<InstagramCarousel> {
        InstagramCarousel lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"caption_text", "comment_count", "content_type", "display_url", "id", "ig_media_id", "like_count", "owner_instagram_user", "permalink", "taken_at", "video_url"};

        @Override
        public InstagramCarousel getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public InstagramCarousel parseResponse(String response, String header) throws APIException {
            return InstagramCarousel.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public InstagramCarousel execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public InstagramCarousel execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<InstagramCarousel> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<InstagramCarousel> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, InstagramCarousel>(){

                public InstagramCarousel apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCaptionTextField() {
            return this.requestCaptionTextField(true);
        }

        public APIRequestGet requestCaptionTextField(boolean value) {
            this.requestField("caption_text", value);
            return this;
        }

        public APIRequestGet requestCommentCountField() {
            return this.requestCommentCountField(true);
        }

        public APIRequestGet requestCommentCountField(boolean value) {
            this.requestField("comment_count", value);
            return this;
        }

        public APIRequestGet requestContentTypeField() {
            return this.requestContentTypeField(true);
        }

        public APIRequestGet requestContentTypeField(boolean value) {
            this.requestField("content_type", value);
            return this;
        }

        public APIRequestGet requestDisplayUrlField() {
            return this.requestDisplayUrlField(true);
        }

        public APIRequestGet requestDisplayUrlField(boolean value) {
            this.requestField("display_url", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIgMediaIdField() {
            return this.requestIgMediaIdField(true);
        }

        public APIRequestGet requestIgMediaIdField(boolean value) {
            this.requestField("ig_media_id", value);
            return this;
        }

        public APIRequestGet requestLikeCountField() {
            return this.requestLikeCountField(true);
        }

        public APIRequestGet requestLikeCountField(boolean value) {
            this.requestField("like_count", value);
            return this;
        }

        public APIRequestGet requestOwnerInstagramUserField() {
            return this.requestOwnerInstagramUserField(true);
        }

        public APIRequestGet requestOwnerInstagramUserField(boolean value) {
            this.requestField("owner_instagram_user", value);
            return this;
        }

        public APIRequestGet requestPermalinkField() {
            return this.requestPermalinkField(true);
        }

        public APIRequestGet requestPermalinkField(boolean value) {
            this.requestField("permalink", value);
            return this;
        }

        public APIRequestGet requestTakenAtField() {
            return this.requestTakenAtField(true);
        }

        public APIRequestGet requestTakenAtField(boolean value) {
            this.requestField("taken_at", value);
            return this;
        }

        public APIRequestGet requestVideoUrlField() {
            return this.requestVideoUrlField(true);
        }

        public APIRequestGet requestVideoUrlField(boolean value) {
            this.requestField("video_url", value);
            return this;
        }
    }
}

