/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class ALMEvent
extends APINode {
    @SerializedName(value="ad_account_ids")
    private List<String> mAdAccountIds = null;
    @SerializedName(value="campaign_ids")
    private List<String> mCampaignIds = null;
    @SerializedName(value="channel")
    private String mChannel = null;
    @SerializedName(value="event")
    private String mEvent = null;
    @SerializedName(value="event_time")
    private String mEventTime = null;
    @SerializedName(value="guidance")
    private String mGuidance = null;
    @SerializedName(value="guidance_detail")
    private String mGuidanceDetail = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="parent_advertiser_ids")
    private List<String> mParentAdvertiserIds = null;
    @SerializedName(value="reseller_business_id")
    private String mResellerBusinessId = null;
    @SerializedName(value="sub_channel")
    private String mSubChannel = null;
    @SerializedName(value="user_id")
    private String mUserId = null;
    protected static Gson gson = null;

    ALMEvent() {
    }

    public ALMEvent(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ALMEvent(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ALMEvent fetch() throws APIException {
        ALMEvent newInstance = ALMEvent.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ALMEvent fetchById(Long id, APIContext context) throws APIException {
        return ALMEvent.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ALMEvent> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ALMEvent.fetchByIdAsync(id.toString(), context);
    }

    public static ALMEvent fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<ALMEvent> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<ALMEvent> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ALMEvent>(context, "", "/", "GET", ALMEvent.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ALMEvent>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<ALMEvent>(context, "", "/", "GET", ALMEvent.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ALMEvent loadJSON(String json, APIContext context, String header) {
        ALMEvent almEvent = (ALMEvent)ALMEvent.getGson().fromJson(json, ALMEvent.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(almEvent.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        almEvent.context = context;
        almEvent.rawValue = json;
        almEvent.header = header;
        return almEvent;
    }

    public static APINodeList<ALMEvent> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ALMEvent> almEvents = new APINodeList<ALMEvent>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        almEvents.add(ALMEvent.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return almEvents;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            almEvents.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        almEvents.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            almEvents.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            almEvents.add(ALMEvent.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                almEvents.add(ALMEvent.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            almEvents.add(ALMEvent.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return almEvents;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        almEvents.add(ALMEvent.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return almEvents;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        almEvents.add(ALMEvent.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return almEvents;
                }
                almEvents.clear();
                almEvents.add(ALMEvent.loadJSON(json, context, header));
                return almEvents;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ALMEvent.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public List<String> getFieldAdAccountIds() {
        return this.mAdAccountIds;
    }

    public List<String> getFieldCampaignIds() {
        return this.mCampaignIds;
    }

    public String getFieldChannel() {
        return this.mChannel;
    }

    public String getFieldEvent() {
        return this.mEvent;
    }

    public String getFieldEventTime() {
        return this.mEventTime;
    }

    public String getFieldGuidance() {
        return this.mGuidance;
    }

    public String getFieldGuidanceDetail() {
        return this.mGuidanceDetail;
    }

    public String getFieldId() {
        return this.mId;
    }

    public List<String> getFieldParentAdvertiserIds() {
        return this.mParentAdvertiserIds;
    }

    public String getFieldResellerBusinessId() {
        return this.mResellerBusinessId;
    }

    public String getFieldSubChannel() {
        return this.mSubChannel;
    }

    public String getFieldUserId() {
        return this.mUserId;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ALMEvent copyFrom(ALMEvent instance) {
        this.mAdAccountIds = instance.mAdAccountIds;
        this.mCampaignIds = instance.mCampaignIds;
        this.mChannel = instance.mChannel;
        this.mEvent = instance.mEvent;
        this.mEventTime = instance.mEventTime;
        this.mGuidance = instance.mGuidance;
        this.mGuidanceDetail = instance.mGuidanceDetail;
        this.mId = instance.mId;
        this.mParentAdvertiserIds = instance.mParentAdvertiserIds;
        this.mResellerBusinessId = instance.mResellerBusinessId;
        this.mSubChannel = instance.mSubChannel;
        this.mUserId = instance.mUserId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ALMEvent> getParser() {
        return new APIRequest.ResponseParser<ALMEvent>(){

            @Override
            public APINodeList<ALMEvent> parseResponse(String response, APIContext context, APIRequest<ALMEvent> request, String header) throws APIException.MalformedResponseException {
                return ALMEvent.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<ALMEvent> {
        ALMEvent lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"ad_account_ids", "campaign_ids", "channel", "event", "event_time", "guidance", "guidance_detail", "id", "parent_advertiser_ids", "reseller_business_id", "sub_channel", "user_id"};

        @Override
        public ALMEvent getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ALMEvent parseResponse(String response, String header) throws APIException {
            return ALMEvent.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public ALMEvent execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ALMEvent execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<ALMEvent> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ALMEvent> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, ALMEvent>(){

                public ALMEvent apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAdAccountIdsField() {
            return this.requestAdAccountIdsField(true);
        }

        public APIRequestGet requestAdAccountIdsField(boolean value) {
            this.requestField("ad_account_ids", value);
            return this;
        }

        public APIRequestGet requestCampaignIdsField() {
            return this.requestCampaignIdsField(true);
        }

        public APIRequestGet requestCampaignIdsField(boolean value) {
            this.requestField("campaign_ids", value);
            return this;
        }

        public APIRequestGet requestChannelField() {
            return this.requestChannelField(true);
        }

        public APIRequestGet requestChannelField(boolean value) {
            this.requestField("channel", value);
            return this;
        }

        public APIRequestGet requestEventField() {
            return this.requestEventField(true);
        }

        public APIRequestGet requestEventField(boolean value) {
            this.requestField("event", value);
            return this;
        }

        public APIRequestGet requestEventTimeField() {
            return this.requestEventTimeField(true);
        }

        public APIRequestGet requestEventTimeField(boolean value) {
            this.requestField("event_time", value);
            return this;
        }

        public APIRequestGet requestGuidanceField() {
            return this.requestGuidanceField(true);
        }

        public APIRequestGet requestGuidanceField(boolean value) {
            this.requestField("guidance", value);
            return this;
        }

        public APIRequestGet requestGuidanceDetailField() {
            return this.requestGuidanceDetailField(true);
        }

        public APIRequestGet requestGuidanceDetailField(boolean value) {
            this.requestField("guidance_detail", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestParentAdvertiserIdsField() {
            return this.requestParentAdvertiserIdsField(true);
        }

        public APIRequestGet requestParentAdvertiserIdsField(boolean value) {
            this.requestField("parent_advertiser_ids", value);
            return this;
        }

        public APIRequestGet requestResellerBusinessIdField() {
            return this.requestResellerBusinessIdField(true);
        }

        public APIRequestGet requestResellerBusinessIdField(boolean value) {
            this.requestField("reseller_business_id", value);
            return this;
        }

        public APIRequestGet requestSubChannelField() {
            return this.requestSubChannelField(true);
        }

        public APIRequestGet requestSubChannelField(boolean value) {
            this.requestField("sub_channel", value);
            return this;
        }

        public APIRequestGet requestUserIdField() {
            return this.requestUserIdField(true);
        }

        public APIRequestGet requestUserIdField(boolean value) {
            this.requestField("user_id", value);
            return this;
        }
    }
}

