/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.VideoCopyrightCheckStatus;
import com.facebook.ads.sdk.VideoStatusProcessingPhase;
import com.facebook.ads.sdk.VideoStatusPublishingPhase;
import com.facebook.ads.sdk.VideoStatusUploadingPhase;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;

public class VideoStatus
extends APINode {
    @SerializedName(value="copyright_check_status")
    private VideoCopyrightCheckStatus mCopyrightCheckStatus = null;
    @SerializedName(value="processing_phase")
    private VideoStatusProcessingPhase mProcessingPhase = null;
    @SerializedName(value="processing_progress")
    private Long mProcessingProgress = null;
    @SerializedName(value="publishing_phase")
    private VideoStatusPublishingPhase mPublishingPhase = null;
    @SerializedName(value="uploading_phase")
    private VideoStatusUploadingPhase mUploadingPhase = null;
    @SerializedName(value="video_status")
    private String mVideoStatus = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static VideoStatus loadJSON(String json, APIContext context, String header) {
        VideoStatus videoStatus = (VideoStatus)VideoStatus.getGson().fromJson(json, VideoStatus.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(videoStatus.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        videoStatus.context = context;
        videoStatus.rawValue = json;
        videoStatus.header = header;
        return videoStatus;
    }

    public static APINodeList<VideoStatus> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<VideoStatus> videoStatuss = new APINodeList<VideoStatus>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        videoStatuss.add(VideoStatus.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return videoStatuss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            videoStatuss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        videoStatuss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            videoStatuss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            videoStatuss.add(VideoStatus.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                videoStatuss.add(VideoStatus.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            videoStatuss.add(VideoStatus.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return videoStatuss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        videoStatuss.add(VideoStatus.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return videoStatuss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        videoStatuss.add(VideoStatus.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return videoStatuss;
                }
                videoStatuss.clear();
                videoStatuss.add(VideoStatus.loadJSON(json, context, header));
                return videoStatuss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return VideoStatus.getGson().toJson((Object)this);
    }

    public VideoCopyrightCheckStatus getFieldCopyrightCheckStatus() {
        return this.mCopyrightCheckStatus;
    }

    public VideoStatus setFieldCopyrightCheckStatus(VideoCopyrightCheckStatus value) {
        this.mCopyrightCheckStatus = value;
        return this;
    }

    public VideoStatus setFieldCopyrightCheckStatus(String value) {
        Type type = new TypeToken<VideoCopyrightCheckStatus>(){}.getType();
        this.mCopyrightCheckStatus = (VideoCopyrightCheckStatus)VideoCopyrightCheckStatus.getGson().fromJson(value, type);
        return this;
    }

    public VideoStatusProcessingPhase getFieldProcessingPhase() {
        return this.mProcessingPhase;
    }

    public VideoStatus setFieldProcessingPhase(VideoStatusProcessingPhase value) {
        this.mProcessingPhase = value;
        return this;
    }

    public VideoStatus setFieldProcessingPhase(String value) {
        Type type = new TypeToken<VideoStatusProcessingPhase>(){}.getType();
        this.mProcessingPhase = (VideoStatusProcessingPhase)VideoStatusProcessingPhase.getGson().fromJson(value, type);
        return this;
    }

    public Long getFieldProcessingProgress() {
        return this.mProcessingProgress;
    }

    public VideoStatus setFieldProcessingProgress(Long value) {
        this.mProcessingProgress = value;
        return this;
    }

    public VideoStatusPublishingPhase getFieldPublishingPhase() {
        return this.mPublishingPhase;
    }

    public VideoStatus setFieldPublishingPhase(VideoStatusPublishingPhase value) {
        this.mPublishingPhase = value;
        return this;
    }

    public VideoStatus setFieldPublishingPhase(String value) {
        Type type = new TypeToken<VideoStatusPublishingPhase>(){}.getType();
        this.mPublishingPhase = (VideoStatusPublishingPhase)VideoStatusPublishingPhase.getGson().fromJson(value, type);
        return this;
    }

    public VideoStatusUploadingPhase getFieldUploadingPhase() {
        return this.mUploadingPhase;
    }

    public VideoStatus setFieldUploadingPhase(VideoStatusUploadingPhase value) {
        this.mUploadingPhase = value;
        return this;
    }

    public VideoStatus setFieldUploadingPhase(String value) {
        Type type = new TypeToken<VideoStatusUploadingPhase>(){}.getType();
        this.mUploadingPhase = (VideoStatusUploadingPhase)VideoStatusUploadingPhase.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldVideoStatus() {
        return this.mVideoStatus;
    }

    public VideoStatus setFieldVideoStatus(String value) {
        this.mVideoStatus = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public VideoStatus copyFrom(VideoStatus instance) {
        this.mCopyrightCheckStatus = instance.mCopyrightCheckStatus;
        this.mProcessingPhase = instance.mProcessingPhase;
        this.mProcessingProgress = instance.mProcessingProgress;
        this.mPublishingPhase = instance.mPublishingPhase;
        this.mUploadingPhase = instance.mUploadingPhase;
        this.mVideoStatus = instance.mVideoStatus;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<VideoStatus> getParser() {
        return new APIRequest.ResponseParser<VideoStatus>(){

            @Override
            public APINodeList<VideoStatus> parseResponse(String response, APIContext context, APIRequest<VideoStatus> request, String header) throws APIException.MalformedResponseException {
                return VideoStatus.parseResponse(response, context, request, header);
            }
        };
    }
}

