/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdAccount;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;

public class AdAccountASLSchedule
extends APINode {
    @SerializedName(value="ad_account")
    private AdAccount mAdAccount = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="time_created")
    private String mTimeCreated = null;
    @SerializedName(value="time_updated")
    private String mTimeUpdated = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdAccountASLSchedule loadJSON(String json, APIContext context, String header) {
        AdAccountASLSchedule adAccountASLSchedule = (AdAccountASLSchedule)AdAccountASLSchedule.getGson().fromJson(json, AdAccountASLSchedule.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adAccountASLSchedule.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adAccountASLSchedule.context = context;
        adAccountASLSchedule.rawValue = json;
        adAccountASLSchedule.header = header;
        return adAccountASLSchedule;
    }

    public static APINodeList<AdAccountASLSchedule> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdAccountASLSchedule> adAccountASLSchedules = new APINodeList<AdAccountASLSchedule>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adAccountASLSchedules.add(AdAccountASLSchedule.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adAccountASLSchedules;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adAccountASLSchedules.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adAccountASLSchedules.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adAccountASLSchedules.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adAccountASLSchedules.add(AdAccountASLSchedule.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adAccountASLSchedules.add(AdAccountASLSchedule.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adAccountASLSchedules.add(AdAccountASLSchedule.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adAccountASLSchedules;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adAccountASLSchedules.add(AdAccountASLSchedule.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adAccountASLSchedules;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adAccountASLSchedules.add(AdAccountASLSchedule.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adAccountASLSchedules;
                }
                adAccountASLSchedules.clear();
                adAccountASLSchedules.add(AdAccountASLSchedule.loadJSON(json, context, header));
                return adAccountASLSchedules;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdAccountASLSchedule.getGson().toJson((Object)this);
    }

    public AdAccount getFieldAdAccount() {
        if (this.mAdAccount != null) {
            this.mAdAccount.context = this.getContext();
        }
        return this.mAdAccount;
    }

    public AdAccountASLSchedule setFieldAdAccount(AdAccount value) {
        this.mAdAccount = value;
        return this;
    }

    public AdAccountASLSchedule setFieldAdAccount(String value) {
        Type type = new TypeToken<AdAccount>(){}.getType();
        this.mAdAccount = (AdAccount)AdAccount.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public AdAccountASLSchedule setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public String getFieldTimeCreated() {
        return this.mTimeCreated;
    }

    public AdAccountASLSchedule setFieldTimeCreated(String value) {
        this.mTimeCreated = value;
        return this;
    }

    public String getFieldTimeUpdated() {
        return this.mTimeUpdated;
    }

    public AdAccountASLSchedule setFieldTimeUpdated(String value) {
        this.mTimeUpdated = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdAccountASLSchedule copyFrom(AdAccountASLSchedule instance) {
        this.mAdAccount = instance.mAdAccount;
        this.mId = instance.mId;
        this.mTimeCreated = instance.mTimeCreated;
        this.mTimeUpdated = instance.mTimeUpdated;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdAccountASLSchedule> getParser() {
        return new APIRequest.ResponseParser<AdAccountASLSchedule>(){

            @Override
            public APINodeList<AdAccountASLSchedule> parseResponse(String response, APIContext context, APIRequest<AdAccountASLSchedule> request, String header) throws APIException.MalformedResponseException {
                return AdAccountASLSchedule.parseResponse(response, context, request, header);
            }
        };
    }
}

