/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Application;
import com.facebook.ads.sdk.PaymentEnginePayment;
import com.facebook.ads.sdk.User;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class PaymentSubscription
extends APINode {
    @SerializedName(value="amount")
    private String mAmount = null;
    @SerializedName(value="app_param_data")
    private String mAppParamData = null;
    @SerializedName(value="application")
    private Application mApplication = null;
    @SerializedName(value="billing_period")
    private String mBillingPeriod = null;
    @SerializedName(value="canceled_reason")
    private String mCanceledReason = null;
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="currency")
    private String mCurrency = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="last_payment")
    private PaymentEnginePayment mLastPayment = null;
    @SerializedName(value="next_bill_time")
    private String mNextBillTime = null;
    @SerializedName(value="next_period_amount")
    private String mNextPeriodAmount = null;
    @SerializedName(value="next_period_currency")
    private String mNextPeriodCurrency = null;
    @SerializedName(value="next_period_product")
    private String mNextPeriodProduct = null;
    @SerializedName(value="payment_status")
    private String mPaymentStatus = null;
    @SerializedName(value="pending_cancel")
    private Boolean mPendingCancel = null;
    @SerializedName(value="period_start_time")
    private String mPeriodStartTime = null;
    @SerializedName(value="product")
    private String mProduct = null;
    @SerializedName(value="status")
    private String mStatus = null;
    @SerializedName(value="test")
    private Long mTest = null;
    @SerializedName(value="trial_amount")
    private String mTrialAmount = null;
    @SerializedName(value="trial_currency")
    private String mTrialCurrency = null;
    @SerializedName(value="trial_expiry_time")
    private String mTrialExpiryTime = null;
    @SerializedName(value="updated_time")
    private String mUpdatedTime = null;
    @SerializedName(value="user")
    private User mUser = null;
    protected static Gson gson = null;

    PaymentSubscription() {
    }

    public PaymentSubscription(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public PaymentSubscription(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public PaymentSubscription fetch() throws APIException {
        PaymentSubscription newInstance = PaymentSubscription.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static PaymentSubscription fetchById(Long id, APIContext context) throws APIException {
        return PaymentSubscription.fetchById(id.toString(), context);
    }

    public static ListenableFuture<PaymentSubscription> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return PaymentSubscription.fetchByIdAsync(id.toString(), context);
    }

    public static PaymentSubscription fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<PaymentSubscription> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<PaymentSubscription> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<PaymentSubscription>(context, "", "/", "GET", PaymentSubscription.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<PaymentSubscription>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<PaymentSubscription>(context, "", "/", "GET", PaymentSubscription.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static PaymentSubscription loadJSON(String json, APIContext context, String header) {
        PaymentSubscription paymentSubscription = (PaymentSubscription)PaymentSubscription.getGson().fromJson(json, PaymentSubscription.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(paymentSubscription.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        paymentSubscription.context = context;
        paymentSubscription.rawValue = json;
        paymentSubscription.header = header;
        return paymentSubscription;
    }

    public static APINodeList<PaymentSubscription> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<PaymentSubscription> paymentSubscriptions = new APINodeList<PaymentSubscription>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        paymentSubscriptions.add(PaymentSubscription.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return paymentSubscriptions;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            paymentSubscriptions.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        paymentSubscriptions.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            paymentSubscriptions.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            paymentSubscriptions.add(PaymentSubscription.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                paymentSubscriptions.add(PaymentSubscription.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            paymentSubscriptions.add(PaymentSubscription.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return paymentSubscriptions;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        paymentSubscriptions.add(PaymentSubscription.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return paymentSubscriptions;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        paymentSubscriptions.add(PaymentSubscription.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return paymentSubscriptions;
                }
                paymentSubscriptions.clear();
                paymentSubscriptions.add(PaymentSubscription.loadJSON(json, context, header));
                return paymentSubscriptions;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return PaymentSubscription.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAmount() {
        return this.mAmount;
    }

    public String getFieldAppParamData() {
        return this.mAppParamData;
    }

    public Application getFieldApplication() {
        if (this.mApplication != null) {
            this.mApplication.context = this.getContext();
        }
        return this.mApplication;
    }

    public String getFieldBillingPeriod() {
        return this.mBillingPeriod;
    }

    public String getFieldCanceledReason() {
        return this.mCanceledReason;
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public String getFieldCurrency() {
        return this.mCurrency;
    }

    public String getFieldId() {
        return this.mId;
    }

    public PaymentEnginePayment getFieldLastPayment() {
        if (this.mLastPayment != null) {
            this.mLastPayment.context = this.getContext();
        }
        return this.mLastPayment;
    }

    public String getFieldNextBillTime() {
        return this.mNextBillTime;
    }

    public String getFieldNextPeriodAmount() {
        return this.mNextPeriodAmount;
    }

    public String getFieldNextPeriodCurrency() {
        return this.mNextPeriodCurrency;
    }

    public String getFieldNextPeriodProduct() {
        return this.mNextPeriodProduct;
    }

    public String getFieldPaymentStatus() {
        return this.mPaymentStatus;
    }

    public Boolean getFieldPendingCancel() {
        return this.mPendingCancel;
    }

    public String getFieldPeriodStartTime() {
        return this.mPeriodStartTime;
    }

    public String getFieldProduct() {
        return this.mProduct;
    }

    public String getFieldStatus() {
        return this.mStatus;
    }

    public Long getFieldTest() {
        return this.mTest;
    }

    public String getFieldTrialAmount() {
        return this.mTrialAmount;
    }

    public String getFieldTrialCurrency() {
        return this.mTrialCurrency;
    }

    public String getFieldTrialExpiryTime() {
        return this.mTrialExpiryTime;
    }

    public String getFieldUpdatedTime() {
        return this.mUpdatedTime;
    }

    public User getFieldUser() {
        if (this.mUser != null) {
            this.mUser.context = this.getContext();
        }
        return this.mUser;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public PaymentSubscription copyFrom(PaymentSubscription instance) {
        this.mAmount = instance.mAmount;
        this.mAppParamData = instance.mAppParamData;
        this.mApplication = instance.mApplication;
        this.mBillingPeriod = instance.mBillingPeriod;
        this.mCanceledReason = instance.mCanceledReason;
        this.mCreatedTime = instance.mCreatedTime;
        this.mCurrency = instance.mCurrency;
        this.mId = instance.mId;
        this.mLastPayment = instance.mLastPayment;
        this.mNextBillTime = instance.mNextBillTime;
        this.mNextPeriodAmount = instance.mNextPeriodAmount;
        this.mNextPeriodCurrency = instance.mNextPeriodCurrency;
        this.mNextPeriodProduct = instance.mNextPeriodProduct;
        this.mPaymentStatus = instance.mPaymentStatus;
        this.mPendingCancel = instance.mPendingCancel;
        this.mPeriodStartTime = instance.mPeriodStartTime;
        this.mProduct = instance.mProduct;
        this.mStatus = instance.mStatus;
        this.mTest = instance.mTest;
        this.mTrialAmount = instance.mTrialAmount;
        this.mTrialCurrency = instance.mTrialCurrency;
        this.mTrialExpiryTime = instance.mTrialExpiryTime;
        this.mUpdatedTime = instance.mUpdatedTime;
        this.mUser = instance.mUser;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<PaymentSubscription> getParser() {
        return new APIRequest.ResponseParser<PaymentSubscription>(){

            @Override
            public APINodeList<PaymentSubscription> parseResponse(String response, APIContext context, APIRequest<PaymentSubscription> request, String header) throws APIException.MalformedResponseException {
                return PaymentSubscription.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<PaymentSubscription> {
        PaymentSubscription lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"amount", "app_param_data", "application", "billing_period", "canceled_reason", "created_time", "currency", "id", "last_payment", "next_bill_time", "next_period_amount", "next_period_currency", "next_period_product", "payment_status", "pending_cancel", "period_start_time", "product", "status", "test", "trial_amount", "trial_currency", "trial_expiry_time", "updated_time", "user"};

        @Override
        public PaymentSubscription getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public PaymentSubscription parseResponse(String response, String header) throws APIException {
            return PaymentSubscription.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public PaymentSubscription execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public PaymentSubscription execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<PaymentSubscription> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<PaymentSubscription> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, PaymentSubscription>(){

                public PaymentSubscription apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAmountField() {
            return this.requestAmountField(true);
        }

        public APIRequestGet requestAmountField(boolean value) {
            this.requestField("amount", value);
            return this;
        }

        public APIRequestGet requestAppParamDataField() {
            return this.requestAppParamDataField(true);
        }

        public APIRequestGet requestAppParamDataField(boolean value) {
            this.requestField("app_param_data", value);
            return this;
        }

        public APIRequestGet requestApplicationField() {
            return this.requestApplicationField(true);
        }

        public APIRequestGet requestApplicationField(boolean value) {
            this.requestField("application", value);
            return this;
        }

        public APIRequestGet requestBillingPeriodField() {
            return this.requestBillingPeriodField(true);
        }

        public APIRequestGet requestBillingPeriodField(boolean value) {
            this.requestField("billing_period", value);
            return this;
        }

        public APIRequestGet requestCanceledReasonField() {
            return this.requestCanceledReasonField(true);
        }

        public APIRequestGet requestCanceledReasonField(boolean value) {
            this.requestField("canceled_reason", value);
            return this;
        }

        public APIRequestGet requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGet requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGet requestCurrencyField() {
            return this.requestCurrencyField(true);
        }

        public APIRequestGet requestCurrencyField(boolean value) {
            this.requestField("currency", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestLastPaymentField() {
            return this.requestLastPaymentField(true);
        }

        public APIRequestGet requestLastPaymentField(boolean value) {
            this.requestField("last_payment", value);
            return this;
        }

        public APIRequestGet requestNextBillTimeField() {
            return this.requestNextBillTimeField(true);
        }

        public APIRequestGet requestNextBillTimeField(boolean value) {
            this.requestField("next_bill_time", value);
            return this;
        }

        public APIRequestGet requestNextPeriodAmountField() {
            return this.requestNextPeriodAmountField(true);
        }

        public APIRequestGet requestNextPeriodAmountField(boolean value) {
            this.requestField("next_period_amount", value);
            return this;
        }

        public APIRequestGet requestNextPeriodCurrencyField() {
            return this.requestNextPeriodCurrencyField(true);
        }

        public APIRequestGet requestNextPeriodCurrencyField(boolean value) {
            this.requestField("next_period_currency", value);
            return this;
        }

        public APIRequestGet requestNextPeriodProductField() {
            return this.requestNextPeriodProductField(true);
        }

        public APIRequestGet requestNextPeriodProductField(boolean value) {
            this.requestField("next_period_product", value);
            return this;
        }

        public APIRequestGet requestPaymentStatusField() {
            return this.requestPaymentStatusField(true);
        }

        public APIRequestGet requestPaymentStatusField(boolean value) {
            this.requestField("payment_status", value);
            return this;
        }

        public APIRequestGet requestPendingCancelField() {
            return this.requestPendingCancelField(true);
        }

        public APIRequestGet requestPendingCancelField(boolean value) {
            this.requestField("pending_cancel", value);
            return this;
        }

        public APIRequestGet requestPeriodStartTimeField() {
            return this.requestPeriodStartTimeField(true);
        }

        public APIRequestGet requestPeriodStartTimeField(boolean value) {
            this.requestField("period_start_time", value);
            return this;
        }

        public APIRequestGet requestProductField() {
            return this.requestProductField(true);
        }

        public APIRequestGet requestProductField(boolean value) {
            this.requestField("product", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestTestField() {
            return this.requestTestField(true);
        }

        public APIRequestGet requestTestField(boolean value) {
            this.requestField("test", value);
            return this;
        }

        public APIRequestGet requestTrialAmountField() {
            return this.requestTrialAmountField(true);
        }

        public APIRequestGet requestTrialAmountField(boolean value) {
            this.requestField("trial_amount", value);
            return this;
        }

        public APIRequestGet requestTrialCurrencyField() {
            return this.requestTrialCurrencyField(true);
        }

        public APIRequestGet requestTrialCurrencyField(boolean value) {
            this.requestField("trial_currency", value);
            return this;
        }

        public APIRequestGet requestTrialExpiryTimeField() {
            return this.requestTrialExpiryTimeField(true);
        }

        public APIRequestGet requestTrialExpiryTimeField(boolean value) {
            this.requestField("trial_expiry_time", value);
            return this;
        }

        public APIRequestGet requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGet requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGet requestUserField() {
            return this.requestUserField(true);
        }

        public APIRequestGet requestUserField(boolean value) {
            this.requestField("user", value);
            return this;
        }
    }
}

