/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

public class AudienceFunnel
extends APINode {
    @SerializedName(value="audience_type_param_name")
    private String mAudienceTypeParamName = null;
    @SerializedName(value="audience_type_param_tags")
    private List<Map<String, String>> mAudienceTypeParamTags = null;
    @SerializedName(value="custom_audience_groups_info")
    private List<Map<String, List<String>>> mCustomAudienceGroupsInfo = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AudienceFunnel loadJSON(String json, APIContext context, String header) {
        AudienceFunnel audienceFunnel = (AudienceFunnel)AudienceFunnel.getGson().fromJson(json, AudienceFunnel.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(audienceFunnel.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        audienceFunnel.context = context;
        audienceFunnel.rawValue = json;
        audienceFunnel.header = header;
        return audienceFunnel;
    }

    public static APINodeList<AudienceFunnel> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AudienceFunnel> audienceFunnels = new APINodeList<AudienceFunnel>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        audienceFunnels.add(AudienceFunnel.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return audienceFunnels;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            audienceFunnels.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        audienceFunnels.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            audienceFunnels.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            audienceFunnels.add(AudienceFunnel.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                audienceFunnels.add(AudienceFunnel.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            audienceFunnels.add(AudienceFunnel.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return audienceFunnels;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        audienceFunnels.add(AudienceFunnel.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return audienceFunnels;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        audienceFunnels.add(AudienceFunnel.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return audienceFunnels;
                }
                audienceFunnels.clear();
                audienceFunnels.add(AudienceFunnel.loadJSON(json, context, header));
                return audienceFunnels;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AudienceFunnel.getGson().toJson((Object)this);
    }

    public String getFieldAudienceTypeParamName() {
        return this.mAudienceTypeParamName;
    }

    public AudienceFunnel setFieldAudienceTypeParamName(String value) {
        this.mAudienceTypeParamName = value;
        return this;
    }

    public List<Map<String, String>> getFieldAudienceTypeParamTags() {
        return this.mAudienceTypeParamTags;
    }

    public AudienceFunnel setFieldAudienceTypeParamTags(List<Map<String, String>> value) {
        this.mAudienceTypeParamTags = value;
        return this;
    }

    public List<Map<String, List<String>>> getFieldCustomAudienceGroupsInfo() {
        return this.mCustomAudienceGroupsInfo;
    }

    public AudienceFunnel setFieldCustomAudienceGroupsInfo(List<Map<String, List<String>>> value) {
        this.mCustomAudienceGroupsInfo = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AudienceFunnel copyFrom(AudienceFunnel instance) {
        this.mAudienceTypeParamName = instance.mAudienceTypeParamName;
        this.mAudienceTypeParamTags = instance.mAudienceTypeParamTags;
        this.mCustomAudienceGroupsInfo = instance.mCustomAudienceGroupsInfo;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AudienceFunnel> getParser() {
        return new APIRequest.ResponseParser<AudienceFunnel>(){

            @Override
            public APINodeList<AudienceFunnel> parseResponse(String response, APIContext context, APIRequest<AudienceFunnel> request, String header) throws APIException.MalformedResponseException {
                return AudienceFunnel.parseResponse(response, context, request, header);
            }
        };
    }
}

