/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class ArAdsDataContainer
extends APINode {
    @SerializedName(value="camera_facing_override")
    private String mCameraFacingOverride = null;
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="effect")
    private List<Object> mEffect = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_published")
    private Boolean mIsPublished = null;
    @SerializedName(value="last_modified_time")
    private String mLastModifiedTime = null;
    @SerializedName(value="name")
    private String mName = null;
    protected static Gson gson = null;

    ArAdsDataContainer() {
    }

    public ArAdsDataContainer(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ArAdsDataContainer(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ArAdsDataContainer fetch() throws APIException {
        ArAdsDataContainer newInstance = ArAdsDataContainer.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ArAdsDataContainer fetchById(Long id, APIContext context) throws APIException {
        return ArAdsDataContainer.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ArAdsDataContainer> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ArAdsDataContainer.fetchByIdAsync(id.toString(), context);
    }

    public static ArAdsDataContainer fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<ArAdsDataContainer> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<ArAdsDataContainer> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ArAdsDataContainer>(context, "", "/", "GET", ArAdsDataContainer.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ArAdsDataContainer>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<ArAdsDataContainer>(context, "", "/", "GET", ArAdsDataContainer.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ArAdsDataContainer loadJSON(String json, APIContext context, String header) {
        ArAdsDataContainer arAdsDataContainer = (ArAdsDataContainer)ArAdsDataContainer.getGson().fromJson(json, ArAdsDataContainer.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(arAdsDataContainer.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        arAdsDataContainer.context = context;
        arAdsDataContainer.rawValue = json;
        arAdsDataContainer.header = header;
        return arAdsDataContainer;
    }

    public static APINodeList<ArAdsDataContainer> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ArAdsDataContainer> arAdsDataContainers = new APINodeList<ArAdsDataContainer>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        arAdsDataContainers.add(ArAdsDataContainer.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return arAdsDataContainers;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            arAdsDataContainers.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        arAdsDataContainers.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            arAdsDataContainers.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            arAdsDataContainers.add(ArAdsDataContainer.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                arAdsDataContainers.add(ArAdsDataContainer.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            arAdsDataContainers.add(ArAdsDataContainer.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return arAdsDataContainers;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        arAdsDataContainers.add(ArAdsDataContainer.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return arAdsDataContainers;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        arAdsDataContainers.add(ArAdsDataContainer.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return arAdsDataContainers;
                }
                arAdsDataContainers.clear();
                arAdsDataContainers.add(ArAdsDataContainer.loadJSON(json, context, header));
                return arAdsDataContainers;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ArAdsDataContainer.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldCameraFacingOverride() {
        return this.mCameraFacingOverride;
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public List<Object> getFieldEffect() {
        return this.mEffect;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsPublished() {
        return this.mIsPublished;
    }

    public String getFieldLastModifiedTime() {
        return this.mLastModifiedTime;
    }

    public String getFieldName() {
        return this.mName;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ArAdsDataContainer copyFrom(ArAdsDataContainer instance) {
        this.mCameraFacingOverride = instance.mCameraFacingOverride;
        this.mCreationTime = instance.mCreationTime;
        this.mEffect = instance.mEffect;
        this.mId = instance.mId;
        this.mIsPublished = instance.mIsPublished;
        this.mLastModifiedTime = instance.mLastModifiedTime;
        this.mName = instance.mName;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ArAdsDataContainer> getParser() {
        return new APIRequest.ResponseParser<ArAdsDataContainer>(){

            @Override
            public APINodeList<ArAdsDataContainer> parseResponse(String response, APIContext context, APIRequest<ArAdsDataContainer> request, String header) throws APIException.MalformedResponseException {
                return ArAdsDataContainer.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<ArAdsDataContainer> {
        ArAdsDataContainer lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"camera_facing_override", "creation_time", "effect", "id", "is_published", "last_modified_time", "name"};

        @Override
        public ArAdsDataContainer getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ArAdsDataContainer parseResponse(String response, String header) throws APIException {
            return ArAdsDataContainer.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public ArAdsDataContainer execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ArAdsDataContainer execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<ArAdsDataContainer> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ArAdsDataContainer> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, ArAdsDataContainer>(){

                public ArAdsDataContainer apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCameraFacingOverrideField() {
            return this.requestCameraFacingOverrideField(true);
        }

        public APIRequestGet requestCameraFacingOverrideField(boolean value) {
            this.requestField("camera_facing_override", value);
            return this;
        }

        public APIRequestGet requestCreationTimeField() {
            return this.requestCreationTimeField(true);
        }

        public APIRequestGet requestCreationTimeField(boolean value) {
            this.requestField("creation_time", value);
            return this;
        }

        public APIRequestGet requestEffectField() {
            return this.requestEffectField(true);
        }

        public APIRequestGet requestEffectField(boolean value) {
            this.requestField("effect", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsPublishedField() {
            return this.requestIsPublishedField(true);
        }

        public APIRequestGet requestIsPublishedField(boolean value) {
            this.requestField("is_published", value);
            return this;
        }

        public APIRequestGet requestLastModifiedTimeField() {
            return this.requestLastModifiedTimeField(true);
        }

        public APIRequestGet requestLastModifiedTimeField(boolean value) {
            this.requestField("last_modified_time", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }
    }
}

