/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

public class ALMGuidance
extends APINode {
    @SerializedName(value="ad_account_id")
    private String mAdAccountId = null;
    @SerializedName(value="guidances")
    private List<Object> mGuidances = null;
    @SerializedName(value="parent_advertiser_id")
    private String mParentAdvertiserId = null;
    @SerializedName(value="parent_advertiser_name")
    private String mParentAdvertiserName = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static ALMGuidance loadJSON(String json, APIContext context, String header) {
        ALMGuidance almGuidance = (ALMGuidance)ALMGuidance.getGson().fromJson(json, ALMGuidance.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(almGuidance.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        almGuidance.context = context;
        almGuidance.rawValue = json;
        almGuidance.header = header;
        return almGuidance;
    }

    public static APINodeList<ALMGuidance> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ALMGuidance> almGuidances = new APINodeList<ALMGuidance>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        almGuidances.add(ALMGuidance.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return almGuidances;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            almGuidances.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        almGuidances.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            almGuidances.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            almGuidances.add(ALMGuidance.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                almGuidances.add(ALMGuidance.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            almGuidances.add(ALMGuidance.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return almGuidances;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        almGuidances.add(ALMGuidance.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return almGuidances;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        almGuidances.add(ALMGuidance.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return almGuidances;
                }
                almGuidances.clear();
                almGuidances.add(ALMGuidance.loadJSON(json, context, header));
                return almGuidances;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ALMGuidance.getGson().toJson((Object)this);
    }

    public String getFieldAdAccountId() {
        return this.mAdAccountId;
    }

    public ALMGuidance setFieldAdAccountId(String value) {
        this.mAdAccountId = value;
        return this;
    }

    public List<Object> getFieldGuidances() {
        return this.mGuidances;
    }

    public ALMGuidance setFieldGuidances(List<Object> value) {
        this.mGuidances = value;
        return this;
    }

    public String getFieldParentAdvertiserId() {
        return this.mParentAdvertiserId;
    }

    public ALMGuidance setFieldParentAdvertiserId(String value) {
        this.mParentAdvertiserId = value;
        return this;
    }

    public String getFieldParentAdvertiserName() {
        return this.mParentAdvertiserName;
    }

    public ALMGuidance setFieldParentAdvertiserName(String value) {
        this.mParentAdvertiserName = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ALMGuidance copyFrom(ALMGuidance instance) {
        this.mAdAccountId = instance.mAdAccountId;
        this.mGuidances = instance.mGuidances;
        this.mParentAdvertiserId = instance.mParentAdvertiserId;
        this.mParentAdvertiserName = instance.mParentAdvertiserName;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ALMGuidance> getParser() {
        return new APIRequest.ResponseParser<ALMGuidance>(){

            @Override
            public APINodeList<ALMGuidance> parseResponse(String response, APIContext context, APIRequest<ALMGuidance> request, String header) throws APIException.MalformedResponseException {
                return ALMGuidance.parseResponse(response, context, request, header);
            }
        };
    }
}

