/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class ThirdPartyPartnerViewabilityRequest
extends APINode {
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="hour")
    private String mHour = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="metric")
    private EnumMetric mMetric = null;
    @SerializedName(value="modified_time")
    private String mModifiedTime = null;
    @SerializedName(value="owner_instance_id")
    private String mOwnerInstanceId = null;
    @SerializedName(value="platform")
    private EnumPlatform mPlatform = null;
    @SerializedName(value="status")
    private EnumStatus mStatus = null;
    @SerializedName(value="total_file_count")
    private Long mTotalFileCount = null;
    protected static Gson gson = null;

    ThirdPartyPartnerViewabilityRequest() {
    }

    public ThirdPartyPartnerViewabilityRequest(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public ThirdPartyPartnerViewabilityRequest(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public ThirdPartyPartnerViewabilityRequest fetch() throws APIException {
        ThirdPartyPartnerViewabilityRequest newInstance = ThirdPartyPartnerViewabilityRequest.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static ThirdPartyPartnerViewabilityRequest fetchById(Long id, APIContext context) throws APIException {
        return ThirdPartyPartnerViewabilityRequest.fetchById(id.toString(), context);
    }

    public static ListenableFuture<ThirdPartyPartnerViewabilityRequest> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return ThirdPartyPartnerViewabilityRequest.fetchByIdAsync(id.toString(), context);
    }

    public static ThirdPartyPartnerViewabilityRequest fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<ThirdPartyPartnerViewabilityRequest> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<ThirdPartyPartnerViewabilityRequest> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<ThirdPartyPartnerViewabilityRequest>(context, "", "/", "GET", ThirdPartyPartnerViewabilityRequest.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<ThirdPartyPartnerViewabilityRequest>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<ThirdPartyPartnerViewabilityRequest>(context, "", "/", "GET", ThirdPartyPartnerViewabilityRequest.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static ThirdPartyPartnerViewabilityRequest loadJSON(String json, APIContext context, String header) {
        ThirdPartyPartnerViewabilityRequest thirdPartyPartnerViewabilityRequest = (ThirdPartyPartnerViewabilityRequest)ThirdPartyPartnerViewabilityRequest.getGson().fromJson(json, ThirdPartyPartnerViewabilityRequest.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(thirdPartyPartnerViewabilityRequest.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        thirdPartyPartnerViewabilityRequest.context = context;
        thirdPartyPartnerViewabilityRequest.rawValue = json;
        thirdPartyPartnerViewabilityRequest.header = header;
        return thirdPartyPartnerViewabilityRequest;
    }

    public static APINodeList<ThirdPartyPartnerViewabilityRequest> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<ThirdPartyPartnerViewabilityRequest> thirdPartyPartnerViewabilityRequests = new APINodeList<ThirdPartyPartnerViewabilityRequest>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        thirdPartyPartnerViewabilityRequests.add(ThirdPartyPartnerViewabilityRequest.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return thirdPartyPartnerViewabilityRequests;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            thirdPartyPartnerViewabilityRequests.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        thirdPartyPartnerViewabilityRequests.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            thirdPartyPartnerViewabilityRequests.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            thirdPartyPartnerViewabilityRequests.add(ThirdPartyPartnerViewabilityRequest.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                thirdPartyPartnerViewabilityRequests.add(ThirdPartyPartnerViewabilityRequest.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            thirdPartyPartnerViewabilityRequests.add(ThirdPartyPartnerViewabilityRequest.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return thirdPartyPartnerViewabilityRequests;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        thirdPartyPartnerViewabilityRequests.add(ThirdPartyPartnerViewabilityRequest.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return thirdPartyPartnerViewabilityRequests;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        thirdPartyPartnerViewabilityRequests.add(ThirdPartyPartnerViewabilityRequest.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return thirdPartyPartnerViewabilityRequests;
                }
                thirdPartyPartnerViewabilityRequests.clear();
                thirdPartyPartnerViewabilityRequests.add(ThirdPartyPartnerViewabilityRequest.loadJSON(json, context, header));
                return thirdPartyPartnerViewabilityRequests;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return ThirdPartyPartnerViewabilityRequest.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldHour() {
        return this.mHour;
    }

    public String getFieldId() {
        return this.mId;
    }

    public EnumMetric getFieldMetric() {
        return this.mMetric;
    }

    public String getFieldModifiedTime() {
        return this.mModifiedTime;
    }

    public String getFieldOwnerInstanceId() {
        return this.mOwnerInstanceId;
    }

    public EnumPlatform getFieldPlatform() {
        return this.mPlatform;
    }

    public EnumStatus getFieldStatus() {
        return this.mStatus;
    }

    public Long getFieldTotalFileCount() {
        return this.mTotalFileCount;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public ThirdPartyPartnerViewabilityRequest copyFrom(ThirdPartyPartnerViewabilityRequest instance) {
        this.mCreatedTime = instance.mCreatedTime;
        this.mDescription = instance.mDescription;
        this.mHour = instance.mHour;
        this.mId = instance.mId;
        this.mMetric = instance.mMetric;
        this.mModifiedTime = instance.mModifiedTime;
        this.mOwnerInstanceId = instance.mOwnerInstanceId;
        this.mPlatform = instance.mPlatform;
        this.mStatus = instance.mStatus;
        this.mTotalFileCount = instance.mTotalFileCount;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<ThirdPartyPartnerViewabilityRequest> getParser() {
        return new APIRequest.ResponseParser<ThirdPartyPartnerViewabilityRequest>(){

            @Override
            public APINodeList<ThirdPartyPartnerViewabilityRequest> parseResponse(String response, APIContext context, APIRequest<ThirdPartyPartnerViewabilityRequest> request, String header) throws APIException.MalformedResponseException {
                return ThirdPartyPartnerViewabilityRequest.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumStatus {
        VALUE_CREATED("CREATED"),
        VALUE_FAILURE("FAILURE"),
        VALUE_IN_PROGRESS("IN_PROGRESS"),
        VALUE_SCHEDULED("SCHEDULED"),
        VALUE_SUCCESS("SUCCESS");

        private String value;

        private EnumStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumPlatform {
        VALUE_AUDIENCE_NETWORK("AUDIENCE_NETWORK"),
        VALUE_FACEBOOK("FACEBOOK"),
        VALUE_INSTAGRAM("INSTAGRAM");

        private String value;

        private EnumPlatform(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumMetric {
        VALUE_DISPLAY_EVENT("DISPLAY_EVENT"),
        VALUE_IMPRESSION("IMPRESSION"),
        VALUE_VIDEO_EVENT("VIDEO_EVENT");

        private String value;

        private EnumMetric(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestGet
    extends APIRequest<ThirdPartyPartnerViewabilityRequest> {
        ThirdPartyPartnerViewabilityRequest lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"created_time", "description", "hour", "id", "metric", "modified_time", "owner_instance_id", "platform", "status", "total_file_count"};

        @Override
        public ThirdPartyPartnerViewabilityRequest getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public ThirdPartyPartnerViewabilityRequest parseResponse(String response, String header) throws APIException {
            return ThirdPartyPartnerViewabilityRequest.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public ThirdPartyPartnerViewabilityRequest execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public ThirdPartyPartnerViewabilityRequest execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<ThirdPartyPartnerViewabilityRequest> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<ThirdPartyPartnerViewabilityRequest> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, ThirdPartyPartnerViewabilityRequest>(){

                public ThirdPartyPartnerViewabilityRequest apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGet requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestHourField() {
            return this.requestHourField(true);
        }

        public APIRequestGet requestHourField(boolean value) {
            this.requestField("hour", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestMetricField() {
            return this.requestMetricField(true);
        }

        public APIRequestGet requestMetricField(boolean value) {
            this.requestField("metric", value);
            return this;
        }

        public APIRequestGet requestModifiedTimeField() {
            return this.requestModifiedTimeField(true);
        }

        public APIRequestGet requestModifiedTimeField(boolean value) {
            this.requestField("modified_time", value);
            return this;
        }

        public APIRequestGet requestOwnerInstanceIdField() {
            return this.requestOwnerInstanceIdField(true);
        }

        public APIRequestGet requestOwnerInstanceIdField(boolean value) {
            this.requestField("owner_instance_id", value);
            return this;
        }

        public APIRequestGet requestPlatformField() {
            return this.requestPlatformField(true);
        }

        public APIRequestGet requestPlatformField(boolean value) {
            this.requestField("platform", value);
            return this;
        }

        public APIRequestGet requestStatusField() {
            return this.requestStatusField(true);
        }

        public APIRequestGet requestStatusField(boolean value) {
            this.requestField("status", value);
            return this;
        }

        public APIRequestGet requestTotalFileCountField() {
            return this.requestTotalFileCountField(true);
        }

        public APIRequestGet requestTotalFileCountField(boolean value) {
            this.requestField("total_file_count", value);
            return this;
        }
    }
}

