/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class TargetingAutomation
extends APINode {
    @SerializedName(value="advantage_audience")
    private Long mAdvantageAudience = null;
    @SerializedName(value="individual_setting")
    private Object mIndividualSetting = null;
    @SerializedName(value="shared_audiences")
    private Long mSharedAudiences = null;
    @SerializedName(value="value_expression")
    private Long mValueExpression = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static TargetingAutomation loadJSON(String json, APIContext context, String header) {
        TargetingAutomation targetingAutomation = (TargetingAutomation)TargetingAutomation.getGson().fromJson(json, TargetingAutomation.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(targetingAutomation.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        targetingAutomation.context = context;
        targetingAutomation.rawValue = json;
        targetingAutomation.header = header;
        return targetingAutomation;
    }

    public static APINodeList<TargetingAutomation> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<TargetingAutomation> targetingAutomations = new APINodeList<TargetingAutomation>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        targetingAutomations.add(TargetingAutomation.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return targetingAutomations;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            targetingAutomations.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        targetingAutomations.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            targetingAutomations.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            targetingAutomations.add(TargetingAutomation.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                targetingAutomations.add(TargetingAutomation.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            targetingAutomations.add(TargetingAutomation.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return targetingAutomations;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        targetingAutomations.add(TargetingAutomation.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return targetingAutomations;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        targetingAutomations.add(TargetingAutomation.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return targetingAutomations;
                }
                targetingAutomations.clear();
                targetingAutomations.add(TargetingAutomation.loadJSON(json, context, header));
                return targetingAutomations;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return TargetingAutomation.getGson().toJson((Object)this);
    }

    public Long getFieldAdvantageAudience() {
        return this.mAdvantageAudience;
    }

    public TargetingAutomation setFieldAdvantageAudience(Long value) {
        this.mAdvantageAudience = value;
        return this;
    }

    public Object getFieldIndividualSetting() {
        return this.mIndividualSetting;
    }

    public TargetingAutomation setFieldIndividualSetting(Object value) {
        this.mIndividualSetting = value;
        return this;
    }

    public Long getFieldSharedAudiences() {
        return this.mSharedAudiences;
    }

    public TargetingAutomation setFieldSharedAudiences(Long value) {
        this.mSharedAudiences = value;
        return this;
    }

    public Long getFieldValueExpression() {
        return this.mValueExpression;
    }

    public TargetingAutomation setFieldValueExpression(Long value) {
        this.mValueExpression = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public TargetingAutomation copyFrom(TargetingAutomation instance) {
        this.mAdvantageAudience = instance.mAdvantageAudience;
        this.mIndividualSetting = instance.mIndividualSetting;
        this.mSharedAudiences = instance.mSharedAudiences;
        this.mValueExpression = instance.mValueExpression;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<TargetingAutomation> getParser() {
        return new APIRequest.ResponseParser<TargetingAutomation>(){

            @Override
            public APINodeList<TargetingAutomation> parseResponse(String response, APIContext context, APIRequest<TargetingAutomation> request, String header) throws APIException.MalformedResponseException {
                return TargetingAutomation.parseResponse(response, context, request, header);
            }
        };
    }
}

