/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdVideo;
import com.facebook.ads.sdk.Photo;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class EventTour
extends APINode {
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="dominant_color")
    private String mDominantColor = null;
    @SerializedName(value="end_time")
    private String mEndTime = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_past")
    private Boolean mIsPast = null;
    @SerializedName(value="last_event_timestamp")
    private Long mLastEventTimestamp = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="num_events")
    private Long mNumEvents = null;
    @SerializedName(value="photo")
    private Photo mPhoto = null;
    @SerializedName(value="scheduled_publish_timestamp")
    private Long mScheduledPublishTimestamp = null;
    @SerializedName(value="start_time")
    private String mStartTime = null;
    @SerializedName(value="ticketing_uri")
    private String mTicketingUri = null;
    @SerializedName(value="video")
    private AdVideo mVideo = null;
    protected static Gson gson = null;

    EventTour() {
    }

    public EventTour(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public EventTour(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public EventTour fetch() throws APIException {
        EventTour newInstance = EventTour.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static EventTour fetchById(Long id, APIContext context) throws APIException {
        return EventTour.fetchById(id.toString(), context);
    }

    public static ListenableFuture<EventTour> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return EventTour.fetchByIdAsync(id.toString(), context);
    }

    public static EventTour fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<EventTour> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<EventTour> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<EventTour>(context, "", "/", "GET", EventTour.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<EventTour>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<EventTour>(context, "", "/", "GET", EventTour.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static EventTour loadJSON(String json, APIContext context, String header) {
        EventTour eventTour = (EventTour)EventTour.getGson().fromJson(json, EventTour.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(eventTour.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        eventTour.context = context;
        eventTour.rawValue = json;
        eventTour.header = header;
        return eventTour;
    }

    public static APINodeList<EventTour> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<EventTour> eventTours = new APINodeList<EventTour>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        eventTours.add(EventTour.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return eventTours;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            eventTours.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        eventTours.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            eventTours.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            eventTours.add(EventTour.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                eventTours.add(EventTour.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            eventTours.add(EventTour.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return eventTours;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        eventTours.add(EventTour.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return eventTours;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        eventTours.add(EventTour.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return eventTours;
                }
                eventTours.clear();
                eventTours.add(EventTour.loadJSON(json, context, header));
                return eventTours;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return EventTour.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldDominantColor() {
        return this.mDominantColor;
    }

    public String getFieldEndTime() {
        return this.mEndTime;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Boolean getFieldIsPast() {
        return this.mIsPast;
    }

    public Long getFieldLastEventTimestamp() {
        return this.mLastEventTimestamp;
    }

    public String getFieldName() {
        return this.mName;
    }

    public Long getFieldNumEvents() {
        return this.mNumEvents;
    }

    public Photo getFieldPhoto() {
        if (this.mPhoto != null) {
            this.mPhoto.context = this.getContext();
        }
        return this.mPhoto;
    }

    public Long getFieldScheduledPublishTimestamp() {
        return this.mScheduledPublishTimestamp;
    }

    public String getFieldStartTime() {
        return this.mStartTime;
    }

    public String getFieldTicketingUri() {
        return this.mTicketingUri;
    }

    public AdVideo getFieldVideo() {
        if (this.mVideo != null) {
            this.mVideo.context = this.getContext();
        }
        return this.mVideo;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public EventTour copyFrom(EventTour instance) {
        this.mDescription = instance.mDescription;
        this.mDominantColor = instance.mDominantColor;
        this.mEndTime = instance.mEndTime;
        this.mId = instance.mId;
        this.mIsPast = instance.mIsPast;
        this.mLastEventTimestamp = instance.mLastEventTimestamp;
        this.mName = instance.mName;
        this.mNumEvents = instance.mNumEvents;
        this.mPhoto = instance.mPhoto;
        this.mScheduledPublishTimestamp = instance.mScheduledPublishTimestamp;
        this.mStartTime = instance.mStartTime;
        this.mTicketingUri = instance.mTicketingUri;
        this.mVideo = instance.mVideo;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<EventTour> getParser() {
        return new APIRequest.ResponseParser<EventTour>(){

            @Override
            public APINodeList<EventTour> parseResponse(String response, APIContext context, APIRequest<EventTour> request, String header) throws APIException.MalformedResponseException {
                return EventTour.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<EventTour> {
        EventTour lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"description", "dominant_color", "end_time", "id", "is_past", "last_event_timestamp", "name", "num_events", "photo", "scheduled_publish_timestamp", "start_time", "ticketing_uri", "video"};

        @Override
        public EventTour getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public EventTour parseResponse(String response, String header) throws APIException {
            return EventTour.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public EventTour execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public EventTour execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<EventTour> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<EventTour> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, EventTour>(){

                public EventTour apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestDominantColorField() {
            return this.requestDominantColorField(true);
        }

        public APIRequestGet requestDominantColorField(boolean value) {
            this.requestField("dominant_color", value);
            return this;
        }

        public APIRequestGet requestEndTimeField() {
            return this.requestEndTimeField(true);
        }

        public APIRequestGet requestEndTimeField(boolean value) {
            this.requestField("end_time", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestIsPastField() {
            return this.requestIsPastField(true);
        }

        public APIRequestGet requestIsPastField(boolean value) {
            this.requestField("is_past", value);
            return this;
        }

        public APIRequestGet requestLastEventTimestampField() {
            return this.requestLastEventTimestampField(true);
        }

        public APIRequestGet requestLastEventTimestampField(boolean value) {
            this.requestField("last_event_timestamp", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestNumEventsField() {
            return this.requestNumEventsField(true);
        }

        public APIRequestGet requestNumEventsField(boolean value) {
            this.requestField("num_events", value);
            return this;
        }

        public APIRequestGet requestPhotoField() {
            return this.requestPhotoField(true);
        }

        public APIRequestGet requestPhotoField(boolean value) {
            this.requestField("photo", value);
            return this;
        }

        public APIRequestGet requestScheduledPublishTimestampField() {
            return this.requestScheduledPublishTimestampField(true);
        }

        public APIRequestGet requestScheduledPublishTimestampField(boolean value) {
            this.requestField("scheduled_publish_timestamp", value);
            return this;
        }

        public APIRequestGet requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGet requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGet requestTicketingUriField() {
            return this.requestTicketingUriField(true);
        }

        public APIRequestGet requestTicketingUriField(boolean value) {
            this.requestField("ticketing_uri", value);
            return this;
        }

        public APIRequestGet requestVideoField() {
            return this.requestVideoField(true);
        }

        public APIRequestGet requestVideoField(boolean value) {
            this.requestField("video", value);
            return this;
        }
    }
}

