/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class VidwallaBroadcast
extends APINode {
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="overlay_url")
    private String mOverlayUrl = null;
    protected static Gson gson = null;

    VidwallaBroadcast() {
    }

    public VidwallaBroadcast(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public VidwallaBroadcast(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public VidwallaBroadcast fetch() throws APIException {
        VidwallaBroadcast newInstance = VidwallaBroadcast.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static VidwallaBroadcast fetchById(Long id, APIContext context) throws APIException {
        return VidwallaBroadcast.fetchById(id.toString(), context);
    }

    public static ListenableFuture<VidwallaBroadcast> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return VidwallaBroadcast.fetchByIdAsync(id.toString(), context);
    }

    public static VidwallaBroadcast fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<VidwallaBroadcast> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<VidwallaBroadcast> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<VidwallaBroadcast>(context, "", "/", "GET", VidwallaBroadcast.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<VidwallaBroadcast>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<VidwallaBroadcast>(context, "", "/", "GET", VidwallaBroadcast.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static VidwallaBroadcast loadJSON(String json, APIContext context, String header) {
        VidwallaBroadcast vidwallaBroadcast = (VidwallaBroadcast)VidwallaBroadcast.getGson().fromJson(json, VidwallaBroadcast.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(vidwallaBroadcast.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        vidwallaBroadcast.context = context;
        vidwallaBroadcast.rawValue = json;
        vidwallaBroadcast.header = header;
        return vidwallaBroadcast;
    }

    public static APINodeList<VidwallaBroadcast> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<VidwallaBroadcast> vidwallaBroadcasts = new APINodeList<VidwallaBroadcast>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        vidwallaBroadcasts.add(VidwallaBroadcast.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return vidwallaBroadcasts;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            vidwallaBroadcasts.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        vidwallaBroadcasts.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            vidwallaBroadcasts.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            vidwallaBroadcasts.add(VidwallaBroadcast.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                vidwallaBroadcasts.add(VidwallaBroadcast.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            vidwallaBroadcasts.add(VidwallaBroadcast.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return vidwallaBroadcasts;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        vidwallaBroadcasts.add(VidwallaBroadcast.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return vidwallaBroadcasts;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        vidwallaBroadcasts.add(VidwallaBroadcast.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return vidwallaBroadcasts;
                }
                vidwallaBroadcasts.clear();
                vidwallaBroadcasts.add(VidwallaBroadcast.loadJSON(json, context, header));
                return vidwallaBroadcasts;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return VidwallaBroadcast.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldOverlayUrl() {
        return this.mOverlayUrl;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public VidwallaBroadcast copyFrom(VidwallaBroadcast instance) {
        this.mId = instance.mId;
        this.mOverlayUrl = instance.mOverlayUrl;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<VidwallaBroadcast> getParser() {
        return new APIRequest.ResponseParser<VidwallaBroadcast>(){

            @Override
            public APINodeList<VidwallaBroadcast> parseResponse(String response, APIContext context, APIRequest<VidwallaBroadcast> request, String header) throws APIException.MalformedResponseException {
                return VidwallaBroadcast.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<VidwallaBroadcast> {
        VidwallaBroadcast lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"id", "overlay_url"};

        @Override
        public VidwallaBroadcast getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public VidwallaBroadcast parseResponse(String response, String header) throws APIException {
            return VidwallaBroadcast.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public VidwallaBroadcast execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public VidwallaBroadcast execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<VidwallaBroadcast> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<VidwallaBroadcast> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, VidwallaBroadcast>(){

                public VidwallaBroadcast apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestOverlayUrlField() {
            return this.requestOverlayUrlField(true);
        }

        public APIRequestGet requestOverlayUrlField(boolean value) {
            this.requestField("overlay_url", value);
            return this;
        }
    }
}

