/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Page;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class CallAdsPhoneData
extends APINode {
    @SerializedName(value="call_ads_phone_data_use_case")
    private String mCallAdsPhoneDataUseCase = null;
    @SerializedName(value="callback_variant")
    private String mCallbackVariant = null;
    @SerializedName(value="destination_website_url")
    private String mDestinationWebsiteUrl = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="page")
    private Page mPage = null;
    @SerializedName(value="phone_number")
    private String mPhoneNumber = null;
    protected static Gson gson = null;

    CallAdsPhoneData() {
    }

    public CallAdsPhoneData(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public CallAdsPhoneData(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public CallAdsPhoneData fetch() throws APIException {
        CallAdsPhoneData newInstance = CallAdsPhoneData.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static CallAdsPhoneData fetchById(Long id, APIContext context) throws APIException {
        return CallAdsPhoneData.fetchById(id.toString(), context);
    }

    public static ListenableFuture<CallAdsPhoneData> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return CallAdsPhoneData.fetchByIdAsync(id.toString(), context);
    }

    public static CallAdsPhoneData fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<CallAdsPhoneData> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<CallAdsPhoneData> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<CallAdsPhoneData>(context, "", "/", "GET", CallAdsPhoneData.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<CallAdsPhoneData>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<CallAdsPhoneData>(context, "", "/", "GET", CallAdsPhoneData.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static CallAdsPhoneData loadJSON(String json, APIContext context, String header) {
        CallAdsPhoneData callAdsPhoneData = (CallAdsPhoneData)CallAdsPhoneData.getGson().fromJson(json, CallAdsPhoneData.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(callAdsPhoneData.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        callAdsPhoneData.context = context;
        callAdsPhoneData.rawValue = json;
        callAdsPhoneData.header = header;
        return callAdsPhoneData;
    }

    public static APINodeList<CallAdsPhoneData> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<CallAdsPhoneData> callAdsPhoneDatas = new APINodeList<CallAdsPhoneData>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        callAdsPhoneDatas.add(CallAdsPhoneData.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return callAdsPhoneDatas;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            callAdsPhoneDatas.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        callAdsPhoneDatas.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            callAdsPhoneDatas.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            callAdsPhoneDatas.add(CallAdsPhoneData.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                callAdsPhoneDatas.add(CallAdsPhoneData.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            callAdsPhoneDatas.add(CallAdsPhoneData.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return callAdsPhoneDatas;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        callAdsPhoneDatas.add(CallAdsPhoneData.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return callAdsPhoneDatas;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        callAdsPhoneDatas.add(CallAdsPhoneData.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return callAdsPhoneDatas;
                }
                callAdsPhoneDatas.clear();
                callAdsPhoneDatas.add(CallAdsPhoneData.loadJSON(json, context, header));
                return callAdsPhoneDatas;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CallAdsPhoneData.getGson().toJson((Object)this);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldCallAdsPhoneDataUseCase() {
        return this.mCallAdsPhoneDataUseCase;
    }

    public String getFieldCallbackVariant() {
        return this.mCallbackVariant;
    }

    public String getFieldDestinationWebsiteUrl() {
        return this.mDestinationWebsiteUrl;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Page getFieldPage() {
        if (this.mPage != null) {
            this.mPage.context = this.getContext();
        }
        return this.mPage;
    }

    public String getFieldPhoneNumber() {
        return this.mPhoneNumber;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CallAdsPhoneData copyFrom(CallAdsPhoneData instance) {
        this.mCallAdsPhoneDataUseCase = instance.mCallAdsPhoneDataUseCase;
        this.mCallbackVariant = instance.mCallbackVariant;
        this.mDestinationWebsiteUrl = instance.mDestinationWebsiteUrl;
        this.mId = instance.mId;
        this.mPage = instance.mPage;
        this.mPhoneNumber = instance.mPhoneNumber;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CallAdsPhoneData> getParser() {
        return new APIRequest.ResponseParser<CallAdsPhoneData>(){

            @Override
            public APINodeList<CallAdsPhoneData> parseResponse(String response, APIContext context, APIRequest<CallAdsPhoneData> request, String header) throws APIException.MalformedResponseException {
                return CallAdsPhoneData.parseResponse(response, context, request, header);
            }
        };
    }

    public static class APIRequestGet
    extends APIRequest<CallAdsPhoneData> {
        CallAdsPhoneData lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"call_ads_phone_data_use_case", "callback_variant", "destination_website_url", "id", "page", "phone_number"};

        @Override
        public CallAdsPhoneData getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public CallAdsPhoneData parseResponse(String response, String header) throws APIException {
            return CallAdsPhoneData.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public CallAdsPhoneData execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public CallAdsPhoneData execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<CallAdsPhoneData> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<CallAdsPhoneData> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, CallAdsPhoneData>(){

                public CallAdsPhoneData apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestCallAdsPhoneDataUseCaseField() {
            return this.requestCallAdsPhoneDataUseCaseField(true);
        }

        public APIRequestGet requestCallAdsPhoneDataUseCaseField(boolean value) {
            this.requestField("call_ads_phone_data_use_case", value);
            return this;
        }

        public APIRequestGet requestCallbackVariantField() {
            return this.requestCallbackVariantField(true);
        }

        public APIRequestGet requestCallbackVariantField(boolean value) {
            this.requestField("callback_variant", value);
            return this;
        }

        public APIRequestGet requestDestinationWebsiteUrlField() {
            return this.requestDestinationWebsiteUrlField(true);
        }

        public APIRequestGet requestDestinationWebsiteUrlField(boolean value) {
            this.requestField("destination_website_url", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestPageField() {
            return this.requestPageField(true);
        }

        public APIRequestGet requestPageField(boolean value) {
            this.requestField("page", value);
            return this;
        }

        public APIRequestGet requestPhoneNumberField() {
            return this.requestPhoneNumberField(true);
        }

        public APIRequestGet requestPhoneNumberField(boolean value) {
            this.requestField("phone_number", value);
            return this;
        }
    }
}

