/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

public class CPASSetupCatalogProgress
extends APINode {
    @SerializedName(value="child_catalog_count")
    private Long mChildCatalogCount = null;
    @SerializedName(value="child_catalog_issues")
    private List<Object> mChildCatalogIssues = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="issues")
    private List<Object> mIssues = null;
    @SerializedName(value="name")
    private String mName = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static CPASSetupCatalogProgress loadJSON(String json, APIContext context, String header) {
        CPASSetupCatalogProgress cpasSetupCatalogProgress = (CPASSetupCatalogProgress)CPASSetupCatalogProgress.getGson().fromJson(json, CPASSetupCatalogProgress.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(cpasSetupCatalogProgress.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        cpasSetupCatalogProgress.context = context;
        cpasSetupCatalogProgress.rawValue = json;
        cpasSetupCatalogProgress.header = header;
        return cpasSetupCatalogProgress;
    }

    public static APINodeList<CPASSetupCatalogProgress> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<CPASSetupCatalogProgress> cpasSetupCatalogProgresss = new APINodeList<CPASSetupCatalogProgress>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        cpasSetupCatalogProgresss.add(CPASSetupCatalogProgress.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return cpasSetupCatalogProgresss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            cpasSetupCatalogProgresss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        cpasSetupCatalogProgresss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            cpasSetupCatalogProgresss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            cpasSetupCatalogProgresss.add(CPASSetupCatalogProgress.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                cpasSetupCatalogProgresss.add(CPASSetupCatalogProgress.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            cpasSetupCatalogProgresss.add(CPASSetupCatalogProgress.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return cpasSetupCatalogProgresss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        cpasSetupCatalogProgresss.add(CPASSetupCatalogProgress.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return cpasSetupCatalogProgresss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        cpasSetupCatalogProgresss.add(CPASSetupCatalogProgress.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return cpasSetupCatalogProgresss;
                }
                cpasSetupCatalogProgresss.clear();
                cpasSetupCatalogProgresss.add(CPASSetupCatalogProgress.loadJSON(json, context, header));
                return cpasSetupCatalogProgresss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CPASSetupCatalogProgress.getGson().toJson((Object)this);
    }

    public Long getFieldChildCatalogCount() {
        return this.mChildCatalogCount;
    }

    public CPASSetupCatalogProgress setFieldChildCatalogCount(Long value) {
        this.mChildCatalogCount = value;
        return this;
    }

    public List<Object> getFieldChildCatalogIssues() {
        return this.mChildCatalogIssues;
    }

    public CPASSetupCatalogProgress setFieldChildCatalogIssues(List<Object> value) {
        this.mChildCatalogIssues = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public CPASSetupCatalogProgress setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public List<Object> getFieldIssues() {
        return this.mIssues;
    }

    public CPASSetupCatalogProgress setFieldIssues(List<Object> value) {
        this.mIssues = value;
        return this;
    }

    public String getFieldName() {
        return this.mName;
    }

    public CPASSetupCatalogProgress setFieldName(String value) {
        this.mName = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CPASSetupCatalogProgress copyFrom(CPASSetupCatalogProgress instance) {
        this.mChildCatalogCount = instance.mChildCatalogCount;
        this.mChildCatalogIssues = instance.mChildCatalogIssues;
        this.mId = instance.mId;
        this.mIssues = instance.mIssues;
        this.mName = instance.mName;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CPASSetupCatalogProgress> getParser() {
        return new APIRequest.ResponseParser<CPASSetupCatalogProgress>(){

            @Override
            public APINodeList<CPASSetupCatalogProgress> parseResponse(String response, APIContext context, APIRequest<CPASSetupCatalogProgress> request, String header) throws APIException.MalformedResponseException {
                return CPASSetupCatalogProgress.parseResponse(response, context, request, header);
            }
        };
    }
}

