/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Business;
import com.facebook.ads.sdk.Campaign;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;

public class BespokePartnerGuidanceLaser
extends APINode {
    @SerializedName(value="business")
    private Business mBusiness = null;
    @SerializedName(value="campaign_group")
    private Campaign mCampaignGroup = null;
    @SerializedName(value="cpa_improvement")
    private Double mCpaImprovement = null;
    @SerializedName(value="guidance_type")
    private String mGuidanceType = null;
    @SerializedName(value="id")
    private String mId = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static BespokePartnerGuidanceLaser loadJSON(String json, APIContext context, String header) {
        BespokePartnerGuidanceLaser bespokePartnerGuidanceLaser = (BespokePartnerGuidanceLaser)BespokePartnerGuidanceLaser.getGson().fromJson(json, BespokePartnerGuidanceLaser.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(bespokePartnerGuidanceLaser.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        bespokePartnerGuidanceLaser.context = context;
        bespokePartnerGuidanceLaser.rawValue = json;
        bespokePartnerGuidanceLaser.header = header;
        return bespokePartnerGuidanceLaser;
    }

    public static APINodeList<BespokePartnerGuidanceLaser> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<BespokePartnerGuidanceLaser> bespokePartnerGuidanceLasers = new APINodeList<BespokePartnerGuidanceLaser>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        bespokePartnerGuidanceLasers.add(BespokePartnerGuidanceLaser.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return bespokePartnerGuidanceLasers;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            bespokePartnerGuidanceLasers.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        bespokePartnerGuidanceLasers.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            bespokePartnerGuidanceLasers.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            bespokePartnerGuidanceLasers.add(BespokePartnerGuidanceLaser.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                bespokePartnerGuidanceLasers.add(BespokePartnerGuidanceLaser.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            bespokePartnerGuidanceLasers.add(BespokePartnerGuidanceLaser.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return bespokePartnerGuidanceLasers;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        bespokePartnerGuidanceLasers.add(BespokePartnerGuidanceLaser.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return bespokePartnerGuidanceLasers;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        bespokePartnerGuidanceLasers.add(BespokePartnerGuidanceLaser.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return bespokePartnerGuidanceLasers;
                }
                bespokePartnerGuidanceLasers.clear();
                bespokePartnerGuidanceLasers.add(BespokePartnerGuidanceLaser.loadJSON(json, context, header));
                return bespokePartnerGuidanceLasers;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return BespokePartnerGuidanceLaser.getGson().toJson((Object)this);
    }

    public Business getFieldBusiness() {
        if (this.mBusiness != null) {
            this.mBusiness.context = this.getContext();
        }
        return this.mBusiness;
    }

    public BespokePartnerGuidanceLaser setFieldBusiness(Business value) {
        this.mBusiness = value;
        return this;
    }

    public BespokePartnerGuidanceLaser setFieldBusiness(String value) {
        Type type = new TypeToken<Business>(){}.getType();
        this.mBusiness = (Business)Business.getGson().fromJson(value, type);
        return this;
    }

    public Campaign getFieldCampaignGroup() {
        if (this.mCampaignGroup != null) {
            this.mCampaignGroup.context = this.getContext();
        }
        return this.mCampaignGroup;
    }

    public BespokePartnerGuidanceLaser setFieldCampaignGroup(Campaign value) {
        this.mCampaignGroup = value;
        return this;
    }

    public BespokePartnerGuidanceLaser setFieldCampaignGroup(String value) {
        Type type = new TypeToken<Campaign>(){}.getType();
        this.mCampaignGroup = (Campaign)Campaign.getGson().fromJson(value, type);
        return this;
    }

    public Double getFieldCpaImprovement() {
        return this.mCpaImprovement;
    }

    public BespokePartnerGuidanceLaser setFieldCpaImprovement(Double value) {
        this.mCpaImprovement = value;
        return this;
    }

    public String getFieldGuidanceType() {
        return this.mGuidanceType;
    }

    public BespokePartnerGuidanceLaser setFieldGuidanceType(String value) {
        this.mGuidanceType = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public BespokePartnerGuidanceLaser setFieldId(String value) {
        this.mId = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public BespokePartnerGuidanceLaser copyFrom(BespokePartnerGuidanceLaser instance) {
        this.mBusiness = instance.mBusiness;
        this.mCampaignGroup = instance.mCampaignGroup;
        this.mCpaImprovement = instance.mCpaImprovement;
        this.mGuidanceType = instance.mGuidanceType;
        this.mId = instance.mId;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<BespokePartnerGuidanceLaser> getParser() {
        return new APIRequest.ResponseParser<BespokePartnerGuidanceLaser>(){

            @Override
            public APINodeList<BespokePartnerGuidanceLaser> parseResponse(String response, APIContext context, APIRequest<BespokePartnerGuidanceLaser> request, String header) throws APIException.MalformedResponseException {
                return BespokePartnerGuidanceLaser.parseResponse(response, context, request, header);
            }
        };
    }
}

