/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdCreativeBrandedContentAdsPartners;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class AdCreativeBrandedContentAds
extends APINode {
    @SerializedName(value="ad_format")
    private Long mAdFormat = null;
    @SerializedName(value="content_search_input")
    private String mContentSearchInput = null;
    @SerializedName(value="creator_ad_permission_type")
    private String mCreatorAdPermissionType = null;
    @SerializedName(value="facebook_boost_post_access_token")
    private String mFacebookBoostPostAccessToken = null;
    @SerializedName(value="instagram_boost_post_access_token")
    private String mInstagramBoostPostAccessToken = null;
    @SerializedName(value="is_mca_internal")
    private Boolean mIsMcaInternal = null;
    @SerializedName(value="partners")
    private List<AdCreativeBrandedContentAdsPartners> mPartners = null;
    @SerializedName(value="promoted_page_id")
    private String mPromotedPageId = null;
    @SerializedName(value="ui_version")
    private Long mUiVersion = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdCreativeBrandedContentAds loadJSON(String json, APIContext context, String header) {
        AdCreativeBrandedContentAds adCreativeBrandedContentAds = (AdCreativeBrandedContentAds)AdCreativeBrandedContentAds.getGson().fromJson(json, AdCreativeBrandedContentAds.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCreativeBrandedContentAds.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCreativeBrandedContentAds.context = context;
        adCreativeBrandedContentAds.rawValue = json;
        adCreativeBrandedContentAds.header = header;
        return adCreativeBrandedContentAds;
    }

    public static APINodeList<AdCreativeBrandedContentAds> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdCreativeBrandedContentAds> adCreativeBrandedContentAdss = new APINodeList<AdCreativeBrandedContentAds>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCreativeBrandedContentAdss.add(AdCreativeBrandedContentAds.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adCreativeBrandedContentAdss;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adCreativeBrandedContentAdss.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adCreativeBrandedContentAdss.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adCreativeBrandedContentAdss.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCreativeBrandedContentAdss.add(AdCreativeBrandedContentAds.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCreativeBrandedContentAdss.add(AdCreativeBrandedContentAds.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCreativeBrandedContentAdss.add(AdCreativeBrandedContentAds.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adCreativeBrandedContentAdss;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCreativeBrandedContentAdss.add(AdCreativeBrandedContentAds.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adCreativeBrandedContentAdss;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCreativeBrandedContentAdss.add(AdCreativeBrandedContentAds.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCreativeBrandedContentAdss;
                }
                adCreativeBrandedContentAdss.clear();
                adCreativeBrandedContentAdss.add(AdCreativeBrandedContentAds.loadJSON(json, context, header));
                return adCreativeBrandedContentAdss;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCreativeBrandedContentAds.getGson().toJson((Object)this);
    }

    public Long getFieldAdFormat() {
        return this.mAdFormat;
    }

    public AdCreativeBrandedContentAds setFieldAdFormat(Long value) {
        this.mAdFormat = value;
        return this;
    }

    public String getFieldContentSearchInput() {
        return this.mContentSearchInput;
    }

    public AdCreativeBrandedContentAds setFieldContentSearchInput(String value) {
        this.mContentSearchInput = value;
        return this;
    }

    public String getFieldCreatorAdPermissionType() {
        return this.mCreatorAdPermissionType;
    }

    public AdCreativeBrandedContentAds setFieldCreatorAdPermissionType(String value) {
        this.mCreatorAdPermissionType = value;
        return this;
    }

    public String getFieldFacebookBoostPostAccessToken() {
        return this.mFacebookBoostPostAccessToken;
    }

    public AdCreativeBrandedContentAds setFieldFacebookBoostPostAccessToken(String value) {
        this.mFacebookBoostPostAccessToken = value;
        return this;
    }

    public String getFieldInstagramBoostPostAccessToken() {
        return this.mInstagramBoostPostAccessToken;
    }

    public AdCreativeBrandedContentAds setFieldInstagramBoostPostAccessToken(String value) {
        this.mInstagramBoostPostAccessToken = value;
        return this;
    }

    public Boolean getFieldIsMcaInternal() {
        return this.mIsMcaInternal;
    }

    public AdCreativeBrandedContentAds setFieldIsMcaInternal(Boolean value) {
        this.mIsMcaInternal = value;
        return this;
    }

    public List<AdCreativeBrandedContentAdsPartners> getFieldPartners() {
        return this.mPartners;
    }

    public AdCreativeBrandedContentAds setFieldPartners(List<AdCreativeBrandedContentAdsPartners> value) {
        this.mPartners = value;
        return this;
    }

    public AdCreativeBrandedContentAds setFieldPartners(String value) {
        Type type = new TypeToken<List<AdCreativeBrandedContentAdsPartners>>(){}.getType();
        this.mPartners = (List)AdCreativeBrandedContentAdsPartners.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldPromotedPageId() {
        return this.mPromotedPageId;
    }

    public AdCreativeBrandedContentAds setFieldPromotedPageId(String value) {
        this.mPromotedPageId = value;
        return this;
    }

    public Long getFieldUiVersion() {
        return this.mUiVersion;
    }

    public AdCreativeBrandedContentAds setFieldUiVersion(Long value) {
        this.mUiVersion = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCreativeBrandedContentAds copyFrom(AdCreativeBrandedContentAds instance) {
        this.mAdFormat = instance.mAdFormat;
        this.mContentSearchInput = instance.mContentSearchInput;
        this.mCreatorAdPermissionType = instance.mCreatorAdPermissionType;
        this.mFacebookBoostPostAccessToken = instance.mFacebookBoostPostAccessToken;
        this.mInstagramBoostPostAccessToken = instance.mInstagramBoostPostAccessToken;
        this.mIsMcaInternal = instance.mIsMcaInternal;
        this.mPartners = instance.mPartners;
        this.mPromotedPageId = instance.mPromotedPageId;
        this.mUiVersion = instance.mUiVersion;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCreativeBrandedContentAds> getParser() {
        return new APIRequest.ResponseParser<AdCreativeBrandedContentAds>(){

            @Override
            public APINodeList<AdCreativeBrandedContentAds> parseResponse(String response, APIContext context, APIRequest<AdCreativeBrandedContentAds> request, String header) throws APIException.MalformedResponseException {
                return AdCreativeBrandedContentAds.parseResponse(response, context, request, header);
            }
        };
    }
}

