/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdAccount;
import com.facebook.ads.sdk.Business;
import com.facebook.ads.sdk.OfflineConversionDataSetPermissions;
import com.facebook.ads.sdk.OfflineConversionDataSetUsage;
import com.facebook.ads.sdk.User;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;

public class AdsDataset
extends APINode {
    @SerializedName(value="can_proxy")
    private Boolean mCanProxy = null;
    @SerializedName(value="collection_rate")
    private Double mCollectionRate = null;
    @SerializedName(value="config")
    private String mConfig = null;
    @SerializedName(value="creation_time")
    private String mCreationTime = null;
    @SerializedName(value="creator")
    private User mCreator = null;
    @SerializedName(value="dataset_id")
    private String mDatasetId = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="duplicate_entries")
    private Long mDuplicateEntries = null;
    @SerializedName(value="enable_auto_assign_to_accounts")
    private Boolean mEnableAutoAssignToAccounts = null;
    @SerializedName(value="enable_automatic_events")
    private Boolean mEnableAutomaticEvents = null;
    @SerializedName(value="enable_automatic_matching")
    private Boolean mEnableAutomaticMatching = null;
    @SerializedName(value="enable_real_time_event_log")
    private Boolean mEnableRealTimeEventLog = null;
    @SerializedName(value="event_stats")
    private String mEventStats = null;
    @SerializedName(value="event_time_max")
    private Long mEventTimeMax = null;
    @SerializedName(value="event_time_min")
    private Long mEventTimeMin = null;
    @SerializedName(value="first_party_cookie_status")
    private String mFirstPartyCookieStatus = null;
    @SerializedName(value="has_bapi_domains")
    private Boolean mHasBapiDomains = null;
    @SerializedName(value="has_catalog_microdata_activity")
    private Boolean mHasCatalogMicrodataActivity = null;
    @SerializedName(value="has_ofa_redacted_keys")
    private Boolean mHasOfaRedactedKeys = null;
    @SerializedName(value="has_sent_pii")
    private Boolean mHasSentPii = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="is_consolidated_container")
    private Boolean mIsConsolidatedContainer = null;
    @SerializedName(value="is_created_by_business")
    private Boolean mIsCreatedByBusiness = null;
    @SerializedName(value="is_crm")
    private Boolean mIsCrm = null;
    @SerializedName(value="is_eligible_for_sharing_to_ad_account")
    private Boolean mIsEligibleForSharingToAdAccount = null;
    @SerializedName(value="is_eligible_for_sharing_to_business")
    private Boolean mIsEligibleForSharingToBusiness = null;
    @SerializedName(value="is_eligible_for_value_optimization")
    private Boolean mIsEligibleForValueOptimization = null;
    @SerializedName(value="is_mta_use")
    private Boolean mIsMtaUse = null;
    @SerializedName(value="is_restricted_use")
    private Boolean mIsRestrictedUse = null;
    @SerializedName(value="is_unavailable")
    private Boolean mIsUnavailable = null;
    @SerializedName(value="last_fired_time")
    private String mLastFiredTime = null;
    @SerializedName(value="last_upload_app")
    private String mLastUploadApp = null;
    @SerializedName(value="last_upload_app_changed_time")
    private Long mLastUploadAppChangedTime = null;
    @SerializedName(value="last_upload_time")
    private Long mLastUploadTime = null;
    @SerializedName(value="late_upload_reminder_eligibility")
    private Boolean mLateUploadReminderEligibility = null;
    @SerializedName(value="match_rate_approx")
    private Long mMatchRateApprox = null;
    @SerializedName(value="matched_entries")
    private Long mMatchedEntries = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="no_ads_tracked_for_weekly_uploaded_events_reminder_eligibility")
    private Boolean mNoAdsTrackedForWeeklyUploadedEventsReminderEligibility = null;
    @SerializedName(value="num_active_ad_set_tracked")
    private Long mNumActiveAdSetTracked = null;
    @SerializedName(value="num_recent_offline_conversions_uploaded")
    private Long mNumRecentOfflineConversionsUploaded = null;
    @SerializedName(value="num_uploads")
    private Long mNumUploads = null;
    @SerializedName(value="owner_ad_account")
    private AdAccount mOwnerAdAccount = null;
    @SerializedName(value="owner_business")
    private Business mOwnerBusiness = null;
    @SerializedName(value="percentage_of_late_uploads_in_external_suboptimal_window")
    private Long mPercentageOfLateUploadsInExternalSuboptimalWindow = null;
    @SerializedName(value="permissions")
    private OfflineConversionDataSetPermissions mPermissions = null;
    @SerializedName(value="server_last_fired_time")
    private String mServerLastFiredTime = null;
    @SerializedName(value="show_automatic_events")
    private Boolean mShowAutomaticEvents = null;
    @SerializedName(value="upload_rate")
    private Double mUploadRate = null;
    @SerializedName(value="upload_reminder_eligibility")
    private Boolean mUploadReminderEligibility = null;
    @SerializedName(value="usage")
    private OfflineConversionDataSetUsage mUsage = null;
    @SerializedName(value="valid_entries")
    private Long mValidEntries = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdsDataset loadJSON(String json, APIContext context, String header) {
        AdsDataset adsDataset = (AdsDataset)AdsDataset.getGson().fromJson(json, AdsDataset.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adsDataset.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adsDataset.context = context;
        adsDataset.rawValue = json;
        adsDataset.header = header;
        return adsDataset;
    }

    public static APINodeList<AdsDataset> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdsDataset> adsDatasets = new APINodeList<AdsDataset>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adsDatasets.add(AdsDataset.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adsDatasets;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adsDatasets.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adsDatasets.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adsDatasets.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adsDatasets.add(AdsDataset.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adsDatasets.add(AdsDataset.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adsDatasets.add(AdsDataset.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adsDatasets;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adsDatasets.add(AdsDataset.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adsDatasets;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adsDatasets.add(AdsDataset.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adsDatasets;
                }
                adsDatasets.clear();
                adsDatasets.add(AdsDataset.loadJSON(json, context, header));
                return adsDatasets;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdsDataset.getGson().toJson((Object)this);
    }

    public Boolean getFieldCanProxy() {
        return this.mCanProxy;
    }

    public AdsDataset setFieldCanProxy(Boolean value) {
        this.mCanProxy = value;
        return this;
    }

    public Double getFieldCollectionRate() {
        return this.mCollectionRate;
    }

    public AdsDataset setFieldCollectionRate(Double value) {
        this.mCollectionRate = value;
        return this;
    }

    public String getFieldConfig() {
        return this.mConfig;
    }

    public AdsDataset setFieldConfig(String value) {
        this.mConfig = value;
        return this;
    }

    public String getFieldCreationTime() {
        return this.mCreationTime;
    }

    public AdsDataset setFieldCreationTime(String value) {
        this.mCreationTime = value;
        return this;
    }

    public User getFieldCreator() {
        if (this.mCreator != null) {
            this.mCreator.context = this.getContext();
        }
        return this.mCreator;
    }

    public AdsDataset setFieldCreator(User value) {
        this.mCreator = value;
        return this;
    }

    public AdsDataset setFieldCreator(String value) {
        Type type = new TypeToken<User>(){}.getType();
        this.mCreator = (User)User.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldDatasetId() {
        return this.mDatasetId;
    }

    public AdsDataset setFieldDatasetId(String value) {
        this.mDatasetId = value;
        return this;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public AdsDataset setFieldDescription(String value) {
        this.mDescription = value;
        return this;
    }

    public Long getFieldDuplicateEntries() {
        return this.mDuplicateEntries;
    }

    public AdsDataset setFieldDuplicateEntries(Long value) {
        this.mDuplicateEntries = value;
        return this;
    }

    public Boolean getFieldEnableAutoAssignToAccounts() {
        return this.mEnableAutoAssignToAccounts;
    }

    public AdsDataset setFieldEnableAutoAssignToAccounts(Boolean value) {
        this.mEnableAutoAssignToAccounts = value;
        return this;
    }

    public Boolean getFieldEnableAutomaticEvents() {
        return this.mEnableAutomaticEvents;
    }

    public AdsDataset setFieldEnableAutomaticEvents(Boolean value) {
        this.mEnableAutomaticEvents = value;
        return this;
    }

    public Boolean getFieldEnableAutomaticMatching() {
        return this.mEnableAutomaticMatching;
    }

    public AdsDataset setFieldEnableAutomaticMatching(Boolean value) {
        this.mEnableAutomaticMatching = value;
        return this;
    }

    public Boolean getFieldEnableRealTimeEventLog() {
        return this.mEnableRealTimeEventLog;
    }

    public AdsDataset setFieldEnableRealTimeEventLog(Boolean value) {
        this.mEnableRealTimeEventLog = value;
        return this;
    }

    public String getFieldEventStats() {
        return this.mEventStats;
    }

    public AdsDataset setFieldEventStats(String value) {
        this.mEventStats = value;
        return this;
    }

    public Long getFieldEventTimeMax() {
        return this.mEventTimeMax;
    }

    public AdsDataset setFieldEventTimeMax(Long value) {
        this.mEventTimeMax = value;
        return this;
    }

    public Long getFieldEventTimeMin() {
        return this.mEventTimeMin;
    }

    public AdsDataset setFieldEventTimeMin(Long value) {
        this.mEventTimeMin = value;
        return this;
    }

    public String getFieldFirstPartyCookieStatus() {
        return this.mFirstPartyCookieStatus;
    }

    public AdsDataset setFieldFirstPartyCookieStatus(String value) {
        this.mFirstPartyCookieStatus = value;
        return this;
    }

    public Boolean getFieldHasBapiDomains() {
        return this.mHasBapiDomains;
    }

    public AdsDataset setFieldHasBapiDomains(Boolean value) {
        this.mHasBapiDomains = value;
        return this;
    }

    public Boolean getFieldHasCatalogMicrodataActivity() {
        return this.mHasCatalogMicrodataActivity;
    }

    public AdsDataset setFieldHasCatalogMicrodataActivity(Boolean value) {
        this.mHasCatalogMicrodataActivity = value;
        return this;
    }

    public Boolean getFieldHasOfaRedactedKeys() {
        return this.mHasOfaRedactedKeys;
    }

    public AdsDataset setFieldHasOfaRedactedKeys(Boolean value) {
        this.mHasOfaRedactedKeys = value;
        return this;
    }

    public Boolean getFieldHasSentPii() {
        return this.mHasSentPii;
    }

    public AdsDataset setFieldHasSentPii(Boolean value) {
        this.mHasSentPii = value;
        return this;
    }

    public String getFieldId() {
        return this.mId;
    }

    public AdsDataset setFieldId(String value) {
        this.mId = value;
        return this;
    }

    public Boolean getFieldIsConsolidatedContainer() {
        return this.mIsConsolidatedContainer;
    }

    public AdsDataset setFieldIsConsolidatedContainer(Boolean value) {
        this.mIsConsolidatedContainer = value;
        return this;
    }

    public Boolean getFieldIsCreatedByBusiness() {
        return this.mIsCreatedByBusiness;
    }

    public AdsDataset setFieldIsCreatedByBusiness(Boolean value) {
        this.mIsCreatedByBusiness = value;
        return this;
    }

    public Boolean getFieldIsCrm() {
        return this.mIsCrm;
    }

    public AdsDataset setFieldIsCrm(Boolean value) {
        this.mIsCrm = value;
        return this;
    }

    public Boolean getFieldIsEligibleForSharingToAdAccount() {
        return this.mIsEligibleForSharingToAdAccount;
    }

    public AdsDataset setFieldIsEligibleForSharingToAdAccount(Boolean value) {
        this.mIsEligibleForSharingToAdAccount = value;
        return this;
    }

    public Boolean getFieldIsEligibleForSharingToBusiness() {
        return this.mIsEligibleForSharingToBusiness;
    }

    public AdsDataset setFieldIsEligibleForSharingToBusiness(Boolean value) {
        this.mIsEligibleForSharingToBusiness = value;
        return this;
    }

    public Boolean getFieldIsEligibleForValueOptimization() {
        return this.mIsEligibleForValueOptimization;
    }

    public AdsDataset setFieldIsEligibleForValueOptimization(Boolean value) {
        this.mIsEligibleForValueOptimization = value;
        return this;
    }

    public Boolean getFieldIsMtaUse() {
        return this.mIsMtaUse;
    }

    public AdsDataset setFieldIsMtaUse(Boolean value) {
        this.mIsMtaUse = value;
        return this;
    }

    public Boolean getFieldIsRestrictedUse() {
        return this.mIsRestrictedUse;
    }

    public AdsDataset setFieldIsRestrictedUse(Boolean value) {
        this.mIsRestrictedUse = value;
        return this;
    }

    public Boolean getFieldIsUnavailable() {
        return this.mIsUnavailable;
    }

    public AdsDataset setFieldIsUnavailable(Boolean value) {
        this.mIsUnavailable = value;
        return this;
    }

    public String getFieldLastFiredTime() {
        return this.mLastFiredTime;
    }

    public AdsDataset setFieldLastFiredTime(String value) {
        this.mLastFiredTime = value;
        return this;
    }

    public String getFieldLastUploadApp() {
        return this.mLastUploadApp;
    }

    public AdsDataset setFieldLastUploadApp(String value) {
        this.mLastUploadApp = value;
        return this;
    }

    public Long getFieldLastUploadAppChangedTime() {
        return this.mLastUploadAppChangedTime;
    }

    public AdsDataset setFieldLastUploadAppChangedTime(Long value) {
        this.mLastUploadAppChangedTime = value;
        return this;
    }

    public Long getFieldLastUploadTime() {
        return this.mLastUploadTime;
    }

    public AdsDataset setFieldLastUploadTime(Long value) {
        this.mLastUploadTime = value;
        return this;
    }

    public Boolean getFieldLateUploadReminderEligibility() {
        return this.mLateUploadReminderEligibility;
    }

    public AdsDataset setFieldLateUploadReminderEligibility(Boolean value) {
        this.mLateUploadReminderEligibility = value;
        return this;
    }

    public Long getFieldMatchRateApprox() {
        return this.mMatchRateApprox;
    }

    public AdsDataset setFieldMatchRateApprox(Long value) {
        this.mMatchRateApprox = value;
        return this;
    }

    public Long getFieldMatchedEntries() {
        return this.mMatchedEntries;
    }

    public AdsDataset setFieldMatchedEntries(Long value) {
        this.mMatchedEntries = value;
        return this;
    }

    public String getFieldName() {
        return this.mName;
    }

    public AdsDataset setFieldName(String value) {
        this.mName = value;
        return this;
    }

    public Boolean getFieldNoAdsTrackedForWeeklyUploadedEventsReminderEligibility() {
        return this.mNoAdsTrackedForWeeklyUploadedEventsReminderEligibility;
    }

    public AdsDataset setFieldNoAdsTrackedForWeeklyUploadedEventsReminderEligibility(Boolean value) {
        this.mNoAdsTrackedForWeeklyUploadedEventsReminderEligibility = value;
        return this;
    }

    public Long getFieldNumActiveAdSetTracked() {
        return this.mNumActiveAdSetTracked;
    }

    public AdsDataset setFieldNumActiveAdSetTracked(Long value) {
        this.mNumActiveAdSetTracked = value;
        return this;
    }

    public Long getFieldNumRecentOfflineConversionsUploaded() {
        return this.mNumRecentOfflineConversionsUploaded;
    }

    public AdsDataset setFieldNumRecentOfflineConversionsUploaded(Long value) {
        this.mNumRecentOfflineConversionsUploaded = value;
        return this;
    }

    public Long getFieldNumUploads() {
        return this.mNumUploads;
    }

    public AdsDataset setFieldNumUploads(Long value) {
        this.mNumUploads = value;
        return this;
    }

    public AdAccount getFieldOwnerAdAccount() {
        if (this.mOwnerAdAccount != null) {
            this.mOwnerAdAccount.context = this.getContext();
        }
        return this.mOwnerAdAccount;
    }

    public AdsDataset setFieldOwnerAdAccount(AdAccount value) {
        this.mOwnerAdAccount = value;
        return this;
    }

    public AdsDataset setFieldOwnerAdAccount(String value) {
        Type type = new TypeToken<AdAccount>(){}.getType();
        this.mOwnerAdAccount = (AdAccount)AdAccount.getGson().fromJson(value, type);
        return this;
    }

    public Business getFieldOwnerBusiness() {
        if (this.mOwnerBusiness != null) {
            this.mOwnerBusiness.context = this.getContext();
        }
        return this.mOwnerBusiness;
    }

    public AdsDataset setFieldOwnerBusiness(Business value) {
        this.mOwnerBusiness = value;
        return this;
    }

    public AdsDataset setFieldOwnerBusiness(String value) {
        Type type = new TypeToken<Business>(){}.getType();
        this.mOwnerBusiness = (Business)Business.getGson().fromJson(value, type);
        return this;
    }

    public Long getFieldPercentageOfLateUploadsInExternalSuboptimalWindow() {
        return this.mPercentageOfLateUploadsInExternalSuboptimalWindow;
    }

    public AdsDataset setFieldPercentageOfLateUploadsInExternalSuboptimalWindow(Long value) {
        this.mPercentageOfLateUploadsInExternalSuboptimalWindow = value;
        return this;
    }

    public OfflineConversionDataSetPermissions getFieldPermissions() {
        return this.mPermissions;
    }

    public AdsDataset setFieldPermissions(OfflineConversionDataSetPermissions value) {
        this.mPermissions = value;
        return this;
    }

    public AdsDataset setFieldPermissions(String value) {
        Type type = new TypeToken<OfflineConversionDataSetPermissions>(){}.getType();
        this.mPermissions = (OfflineConversionDataSetPermissions)OfflineConversionDataSetPermissions.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldServerLastFiredTime() {
        return this.mServerLastFiredTime;
    }

    public AdsDataset setFieldServerLastFiredTime(String value) {
        this.mServerLastFiredTime = value;
        return this;
    }

    public Boolean getFieldShowAutomaticEvents() {
        return this.mShowAutomaticEvents;
    }

    public AdsDataset setFieldShowAutomaticEvents(Boolean value) {
        this.mShowAutomaticEvents = value;
        return this;
    }

    public Double getFieldUploadRate() {
        return this.mUploadRate;
    }

    public AdsDataset setFieldUploadRate(Double value) {
        this.mUploadRate = value;
        return this;
    }

    public Boolean getFieldUploadReminderEligibility() {
        return this.mUploadReminderEligibility;
    }

    public AdsDataset setFieldUploadReminderEligibility(Boolean value) {
        this.mUploadReminderEligibility = value;
        return this;
    }

    public OfflineConversionDataSetUsage getFieldUsage() {
        return this.mUsage;
    }

    public AdsDataset setFieldUsage(OfflineConversionDataSetUsage value) {
        this.mUsage = value;
        return this;
    }

    public AdsDataset setFieldUsage(String value) {
        Type type = new TypeToken<OfflineConversionDataSetUsage>(){}.getType();
        this.mUsage = (OfflineConversionDataSetUsage)OfflineConversionDataSetUsage.getGson().fromJson(value, type);
        return this;
    }

    public Long getFieldValidEntries() {
        return this.mValidEntries;
    }

    public AdsDataset setFieldValidEntries(Long value) {
        this.mValidEntries = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdsDataset copyFrom(AdsDataset instance) {
        this.mCanProxy = instance.mCanProxy;
        this.mCollectionRate = instance.mCollectionRate;
        this.mConfig = instance.mConfig;
        this.mCreationTime = instance.mCreationTime;
        this.mCreator = instance.mCreator;
        this.mDatasetId = instance.mDatasetId;
        this.mDescription = instance.mDescription;
        this.mDuplicateEntries = instance.mDuplicateEntries;
        this.mEnableAutoAssignToAccounts = instance.mEnableAutoAssignToAccounts;
        this.mEnableAutomaticEvents = instance.mEnableAutomaticEvents;
        this.mEnableAutomaticMatching = instance.mEnableAutomaticMatching;
        this.mEnableRealTimeEventLog = instance.mEnableRealTimeEventLog;
        this.mEventStats = instance.mEventStats;
        this.mEventTimeMax = instance.mEventTimeMax;
        this.mEventTimeMin = instance.mEventTimeMin;
        this.mFirstPartyCookieStatus = instance.mFirstPartyCookieStatus;
        this.mHasBapiDomains = instance.mHasBapiDomains;
        this.mHasCatalogMicrodataActivity = instance.mHasCatalogMicrodataActivity;
        this.mHasOfaRedactedKeys = instance.mHasOfaRedactedKeys;
        this.mHasSentPii = instance.mHasSentPii;
        this.mId = instance.mId;
        this.mIsConsolidatedContainer = instance.mIsConsolidatedContainer;
        this.mIsCreatedByBusiness = instance.mIsCreatedByBusiness;
        this.mIsCrm = instance.mIsCrm;
        this.mIsEligibleForSharingToAdAccount = instance.mIsEligibleForSharingToAdAccount;
        this.mIsEligibleForSharingToBusiness = instance.mIsEligibleForSharingToBusiness;
        this.mIsEligibleForValueOptimization = instance.mIsEligibleForValueOptimization;
        this.mIsMtaUse = instance.mIsMtaUse;
        this.mIsRestrictedUse = instance.mIsRestrictedUse;
        this.mIsUnavailable = instance.mIsUnavailable;
        this.mLastFiredTime = instance.mLastFiredTime;
        this.mLastUploadApp = instance.mLastUploadApp;
        this.mLastUploadAppChangedTime = instance.mLastUploadAppChangedTime;
        this.mLastUploadTime = instance.mLastUploadTime;
        this.mLateUploadReminderEligibility = instance.mLateUploadReminderEligibility;
        this.mMatchRateApprox = instance.mMatchRateApprox;
        this.mMatchedEntries = instance.mMatchedEntries;
        this.mName = instance.mName;
        this.mNoAdsTrackedForWeeklyUploadedEventsReminderEligibility = instance.mNoAdsTrackedForWeeklyUploadedEventsReminderEligibility;
        this.mNumActiveAdSetTracked = instance.mNumActiveAdSetTracked;
        this.mNumRecentOfflineConversionsUploaded = instance.mNumRecentOfflineConversionsUploaded;
        this.mNumUploads = instance.mNumUploads;
        this.mOwnerAdAccount = instance.mOwnerAdAccount;
        this.mOwnerBusiness = instance.mOwnerBusiness;
        this.mPercentageOfLateUploadsInExternalSuboptimalWindow = instance.mPercentageOfLateUploadsInExternalSuboptimalWindow;
        this.mPermissions = instance.mPermissions;
        this.mServerLastFiredTime = instance.mServerLastFiredTime;
        this.mShowAutomaticEvents = instance.mShowAutomaticEvents;
        this.mUploadRate = instance.mUploadRate;
        this.mUploadReminderEligibility = instance.mUploadReminderEligibility;
        this.mUsage = instance.mUsage;
        this.mValidEntries = instance.mValidEntries;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdsDataset> getParser() {
        return new APIRequest.ResponseParser<AdsDataset>(){

            @Override
            public APINodeList<AdsDataset> parseResponse(String response, APIContext context, APIRequest<AdsDataset> request, String header) throws APIException.MalformedResponseException {
                return AdsDataset.parseResponse(response, context, request, header);
            }
        };
    }
}

