/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Business;
import com.facebook.ads.sdk.ExternalEventSource;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventSourceGroup
extends APINode {
    @SerializedName(value="business")
    private Business mBusiness = null;
    @SerializedName(value="event_sources")
    private List<ExternalEventSource> mEventSources = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="name")
    private String mName = null;
    protected static Gson gson = null;

    EventSourceGroup() {
    }

    public EventSourceGroup(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public EventSourceGroup(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public EventSourceGroup fetch() throws APIException {
        EventSourceGroup newInstance = EventSourceGroup.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static EventSourceGroup fetchById(Long id, APIContext context) throws APIException {
        return EventSourceGroup.fetchById(id.toString(), context);
    }

    public static EventSourceGroup fetchById(String id, APIContext context) throws APIException {
        EventSourceGroup eventSourceGroup = new APIRequestGet(id, context).requestAllFields().execute();
        return eventSourceGroup;
    }

    public static APINodeList<EventSourceGroup> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<EventSourceGroup>(context, "", "/", "GET", EventSourceGroup.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static EventSourceGroup loadJSON(String json, APIContext context) {
        EventSourceGroup eventSourceGroup = (EventSourceGroup)EventSourceGroup.getGson().fromJson(json, EventSourceGroup.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(eventSourceGroup.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        eventSourceGroup.context = context;
        eventSourceGroup.rawValue = json;
        return eventSourceGroup;
    }

    public static APINodeList<EventSourceGroup> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block18: {
            APINodeList<EventSourceGroup> eventSourceGroups = new APINodeList<EventSourceGroup>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        eventSourceGroups.add(EventSourceGroup.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return eventSourceGroups;
                }
                if (!result.isJsonObject()) break block18;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject().get("cursors").getAsJsonObject();
                        String[] before = paging.has("before") ? paging.get("before").getAsString() : null;
                        String after = paging.has("after") ? paging.get("after").getAsString() : null;
                        eventSourceGroups.setPaging((String)before, after);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            eventSourceGroups.add(EventSourceGroup.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                eventSourceGroups.add(EventSourceGroup.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            eventSourceGroups.add(EventSourceGroup.loadJSON(obj.toString(), context));
                        }
                    }
                    return eventSourceGroups;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        eventSourceGroups.add(EventSourceGroup.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return eventSourceGroups;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        eventSourceGroups.add(EventSourceGroup.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return eventSourceGroups;
                }
                eventSourceGroups.clear();
                eventSourceGroups.add(EventSourceGroup.loadJSON(json, context));
                return eventSourceGroups;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return EventSourceGroup.getGson().toJson((Object)this);
    }

    public APIRequestCreateSharedAccount createSharedAccount() {
        return new APIRequestCreateSharedAccount(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public Business getFieldBusiness() {
        if (this.mBusiness != null) {
            this.mBusiness.context = this.getContext();
        }
        return this.mBusiness;
    }

    public List<ExternalEventSource> getFieldEventSources() {
        return this.mEventSources;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldName() {
        return this.mName;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public EventSourceGroup copyFrom(EventSourceGroup instance) {
        this.mBusiness = instance.mBusiness;
        this.mEventSources = instance.mEventSources;
        this.mId = instance.mId;
        this.mName = instance.mName;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<EventSourceGroup> getParser() {
        return new APIRequest.ResponseParser<EventSourceGroup>(){

            @Override
            public APINodeList<EventSourceGroup> parseResponse(String response, APIContext context, APIRequest<EventSourceGroup> request) throws APIException.MalformedResponseException {
                return EventSourceGroup.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<EventSourceGroup> {
        EventSourceGroup lastResponse = null;
        public static final String[] PARAMS = new String[]{"event_sources", "name"};
        public static final String[] FIELDS = new String[0];

        @Override
        public EventSourceGroup getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public EventSourceGroup parseResponse(String response) throws APIException {
            return EventSourceGroup.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public EventSourceGroup execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public EventSourceGroup execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setEventSources(List<String> eventSources) {
            this.setParam("event_sources", eventSources);
            return this;
        }

        public APIRequestUpdate setEventSources(String eventSources) {
            this.setParam("event_sources", eventSources);
            return this;
        }

        public APIRequestUpdate setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<EventSourceGroup> {
        EventSourceGroup lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"business", "event_sources", "id", "name"};

        @Override
        public EventSourceGroup getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public EventSourceGroup parseResponse(String response) throws APIException {
            return EventSourceGroup.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public EventSourceGroup execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public EventSourceGroup execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGet requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGet requestEventSourcesField() {
            return this.requestEventSourcesField(true);
        }

        public APIRequestGet requestEventSourcesField(boolean value) {
            this.requestField("event_sources", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateSharedAccount
    extends APIRequest<EventSourceGroup> {
        EventSourceGroup lastResponse = null;
        public static final String[] PARAMS = new String[]{"accounts"};
        public static final String[] FIELDS = new String[0];

        @Override
        public EventSourceGroup getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public EventSourceGroup parseResponse(String response) throws APIException {
            return EventSourceGroup.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public EventSourceGroup execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public EventSourceGroup execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestCreateSharedAccount(String nodeId, APIContext context) {
            super(context, nodeId, "/shared_accounts", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateSharedAccount setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateSharedAccount setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateSharedAccount setAccounts(List<String> accounts) {
            this.setParam("accounts", accounts);
            return this;
        }

        public APIRequestCreateSharedAccount setAccounts(String accounts) {
            this.setParam("accounts", accounts);
            return this;
        }

        public APIRequestCreateSharedAccount requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateSharedAccount requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateSharedAccount requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateSharedAccount requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateSharedAccount requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateSharedAccount requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

