/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.Album;
import com.facebook.ads.sdk.Comment;
import com.facebook.ads.sdk.EntityAtTextRange;
import com.facebook.ads.sdk.Event;
import com.facebook.ads.sdk.InsightsResult;
import com.facebook.ads.sdk.Page;
import com.facebook.ads.sdk.Place;
import com.facebook.ads.sdk.PlatformImageSource;
import com.facebook.ads.sdk.Profile;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class Photo
extends APINode {
    @SerializedName(value="album")
    private Album mAlbum = null;
    @SerializedName(value="alt_text")
    private String mAltText = null;
    @SerializedName(value="alt_text_custom")
    private String mAltTextCustom = null;
    @SerializedName(value="backdated_time")
    private String mBackdatedTime = null;
    @SerializedName(value="backdated_time_granularity")
    private String mBackdatedTimeGranularity = null;
    @SerializedName(value="can_backdate")
    private Boolean mCanBackdate = null;
    @SerializedName(value="can_delete")
    private Boolean mCanDelete = null;
    @SerializedName(value="can_tag")
    private Boolean mCanTag = null;
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="event")
    private Event mEvent = null;
    @SerializedName(value="from")
    private Object mFrom = null;
    @SerializedName(value="height")
    private Long mHeight = null;
    @SerializedName(value="icon")
    private String mIcon = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="images")
    private List<PlatformImageSource> mImages = null;
    @SerializedName(value="link")
    private String mLink = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="name_tags")
    private List<EntityAtTextRange> mNameTags = null;
    @SerializedName(value="page_story_id")
    private String mPageStoryId = null;
    @SerializedName(value="picture")
    private String mPicture = null;
    @SerializedName(value="place")
    private Place mPlace = null;
    @SerializedName(value="position")
    private Long mPosition = null;
    @SerializedName(value="source")
    private String mSource = null;
    @SerializedName(value="target")
    private Profile mTarget = null;
    @SerializedName(value="updated_time")
    private String mUpdatedTime = null;
    @SerializedName(value="webp_images")
    private List<PlatformImageSource> mWebpImages = null;
    @SerializedName(value="width")
    private Long mWidth = null;
    protected static Gson gson = null;

    Photo() {
    }

    public Photo(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public Photo(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public Photo fetch() throws APIException {
        Photo newInstance = Photo.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static Photo fetchById(Long id, APIContext context) throws APIException {
        return Photo.fetchById(id.toString(), context);
    }

    public static ListenableFuture<Photo> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return Photo.fetchByIdAsync(id.toString(), context);
    }

    public static Photo fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<Photo> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<Photo> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<Photo>(context, "", "/", "GET", Photo.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<Photo>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<Photo>(context, "", "/", "GET", Photo.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static Photo loadJSON(String json, APIContext context, String header) {
        Photo photo = (Photo)Photo.getGson().fromJson(json, Photo.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(photo.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        photo.context = context;
        photo.rawValue = json;
        photo.header = header;
        return photo;
    }

    public static APINodeList<Photo> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<Photo> photos = new APINodeList<Photo>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        photos.add(Photo.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return photos;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            photos.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        photos.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            photos.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            photos.add(Photo.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                photos.add(Photo.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            photos.add(Photo.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return photos;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        photos.add(Photo.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return photos;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        photos.add(Photo.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return photos;
                }
                photos.clear();
                photos.add(Photo.loadJSON(json, context, header));
                return photos;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return Photo.getGson().toJson((Object)this);
    }

    public APIRequestGetComments getComments() {
        return new APIRequestGetComments(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateComment createComment() {
        return new APIRequestCreateComment(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetInsights getInsights() {
        return new APIRequestGetInsights(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetLikes getLikes() {
        return new APIRequestGetLikes(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateLike createLike() {
        return new APIRequestCreateLike(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetSponsorTags getSponsorTags() {
        return new APIRequestGetSponsorTags(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Album getFieldAlbum() {
        if (this.mAlbum != null) {
            this.mAlbum.context = this.getContext();
        }
        return this.mAlbum;
    }

    public String getFieldAltText() {
        return this.mAltText;
    }

    public String getFieldAltTextCustom() {
        return this.mAltTextCustom;
    }

    public String getFieldBackdatedTime() {
        return this.mBackdatedTime;
    }

    public String getFieldBackdatedTimeGranularity() {
        return this.mBackdatedTimeGranularity;
    }

    public Boolean getFieldCanBackdate() {
        return this.mCanBackdate;
    }

    public Boolean getFieldCanDelete() {
        return this.mCanDelete;
    }

    public Boolean getFieldCanTag() {
        return this.mCanTag;
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public Event getFieldEvent() {
        if (this.mEvent != null) {
            this.mEvent.context = this.getContext();
        }
        return this.mEvent;
    }

    public Object getFieldFrom() {
        return this.mFrom;
    }

    public Long getFieldHeight() {
        return this.mHeight;
    }

    public String getFieldIcon() {
        return this.mIcon;
    }

    public String getFieldId() {
        return this.mId;
    }

    public List<PlatformImageSource> getFieldImages() {
        return this.mImages;
    }

    public String getFieldLink() {
        return this.mLink;
    }

    public String getFieldName() {
        return this.mName;
    }

    public List<EntityAtTextRange> getFieldNameTags() {
        return this.mNameTags;
    }

    public String getFieldPageStoryId() {
        return this.mPageStoryId;
    }

    public String getFieldPicture() {
        return this.mPicture;
    }

    public Place getFieldPlace() {
        if (this.mPlace != null) {
            this.mPlace.context = this.getContext();
        }
        return this.mPlace;
    }

    public Long getFieldPosition() {
        return this.mPosition;
    }

    public String getFieldSource() {
        return this.mSource;
    }

    public Profile getFieldTarget() {
        if (this.mTarget != null) {
            this.mTarget.context = this.getContext();
        }
        return this.mTarget;
    }

    public String getFieldUpdatedTime() {
        return this.mUpdatedTime;
    }

    public List<PlatformImageSource> getFieldWebpImages() {
        return this.mWebpImages;
    }

    public Long getFieldWidth() {
        return this.mWidth;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public Photo copyFrom(Photo instance) {
        this.mAlbum = instance.mAlbum;
        this.mAltText = instance.mAltText;
        this.mAltTextCustom = instance.mAltTextCustom;
        this.mBackdatedTime = instance.mBackdatedTime;
        this.mBackdatedTimeGranularity = instance.mBackdatedTimeGranularity;
        this.mCanBackdate = instance.mCanBackdate;
        this.mCanDelete = instance.mCanDelete;
        this.mCanTag = instance.mCanTag;
        this.mCreatedTime = instance.mCreatedTime;
        this.mEvent = instance.mEvent;
        this.mFrom = instance.mFrom;
        this.mHeight = instance.mHeight;
        this.mIcon = instance.mIcon;
        this.mId = instance.mId;
        this.mImages = instance.mImages;
        this.mLink = instance.mLink;
        this.mName = instance.mName;
        this.mNameTags = instance.mNameTags;
        this.mPageStoryId = instance.mPageStoryId;
        this.mPicture = instance.mPicture;
        this.mPlace = instance.mPlace;
        this.mPosition = instance.mPosition;
        this.mSource = instance.mSource;
        this.mTarget = instance.mTarget;
        this.mUpdatedTime = instance.mUpdatedTime;
        this.mWebpImages = instance.mWebpImages;
        this.mWidth = instance.mWidth;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<Photo> getParser() {
        return new APIRequest.ResponseParser<Photo>(){

            @Override
            public APINodeList<Photo> parseResponse(String response, APIContext context, APIRequest<Photo> request, String header) throws APIException.MalformedResponseException {
                return Photo.parseResponse(response, context, request, header);
            }
        };
    }

    public static enum EnumType {
        VALUE_PROFILE("profile"),
        VALUE_TAGGED("tagged"),
        VALUE_UPLOADED("uploaded");

        private String value;

        private EnumType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumUnpublishedContentType {
        VALUE_ADS_POST("ADS_POST"),
        VALUE_DRAFT("DRAFT"),
        VALUE_INLINE_CREATED("INLINE_CREATED"),
        VALUE_PUBLISHED("PUBLISHED"),
        VALUE_REVIEWABLE_BRANDED_CONTENT("REVIEWABLE_BRANDED_CONTENT"),
        VALUE_SCHEDULED("SCHEDULED"),
        VALUE_SCHEDULED_RECURRING("SCHEDULED_RECURRING");

        private String value;

        private EnumUnpublishedContentType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum EnumBackdatedTimeGranularity {
        VALUE_DAY("day"),
        VALUE_HOUR("hour"),
        VALUE_MIN("min"),
        VALUE_MONTH("month"),
        VALUE_NONE("none"),
        VALUE_YEAR("year");

        private String value;

        private EnumBackdatedTimeGranularity(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class APIRequestGet
    extends APIRequest<Photo> {
        Photo lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"album", "alt_text", "alt_text_custom", "backdated_time", "backdated_time_granularity", "can_backdate", "can_delete", "can_tag", "created_time", "event", "from", "height", "icon", "id", "images", "link", "name", "name_tags", "page_story_id", "picture", "place", "position", "source", "target", "updated_time", "webp_images", "width"};

        @Override
        public Photo getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Photo parseResponse(String response, String header) throws APIException {
            return Photo.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public Photo execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Photo execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<Photo> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Photo> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, Photo>(){

                public Photo apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAlbumField() {
            return this.requestAlbumField(true);
        }

        public APIRequestGet requestAlbumField(boolean value) {
            this.requestField("album", value);
            return this;
        }

        public APIRequestGet requestAltTextField() {
            return this.requestAltTextField(true);
        }

        public APIRequestGet requestAltTextField(boolean value) {
            this.requestField("alt_text", value);
            return this;
        }

        public APIRequestGet requestAltTextCustomField() {
            return this.requestAltTextCustomField(true);
        }

        public APIRequestGet requestAltTextCustomField(boolean value) {
            this.requestField("alt_text_custom", value);
            return this;
        }

        public APIRequestGet requestBackdatedTimeField() {
            return this.requestBackdatedTimeField(true);
        }

        public APIRequestGet requestBackdatedTimeField(boolean value) {
            this.requestField("backdated_time", value);
            return this;
        }

        public APIRequestGet requestBackdatedTimeGranularityField() {
            return this.requestBackdatedTimeGranularityField(true);
        }

        public APIRequestGet requestBackdatedTimeGranularityField(boolean value) {
            this.requestField("backdated_time_granularity", value);
            return this;
        }

        public APIRequestGet requestCanBackdateField() {
            return this.requestCanBackdateField(true);
        }

        public APIRequestGet requestCanBackdateField(boolean value) {
            this.requestField("can_backdate", value);
            return this;
        }

        public APIRequestGet requestCanDeleteField() {
            return this.requestCanDeleteField(true);
        }

        public APIRequestGet requestCanDeleteField(boolean value) {
            this.requestField("can_delete", value);
            return this;
        }

        public APIRequestGet requestCanTagField() {
            return this.requestCanTagField(true);
        }

        public APIRequestGet requestCanTagField(boolean value) {
            this.requestField("can_tag", value);
            return this;
        }

        public APIRequestGet requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGet requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGet requestEventField() {
            return this.requestEventField(true);
        }

        public APIRequestGet requestEventField(boolean value) {
            this.requestField("event", value);
            return this;
        }

        public APIRequestGet requestFromField() {
            return this.requestFromField(true);
        }

        public APIRequestGet requestFromField(boolean value) {
            this.requestField("from", value);
            return this;
        }

        public APIRequestGet requestHeightField() {
            return this.requestHeightField(true);
        }

        public APIRequestGet requestHeightField(boolean value) {
            this.requestField("height", value);
            return this;
        }

        public APIRequestGet requestIconField() {
            return this.requestIconField(true);
        }

        public APIRequestGet requestIconField(boolean value) {
            this.requestField("icon", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestImagesField() {
            return this.requestImagesField(true);
        }

        public APIRequestGet requestImagesField(boolean value) {
            this.requestField("images", value);
            return this;
        }

        public APIRequestGet requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGet requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestNameTagsField() {
            return this.requestNameTagsField(true);
        }

        public APIRequestGet requestNameTagsField(boolean value) {
            this.requestField("name_tags", value);
            return this;
        }

        public APIRequestGet requestPageStoryIdField() {
            return this.requestPageStoryIdField(true);
        }

        public APIRequestGet requestPageStoryIdField(boolean value) {
            this.requestField("page_story_id", value);
            return this;
        }

        public APIRequestGet requestPictureField() {
            return this.requestPictureField(true);
        }

        public APIRequestGet requestPictureField(boolean value) {
            this.requestField("picture", value);
            return this;
        }

        public APIRequestGet requestPlaceField() {
            return this.requestPlaceField(true);
        }

        public APIRequestGet requestPlaceField(boolean value) {
            this.requestField("place", value);
            return this;
        }

        public APIRequestGet requestPositionField() {
            return this.requestPositionField(true);
        }

        public APIRequestGet requestPositionField(boolean value) {
            this.requestField("position", value);
            return this;
        }

        public APIRequestGet requestSourceField() {
            return this.requestSourceField(true);
        }

        public APIRequestGet requestSourceField(boolean value) {
            this.requestField("source", value);
            return this;
        }

        public APIRequestGet requestTargetField() {
            return this.requestTargetField(true);
        }

        public APIRequestGet requestTargetField(boolean value) {
            this.requestField("target", value);
            return this;
        }

        public APIRequestGet requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGet requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }

        public APIRequestGet requestWebpImagesField() {
            return this.requestWebpImagesField(true);
        }

        public APIRequestGet requestWebpImagesField(boolean value) {
            this.requestField("webp_images", value);
            return this;
        }

        public APIRequestGet requestWidthField() {
            return this.requestWidthField(true);
        }

        public APIRequestGet requestWidthField(boolean value) {
            this.requestField("width", value);
            return this;
        }
    }

    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetSponsorTags
    extends APIRequest<Page> {
        APINodeList<Page> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"about", "access_token", "ad_campaign", "affiliation", "app_id", "artists_we_like", "attire", "available_promo_offer_ids", "awards", "band_interests", "band_members", "best_page", "bio", "birthday", "booking_agent", "breaking_news_usage", "built", "business", "can_checkin", "can_post", "category", "category_list", "checkins", "company_overview", "connected_instagram_account", "connected_page_backed_instagram_account", "contact_address", "copyright_whitelisted_ig_partners", "country_page_likes", "cover", "culinary_team", "current_location", "delivery_and_pickup_option_info", "description", "description_html", "differently_open_offerings", "directed_by", "display_subtext", "displayed_message_response_time", "does_viewer_have_page_permission_link_ig", "emails", "engagement", "fan_count", "featured_video", "features", "followers_count", "food_styles", "founded", "general_info", "general_manager", "genre", "global_brand_page_name", "global_brand_root_id", "has_added_app", "has_lead_access", "has_transitioned_to_new_page_experience", "has_whatsapp_business_number", "has_whatsapp_number", "hometown", "hours", "id", "impressum", "influences", "instagram_business_account", "is_always_open", "is_chain", "is_community_page", "is_eligible_for_branded_content", "is_eligible_for_disable_connect_ig_btn_for_non_page_admin_am_web", "is_eligible_for_live_boosting_expansion", "is_messenger_bot_get_started_enabled", "is_messenger_platform_bot", "is_owned", "is_permanently_closed", "is_published", "is_unclaimed", "is_verified", "is_webhooks_subscribed", "keywords", "leadgen_tos_acceptance_time", "leadgen_tos_accepted", "leadgen_tos_accepting_user", "link", "location", "members", "merchant_id", "merchant_review_status", "messaging_feature_status", "messenger_ads_default_icebreakers", "messenger_ads_default_quick_replies", "messenger_ads_quick_replies_type", "mini_shop_storefront", "mission", "mpg", "name", "name_with_location_descriptor", "network", "new_like_count", "offer_eligible", "overall_star_rating", "owner_business", "page_token", "parent_page", "parking", "payment_options", "personal_info", "personal_interests", "pharma_safety_info", "phone", "pickup_options", "place_type", "plot_outline", "preferred_audience", "press_contact", "price_range", "privacy_info_url", "produced_by", "products", "promotion_eligible", "promotion_ineligible_reason", "public_transit", "rating_count", "recipient", "record_label", "release_date", "restaurant_services", "restaurant_specialties", "schedule", "screenplay_by", "season", "single_line_address", "starring", "start_info", "store_code", "store_location_descriptor", "store_number", "studio", "supports_donate_button_in_live_video", "talking_about_count", "temporary_status", "unread_message_count", "unread_notif_count", "unseen_message_count", "user_access_expire_time", "username", "verification_status", "voip_info", "website", "were_here_count", "whatsapp_number", "written_by"};

        @Override
        public APINodeList<Page> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Page> parseResponse(String response, String header) throws APIException {
            return Page.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Page> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Page> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Page>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Page>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Page>>(){

                public APINodeList<Page> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetSponsorTags(String nodeId, APIContext context) {
            super(context, nodeId, "/sponsor_tags", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetSponsorTags setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetSponsorTags setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetSponsorTags requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetSponsorTags requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetSponsorTags requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetSponsorTags requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetSponsorTags requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetSponsorTags requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetSponsorTags requestAboutField() {
            return this.requestAboutField(true);
        }

        public APIRequestGetSponsorTags requestAboutField(boolean value) {
            this.requestField("about", value);
            return this;
        }

        public APIRequestGetSponsorTags requestAccessTokenField() {
            return this.requestAccessTokenField(true);
        }

        public APIRequestGetSponsorTags requestAccessTokenField(boolean value) {
            this.requestField("access_token", value);
            return this;
        }

        public APIRequestGetSponsorTags requestAdCampaignField() {
            return this.requestAdCampaignField(true);
        }

        public APIRequestGetSponsorTags requestAdCampaignField(boolean value) {
            this.requestField("ad_campaign", value);
            return this;
        }

        public APIRequestGetSponsorTags requestAffiliationField() {
            return this.requestAffiliationField(true);
        }

        public APIRequestGetSponsorTags requestAffiliationField(boolean value) {
            this.requestField("affiliation", value);
            return this;
        }

        public APIRequestGetSponsorTags requestAppIdField() {
            return this.requestAppIdField(true);
        }

        public APIRequestGetSponsorTags requestAppIdField(boolean value) {
            this.requestField("app_id", value);
            return this;
        }

        public APIRequestGetSponsorTags requestArtistsWeLikeField() {
            return this.requestArtistsWeLikeField(true);
        }

        public APIRequestGetSponsorTags requestArtistsWeLikeField(boolean value) {
            this.requestField("artists_we_like", value);
            return this;
        }

        public APIRequestGetSponsorTags requestAttireField() {
            return this.requestAttireField(true);
        }

        public APIRequestGetSponsorTags requestAttireField(boolean value) {
            this.requestField("attire", value);
            return this;
        }

        public APIRequestGetSponsorTags requestAvailablePromoOfferIdsField() {
            return this.requestAvailablePromoOfferIdsField(true);
        }

        public APIRequestGetSponsorTags requestAvailablePromoOfferIdsField(boolean value) {
            this.requestField("available_promo_offer_ids", value);
            return this;
        }

        public APIRequestGetSponsorTags requestAwardsField() {
            return this.requestAwardsField(true);
        }

        public APIRequestGetSponsorTags requestAwardsField(boolean value) {
            this.requestField("awards", value);
            return this;
        }

        public APIRequestGetSponsorTags requestBandInterestsField() {
            return this.requestBandInterestsField(true);
        }

        public APIRequestGetSponsorTags requestBandInterestsField(boolean value) {
            this.requestField("band_interests", value);
            return this;
        }

        public APIRequestGetSponsorTags requestBandMembersField() {
            return this.requestBandMembersField(true);
        }

        public APIRequestGetSponsorTags requestBandMembersField(boolean value) {
            this.requestField("band_members", value);
            return this;
        }

        public APIRequestGetSponsorTags requestBestPageField() {
            return this.requestBestPageField(true);
        }

        public APIRequestGetSponsorTags requestBestPageField(boolean value) {
            this.requestField("best_page", value);
            return this;
        }

        public APIRequestGetSponsorTags requestBioField() {
            return this.requestBioField(true);
        }

        public APIRequestGetSponsorTags requestBioField(boolean value) {
            this.requestField("bio", value);
            return this;
        }

        public APIRequestGetSponsorTags requestBirthdayField() {
            return this.requestBirthdayField(true);
        }

        public APIRequestGetSponsorTags requestBirthdayField(boolean value) {
            this.requestField("birthday", value);
            return this;
        }

        public APIRequestGetSponsorTags requestBookingAgentField() {
            return this.requestBookingAgentField(true);
        }

        public APIRequestGetSponsorTags requestBookingAgentField(boolean value) {
            this.requestField("booking_agent", value);
            return this;
        }

        public APIRequestGetSponsorTags requestBreakingNewsUsageField() {
            return this.requestBreakingNewsUsageField(true);
        }

        public APIRequestGetSponsorTags requestBreakingNewsUsageField(boolean value) {
            this.requestField("breaking_news_usage", value);
            return this;
        }

        public APIRequestGetSponsorTags requestBuiltField() {
            return this.requestBuiltField(true);
        }

        public APIRequestGetSponsorTags requestBuiltField(boolean value) {
            this.requestField("built", value);
            return this;
        }

        public APIRequestGetSponsorTags requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGetSponsorTags requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGetSponsorTags requestCanCheckinField() {
            return this.requestCanCheckinField(true);
        }

        public APIRequestGetSponsorTags requestCanCheckinField(boolean value) {
            this.requestField("can_checkin", value);
            return this;
        }

        public APIRequestGetSponsorTags requestCanPostField() {
            return this.requestCanPostField(true);
        }

        public APIRequestGetSponsorTags requestCanPostField(boolean value) {
            this.requestField("can_post", value);
            return this;
        }

        public APIRequestGetSponsorTags requestCategoryField() {
            return this.requestCategoryField(true);
        }

        public APIRequestGetSponsorTags requestCategoryField(boolean value) {
            this.requestField("category", value);
            return this;
        }

        public APIRequestGetSponsorTags requestCategoryListField() {
            return this.requestCategoryListField(true);
        }

        public APIRequestGetSponsorTags requestCategoryListField(boolean value) {
            this.requestField("category_list", value);
            return this;
        }

        public APIRequestGetSponsorTags requestCheckinsField() {
            return this.requestCheckinsField(true);
        }

        public APIRequestGetSponsorTags requestCheckinsField(boolean value) {
            this.requestField("checkins", value);
            return this;
        }

        public APIRequestGetSponsorTags requestCompanyOverviewField() {
            return this.requestCompanyOverviewField(true);
        }

        public APIRequestGetSponsorTags requestCompanyOverviewField(boolean value) {
            this.requestField("company_overview", value);
            return this;
        }

        public APIRequestGetSponsorTags requestConnectedInstagramAccountField() {
            return this.requestConnectedInstagramAccountField(true);
        }

        public APIRequestGetSponsorTags requestConnectedInstagramAccountField(boolean value) {
            this.requestField("connected_instagram_account", value);
            return this;
        }

        public APIRequestGetSponsorTags requestConnectedPageBackedInstagramAccountField() {
            return this.requestConnectedPageBackedInstagramAccountField(true);
        }

        public APIRequestGetSponsorTags requestConnectedPageBackedInstagramAccountField(boolean value) {
            this.requestField("connected_page_backed_instagram_account", value);
            return this;
        }

        public APIRequestGetSponsorTags requestContactAddressField() {
            return this.requestContactAddressField(true);
        }

        public APIRequestGetSponsorTags requestContactAddressField(boolean value) {
            this.requestField("contact_address", value);
            return this;
        }

        public APIRequestGetSponsorTags requestCopyrightWhitelistedIgPartnersField() {
            return this.requestCopyrightWhitelistedIgPartnersField(true);
        }

        public APIRequestGetSponsorTags requestCopyrightWhitelistedIgPartnersField(boolean value) {
            this.requestField("copyright_whitelisted_ig_partners", value);
            return this;
        }

        public APIRequestGetSponsorTags requestCountryPageLikesField() {
            return this.requestCountryPageLikesField(true);
        }

        public APIRequestGetSponsorTags requestCountryPageLikesField(boolean value) {
            this.requestField("country_page_likes", value);
            return this;
        }

        public APIRequestGetSponsorTags requestCoverField() {
            return this.requestCoverField(true);
        }

        public APIRequestGetSponsorTags requestCoverField(boolean value) {
            this.requestField("cover", value);
            return this;
        }

        public APIRequestGetSponsorTags requestCulinaryTeamField() {
            return this.requestCulinaryTeamField(true);
        }

        public APIRequestGetSponsorTags requestCulinaryTeamField(boolean value) {
            this.requestField("culinary_team", value);
            return this;
        }

        public APIRequestGetSponsorTags requestCurrentLocationField() {
            return this.requestCurrentLocationField(true);
        }

        public APIRequestGetSponsorTags requestCurrentLocationField(boolean value) {
            this.requestField("current_location", value);
            return this;
        }

        public APIRequestGetSponsorTags requestDeliveryAndPickupOptionInfoField() {
            return this.requestDeliveryAndPickupOptionInfoField(true);
        }

        public APIRequestGetSponsorTags requestDeliveryAndPickupOptionInfoField(boolean value) {
            this.requestField("delivery_and_pickup_option_info", value);
            return this;
        }

        public APIRequestGetSponsorTags requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetSponsorTags requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetSponsorTags requestDescriptionHtmlField() {
            return this.requestDescriptionHtmlField(true);
        }

        public APIRequestGetSponsorTags requestDescriptionHtmlField(boolean value) {
            this.requestField("description_html", value);
            return this;
        }

        public APIRequestGetSponsorTags requestDifferentlyOpenOfferingsField() {
            return this.requestDifferentlyOpenOfferingsField(true);
        }

        public APIRequestGetSponsorTags requestDifferentlyOpenOfferingsField(boolean value) {
            this.requestField("differently_open_offerings", value);
            return this;
        }

        public APIRequestGetSponsorTags requestDirectedByField() {
            return this.requestDirectedByField(true);
        }

        public APIRequestGetSponsorTags requestDirectedByField(boolean value) {
            this.requestField("directed_by", value);
            return this;
        }

        public APIRequestGetSponsorTags requestDisplaySubtextField() {
            return this.requestDisplaySubtextField(true);
        }

        public APIRequestGetSponsorTags requestDisplaySubtextField(boolean value) {
            this.requestField("display_subtext", value);
            return this;
        }

        public APIRequestGetSponsorTags requestDisplayedMessageResponseTimeField() {
            return this.requestDisplayedMessageResponseTimeField(true);
        }

        public APIRequestGetSponsorTags requestDisplayedMessageResponseTimeField(boolean value) {
            this.requestField("displayed_message_response_time", value);
            return this;
        }

        public APIRequestGetSponsorTags requestDoesViewerHavePagePermissionLinkIgField() {
            return this.requestDoesViewerHavePagePermissionLinkIgField(true);
        }

        public APIRequestGetSponsorTags requestDoesViewerHavePagePermissionLinkIgField(boolean value) {
            this.requestField("does_viewer_have_page_permission_link_ig", value);
            return this;
        }

        public APIRequestGetSponsorTags requestEmailsField() {
            return this.requestEmailsField(true);
        }

        public APIRequestGetSponsorTags requestEmailsField(boolean value) {
            this.requestField("emails", value);
            return this;
        }

        public APIRequestGetSponsorTags requestEngagementField() {
            return this.requestEngagementField(true);
        }

        public APIRequestGetSponsorTags requestEngagementField(boolean value) {
            this.requestField("engagement", value);
            return this;
        }

        public APIRequestGetSponsorTags requestFanCountField() {
            return this.requestFanCountField(true);
        }

        public APIRequestGetSponsorTags requestFanCountField(boolean value) {
            this.requestField("fan_count", value);
            return this;
        }

        public APIRequestGetSponsorTags requestFeaturedVideoField() {
            return this.requestFeaturedVideoField(true);
        }

        public APIRequestGetSponsorTags requestFeaturedVideoField(boolean value) {
            this.requestField("featured_video", value);
            return this;
        }

        public APIRequestGetSponsorTags requestFeaturesField() {
            return this.requestFeaturesField(true);
        }

        public APIRequestGetSponsorTags requestFeaturesField(boolean value) {
            this.requestField("features", value);
            return this;
        }

        public APIRequestGetSponsorTags requestFollowersCountField() {
            return this.requestFollowersCountField(true);
        }

        public APIRequestGetSponsorTags requestFollowersCountField(boolean value) {
            this.requestField("followers_count", value);
            return this;
        }

        public APIRequestGetSponsorTags requestFoodStylesField() {
            return this.requestFoodStylesField(true);
        }

        public APIRequestGetSponsorTags requestFoodStylesField(boolean value) {
            this.requestField("food_styles", value);
            return this;
        }

        public APIRequestGetSponsorTags requestFoundedField() {
            return this.requestFoundedField(true);
        }

        public APIRequestGetSponsorTags requestFoundedField(boolean value) {
            this.requestField("founded", value);
            return this;
        }

        public APIRequestGetSponsorTags requestGeneralInfoField() {
            return this.requestGeneralInfoField(true);
        }

        public APIRequestGetSponsorTags requestGeneralInfoField(boolean value) {
            this.requestField("general_info", value);
            return this;
        }

        public APIRequestGetSponsorTags requestGeneralManagerField() {
            return this.requestGeneralManagerField(true);
        }

        public APIRequestGetSponsorTags requestGeneralManagerField(boolean value) {
            this.requestField("general_manager", value);
            return this;
        }

        public APIRequestGetSponsorTags requestGenreField() {
            return this.requestGenreField(true);
        }

        public APIRequestGetSponsorTags requestGenreField(boolean value) {
            this.requestField("genre", value);
            return this;
        }

        public APIRequestGetSponsorTags requestGlobalBrandPageNameField() {
            return this.requestGlobalBrandPageNameField(true);
        }

        public APIRequestGetSponsorTags requestGlobalBrandPageNameField(boolean value) {
            this.requestField("global_brand_page_name", value);
            return this;
        }

        public APIRequestGetSponsorTags requestGlobalBrandRootIdField() {
            return this.requestGlobalBrandRootIdField(true);
        }

        public APIRequestGetSponsorTags requestGlobalBrandRootIdField(boolean value) {
            this.requestField("global_brand_root_id", value);
            return this;
        }

        public APIRequestGetSponsorTags requestHasAddedAppField() {
            return this.requestHasAddedAppField(true);
        }

        public APIRequestGetSponsorTags requestHasAddedAppField(boolean value) {
            this.requestField("has_added_app", value);
            return this;
        }

        public APIRequestGetSponsorTags requestHasLeadAccessField() {
            return this.requestHasLeadAccessField(true);
        }

        public APIRequestGetSponsorTags requestHasLeadAccessField(boolean value) {
            this.requestField("has_lead_access", value);
            return this;
        }

        public APIRequestGetSponsorTags requestHasTransitionedToNewPageExperienceField() {
            return this.requestHasTransitionedToNewPageExperienceField(true);
        }

        public APIRequestGetSponsorTags requestHasTransitionedToNewPageExperienceField(boolean value) {
            this.requestField("has_transitioned_to_new_page_experience", value);
            return this;
        }

        public APIRequestGetSponsorTags requestHasWhatsappBusinessNumberField() {
            return this.requestHasWhatsappBusinessNumberField(true);
        }

        public APIRequestGetSponsorTags requestHasWhatsappBusinessNumberField(boolean value) {
            this.requestField("has_whatsapp_business_number", value);
            return this;
        }

        public APIRequestGetSponsorTags requestHasWhatsappNumberField() {
            return this.requestHasWhatsappNumberField(true);
        }

        public APIRequestGetSponsorTags requestHasWhatsappNumberField(boolean value) {
            this.requestField("has_whatsapp_number", value);
            return this;
        }

        public APIRequestGetSponsorTags requestHometownField() {
            return this.requestHometownField(true);
        }

        public APIRequestGetSponsorTags requestHometownField(boolean value) {
            this.requestField("hometown", value);
            return this;
        }

        public APIRequestGetSponsorTags requestHoursField() {
            return this.requestHoursField(true);
        }

        public APIRequestGetSponsorTags requestHoursField(boolean value) {
            this.requestField("hours", value);
            return this;
        }

        public APIRequestGetSponsorTags requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetSponsorTags requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetSponsorTags requestImpressumField() {
            return this.requestImpressumField(true);
        }

        public APIRequestGetSponsorTags requestImpressumField(boolean value) {
            this.requestField("impressum", value);
            return this;
        }

        public APIRequestGetSponsorTags requestInfluencesField() {
            return this.requestInfluencesField(true);
        }

        public APIRequestGetSponsorTags requestInfluencesField(boolean value) {
            this.requestField("influences", value);
            return this;
        }

        public APIRequestGetSponsorTags requestInstagramBusinessAccountField() {
            return this.requestInstagramBusinessAccountField(true);
        }

        public APIRequestGetSponsorTags requestInstagramBusinessAccountField(boolean value) {
            this.requestField("instagram_business_account", value);
            return this;
        }

        public APIRequestGetSponsorTags requestIsAlwaysOpenField() {
            return this.requestIsAlwaysOpenField(true);
        }

        public APIRequestGetSponsorTags requestIsAlwaysOpenField(boolean value) {
            this.requestField("is_always_open", value);
            return this;
        }

        public APIRequestGetSponsorTags requestIsChainField() {
            return this.requestIsChainField(true);
        }

        public APIRequestGetSponsorTags requestIsChainField(boolean value) {
            this.requestField("is_chain", value);
            return this;
        }

        public APIRequestGetSponsorTags requestIsCommunityPageField() {
            return this.requestIsCommunityPageField(true);
        }

        public APIRequestGetSponsorTags requestIsCommunityPageField(boolean value) {
            this.requestField("is_community_page", value);
            return this;
        }

        public APIRequestGetSponsorTags requestIsEligibleForBrandedContentField() {
            return this.requestIsEligibleForBrandedContentField(true);
        }

        public APIRequestGetSponsorTags requestIsEligibleForBrandedContentField(boolean value) {
            this.requestField("is_eligible_for_branded_content", value);
            return this;
        }

        public APIRequestGetSponsorTags requestIsEligibleForDisableConnectIgBtnForNonPageAdminAmWebField() {
            return this.requestIsEligibleForDisableConnectIgBtnForNonPageAdminAmWebField(true);
        }

        public APIRequestGetSponsorTags requestIsEligibleForDisableConnectIgBtnForNonPageAdminAmWebField(boolean value) {
            this.requestField("is_eligible_for_disable_connect_ig_btn_for_non_page_admin_am_web", value);
            return this;
        }

        public APIRequestGetSponsorTags requestIsEligibleForLiveBoostingExpansionField() {
            return this.requestIsEligibleForLiveBoostingExpansionField(true);
        }

        public APIRequestGetSponsorTags requestIsEligibleForLiveBoostingExpansionField(boolean value) {
            this.requestField("is_eligible_for_live_boosting_expansion", value);
            return this;
        }

        public APIRequestGetSponsorTags requestIsMessengerBotGetStartedEnabledField() {
            return this.requestIsMessengerBotGetStartedEnabledField(true);
        }

        public APIRequestGetSponsorTags requestIsMessengerBotGetStartedEnabledField(boolean value) {
            this.requestField("is_messenger_bot_get_started_enabled", value);
            return this;
        }

        public APIRequestGetSponsorTags requestIsMessengerPlatformBotField() {
            return this.requestIsMessengerPlatformBotField(true);
        }

        public APIRequestGetSponsorTags requestIsMessengerPlatformBotField(boolean value) {
            this.requestField("is_messenger_platform_bot", value);
            return this;
        }

        public APIRequestGetSponsorTags requestIsOwnedField() {
            return this.requestIsOwnedField(true);
        }

        public APIRequestGetSponsorTags requestIsOwnedField(boolean value) {
            this.requestField("is_owned", value);
            return this;
        }

        public APIRequestGetSponsorTags requestIsPermanentlyClosedField() {
            return this.requestIsPermanentlyClosedField(true);
        }

        public APIRequestGetSponsorTags requestIsPermanentlyClosedField(boolean value) {
            this.requestField("is_permanently_closed", value);
            return this;
        }

        public APIRequestGetSponsorTags requestIsPublishedField() {
            return this.requestIsPublishedField(true);
        }

        public APIRequestGetSponsorTags requestIsPublishedField(boolean value) {
            this.requestField("is_published", value);
            return this;
        }

        public APIRequestGetSponsorTags requestIsUnclaimedField() {
            return this.requestIsUnclaimedField(true);
        }

        public APIRequestGetSponsorTags requestIsUnclaimedField(boolean value) {
            this.requestField("is_unclaimed", value);
            return this;
        }

        public APIRequestGetSponsorTags requestIsVerifiedField() {
            return this.requestIsVerifiedField(true);
        }

        public APIRequestGetSponsorTags requestIsVerifiedField(boolean value) {
            this.requestField("is_verified", value);
            return this;
        }

        public APIRequestGetSponsorTags requestIsWebhooksSubscribedField() {
            return this.requestIsWebhooksSubscribedField(true);
        }

        public APIRequestGetSponsorTags requestIsWebhooksSubscribedField(boolean value) {
            this.requestField("is_webhooks_subscribed", value);
            return this;
        }

        public APIRequestGetSponsorTags requestKeywordsField() {
            return this.requestKeywordsField(true);
        }

        public APIRequestGetSponsorTags requestKeywordsField(boolean value) {
            this.requestField("keywords", value);
            return this;
        }

        public APIRequestGetSponsorTags requestLeadgenTosAcceptanceTimeField() {
            return this.requestLeadgenTosAcceptanceTimeField(true);
        }

        public APIRequestGetSponsorTags requestLeadgenTosAcceptanceTimeField(boolean value) {
            this.requestField("leadgen_tos_acceptance_time", value);
            return this;
        }

        public APIRequestGetSponsorTags requestLeadgenTosAcceptedField() {
            return this.requestLeadgenTosAcceptedField(true);
        }

        public APIRequestGetSponsorTags requestLeadgenTosAcceptedField(boolean value) {
            this.requestField("leadgen_tos_accepted", value);
            return this;
        }

        public APIRequestGetSponsorTags requestLeadgenTosAcceptingUserField() {
            return this.requestLeadgenTosAcceptingUserField(true);
        }

        public APIRequestGetSponsorTags requestLeadgenTosAcceptingUserField(boolean value) {
            this.requestField("leadgen_tos_accepting_user", value);
            return this;
        }

        public APIRequestGetSponsorTags requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetSponsorTags requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetSponsorTags requestLocationField() {
            return this.requestLocationField(true);
        }

        public APIRequestGetSponsorTags requestLocationField(boolean value) {
            this.requestField("location", value);
            return this;
        }

        public APIRequestGetSponsorTags requestMembersField() {
            return this.requestMembersField(true);
        }

        public APIRequestGetSponsorTags requestMembersField(boolean value) {
            this.requestField("members", value);
            return this;
        }

        public APIRequestGetSponsorTags requestMerchantIdField() {
            return this.requestMerchantIdField(true);
        }

        public APIRequestGetSponsorTags requestMerchantIdField(boolean value) {
            this.requestField("merchant_id", value);
            return this;
        }

        public APIRequestGetSponsorTags requestMerchantReviewStatusField() {
            return this.requestMerchantReviewStatusField(true);
        }

        public APIRequestGetSponsorTags requestMerchantReviewStatusField(boolean value) {
            this.requestField("merchant_review_status", value);
            return this;
        }

        public APIRequestGetSponsorTags requestMessagingFeatureStatusField() {
            return this.requestMessagingFeatureStatusField(true);
        }

        public APIRequestGetSponsorTags requestMessagingFeatureStatusField(boolean value) {
            this.requestField("messaging_feature_status", value);
            return this;
        }

        public APIRequestGetSponsorTags requestMessengerAdsDefaultIcebreakersField() {
            return this.requestMessengerAdsDefaultIcebreakersField(true);
        }

        public APIRequestGetSponsorTags requestMessengerAdsDefaultIcebreakersField(boolean value) {
            this.requestField("messenger_ads_default_icebreakers", value);
            return this;
        }

        public APIRequestGetSponsorTags requestMessengerAdsDefaultQuickRepliesField() {
            return this.requestMessengerAdsDefaultQuickRepliesField(true);
        }

        public APIRequestGetSponsorTags requestMessengerAdsDefaultQuickRepliesField(boolean value) {
            this.requestField("messenger_ads_default_quick_replies", value);
            return this;
        }

        public APIRequestGetSponsorTags requestMessengerAdsQuickRepliesTypeField() {
            return this.requestMessengerAdsQuickRepliesTypeField(true);
        }

        public APIRequestGetSponsorTags requestMessengerAdsQuickRepliesTypeField(boolean value) {
            this.requestField("messenger_ads_quick_replies_type", value);
            return this;
        }

        public APIRequestGetSponsorTags requestMiniShopStorefrontField() {
            return this.requestMiniShopStorefrontField(true);
        }

        public APIRequestGetSponsorTags requestMiniShopStorefrontField(boolean value) {
            this.requestField("mini_shop_storefront", value);
            return this;
        }

        public APIRequestGetSponsorTags requestMissionField() {
            return this.requestMissionField(true);
        }

        public APIRequestGetSponsorTags requestMissionField(boolean value) {
            this.requestField("mission", value);
            return this;
        }

        public APIRequestGetSponsorTags requestMpgField() {
            return this.requestMpgField(true);
        }

        public APIRequestGetSponsorTags requestMpgField(boolean value) {
            this.requestField("mpg", value);
            return this;
        }

        public APIRequestGetSponsorTags requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetSponsorTags requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetSponsorTags requestNameWithLocationDescriptorField() {
            return this.requestNameWithLocationDescriptorField(true);
        }

        public APIRequestGetSponsorTags requestNameWithLocationDescriptorField(boolean value) {
            this.requestField("name_with_location_descriptor", value);
            return this;
        }

        public APIRequestGetSponsorTags requestNetworkField() {
            return this.requestNetworkField(true);
        }

        public APIRequestGetSponsorTags requestNetworkField(boolean value) {
            this.requestField("network", value);
            return this;
        }

        public APIRequestGetSponsorTags requestNewLikeCountField() {
            return this.requestNewLikeCountField(true);
        }

        public APIRequestGetSponsorTags requestNewLikeCountField(boolean value) {
            this.requestField("new_like_count", value);
            return this;
        }

        public APIRequestGetSponsorTags requestOfferEligibleField() {
            return this.requestOfferEligibleField(true);
        }

        public APIRequestGetSponsorTags requestOfferEligibleField(boolean value) {
            this.requestField("offer_eligible", value);
            return this;
        }

        public APIRequestGetSponsorTags requestOverallStarRatingField() {
            return this.requestOverallStarRatingField(true);
        }

        public APIRequestGetSponsorTags requestOverallStarRatingField(boolean value) {
            this.requestField("overall_star_rating", value);
            return this;
        }

        public APIRequestGetSponsorTags requestOwnerBusinessField() {
            return this.requestOwnerBusinessField(true);
        }

        public APIRequestGetSponsorTags requestOwnerBusinessField(boolean value) {
            this.requestField("owner_business", value);
            return this;
        }

        public APIRequestGetSponsorTags requestPageTokenField() {
            return this.requestPageTokenField(true);
        }

        public APIRequestGetSponsorTags requestPageTokenField(boolean value) {
            this.requestField("page_token", value);
            return this;
        }

        public APIRequestGetSponsorTags requestParentPageField() {
            return this.requestParentPageField(true);
        }

        public APIRequestGetSponsorTags requestParentPageField(boolean value) {
            this.requestField("parent_page", value);
            return this;
        }

        public APIRequestGetSponsorTags requestParkingField() {
            return this.requestParkingField(true);
        }

        public APIRequestGetSponsorTags requestParkingField(boolean value) {
            this.requestField("parking", value);
            return this;
        }

        public APIRequestGetSponsorTags requestPaymentOptionsField() {
            return this.requestPaymentOptionsField(true);
        }

        public APIRequestGetSponsorTags requestPaymentOptionsField(boolean value) {
            this.requestField("payment_options", value);
            return this;
        }

        public APIRequestGetSponsorTags requestPersonalInfoField() {
            return this.requestPersonalInfoField(true);
        }

        public APIRequestGetSponsorTags requestPersonalInfoField(boolean value) {
            this.requestField("personal_info", value);
            return this;
        }

        public APIRequestGetSponsorTags requestPersonalInterestsField() {
            return this.requestPersonalInterestsField(true);
        }

        public APIRequestGetSponsorTags requestPersonalInterestsField(boolean value) {
            this.requestField("personal_interests", value);
            return this;
        }

        public APIRequestGetSponsorTags requestPharmaSafetyInfoField() {
            return this.requestPharmaSafetyInfoField(true);
        }

        public APIRequestGetSponsorTags requestPharmaSafetyInfoField(boolean value) {
            this.requestField("pharma_safety_info", value);
            return this;
        }

        public APIRequestGetSponsorTags requestPhoneField() {
            return this.requestPhoneField(true);
        }

        public APIRequestGetSponsorTags requestPhoneField(boolean value) {
            this.requestField("phone", value);
            return this;
        }

        public APIRequestGetSponsorTags requestPickupOptionsField() {
            return this.requestPickupOptionsField(true);
        }

        public APIRequestGetSponsorTags requestPickupOptionsField(boolean value) {
            this.requestField("pickup_options", value);
            return this;
        }

        public APIRequestGetSponsorTags requestPlaceTypeField() {
            return this.requestPlaceTypeField(true);
        }

        public APIRequestGetSponsorTags requestPlaceTypeField(boolean value) {
            this.requestField("place_type", value);
            return this;
        }

        public APIRequestGetSponsorTags requestPlotOutlineField() {
            return this.requestPlotOutlineField(true);
        }

        public APIRequestGetSponsorTags requestPlotOutlineField(boolean value) {
            this.requestField("plot_outline", value);
            return this;
        }

        public APIRequestGetSponsorTags requestPreferredAudienceField() {
            return this.requestPreferredAudienceField(true);
        }

        public APIRequestGetSponsorTags requestPreferredAudienceField(boolean value) {
            this.requestField("preferred_audience", value);
            return this;
        }

        public APIRequestGetSponsorTags requestPressContactField() {
            return this.requestPressContactField(true);
        }

        public APIRequestGetSponsorTags requestPressContactField(boolean value) {
            this.requestField("press_contact", value);
            return this;
        }

        public APIRequestGetSponsorTags requestPriceRangeField() {
            return this.requestPriceRangeField(true);
        }

        public APIRequestGetSponsorTags requestPriceRangeField(boolean value) {
            this.requestField("price_range", value);
            return this;
        }

        public APIRequestGetSponsorTags requestPrivacyInfoUrlField() {
            return this.requestPrivacyInfoUrlField(true);
        }

        public APIRequestGetSponsorTags requestPrivacyInfoUrlField(boolean value) {
            this.requestField("privacy_info_url", value);
            return this;
        }

        public APIRequestGetSponsorTags requestProducedByField() {
            return this.requestProducedByField(true);
        }

        public APIRequestGetSponsorTags requestProducedByField(boolean value) {
            this.requestField("produced_by", value);
            return this;
        }

        public APIRequestGetSponsorTags requestProductsField() {
            return this.requestProductsField(true);
        }

        public APIRequestGetSponsorTags requestProductsField(boolean value) {
            this.requestField("products", value);
            return this;
        }

        public APIRequestGetSponsorTags requestPromotionEligibleField() {
            return this.requestPromotionEligibleField(true);
        }

        public APIRequestGetSponsorTags requestPromotionEligibleField(boolean value) {
            this.requestField("promotion_eligible", value);
            return this;
        }

        public APIRequestGetSponsorTags requestPromotionIneligibleReasonField() {
            return this.requestPromotionIneligibleReasonField(true);
        }

        public APIRequestGetSponsorTags requestPromotionIneligibleReasonField(boolean value) {
            this.requestField("promotion_ineligible_reason", value);
            return this;
        }

        public APIRequestGetSponsorTags requestPublicTransitField() {
            return this.requestPublicTransitField(true);
        }

        public APIRequestGetSponsorTags requestPublicTransitField(boolean value) {
            this.requestField("public_transit", value);
            return this;
        }

        public APIRequestGetSponsorTags requestRatingCountField() {
            return this.requestRatingCountField(true);
        }

        public APIRequestGetSponsorTags requestRatingCountField(boolean value) {
            this.requestField("rating_count", value);
            return this;
        }

        public APIRequestGetSponsorTags requestRecipientField() {
            return this.requestRecipientField(true);
        }

        public APIRequestGetSponsorTags requestRecipientField(boolean value) {
            this.requestField("recipient", value);
            return this;
        }

        public APIRequestGetSponsorTags requestRecordLabelField() {
            return this.requestRecordLabelField(true);
        }

        public APIRequestGetSponsorTags requestRecordLabelField(boolean value) {
            this.requestField("record_label", value);
            return this;
        }

        public APIRequestGetSponsorTags requestReleaseDateField() {
            return this.requestReleaseDateField(true);
        }

        public APIRequestGetSponsorTags requestReleaseDateField(boolean value) {
            this.requestField("release_date", value);
            return this;
        }

        public APIRequestGetSponsorTags requestRestaurantServicesField() {
            return this.requestRestaurantServicesField(true);
        }

        public APIRequestGetSponsorTags requestRestaurantServicesField(boolean value) {
            this.requestField("restaurant_services", value);
            return this;
        }

        public APIRequestGetSponsorTags requestRestaurantSpecialtiesField() {
            return this.requestRestaurantSpecialtiesField(true);
        }

        public APIRequestGetSponsorTags requestRestaurantSpecialtiesField(boolean value) {
            this.requestField("restaurant_specialties", value);
            return this;
        }

        public APIRequestGetSponsorTags requestScheduleField() {
            return this.requestScheduleField(true);
        }

        public APIRequestGetSponsorTags requestScheduleField(boolean value) {
            this.requestField("schedule", value);
            return this;
        }

        public APIRequestGetSponsorTags requestScreenplayByField() {
            return this.requestScreenplayByField(true);
        }

        public APIRequestGetSponsorTags requestScreenplayByField(boolean value) {
            this.requestField("screenplay_by", value);
            return this;
        }

        public APIRequestGetSponsorTags requestSeasonField() {
            return this.requestSeasonField(true);
        }

        public APIRequestGetSponsorTags requestSeasonField(boolean value) {
            this.requestField("season", value);
            return this;
        }

        public APIRequestGetSponsorTags requestSingleLineAddressField() {
            return this.requestSingleLineAddressField(true);
        }

        public APIRequestGetSponsorTags requestSingleLineAddressField(boolean value) {
            this.requestField("single_line_address", value);
            return this;
        }

        public APIRequestGetSponsorTags requestStarringField() {
            return this.requestStarringField(true);
        }

        public APIRequestGetSponsorTags requestStarringField(boolean value) {
            this.requestField("starring", value);
            return this;
        }

        public APIRequestGetSponsorTags requestStartInfoField() {
            return this.requestStartInfoField(true);
        }

        public APIRequestGetSponsorTags requestStartInfoField(boolean value) {
            this.requestField("start_info", value);
            return this;
        }

        public APIRequestGetSponsorTags requestStoreCodeField() {
            return this.requestStoreCodeField(true);
        }

        public APIRequestGetSponsorTags requestStoreCodeField(boolean value) {
            this.requestField("store_code", value);
            return this;
        }

        public APIRequestGetSponsorTags requestStoreLocationDescriptorField() {
            return this.requestStoreLocationDescriptorField(true);
        }

        public APIRequestGetSponsorTags requestStoreLocationDescriptorField(boolean value) {
            this.requestField("store_location_descriptor", value);
            return this;
        }

        public APIRequestGetSponsorTags requestStoreNumberField() {
            return this.requestStoreNumberField(true);
        }

        public APIRequestGetSponsorTags requestStoreNumberField(boolean value) {
            this.requestField("store_number", value);
            return this;
        }

        public APIRequestGetSponsorTags requestStudioField() {
            return this.requestStudioField(true);
        }

        public APIRequestGetSponsorTags requestStudioField(boolean value) {
            this.requestField("studio", value);
            return this;
        }

        public APIRequestGetSponsorTags requestSupportsDonateButtonInLiveVideoField() {
            return this.requestSupportsDonateButtonInLiveVideoField(true);
        }

        public APIRequestGetSponsorTags requestSupportsDonateButtonInLiveVideoField(boolean value) {
            this.requestField("supports_donate_button_in_live_video", value);
            return this;
        }

        public APIRequestGetSponsorTags requestTalkingAboutCountField() {
            return this.requestTalkingAboutCountField(true);
        }

        public APIRequestGetSponsorTags requestTalkingAboutCountField(boolean value) {
            this.requestField("talking_about_count", value);
            return this;
        }

        public APIRequestGetSponsorTags requestTemporaryStatusField() {
            return this.requestTemporaryStatusField(true);
        }

        public APIRequestGetSponsorTags requestTemporaryStatusField(boolean value) {
            this.requestField("temporary_status", value);
            return this;
        }

        public APIRequestGetSponsorTags requestUnreadMessageCountField() {
            return this.requestUnreadMessageCountField(true);
        }

        public APIRequestGetSponsorTags requestUnreadMessageCountField(boolean value) {
            this.requestField("unread_message_count", value);
            return this;
        }

        public APIRequestGetSponsorTags requestUnreadNotifCountField() {
            return this.requestUnreadNotifCountField(true);
        }

        public APIRequestGetSponsorTags requestUnreadNotifCountField(boolean value) {
            this.requestField("unread_notif_count", value);
            return this;
        }

        public APIRequestGetSponsorTags requestUnseenMessageCountField() {
            return this.requestUnseenMessageCountField(true);
        }

        public APIRequestGetSponsorTags requestUnseenMessageCountField(boolean value) {
            this.requestField("unseen_message_count", value);
            return this;
        }

        public APIRequestGetSponsorTags requestUserAccessExpireTimeField() {
            return this.requestUserAccessExpireTimeField(true);
        }

        public APIRequestGetSponsorTags requestUserAccessExpireTimeField(boolean value) {
            this.requestField("user_access_expire_time", value);
            return this;
        }

        public APIRequestGetSponsorTags requestUsernameField() {
            return this.requestUsernameField(true);
        }

        public APIRequestGetSponsorTags requestUsernameField(boolean value) {
            this.requestField("username", value);
            return this;
        }

        public APIRequestGetSponsorTags requestVerificationStatusField() {
            return this.requestVerificationStatusField(true);
        }

        public APIRequestGetSponsorTags requestVerificationStatusField(boolean value) {
            this.requestField("verification_status", value);
            return this;
        }

        public APIRequestGetSponsorTags requestVoipInfoField() {
            return this.requestVoipInfoField(true);
        }

        public APIRequestGetSponsorTags requestVoipInfoField(boolean value) {
            this.requestField("voip_info", value);
            return this;
        }

        public APIRequestGetSponsorTags requestWebsiteField() {
            return this.requestWebsiteField(true);
        }

        public APIRequestGetSponsorTags requestWebsiteField(boolean value) {
            this.requestField("website", value);
            return this;
        }

        public APIRequestGetSponsorTags requestWereHereCountField() {
            return this.requestWereHereCountField(true);
        }

        public APIRequestGetSponsorTags requestWereHereCountField(boolean value) {
            this.requestField("were_here_count", value);
            return this;
        }

        public APIRequestGetSponsorTags requestWhatsappNumberField() {
            return this.requestWhatsappNumberField(true);
        }

        public APIRequestGetSponsorTags requestWhatsappNumberField(boolean value) {
            this.requestField("whatsapp_number", value);
            return this;
        }

        public APIRequestGetSponsorTags requestWrittenByField() {
            return this.requestWrittenByField(true);
        }

        public APIRequestGetSponsorTags requestWrittenByField(boolean value) {
            this.requestField("written_by", value);
            return this;
        }
    }

    public static class APIRequestCreateLike
    extends APIRequest<Photo> {
        Photo lastResponse = null;
        public static final String[] PARAMS = new String[]{"feedback_source", "nectar_module", "notify", "tracking"};
        public static final String[] FIELDS = new String[0];

        @Override
        public Photo getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Photo parseResponse(String response, String header) throws APIException {
            return Photo.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public Photo execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Photo execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<Photo> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Photo> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, Photo>(){

                public Photo apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestCreateLike(String nodeId, APIContext context) {
            super(context, nodeId, "/likes", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateLike setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateLike setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateLike setFeedbackSource(String feedbackSource) {
            this.setParam("feedback_source", feedbackSource);
            return this;
        }

        public APIRequestCreateLike setNectarModule(String nectarModule) {
            this.setParam("nectar_module", nectarModule);
            return this;
        }

        public APIRequestCreateLike setNotify(Boolean notify) {
            this.setParam("notify", notify);
            return this;
        }

        public APIRequestCreateLike setNotify(String notify) {
            this.setParam("notify", notify);
            return this;
        }

        public APIRequestCreateLike setTracking(String tracking) {
            this.setParam("tracking", tracking);
            return this;
        }

        public APIRequestCreateLike requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateLike requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateLike requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateLike requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateLike requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateLike requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetLikes
    extends APIRequest<Profile> {
        APINodeList<Profile> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"can_post", "id", "link", "name", "pic", "pic_crop", "pic_large", "pic_small", "pic_square", "profile_type", "username"};

        @Override
        public APINodeList<Profile> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Profile> parseResponse(String response, String header) throws APIException {
            return Profile.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Profile> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Profile> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Profile>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Profile>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Profile>>(){

                public APINodeList<Profile> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetLikes(String nodeId, APIContext context) {
            super(context, nodeId, "/likes", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetLikes setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetLikes setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetLikes requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetLikes requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetLikes requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetLikes requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetLikes requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetLikes requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetLikes requestCanPostField() {
            return this.requestCanPostField(true);
        }

        public APIRequestGetLikes requestCanPostField(boolean value) {
            this.requestField("can_post", value);
            return this;
        }

        public APIRequestGetLikes requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetLikes requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetLikes requestLinkField() {
            return this.requestLinkField(true);
        }

        public APIRequestGetLikes requestLinkField(boolean value) {
            this.requestField("link", value);
            return this;
        }

        public APIRequestGetLikes requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetLikes requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetLikes requestPicField() {
            return this.requestPicField(true);
        }

        public APIRequestGetLikes requestPicField(boolean value) {
            this.requestField("pic", value);
            return this;
        }

        public APIRequestGetLikes requestPicCropField() {
            return this.requestPicCropField(true);
        }

        public APIRequestGetLikes requestPicCropField(boolean value) {
            this.requestField("pic_crop", value);
            return this;
        }

        public APIRequestGetLikes requestPicLargeField() {
            return this.requestPicLargeField(true);
        }

        public APIRequestGetLikes requestPicLargeField(boolean value) {
            this.requestField("pic_large", value);
            return this;
        }

        public APIRequestGetLikes requestPicSmallField() {
            return this.requestPicSmallField(true);
        }

        public APIRequestGetLikes requestPicSmallField(boolean value) {
            this.requestField("pic_small", value);
            return this;
        }

        public APIRequestGetLikes requestPicSquareField() {
            return this.requestPicSquareField(true);
        }

        public APIRequestGetLikes requestPicSquareField(boolean value) {
            this.requestField("pic_square", value);
            return this;
        }

        public APIRequestGetLikes requestProfileTypeField() {
            return this.requestProfileTypeField(true);
        }

        public APIRequestGetLikes requestProfileTypeField(boolean value) {
            this.requestField("profile_type", value);
            return this;
        }

        public APIRequestGetLikes requestUsernameField() {
            return this.requestUsernameField(true);
        }

        public APIRequestGetLikes requestUsernameField(boolean value) {
            this.requestField("username", value);
            return this;
        }
    }

    public static class APIRequestGetInsights
    extends APIRequest<InsightsResult> {
        APINodeList<InsightsResult> lastResponse = null;
        public static final String[] PARAMS = new String[]{"date_preset", "metric", "period", "since", "until"};
        public static final String[] FIELDS = new String[]{"description", "description_from_api_doc", "id", "name", "period", "title", "values"};

        @Override
        public APINodeList<InsightsResult> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<InsightsResult> parseResponse(String response, String header) throws APIException {
            return InsightsResult.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<InsightsResult> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<InsightsResult> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<InsightsResult>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<InsightsResult>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<InsightsResult>>(){

                public APINodeList<InsightsResult> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetInsights(String nodeId, APIContext context) {
            super(context, nodeId, "/insights", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetInsights setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetInsights setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetInsights setDatePreset(InsightsResult.EnumDatePreset datePreset) {
            this.setParam("date_preset", (Object)datePreset);
            return this;
        }

        public APIRequestGetInsights setDatePreset(String datePreset) {
            this.setParam("date_preset", datePreset);
            return this;
        }

        public APIRequestGetInsights setMetric(List<Object> metric) {
            this.setParam("metric", metric);
            return this;
        }

        public APIRequestGetInsights setMetric(String metric) {
            this.setParam("metric", metric);
            return this;
        }

        public APIRequestGetInsights setPeriod(InsightsResult.EnumPeriod period) {
            this.setParam("period", (Object)period);
            return this;
        }

        public APIRequestGetInsights setPeriod(String period) {
            this.setParam("period", period);
            return this;
        }

        public APIRequestGetInsights setSince(String since) {
            this.setParam("since", since);
            return this;
        }

        public APIRequestGetInsights setUntil(String until) {
            this.setParam("until", until);
            return this;
        }

        public APIRequestGetInsights requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetInsights requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetInsights requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetInsights requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetInsights requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetInsights requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetInsights requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGetInsights requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGetInsights requestDescriptionFromApiDocField() {
            return this.requestDescriptionFromApiDocField(true);
        }

        public APIRequestGetInsights requestDescriptionFromApiDocField(boolean value) {
            this.requestField("description_from_api_doc", value);
            return this;
        }

        public APIRequestGetInsights requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetInsights requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetInsights requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetInsights requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetInsights requestPeriodField() {
            return this.requestPeriodField(true);
        }

        public APIRequestGetInsights requestPeriodField(boolean value) {
            this.requestField("period", value);
            return this;
        }

        public APIRequestGetInsights requestTitleField() {
            return this.requestTitleField(true);
        }

        public APIRequestGetInsights requestTitleField(boolean value) {
            this.requestField("title", value);
            return this;
        }

        public APIRequestGetInsights requestValuesField() {
            return this.requestValuesField(true);
        }

        public APIRequestGetInsights requestValuesField(boolean value) {
            this.requestField("values", value);
            return this;
        }
    }

    public static class APIRequestCreateComment
    extends APIRequest<Comment> {
        Comment lastResponse = null;
        public static final String[] PARAMS = new String[]{"attachment_id", "attachment_share_url", "attachment_url", "comment_privacy_value", "facepile_mentioned_ids", "feedback_source", "is_offline", "message", "nectar_module", "object_id", "parent_comment_id", "text", "tracking"};
        public static final String[] FIELDS = new String[0];

        @Override
        public Comment getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Comment parseResponse(String response, String header) throws APIException {
            return Comment.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public Comment execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Comment execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<Comment> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<Comment> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, Comment>(){

                public Comment apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestCreateComment(String nodeId, APIContext context) {
            super(context, nodeId, "/comments", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateComment setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateComment setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateComment setAttachmentId(String attachmentId) {
            this.setParam("attachment_id", attachmentId);
            return this;
        }

        public APIRequestCreateComment setAttachmentShareUrl(String attachmentShareUrl) {
            this.setParam("attachment_share_url", attachmentShareUrl);
            return this;
        }

        public APIRequestCreateComment setAttachmentUrl(String attachmentUrl) {
            this.setParam("attachment_url", attachmentUrl);
            return this;
        }

        public APIRequestCreateComment setCommentPrivacyValue(Comment.EnumCommentPrivacyValue commentPrivacyValue) {
            this.setParam("comment_privacy_value", (Object)commentPrivacyValue);
            return this;
        }

        public APIRequestCreateComment setCommentPrivacyValue(String commentPrivacyValue) {
            this.setParam("comment_privacy_value", commentPrivacyValue);
            return this;
        }

        public APIRequestCreateComment setFacepileMentionedIds(List<String> facepileMentionedIds) {
            this.setParam("facepile_mentioned_ids", facepileMentionedIds);
            return this;
        }

        public APIRequestCreateComment setFacepileMentionedIds(String facepileMentionedIds) {
            this.setParam("facepile_mentioned_ids", facepileMentionedIds);
            return this;
        }

        public APIRequestCreateComment setFeedbackSource(String feedbackSource) {
            this.setParam("feedback_source", feedbackSource);
            return this;
        }

        public APIRequestCreateComment setIsOffline(Boolean isOffline) {
            this.setParam("is_offline", isOffline);
            return this;
        }

        public APIRequestCreateComment setIsOffline(String isOffline) {
            this.setParam("is_offline", isOffline);
            return this;
        }

        public APIRequestCreateComment setMessage(String message) {
            this.setParam("message", message);
            return this;
        }

        public APIRequestCreateComment setNectarModule(String nectarModule) {
            this.setParam("nectar_module", nectarModule);
            return this;
        }

        public APIRequestCreateComment setObjectId(String objectId) {
            this.setParam("object_id", objectId);
            return this;
        }

        public APIRequestCreateComment setParentCommentId(Object parentCommentId) {
            this.setParam("parent_comment_id", parentCommentId);
            return this;
        }

        public APIRequestCreateComment setParentCommentId(String parentCommentId) {
            this.setParam("parent_comment_id", parentCommentId);
            return this;
        }

        public APIRequestCreateComment setText(String text) {
            this.setParam("text", text);
            return this;
        }

        public APIRequestCreateComment setTracking(String tracking) {
            this.setParam("tracking", tracking);
            return this;
        }

        public APIRequestCreateComment requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateComment requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateComment requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateComment requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateComment requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateComment requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    public static class APIRequestGetComments
    extends APIRequest<Comment> {
        APINodeList<Comment> lastResponse = null;
        public static final String[] PARAMS = new String[]{"filter", "live_filter", "order", "since"};
        public static final String[] FIELDS = new String[]{"admin_creator", "application", "attachment", "can_comment", "can_hide", "can_like", "can_remove", "can_reply_privately", "comment_count", "created_time", "from", "id", "is_hidden", "is_private", "like_count", "live_broadcast_timestamp", "message", "message_tags", "object", "parent", "permalink_url", "private_reply_conversation", "user_likes"};

        @Override
        public APINodeList<Comment> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<Comment> parseResponse(String response, String header) throws APIException {
            return Comment.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<Comment> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<Comment> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<Comment>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<Comment>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<Comment>>(){

                public APINodeList<Comment> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        public APIRequestGetComments(String nodeId, APIContext context) {
            super(context, nodeId, "/comments", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetComments setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetComments setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetComments setFilter(Comment.EnumFilter filter) {
            this.setParam("filter", (Object)filter);
            return this;
        }

        public APIRequestGetComments setFilter(String filter) {
            this.setParam("filter", filter);
            return this;
        }

        public APIRequestGetComments setLiveFilter(Comment.EnumLiveFilter liveFilter) {
            this.setParam("live_filter", (Object)liveFilter);
            return this;
        }

        public APIRequestGetComments setLiveFilter(String liveFilter) {
            this.setParam("live_filter", liveFilter);
            return this;
        }

        public APIRequestGetComments setOrder(Comment.EnumOrder order) {
            this.setParam("order", (Object)order);
            return this;
        }

        public APIRequestGetComments setOrder(String order) {
            this.setParam("order", order);
            return this;
        }

        public APIRequestGetComments setSince(String since) {
            this.setParam("since", since);
            return this;
        }

        public APIRequestGetComments requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetComments requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetComments requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetComments requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetComments requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetComments requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetComments requestAdminCreatorField() {
            return this.requestAdminCreatorField(true);
        }

        public APIRequestGetComments requestAdminCreatorField(boolean value) {
            this.requestField("admin_creator", value);
            return this;
        }

        public APIRequestGetComments requestApplicationField() {
            return this.requestApplicationField(true);
        }

        public APIRequestGetComments requestApplicationField(boolean value) {
            this.requestField("application", value);
            return this;
        }

        public APIRequestGetComments requestAttachmentField() {
            return this.requestAttachmentField(true);
        }

        public APIRequestGetComments requestAttachmentField(boolean value) {
            this.requestField("attachment", value);
            return this;
        }

        public APIRequestGetComments requestCanCommentField() {
            return this.requestCanCommentField(true);
        }

        public APIRequestGetComments requestCanCommentField(boolean value) {
            this.requestField("can_comment", value);
            return this;
        }

        public APIRequestGetComments requestCanHideField() {
            return this.requestCanHideField(true);
        }

        public APIRequestGetComments requestCanHideField(boolean value) {
            this.requestField("can_hide", value);
            return this;
        }

        public APIRequestGetComments requestCanLikeField() {
            return this.requestCanLikeField(true);
        }

        public APIRequestGetComments requestCanLikeField(boolean value) {
            this.requestField("can_like", value);
            return this;
        }

        public APIRequestGetComments requestCanRemoveField() {
            return this.requestCanRemoveField(true);
        }

        public APIRequestGetComments requestCanRemoveField(boolean value) {
            this.requestField("can_remove", value);
            return this;
        }

        public APIRequestGetComments requestCanReplyPrivatelyField() {
            return this.requestCanReplyPrivatelyField(true);
        }

        public APIRequestGetComments requestCanReplyPrivatelyField(boolean value) {
            this.requestField("can_reply_privately", value);
            return this;
        }

        public APIRequestGetComments requestCommentCountField() {
            return this.requestCommentCountField(true);
        }

        public APIRequestGetComments requestCommentCountField(boolean value) {
            this.requestField("comment_count", value);
            return this;
        }

        public APIRequestGetComments requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGetComments requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGetComments requestFromField() {
            return this.requestFromField(true);
        }

        public APIRequestGetComments requestFromField(boolean value) {
            this.requestField("from", value);
            return this;
        }

        public APIRequestGetComments requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetComments requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetComments requestIsHiddenField() {
            return this.requestIsHiddenField(true);
        }

        public APIRequestGetComments requestIsHiddenField(boolean value) {
            this.requestField("is_hidden", value);
            return this;
        }

        public APIRequestGetComments requestIsPrivateField() {
            return this.requestIsPrivateField(true);
        }

        public APIRequestGetComments requestIsPrivateField(boolean value) {
            this.requestField("is_private", value);
            return this;
        }

        public APIRequestGetComments requestLikeCountField() {
            return this.requestLikeCountField(true);
        }

        public APIRequestGetComments requestLikeCountField(boolean value) {
            this.requestField("like_count", value);
            return this;
        }

        public APIRequestGetComments requestLiveBroadcastTimestampField() {
            return this.requestLiveBroadcastTimestampField(true);
        }

        public APIRequestGetComments requestLiveBroadcastTimestampField(boolean value) {
            this.requestField("live_broadcast_timestamp", value);
            return this;
        }

        public APIRequestGetComments requestMessageField() {
            return this.requestMessageField(true);
        }

        public APIRequestGetComments requestMessageField(boolean value) {
            this.requestField("message", value);
            return this;
        }

        public APIRequestGetComments requestMessageTagsField() {
            return this.requestMessageTagsField(true);
        }

        public APIRequestGetComments requestMessageTagsField(boolean value) {
            this.requestField("message_tags", value);
            return this;
        }

        public APIRequestGetComments requestObjectField() {
            return this.requestObjectField(true);
        }

        public APIRequestGetComments requestObjectField(boolean value) {
            this.requestField("object", value);
            return this;
        }

        public APIRequestGetComments requestParentField() {
            return this.requestParentField(true);
        }

        public APIRequestGetComments requestParentField(boolean value) {
            this.requestField("parent", value);
            return this;
        }

        public APIRequestGetComments requestPermalinkUrlField() {
            return this.requestPermalinkUrlField(true);
        }

        public APIRequestGetComments requestPermalinkUrlField(boolean value) {
            this.requestField("permalink_url", value);
            return this;
        }

        public APIRequestGetComments requestPrivateReplyConversationField() {
            return this.requestPrivateReplyConversationField(true);
        }

        public APIRequestGetComments requestPrivateReplyConversationField(boolean value) {
            this.requestField("private_reply_conversation", value);
            return this;
        }

        public APIRequestGetComments requestUserLikesField() {
            return this.requestUserLikesField(true);
        }

        public APIRequestGetComments requestUserLikesField(boolean value) {
            this.requestField("user_likes", value);
            return this;
        }
    }
}

