/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk.serverside;

import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.serverside.Event;
import com.facebook.ads.sdk.serverside.EventRequest;
import com.facebook.ads.sdk.serverside.EventResponse;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class BatchProcessor {
    private int batchSize;
    private int concurrentRequests;

    public BatchProcessor(int batchSize, int concurrentRequests) {
        this.batchSize = batchSize;
        this.concurrentRequests = concurrentRequests;
    }

    public void processEventRequests(List<EventRequest> eventRequests) throws ExecutionException, InterruptedException {
        Iterator<List<ListenableFuture<EventResponse>>> it = this.processEventRequestsIterator(eventRequests);
        while (it.hasNext()) {
            List<ListenableFuture<EventResponse>> futures = it.next();
            Futures.allAsList(futures).get();
        }
    }

    public Iterator<List<ListenableFuture<EventResponse>>> processEventsIterator(EventRequest eventRequestToClone, List<Event> events) {
        return new EventIterator(eventRequestToClone, events, this.batchSize, this.concurrentRequests);
    }

    public void processEvents(EventRequest eventRequestToClone, List<Event> events) throws ExecutionException, InterruptedException {
        Iterator<List<ListenableFuture<EventResponse>>> it = this.processEventsIterator(eventRequestToClone, events);
        while (it.hasNext()) {
            List<ListenableFuture<EventResponse>> futures = it.next();
            Futures.allAsList(futures).get();
        }
    }

    public Iterator<List<ListenableFuture<EventResponse>>> processEventRequestsIterator(List<EventRequest> eventRequests) {
        return new EventRequestIterator(eventRequests, this.concurrentRequests);
    }

    protected static class EventRequestIterator
    implements Iterator<List<ListenableFuture<EventResponse>>> {
        private final List<EventRequest> eventRequests;
        int concurrentRequests;
        int index;

        public EventRequestIterator(List<EventRequest> eventRequests, int concurrentRequests) {
            this.eventRequests = eventRequests;
            this.concurrentRequests = concurrentRequests;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.eventRequests.size();
        }

        @Override
        public List<ListenableFuture<EventResponse>> next() {
            int i;
            ArrayList<ListenableFuture<EventResponse>> responses = new ArrayList<ListenableFuture<EventResponse>>();
            for (i = this.index; i < this.index + this.concurrentRequests && i < this.eventRequests.size(); ++i) {
                try {
                    responses.add(this.eventRequests.get(i).executeAsync());
                    continue;
                }
                catch (APIException e) {
                    e.printStackTrace();
                }
            }
            this.index = i;
            return responses;
        }

        @Override
        public void remove() {
        }
    }

    protected static class EventIterator
    implements Iterator<List<ListenableFuture<EventResponse>>> {
        private final EventRequest eventRequestToClone;
        private final List<Event> events;
        int concurrentRequests;
        int batchSize;
        int index;

        public EventIterator(EventRequest eventRequestToClone, List<Event> events, int batchSize, int concurrentRequests) {
            this.eventRequestToClone = eventRequestToClone;
            this.events = events;
            this.batchSize = batchSize;
            this.concurrentRequests = concurrentRequests;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.events.size();
        }

        @Override
        public List<ListenableFuture<EventResponse>> next() {
            int i;
            ArrayList<ListenableFuture<EventResponse>> responses = new ArrayList<ListenableFuture<EventResponse>>();
            for (i = this.index; i < this.events.size() && responses.size() < this.concurrentRequests; i += this.batchSize) {
                EventRequest eventRequest = this.eventRequestToClone.cloneWithoutData();
                int maxIndex = Math.min(i + this.batchSize, this.events.size());
                eventRequest.setData(this.events.subList(i, maxIndex));
                try {
                    responses.add(eventRequest.executeAsync());
                    continue;
                }
                catch (APIException e) {
                    e.printStackTrace();
                }
            }
            this.index = i;
            return responses;
        }

        @Override
        public void remove() {
        }
    }
}

